/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.I2Dom;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateTool {
    private static final String WSSE_SECURITY_TOKEN_REFERENCE = "wsse:SecurityTokenReference";
    private static final String WSSE_KEY_IDENTIFIER = "wsse:KeyIdentifier";
    private static final String ATTR_VALUETYPE = "ValueType";
    private static final String ATTR_ENCODINGTYPE = "EncodingType";
    private static final String ATTR_URI = "URI";
    private static final String ALGORITHM = "Algorithm";

    public static Element genKeyInfoElem(Document doc, Element child, boolean addNS) {
        Element keyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        if (addNS) {
            keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        }
        keyInfo.appendChild(child);
        return keyInfo;
    }

    public static I2Dom genKeyInfoObj(I2Dom child, boolean addNS) {
        return new I2Dom(){
            I2Dom child;
            boolean addNS;

            @Override
            public Element toDom(Document doc) {
                Element keyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
                if (this.addNS) {
                    keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
                }
                keyInfo.appendChild(this.child.toDom(doc));
                return keyInfo;
            }
        };
    }

    public static Element genSignatureElem(Document doc, String[] idsToSign, String sigMethod, boolean enveloped) throws Exception {
        String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
        String canonMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
        Element signatureElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        signatureElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        Element signedInfoElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
        Element canonMethodElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonMethodElement.setAttribute(ALGORITHM, "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element sigMethodElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
        sigMethodElement.setAttribute(ALGORITHM, sigMethod);
        signedInfoElement.appendChild(canonMethodElement);
        signedInfoElement.appendChild(sigMethodElement);
        for (int i = 0; i < idsToSign.length; ++i) {
            Element refElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
            refElem.setAttribute(ATTR_URI, "#" + idsToSign[i]);
            Element transformsElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
            Element transformElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
            transformElement.setAttribute(ALGORITHM, canonMethod);
            if (enveloped) {
                Element transformElement2 = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
                transformElement2.setAttribute(ALGORITHM, "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
                transformsElement.appendChild(transformElement2);
            }
            transformsElement.appendChild(transformElement);
            Element digestMethodElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
            digestMethodElement.setAttribute(ALGORITHM, digestMethod);
            Element digestValueElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
            refElem.appendChild(transformsElement);
            refElem.appendChild(digestMethodElement);
            refElem.appendChild(digestValueElement);
            signedInfoElement.appendChild(refElem);
        }
        signatureElement.appendChild(signedInfoElement);
        Element signatureValueElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
        signatureElement.appendChild(signatureValueElement);
        return signatureElement;
    }

    public static Element genSTRElem(Document doc, String keyIdentifier, String valType) throws Exception {
        Element sectokenrefElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", WSSE_SECURITY_TOKEN_REFERENCE);
        sectokenrefElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Element keyidElem = null;
        if (valType.equals("wsse:X509v3")) {
            keyidElem = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/trust", WSSE_KEY_IDENTIFIER);
            keyidElem.setAttribute(ATTR_VALUETYPE, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            keyidElem.setAttribute(ATTR_ENCODINGTYPE, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            keyidElem.appendChild(doc.createTextNode(keyIdentifier));
        } else if (valType.equals("wsse:X509v3ref")) {
            keyidElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
            keyidElem.setAttribute(ATTR_VALUETYPE, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            keyidElem.setAttribute(ATTR_URI, keyIdentifier);
        } else if (valType.equals("saml:Assertion")) {
            keyidElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
            keyidElem.setAttribute(ATTR_VALUETYPE, valType);
            keyidElem.setAttribute(ATTR_URI, keyIdentifier);
        } else if (valType.equals("wst:DerivedKeyToken")) {
            keyidElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
            keyidElem.setAttribute(ATTR_VALUETYPE, valType);
            keyidElem.setAttribute(ATTR_URI, keyIdentifier);
        } else if (valType.equals("sc/dk")) {
            keyidElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
            keyidElem.setAttribute(ATTR_VALUETYPE, "http://schemas.xmlsoap.org/ws/2004/04/security/sc/dk");
            keyidElem.setAttribute(ATTR_URI, keyIdentifier);
        }
        sectokenrefElem.appendChild(keyidElem);
        return sectokenrefElem;
    }
}

