/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.I2Dom;
import com.ibm.security.krb5.wss.util.LocalConstants;
import com.ibm.security.krb5.wss.util.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapFault
extends RuntimeException
implements I2Dom,
LocalConstants {
    private static final long serialVersionUID = 4883875593561043584L;
    public static final String FC_INV_RQST = "wst:InvalidRequest";
    public static final String FC_FAIL_AUTH = "wst:FailedAuthentication";
    public static final String FC_RQST_FAILED = "wst:RequestFailed";
    public static final String FC_INV_SEC_TKN = "wst:InvalidSecurityToken";
    public static final String FC_AUTH_BAD_ELE = "wst:AuthenticationBadElements";
    public static final String FC_BAD_REQ = "wst:BadRequest";
    public static final String FC_EXP_DATA = "wst:ExpiredData";
    public static final String FC_INV_TIME_RANGE = "wst:InvalidTimeRange";
    public static final String FC_DEFAULT = "wst:InvalidRequest";
    public static final String FS_INV_RQST = "The request was invalid or malformed";
    public static final String FS_FAIL_AUTH = "Authentication failed";
    public static final String FS_RQST_FAILED = "The specified request failed";
    public static final String FS_INV_SEC_TKN = "Security token has been revoked";
    public static final String FS_AUTH_BAD_ELE = "Insufficient digest elements";
    public static final String FS_BAD_REQ = "The specified RequestSecurityToken is not understood";
    public static final String FS_EXP_DATA = "The request data is out-of-date";
    public static final String FS_INV_TIME_RANGE = "The requested time range is invalid or unsupported";
    public static final String FS_DEFAULT = "The request was invalid or malformed";
    private static final String[] knownCodes = new String[]{"wst:InvalidRequest", "wst:FailedAuthentication", "wst:RequestFailed", "wst:InvalidSecurityToken", "wst:AuthenticationBadElements", "wst:BadRequest", "wst:ExpiredData", "wst:InvalidTimeRange"};
    private static final String[] knownStrings = new String[]{"The request was invalid or malformed", "Authentication failed", "The specified request failed", "Security token has been revoked", "Insufficient digest elements", "The specified RequestSecurityToken is not understood", "The request data is out-of-date", "The requested time range is invalid or unsupported"};
    private final String hdr = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/04/trust\" encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" >\n<soap:Body>\n" + "<soap:Fault>\n".intern();
    private final String doofusPre = "<faultcode>";
    private final String doofusPost = "</faultcode>\n";
    private String faultCode = "Client";
    private final String msgPre = "<faultstring>".intern();
    private final String msgPost = "</faultstring>\n".intern();
    private String faultString = "InvalidSecurityToken";
    private String detail;
    private final String trailer = "</soap:Fault>\n</soap:Body>\n" + "</soap:Envelope>".intern();
    private static final String UTF8 = "UTF-8".intern();

    public SoapFault() {
        this.faultCode = "wst:InvalidRequest";
        this.faultString = "The request was invalid or malformed";
    }

    public SoapFault(String message) {
        super(message);
        int i;
        for (i = 0; i < knownCodes.length && !message.equals(knownCodes[i]); ++i) {
        }
        if (i >= knownCodes.length) {
            this.faultCode = "wst:InvalidRequest";
            this.faultString = "The request was invalid or malformed";
            this.detail = message;
        } else {
            this.faultCode = knownCodes[i];
            this.faultString = knownStrings[i];
        }
    }

    public SoapFault(String faultCode, String faultString) {
        super(faultCode);
        this.faultCode = faultCode;
        this.faultString = faultString;
    }

    public SoapFault(String faultCode, String faultString, String detail) {
        super(faultCode);
        this.faultCode = faultCode;
        this.faultString = faultString;
        this.detail = detail;
    }

    public SoapFault(String detail, Throwable cause) {
        super(cause);
        this.faultCode = "wst:InvalidRequest";
        this.faultString = "The request was invalid or malformed";
        this.detail = detail;
    }

    public SoapFault(Throwable cause) {
        super(cause);
        this.faultCode = "wst:InvalidRequest";
        this.faultString = "The request was invalid or malformed";
        this.detail = cause.toString();
    }

    public void toStream(OutputStream os) throws IOException {
        os.write(this.hdr.getBytes(UTF8));
        os.write(("<faultcode>" + this.faultCode + "</faultcode>\n").getBytes(UTF8));
        os.write((this.msgPre + this.faultString + this.msgPost).getBytes(UTF8));
        os.write(this.trailer.getBytes(UTF8));
    }

    public SoapFault setDetail(String toThis) {
        this.detail = toThis;
        return this;
    }

    public SoapFault setFaultCode(String toThis) {
        this.faultCode = toThis;
        return this;
    }

    public SoapFault setFaultString(String toThis) {
        this.faultString = toThis;
        return this;
    }

    public SoapFault setAll(String toThisCode, String toThisString, String toThisDetail) {
        this.faultCode = toThisCode;
        this.faultString = toThisString;
        this.detail = toThisDetail;
        return this;
    }

    @Override
    public String toString() {
        return this.faultCode + "::" + this.faultString + "::" + this.detail;
    }

    @Override
    public Element toDom(Document factory) {
        return this.toDomWithHeaderContent(factory, null);
    }

    public Element toDomWithHeaderContent(Document factory, Node addToHeader) {
        Element env = factory.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        env.setPrefix("soap");
        env.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
        env.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wst", "http://schemas.xmlsoap.org/ws/2005/02/trust");
        env.setAttribute("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
        Element h = factory.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        h.setPrefix("soap");
        env.appendChild(h);
        if (addToHeader != null) {
            h.appendChild(addToHeader);
        }
        Element b = factory.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        b.setPrefix("soap");
        env.appendChild(b);
        Element f = factory.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        f.setPrefix("soap");
        b.appendChild(f);
        Element code = factory.createElement("faultcode");
        code.appendChild(factory.createTextNode(this.faultCode));
        f.appendChild(code);
        Element fstring = factory.createElement("faultstring");
        fstring.appendChild(factory.createTextNode(this.faultString));
        f.appendChild(fstring);
        if (this.detail != null) {
            Element dstring = factory.createElement("detail");
            Element myFaultDetails = factory.createElementNS("http://nogooddeedgoesunpunished", "myFaultDetails");
            myFaultDetails.setPrefix("e");
            myFaultDetails.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:e", "http://nogooddeedgoesunpunished");
            Element message = factory.createElement("message");
            message.appendChild(factory.createTextNode(this.detail));
            myFaultDetails.appendChild(message);
            dstring.appendChild(myFaultDetails);
            f.appendChild(dstring);
        }
        return env;
    }

    public static SoapFault convertFrom(RuntimeException re) {
        SoapFault answer = new SoapFault();
        answer.setDetail(re.getMessage());
        return answer;
    }

    public static SoapFault convertFrom(Document doc) {
        SoapFault answer = null;
        String phaseMessage = null;
        phaseMessage = "Body not found";
        Element elem = (Element)doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        if (elem != null) {
            phaseMessage = "Fault not found";
            if ((elem = (Element)elem.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault").item(0)) != null) {
                String fCode;
                phaseMessage = "faultcode not found";
                Element elem2 = (Element)elem.getElementsByTagName("faultcode").item(0);
                if (elem2 != null && (fCode = XMLUtil.getElementText(elem2, true)) != null) {
                    String fString;
                    phaseMessage = "faultstring not found";
                    elem2 = (Element)elem.getElementsByTagName("faultstring").item(0);
                    if (elem2 != null && (fString = XMLUtil.getElementText(elem2, true)) != null) {
                        phaseMessage = "detail not found";
                        elem2 = (Element)elem.getElementsByTagName("detail").item(0);
                        String dString = null;
                        if (elem2 != null && (elem2 = (Element)elem2.getFirstChild()) != null) {
                            dString = XMLUtil.getElementText(elem2, true);
                        }
                        answer = new SoapFault(fCode, fString);
                        if (dString != null) {
                            answer.setDetail(dString);
                        }
                    }
                }
            }
        }
        if (answer == null) {
            throw new RuntimeException(phaseMessage);
        }
        return answer;
    }

    public static boolean isFault(Document doc) {
        Node flt;
        boolean answer = false;
        Element body = (Element)doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        if (body != null && (flt = body.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault").item(0)) != null) {
            answer = true;
        }
        return answer;
    }
}

