/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import java.util.IdentityHashMap;
import java.util.Iterator;

public abstract class ObjectPool {
    private static final int WAIT_TIMEOUT = 600000;
    private int _numCreatedObjects;
    private int _maxObjectSize;
    private int _currentCapacity;
    private float _loadFactor;
    private int _maxObjectsBeforeReCreate;
    private IdentityHashMap _inUseObjects;
    private IdentityHashMap _freeObjects;
    private IdentityHashMap _toRemoveOnReturn;
    private boolean _initialized;

    protected ObjectPool(int initialObjectSize, int maxObjectSize, float loadFactor) {
        if (initialObjectSize == 0 || maxObjectSize < initialObjectSize || loadFactor < 0.0f) {
            throw new IllegalArgumentException();
        }
        this._maxObjectSize = maxObjectSize;
        this._inUseObjects = new IdentityHashMap(initialObjectSize);
        this._freeObjects = new IdentityHashMap(initialObjectSize);
        this._toRemoveOnReturn = new IdentityHashMap();
        this._loadFactor = loadFactor;
        this._currentCapacity = initialObjectSize;
        this._maxObjectsBeforeReCreate = 0;
    }

    private void ensureInitialized() {
        if (!this._initialized) {
            this.growPool(false);
        }
        this._initialized = true;
    }

    protected abstract Object createObject(int var1);

    protected int getWaitTimeout() {
        return 600000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(boolean waitOnNA) {
        int inUseSize;
        this.ensureInitialized();
        Object foundObject = this.removeAFreeObject();
        if (foundObject == null) {
            if (waitOnNA) {
                if (this._numCreatedObjects == 0) {
                    return null;
                }
                while (foundObject == null) {
                    try {
                        ObjectPool objectPool = this;
                        synchronized (objectPool) {
                            this.wait(this.getWaitTimeout());
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return null;
                    }
                    foundObject = this.removeAFreeObject();
                }
            } else {
                return null;
            }
        }
        if (foundObject == null) {
            return null;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this._inUseObjects.put(foundObject, foundObject);
            inUseSize = this._inUseObjects.size();
        }
        if (inUseSize > this._maxObjectsBeforeReCreate) {
            this.growPool(true);
        }
        return foundObject;
    }

    private synchronized Object removeAFreeObject() {
        Iterator iter = this._freeObjects.keySet().iterator();
        if (iter.hasNext()) {
            Object ret = iter.next();
            iter.remove();
            return ret;
        }
        return null;
    }

    private synchronized Object removeAnInUseObject(Object o) {
        return this._inUseObjects.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnObject(Object o) {
        this.ensureInitialized();
        Object toRemove = this.removeAnInUseObject(o);
        if (toRemove == null) {
            return;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this._freeObjects.put(toRemove, toRemove);
            if (this._toRemoveOnReturn.size() > 0) {
                Iterator iter = this._toRemoveOnReturn.keySet().iterator();
                while (iter.hasNext()) {
                    this.removeObjectFromPool(iter.next());
                }
                this._toRemoveOnReturn.clear();
            }
            this.notify();
        }
    }

    private synchronized Object removeObjectFromPool(Object o) {
        Object remmed = this._freeObjects.remove(o);
        if (remmed != null) {
            --this._numCreatedObjects;
            this.growPool(true);
        }
        return remmed;
    }

    protected synchronized void markForPoolRemoval(Object o) {
        this.ensureInitialized();
        Object remmed = this.removeObjectFromPool(o);
        if (remmed != null) {
            return;
        }
        this._toRemoveOnReturn.put(o, o);
    }

    private final synchronized void growPool(boolean growIfNeeded) {
        if (this._currentCapacity > this._maxObjectsBeforeReCreate) {
            if (growIfNeeded) {
                this._currentCapacity = Math.min(this._currentCapacity * 2, this._maxObjectSize);
            }
        } else {
            return;
        }
        int curSize = 0;
        curSize = this._inUseObjects.size() + this._freeObjects.size();
        int toCreate = this._currentCapacity - curSize;
        for (int i = 0; i < toCreate; ++i) {
            int input = 1 + this._numCreatedObjects;
            try {
                Object n = this.createObject(input);
                if (n == null) continue;
                this._freeObjects.put(n, n);
                this._numCreatedObjects = input;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._maxObjectsBeforeReCreate = this._currentCapacity == this._maxObjectSize ? this._currentCapacity + 1 : (int)((float)this._currentCapacity * this._loadFactor);
    }

    public int getNumObjectsInPool() {
        return this._numCreatedObjects;
    }
}

