/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.KeyAndCert;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import sun.misc.HexDumpEncoder;

public class KeyStoreUtils {
    private KeyStore ks;
    private Map props;
    private char[] kspw;
    private String phaseMessage;
    public static final String KEYSTORENAME = "keystorename";
    public static final String KEYSTOREPW = "keystorepw";
    public static final String KEYSTORETYPE = "keystoretype";
    public static final String MYALIAS = "myalias";
    public static final String[] PARAMS = new String[]{"keystorename", "keystorepw", "keystoretype", "myalias"};

    public KeyStoreUtils(Map params) {
        this.props = new HashMap(params);
    }

    public KeyStore openKeystore() {
        KeyStore answer;
        block12: {
            answer = this.ks;
            try {
                if (answer != null) break block12;
                this.phaseMessage = "getting keystore password";
                String ksPw = (String)this.props.get(KEYSTOREPW);
                if (ksPw == null) {
                    throw new RuntimeException();
                }
                this.kspw = ksPw.toCharArray();
                String type = (String)this.props.get(KEYSTORETYPE);
                if (type == null) {
                    type = "jks";
                }
                try {
                    this.phaseMessage = "getting keystore type";
                    answer = KeyStore.getInstance(type);
                    this.phaseMessage = "getting keystore inputstream";
                    String ksName = (String)this.props.get(KEYSTORENAME);
                    if (ksName == null) {
                        throw new RuntimeException();
                    }
                    FileInputStream ksis = new FileInputStream(ksName);
                    this.phaseMessage = "opening keystore";
                    answer.load(ksis, this.kspw);
                }
                catch (KeyStoreException e) {
                    throw new RuntimeException(e);
                }
                catch (RuntimeException e) {
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (CertificateException e) {
                }
                catch (IOException e) {
                }
            }
            catch (Exception e) {
                throw new RuntimeException(this.phaseMessage, e);
            }
        }
        return answer;
    }

    public PrivateKey getMyPrivateKey() {
        PrivateKey pk = null;
        this.ks = this.openKeystore();
        if (this.ks != null) {
            this.phaseMessage = "locating my alias";
            String myAlias = "tomcat";
            if (myAlias == null) {
                throw new RuntimeException();
            }
            try {
                this.phaseMessage = "getting private key";
                pk = (PrivateKey)this.ks.getKey(myAlias, this.kspw);
            }
            catch (KeyStoreException e) {
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                // empty catch block
            }
        }
        return pk;
    }

    public Certificate getMyCert() {
        return this.getThisCert("tomcat");
    }

    public KeyAndCert getMyKeyAndCert() {
        KeyAndCert answer = null;
        Key pk = null;
        Certificate cert = null;
        this.ks = this.openKeystore();
        if (this.ks != null) {
            this.phaseMessage = "locating my alias";
            String myAlias = (String)this.props.get(MYALIAS);
            if (myAlias == null) {
                myAlias = "tomcat";
            }
            try {
                if (!this.ks.containsAlias(myAlias)) {
                    throw new RuntimeException(this.phaseMessage);
                }
                this.phaseMessage = "getting cert from keystore";
                cert = this.ks.getCertificate(myAlias);
                if (this.ks.isKeyEntry(myAlias)) {
                    this.phaseMessage = "getting private key";
                    pk = this.ks.getKey(myAlias, this.kspw);
                } else {
                    this.phaseMessage = "getting public key";
                    pk = cert.getPublicKey();
                }
                answer = new KeyAndCert(pk, cert);
            }
            catch (KeyStoreException e) {
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (UnrecoverableKeyException e) {
                // empty catch block
            }
        }
        return answer;
    }

    public Certificate getThisCert(String alias) {
        Certificate cert = null;
        this.ks = this.openKeystore();
        if (this.ks != null) {
            this.phaseMessage = "locating Identity Provider alias";
            if (alias == null) {
                throw new RuntimeException();
            }
            try {
                this.phaseMessage = "getting certificate";
                cert = this.ks.getCertificate(alias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return cert;
    }

    public static String getB64Skid(Certificate cert, boolean shortie) {
        String answer = null;
        byte[] bits = null;
        if (cert instanceof X509Certificate) {
            bits = KeyStoreUtils.getSkiWithTrim((X509Certificate)cert);
        }
        if (bits == null) {
            PublicKey key = cert.getPublicKey();
            try {
                bits = KeyStoreUtils.computeKID(key, shortie);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bits != null) {
            answer = Base64.encode(bits);
        }
        return answer;
    }

    public static String getB64Skid(Certificate cert) {
        return KeyStoreUtils.getB64Skid(cert, false);
    }

    public static String getB64Skid(Certificate cert, String likeThis) {
        String answer = null;
        byte[] bits = null;
        if (cert instanceof X509Certificate) {
            bits = KeyStoreUtils.getSkiWithTrim((X509Certificate)cert);
        }
        if (bits == null) {
            PublicKey key = cert.getPublicKey();
            try {
                boolean shortie = false;
                if (likeThis.length() < 28) {
                    shortie = true;
                }
                bits = KeyStoreUtils.computeKID(key, shortie);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bits != null) {
            answer = Base64.encode(bits);
        }
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Key getPublicKeyBySKI(String skiS, X509Certificate isThisTheOne) {
        PublicKey pk = null;
        byte[] attempt = KeyStoreUtils.getSkiWithTrim(isThisTheOne);
        if (attempt == null) {
            try {
                PublicKey temp = isThisTheOne.getPublicKey();
                attempt = KeyStoreUtils.computeKID(temp, false);
                System.out.println("Computed ski = " + new HexDumpEncoder().encodeBuffer(attempt));
                String computeSkiS = Base64.encode(attempt);
                if (computeSkiS.equals(skiS)) {
                    return temp;
                }
                attempt = KeyStoreUtils.computeKID(temp, true);
                System.out.println("Computed ski = " + new HexDumpEncoder().encodeBuffer(attempt));
                computeSkiS = Base64.encode(attempt);
                if (!computeSkiS.equals(skiS)) return pk;
                return temp;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException(nsae);
            }
        }
        String computeSkiS = Base64.encode(attempt);
        if (!computeSkiS.equals(skiS)) return pk;
        return isThisTheOne.getPublicKey();
    }

    public String getAliasBySKI(String skiS) {
        String answer = null;
        this.ks = this.openKeystore();
        try {
            Enumeration<String> enumr = this.ks.aliases();
            while (enumr.hasMoreElements()) {
                String alias = enumr.nextElement();
                Certificate cert = this.ks.getCertificate(alias);
                if (!skiS.equals(KeyStoreUtils.getB64Skid(cert, skiS))) continue;
                answer = alias;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return answer;
    }

    public KeyStore getKeyStoreRef() {
        this.ks = this.openKeystore();
        return this.ks;
    }

    public Key getPrivateKeyBySKI(String skiS) {
        Key pk = null;
        this.ks = this.openKeystore();
        try {
            Enumeration<String> enumr = this.ks.aliases();
            while (enumr.hasMoreElements()) {
                Certificate cert;
                String alias = enumr.nextElement();
                if (!this.ks.isKeyEntry(alias) || !skiS.equals(KeyStoreUtils.getB64Skid(cert = this.ks.getCertificate(alias), skiS))) continue;
                pk = this.ks.getKey(alias, this.kspw);
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return pk;
    }

    public Key getPublicKeyBySKI(String skiS) {
        Key pk = null;
        String alias = null;
        X509Certificate cert = null;
        this.ks = this.openKeystore();
        System.out.println("looking for this ski " + skiS);
        if (this.ks != null) {
            try {
                Enumeration<String> enumr = this.ks.aliases();
                while (enumr.hasMoreElements() && (pk = KeyStoreUtils.getPublicKeyBySKI(skiS, cert = (X509Certificate)this.ks.getCertificate(alias = enumr.nextElement()))) == null) {
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
        }
        if (pk == null) {
            throw new RuntimeException("could not find a matching SKI in the keystore");
        }
        return pk;
    }

    private static byte[] getSkiWithTrim(X509Certificate xcert) {
        byte[] bits = null;
        byte[] bytes = xcert.getExtensionValue("2.5.29.14");
        if (bytes != null) {
            bits = new byte[bytes.length - 4];
            System.arraycopy(bytes, 4, bits, 0, bits.length);
        }
        return bits;
    }

    private static byte[] computeKID(PublicKey key, boolean shortValue) throws NoSuchAlgorithmException {
        int off = 0;
        byte[] k = key.getEncoded();
        if (k == null) {
            return null;
        }
        if (off >= k.length) {
            return null;
        }
        MessageDigest dig = MessageDigest.getInstance("SHA1");
        dig.update(k, off, k.length - off);
        if (shortValue) {
            byte[] d = dig.digest();
            byte[] r = new byte[8];
            for (int j = 0; j < 8; ++j) {
                r[j] = d[j + d.length - 8];
            }
            r[0] = (byte)(r[0] & 0xF | 0x40);
            return r;
        }
        return dig.digest();
    }

    public void finalize() {
        if (this.kspw != null) {
            for (int i = 0; i < this.kspw.length; ++i) {
                this.kspw[i] = '\u0000';
            }
        }
    }
}

