/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.AdHocIDResolver;
import com.ibm.ws.wssecurity.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import java.security.Key;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EncServices {
    public static final String ISDEBUGGING = "isdebugging";

    private EncServices() {
    }

    public static Element encryptAndReplaceDataContent(Document doc, Key encrKey, String encElementIdentifier, String encMethod, Element toEncRep, Element ki) {
        return EncServices.encryptAndReplaceData(doc, encrKey, encElementIdentifier, encMethod, toEncRep, ki, "Content");
    }

    public static Element encryptAndReplaceDataElement(Document doc, Key encrKey, String encElementIdentifier, String encMethod, Element toEncRep, Element ki) {
        return EncServices.encryptAndReplaceData(doc, encrKey, encElementIdentifier, encMethod, toEncRep, ki, "Element");
    }

    public static Element encryptKey(Document doc, Key encrKey, String encKeyIdentifier, String encMethod, Key keyToEncrypt, Element str) {
        String ALGORITHM = "Algorithm";
        Element encDataElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey");
        if (encKeyIdentifier != null) {
            encDataElem.setAttribute("Id", encKeyIdentifier);
        }
        encDataElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        Element encMethElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encMethElem.setAttribute(ALGORITHM, encMethod);
        encDataElem.appendChild(encMethElem);
        Element ki = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        ki.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        ki.appendChild(str);
        encDataElem.appendChild(ki);
        Element cipherDataElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValueElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherDataElem.appendChild(cipherValueElem);
        encDataElem.appendChild(cipherDataElem);
        EncryptionContext cxt = new EncryptionContext();
        AlgorithmFactory algo = AlgorithmFactory.getInstance();
        cxt.setAlgorithmFactory(algo);
        cxt.setData(keyToEncrypt);
        cxt.setKey(encrKey);
        cxt.setEncryptedType(encDataElem, null, null, null);
        try {
            cxt.encrypt();
        }
        catch (Exception e) {
            throw new RuntimeException("encrypting requested key", e);
        }
        return encDataElem;
    }

    public static Element encryptKey(Document doc, Key encrKey, String encKeyIdentifier, Key keyToEncrypt, Element str) {
        String ALGORITHM = "Algorithm";
        Element encDataElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey");
        if (encKeyIdentifier != null) {
            encDataElem.setAttribute("Id", encKeyIdentifier);
        }
        encDataElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        Element encMethElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encMethElem.setAttribute(ALGORITHM, "http://www.w3.org/2001/04/xmlenc#kw-aes128");
        encDataElem.appendChild(encMethElem);
        Element ki = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        ki.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        ki.appendChild(str);
        encDataElem.appendChild(ki);
        Element cipherDataElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValueElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherDataElem.appendChild(cipherValueElem);
        encDataElem.appendChild(cipherDataElem);
        EncryptionContext cxt = new EncryptionContext();
        AlgorithmFactory algo = AlgorithmFactory.getInstance();
        cxt.setAlgorithmFactory(algo);
        cxt.setData(keyToEncrypt);
        cxt.setKey(encrKey);
        cxt.setEncryptedType(encDataElem, null, null, null);
        try {
            cxt.encrypt();
        }
        catch (Exception e) {
            throw new RuntimeException("encrypting requested key", e);
        }
        return encDataElem;
    }

    public static Key decryptKey(Document in, Key decryptKey, Element encryptedKey, String originalKeyType) {
        Key answer = null;
        AdHocIDResolver idResolver = new AdHocIDResolver(in);
        AlgorithmFactory afactory = AlgorithmFactory.getInstance();
        EasyKeyInfoResolver kiResolver = new EasyKeyInfoResolver(decryptKey);
        kiResolver.setOperationMode(2);
        DecryptionContext dcontext = new DecryptionContext();
        dcontext.setAlgorithmFactory(afactory);
        dcontext.setKeyInfoResolver((KeyInfoResolver)kiResolver);
        dcontext.setIdResolver((IDResolver)idResolver);
        dcontext.setKey(decryptKey);
        Element meth = in.createElementNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
        meth.setAttribute("Algorithm", originalKeyType);
        dcontext.setEncryptedType(encryptedKey, null, null, null);
        dcontext.setEncryptionMethod(meth);
        try {
            dcontext.decrypt();
            answer = (Key)dcontext.getData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return answer;
    }

    public static void decryptContent(Document in, Key decryptKey, Element encryptedContent) {
        AdHocIDResolver idResolver = new AdHocIDResolver(in);
        AlgorithmFactory afactory = AlgorithmFactory.getInstance();
        EasyKeyInfoResolver kiResolver = new EasyKeyInfoResolver(decryptKey);
        kiResolver.setOperationMode(2);
        DecryptionContext dcontext = new DecryptionContext();
        dcontext.setAlgorithmFactory(afactory);
        dcontext.setKeyInfoResolver((KeyInfoResolver)kiResolver);
        dcontext.setIdResolver((IDResolver)idResolver);
        dcontext.setEncryptedType(encryptedContent, null, null, null);
        dcontext.setKey(decryptKey);
        Element meth = (Element)encryptedContent.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
        dcontext.setEncryptionMethod(meth);
        try {
            dcontext.decrypt();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            dcontext.replace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void decryptReferenceList(Document in, Key decryptKey) {
        MyIDResolver idResolver = new MyIDResolver();
        AlgorithmFactory afactory = AlgorithmFactory.getInstance();
        EasyKeyInfoResolver kiResolver = new EasyKeyInfoResolver(decryptKey);
        kiResolver.setOperationMode(2);
        DecryptionContext dcontext = new DecryptionContext();
        dcontext.setAlgorithmFactory(afactory);
        dcontext.setKeyInfoResolver((KeyInfoResolver)kiResolver);
        dcontext.setIdResolver((IDResolver)idResolver);
        NodeList rList = in.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList").item(0).getChildNodes();
        for (int i = 0; i < rList.getLength(); ++i) {
            Element listelem = (Element)rList.item(i);
            String id = listelem.getAttribute("URI").substring(1);
            Element anelem = idResolver.resolveID(in, id);
            dcontext.setEncryptedType(anelem, null, null, null);
            dcontext.setKey(decryptKey);
            try {
                dcontext.decrypt();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                dcontext.replace();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Element encryptAndReplaceData(Document doc, Key encrKey, String encElementIdentifier, String encMethod, Element toEncRep, Element ki, String type) {
        String ALGORITHM = "Algorithm";
        Element encDataElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedData");
        if (encElementIdentifier != null) {
            encDataElem.setAttribute("Id", encElementIdentifier);
        }
        encDataElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        encDataElem.setAttribute("Type", "http://www.w3.org/2001/04/xmlenc#" + type);
        Element encMethElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encMethElem.setAttribute(ALGORITHM, encMethod);
        Element cipherDataElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValueElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherDataElem.appendChild(cipherValueElem);
        encDataElem.appendChild(encMethElem);
        if (ki != null) {
            encDataElem.appendChild(ki);
        }
        encDataElem.appendChild(cipherDataElem);
        EncryptionContext cxt = new EncryptionContext();
        AlgorithmFactory algo = AlgorithmFactory.getInstance();
        cxt.setAlgorithmFactory(algo);
        cxt.setData(toEncRep);
        cxt.setKey(encrKey);
        cxt.setEncryptedType(encDataElem, null, null, null);
        try {
            cxt.encrypt();
            cxt.replace();
        }
        catch (Exception e) {
            throw new RuntimeException("encrypting requested element", e);
        }
        return encDataElem;
    }

    public static byte[] pad(int blocksize, byte[] data) {
        int padcount = blocksize - data.length % blocksize;
        byte[] padded = new byte[data.length + padcount];
        System.arraycopy(data, 0, padded, 0, data.length);
        padded[padded.length - 1] = (byte)padcount;
        return padded;
    }

    public static byte[] depad(byte[] data) {
        byte padcount = data[data.length - 1];
        byte[] depadded = new byte[data.length - padcount];
        System.arraycopy(data, 0, depadded, 0, depadded.length);
        return depadded;
    }

    protected static class EasyKeyInfoResolver
    extends KeyInfoResolverBase {
        private Key _myKey;

        public EasyKeyInfoResolver(Key myKey) {
            this._myKey = myKey;
        }

        public Key resolve(KeyInfo arg0, EncryptionMethod arg1) throws KeyInfoResolvingException {
            return this._myKey;
        }
    }

    private static class MyIDResolver
    implements IDResolver {
        private MyIDResolver() {
        }

        public Element resolveID(Document doc, String id) {
            Element answer = null;
            NodeList nl = doc.getElementsByTagName("*");
            if (nl != null) {
                Element temp = null;
                for (int i = 0; i < nl.getLength(); ++i) {
                    temp = (Element)nl.item(i);
                    Attr attr = temp.getAttributeNode("Id");
                    if (attr == null || !id.equals(attr.getValue())) continue;
                    answer = temp;
                    break;
                }
            }
            return answer;
        }
    }
}

