/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.soap;

import com.ibm.crypto.provider.AESKeySpec;
import com.ibm.crypto.provider.RC4KeySpec;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.jgss.Debug;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.wss.KerberosTokenGenerator;
import com.ibm.security.krb5.wss.soap.util.SoapPing;
import com.ibm.security.krb5.wss.util.BinarySecurityToken;
import com.ibm.security.krb5.wss.util.EncServices;
import com.ibm.security.krb5.wss.util.LocalConstants;
import com.ibm.security.krb5.wss.util.MiscUtils;
import com.ibm.security.krb5.wss.util.Programmable;
import com.ibm.security.krb5.wss.util.RecursiveIDResolver;
import com.ibm.security.krb5.wss.util.Reference;
import com.ibm.security.krb5.wss.util.SecurityTokenReference;
import com.ibm.security.krb5.wss.util.TemplateTool;
import com.ibm.security.krb5.wss.util.XMLUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import java.security.Key;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KerberosSoapClient
extends Programmable
implements LocalConstants {
    public static final int WRAPPED = 1;
    public static final int NOT_WRAPPED = 2;
    public static final int RFC_NEEDED = 1;
    public static final String MESSAGE = "message";
    public static final String CLIENTNAME = "clientname";
    public static final String REALMNAME = "realmname";
    public static final String PASSWORD = "password";
    public static final String SERVICENAME = "servicename";
    public static final String LOGINCONF = "loginConfig";
    public static final String APPEND_RFC = "appendRFC";
    private static final String debugPrefix = "KerberosSoapClient: ";
    private byte[] localSubKey = null;
    private String phaseMessage = "";
    private boolean rfc;
    private Debug debug = new Debug();
    private HexDumpEncoder encoder = new HexDumpEncoder();
    private int encType;

    public KerberosSoapClient() {
        super(KerberosSoapClient.class);
    }

    public KerberosSoapClient(Map settings) {
        super(KerberosSoapClient.class, settings);
    }

    public Document buildAPREQDoc() {
        Document resp = null;
        try {
            this.phaseMessage = "getting new Document";
            resp = XMLUtil.newDocument();
            this.phaseMessage = "getting LoginContext";
            Integer wrapped = new Integer(2);
            HashMap<String, Object> initMap = new HashMap<String, Object>();
            initMap.put("clientRealmName", (String)this.props.get(REALMNAME));
            initMap.put("serviceName", (String)this.props.get(SERVICENAME));
            initMap.put("clientName", (String)this.props.get(CLIENTNAME));
            initMap.put("clientPassword", (String)this.props.get(PASSWORD));
            initMap.put("clientLoginConfig", (String)this.props.get(LOGINCONF));
            initMap.put("wrapped", wrapped);
            Integer rfcAppend = (Integer)this.props.get(APPEND_RFC);
            if (rfcAppend != null && rfcAppend == 1) {
                this.rfc = true;
            }
            KerberosTokenGenerator ktg = new KerberosTokenGenerator();
            ktg.init(initMap);
            HashMap contextMap = new HashMap();
            ktg.invoke(contextMap);
            this.localSubKey = (byte[])contextMap.get("contextSubKeyBytes");
            this.encType = (Integer)contextMap.get("contextSubKeyEnc");
            this.genSoapParts(resp, (String)this.props.get(MESSAGE), this.localSubKey, (byte[])contextMap.get("contextAPReq"), false);
        }
        catch (Exception e) {
            RuntimeException re = null;
            if (e instanceof RuntimeException) {
                re = (RuntimeException)e;
                if (re.getMessage() == null) {
                    re = new RuntimeException(this.phaseMessage, e);
                }
            } else {
                e.printStackTrace();
                re = new RuntimeException(this.phaseMessage, e);
            }
            throw re;
        }
        return resp;
    }

    public Document buildGSSDoc() {
        Document resp = null;
        try {
            this.phaseMessage = "getting new Document";
            resp = XMLUtil.newDocument();
            this.phaseMessage = "getting LoginContext";
            Integer wrapped = new Integer(1);
            HashMap<String, Object> initMap = new HashMap<String, Object>();
            initMap.put("clientRealmName", (String)this.props.get(REALMNAME));
            initMap.put("serviceName", (String)this.props.get(SERVICENAME));
            initMap.put("clientName", (String)this.props.get(CLIENTNAME));
            initMap.put("clientPassword", (String)this.props.get(PASSWORD));
            initMap.put("clientLoginConfig", (String)this.props.get(LOGINCONF));
            initMap.put("wrapped", wrapped);
            Integer rfcAppend = (Integer)this.props.get(APPEND_RFC);
            if (rfcAppend != null && rfcAppend == 1) {
                this.rfc = true;
            }
            KerberosTokenGenerator ktg = new KerberosTokenGenerator();
            ktg.init(initMap);
            HashMap contextMap = new HashMap();
            ktg.invoke(contextMap);
            this.localSubKey = (byte[])contextMap.get("contextSubKeyBytes");
            this.encType = (Integer)contextMap.get("contextSubKeyEnc");
            this.genSoapParts(resp, (String)this.props.get(MESSAGE), this.localSubKey, (byte[])contextMap.get("contextGSSToken"), true);
        }
        catch (Exception e) {
            RuntimeException re = null;
            if (e instanceof RuntimeException) {
                re = (RuntimeException)e;
                if (re.getMessage() == null) {
                    re = new RuntimeException(this.phaseMessage, e);
                }
            } else {
                e.printStackTrace();
                re = new RuntimeException(this.phaseMessage, e);
            }
            throw re;
        }
        return resp;
    }

    public String getReply(Document response) throws Exception {
        String answer = null;
        this.requestorSideDecryptResponseMessage(response, this.localSubKey);
        Element wsse2 = (Element)response.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
        this.requestorSideVerifySignatureOnResponseMessage(response, wsse2, this.localSubKey);
        answer = this.requestorSideReturnPingResponse(response);
        return answer;
    }

    private Response genSoapParts(Document doc, String pingText, byte[] ek, byte[] apreq, boolean wrapped) {
        Element root = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        root.setPrefix("soap");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        doc.appendChild(root);
        Element soapHdr = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        soapHdr.setPrefix("soap");
        root.appendChild(soapHdr);
        Element wsseE = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        wsseE.setPrefix("wsse");
        wsseE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        wsseE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:mustUnderstand", "1");
        soapHdr.appendChild(wsseE);
        Element timeE = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Timestamp");
        timeE.setPrefix("wsu");
        timeE.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", "timestamp");
        Element createdE = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Created");
        createdE.setPrefix("wsu");
        createdE.appendChild(doc.createTextNode(MiscUtils.makeDateTime()));
        timeE.appendChild(createdE);
        wsseE.appendChild(timeE);
        BinarySecurityToken bst = new BinarySecurityToken();
        if (!wrapped) {
            if (this.rfc && (this.encType == 17 || this.encType == 17)) {
                bst.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ@4120");
            } else if (this.rfc) {
                bst.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ@1510");
            } else {
                bst.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ");
            }
        } else if (this.rfc && (this.encType == 17 || this.encType == 17)) {
            bst.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@4120");
        } else if (this.rfc) {
            bst.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@1510");
        } else {
            bst.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
        }
        bst.put("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        bst.put("id", "token");
        bst.put("bytearray", apreq);
        Element bstE = bst.toDom(doc);
        wsseE.appendChild(bstE);
        Element soapBody = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        soapBody.setPrefix("soap");
        soapBody.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", "body");
        Element pingE = SoapPing.makePingElement(doc, pingText);
        soapBody.appendChild(pingE);
        root.appendChild(soapBody);
        try {
            Element protoSig = TemplateTool.genSignatureElem(doc, new String[]{"timestamp", "body"}, "http://www.w3.org/2000/09/xmldsig#hmac-sha1", false);
            wsseE.appendChild(protoSig);
            Reference ref = new Reference();
            if (!wrapped) {
                ref.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            } else {
                ref.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            }
            ref.put("URI", "#token");
            SecurityTokenReference str = new SecurityTokenReference();
            str.put("reference", ref);
            protoSig.appendChild(TemplateTool.genKeyInfoElem(doc, str.toDom(doc), false));
            SignatureContext sc = new SignatureContext();
            sc.setIDResolver((IDResolver)new RecursiveIDResolver());
            this.phaseMessage = "sign the doc";
            this.debug.out(5, debugPrefix + XMLUtil.getStringUnchanged(doc));
            SecretKey key = null;
            if (EncryptedData.isRc4HMacEncType((int)this.encType)) {
                RC4KeySpec rc4KeySpec = new RC4KeySpec(ek);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("RC4", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)rc4KeySpec);
            } else if (this.encType == 16) {
                SecretKeySpec DESedeKeySpec = new SecretKeySpec(ek, "DESede");
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede", "IBMJCE");
                key = keyFactory.generateSecret(DESedeKeySpec);
            } else if (this.encType == 17) {
                AESKeySpec aesKeySpec = new AESKeySpec(ek);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)aesKeySpec);
            } else if (this.encType == 18) {
                AESKeySpec aesKeySpec = new AESKeySpec(ek);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)aesKeySpec);
            } else if (EncryptedData.isDesEncType((int)this.encType)) {
                SecretKeySpec DESKeySpec2 = new SecretKeySpec(ek, "DES");
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES", "IBMJCE");
                key = keyFactory.generateSecret(DESKeySpec2);
            } else {
                throw new RuntimeException("Unsupported Encryption Type for the Subsession Key");
            }
            sc.sign(protoSig, (Key)key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Response(root, wsseE, soapBody, pingE);
    }

    private void requestorSideDecryptResponseMessage(Document doc, byte[] sessKey) throws Exception {
        AESKeySpec aesKeySpec = new AESKeySpec(sessKey);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
        SecretKey key = keyFactory.generateSecret((KeySpec)aesKeySpec);
        this.debug.out(5, "KerberosSoapClient: OutputKey:  " + this.encoder.encodeBuffer(key.getEncoded()));
        this.debug.out(5, "KerberosSoapClient: The XML Soap DOC =\n" + XMLUtil.getStringUnchanged(doc));
        Node child = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0).getFirstChild();
        while (!(child instanceof Element)) {
            child = child.getNextSibling();
        }
        Element encContent = (Element)child;
        EncServices.decryptContent(doc, key, encContent);
    }

    private void requestorSideVerifySignatureOnResponseMessage(Document docIn, Element wsse2, byte[] rawKey) throws Exception {
        AESKeySpec aesKeySpec;
        SignatureContext sc = new SignatureContext();
        sc.setIDResolver((IDResolver)new RecursiveIDResolver());
        this.phaseMessage = "verify the signature";
        this.debug.out(5, debugPrefix + XMLUtil.getStringUnchanged(docIn));
        Element sigE = (Element)wsse2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        SecretKey key = null;
        if (EncryptedData.isRc4HMacEncType((int)this.encType)) {
            RC4KeySpec rc4KeySpec = new RC4KeySpec(rawKey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("RC4", "IBMJCE");
            key = keyFactory.generateSecret((KeySpec)rc4KeySpec);
        } else if (this.encType == 16) {
            SecretKeySpec DESedeKeySpec = new SecretKeySpec(rawKey, "DESede");
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede", "IBMJCE");
            key = keyFactory.generateSecret(DESedeKeySpec);
        } else if (this.encType == 17) {
            aesKeySpec = new AESKeySpec(rawKey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
            key = keyFactory.generateSecret((KeySpec)aesKeySpec);
        } else if (this.encType == 18) {
            aesKeySpec = new AESKeySpec(rawKey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
            key = keyFactory.generateSecret((KeySpec)aesKeySpec);
        } else if (EncryptedData.isDesEncType((int)this.encType)) {
            SecretKeySpec DESKeySpec2 = new SecretKeySpec(rawKey, "DES");
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES", "IBMJCE");
            key = keyFactory.generateSecret(DESKeySpec2);
        } else {
            throw new RuntimeException("Unsupported Encryption Type for the Subsession Key");
        }
        Validity vlid = sc.verify(sigE, (Key)key);
        if (!vlid.getCoreValidity()) {
            throw new RuntimeException("sig validation failed");
        }
    }

    private String requestorSideReturnPingResponse(Document docIn) {
        String answer = null;
        this.phaseMessage = "building echo response";
        Element ping = (Element)docIn.getElementsByTagNameNS("http://xmlsoap.org/Ping", "PingResponse").item(0);
        answer = XMLUtil.getElementText(ping, true);
        return answer;
    }

    class Response {
        Element rootE;
        Element wsseE;
        Element bodyE;
        Element pingE;

        Response(Element root, Element wsse2, Element body, Element ping) {
            this.rootE = root;
            this.wsseE = wsse2;
            this.bodyE = body;
            this.pingE = ping;
        }
    }
}

