/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.auth.callback.CcacheFileTextInputCallback;
import com.ibm.security.auth.callback.DefaultCcacheTextInputCallback;
import com.ibm.security.auth.callback.DefaultKeytabTextInputCallback;
import com.ibm.security.auth.callback.KeytabFileTextInputCallback;
import com.ibm.security.jgss.TokenHeader;
import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Checksum;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.APOptions;
import com.ibm.security.krb5.internal.APReq;
import com.ibm.security.krb5.internal.Authenticator;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.EncKrbCredPart;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.KRBCred;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbCredInfo;
import com.ibm.security.krb5.internal.LocalSeqNumber;
import com.ibm.security.krb5.internal.ServiceName;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.wss.KerberosCredsUtil;
import com.ibm.security.krb5.wss.util.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class KerberosTokenGenerator {
    private static final String debugPrefix = "KerberosTokenGenerator: ";
    private static final int DELEG_FLAG = 1;
    private static final int WRAPPED = 1;
    private static final int NOT_WRAPPED = 0;
    private static final int KD_AP_REQ_AUTHN = 11;
    public static final int CKSUMTYPE_KRB = 32771;
    private static final int TOK_ID_LEN = 2;
    private static final byte[] AP_REQ_TOK_ID = new byte[]{1, 0};
    private boolean isWrapped;
    private Subject subject;
    private EncryptionKey sessionKey = null;
    private EncryptionKey localSubKey = null;
    private byte[] gssWrappedToken;
    private byte[] apReqToken;
    private Debug debug = new Debug();
    private String clientRealmName;
    private String serviceRealmName;
    private String clientName;
    private String serviceName;
    private Integer wrapped;
    private boolean useSubject;
    private String jaasClientPassword;
    private String jaasLoginConf;
    private boolean useDelegatedCreds = false;
    private byte[] delegatedCreds;
    private byte[] sessionKey4Delegate = null;
    private int sessionKey4DelegateType;
    private KerberosTicket serviceTicket = null;

    public void init(Map config2) throws Exception {
        try {
            this.clientRealmName = (String)config2.get("clientRealmName");
            this.clientName = (String)config2.get("clientName");
            this.serviceName = (String)config2.get("serviceName");
            this.serviceRealmName = (String)config2.get("serviceRealmName");
            this.wrapped = (Integer)config2.get("wrapped");
            if (this.wrapped != null && this.wrapped == 1) {
                this.isWrapped = true;
            }
            this.subject = (Subject)config2.get("subject");
            if (this.subject != null) {
                this.setUseSubjectCredsOnly(true);
            }
            Config krb5Config = Config.getInstance();
            String realm = krb5Config.getDefaultRealm();
            if (this.clientRealmName == null || this.clientRealmName.trim().equals("")) {
                this.clientRealmName = realm;
            }
            if (this.serviceRealmName == null || this.serviceRealmName.trim().equals("")) {
                this.serviceRealmName = realm;
            }
            if (this.clientRealmName == null || this.serviceName == null || this.serviceRealmName == null) {
                throw new IllegalStateException("Null Input values");
            }
            this.jaasClientPassword = (String)config2.get("clientPassword");
            this.jaasLoginConf = (String)config2.get("clientLoginConfig");
            this.delegatedCreds = (byte[])config2.get("contextDelegatedCredsBytes");
            if (this.delegatedCreds != null && this.delegatedCreds.length > 0) {
                this.useDelegatedCreds = true;
                this.sessionKey4Delegate = (byte[])config2.get("contextSessionKeyBytes");
                this.sessionKey4DelegateType = (Integer)config2.get("contextSessionKeyBytesType");
                if (this.sessionKey4Delegate == null || this.sessionKey4Delegate.length == 0 || "".equals(this.sessionKey4DelegateType)) {
                    this.debug.out(4, "KerberosTokenGenerator: sessionKey/keyType missing for delegated credentials");
                    throw new IllegalStateException("session key or key type missing for delegated credentials");
                }
            }
        }
        catch (Exception exc) {
            throw new IllegalStateException("Invalid config parameters", exc);
        }
    }

    public void invoke(Map context) throws Exception {
        Credentials ccreds = null;
        if (!this.useDelegatedCreds) {
            this.jaasLogin();
            ccreds = this.getClientCredentials(this.clientName);
        } else {
            EncryptionKey encKey = new EncryptionKey(this.sessionKey4Delegate, this.sessionKey4DelegateType, Integer.valueOf(1));
            KerberosCredsUtil krbCredUtil = new KerberosCredsUtil();
            ccreds = krbCredUtil.getClientCredentials(this.delegatedCreds, encKey);
        }
        if (this.isWrapped) {
            this.requestorSideGSSTokenCreation(this.serviceRealmName, this.clientName, ccreds, this.serviceName);
        } else {
            this.requestorSideAPReqCreation(this.serviceRealmName, this.clientName, ccreds, this.serviceName);
        }
        this.fillContext(context);
    }

    private void jaasLogin() {
        String fullClientName = this.clientName + "@" + this.clientRealmName;
        if (this.subject == null && !this.useSubjectCredsOnly() && this.jaasLoginConf != null && this.jaasClientPassword != null) {
            this.debug.out(5, "KerberosTokenGenerator: Attempting to do a JAAS Login for: \n" + fullClientName);
            try {
                LoginContext lc = new LoginContext(this.jaasLoginConf, new NullPrompter(fullClientName, this.jaasClientPassword.toCharArray()));
                lc.login();
                this.subject = lc.getSubject();
                this.setUseSubjectCredsOnly(true);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                this.debug.out(5, "KerberosTokenGenerator: Failed to do a JAAS Login for: \n" + fullClientName);
                this.setUseSubjectCredsOnly(false);
            }
        } else if (this.subject != null) {
            this.debug.out(5, "KerberosTokenGenerator: Will attempt to use supplied Subject\n");
            this.setUseSubjectCredsOnly(true);
        }
    }

    private void fillContext(Map context) {
        if (this.isWrapped()) {
            Integer wrap = new Integer(1);
            context.put("contextWrapped", wrap);
            context.put("contextWrappedType", new String(wrap.getClass().getName()));
        } else {
            Integer notWrap = new Integer(0);
            context.put("contextWrapped", notWrap);
            context.put("contextWrappedType", new String(notWrap.getClass().getName()));
        }
        if (this.sessionKey != null) {
            byte[] sessKey = this.sessionKey.getBytes();
            context.put("contextSessionKeyBytes", sessKey);
            context.put("contextSessionKeyBytesType", this.sessionKey.getEType());
        }
        if (this.localSubKey != null) {
            byte[] locSubKey = this.localSubKey.getBytes();
            context.put("contextSubKeyBytes", locSubKey);
        }
        if (this.apReqToken != null) {
            context.put("contextAPReq", this.apReqToken);
            context.put("contextAPReqType", new String(this.apReqToken.getClass().getName()));
        }
        if (this.gssWrappedToken != null) {
            context.put("contextGSSToken", this.gssWrappedToken);
            context.put("contextGSSTokenType", new String(this.gssWrappedToken.getClass().getName()));
        }
        if (this.sessionKey != null) {
            Integer sessEncType = new Integer(this.getSessionKeyEncType());
            context.put("contextSessionKeyEnc", sessEncType);
        }
        if (this.localSubKey != null) {
            Integer subEncType = new Integer(this.getSubSessionKeyEncType());
            context.put("contextSubKeyEnc", subEncType);
            context.put("contextSubKeyEncType", new String(subEncType.getClass().getName()));
        }
        if (this.subject != null) {
            context.put("contextSubject", this.subject);
            context.put("contextSubjectType", new String(this.subject.getClass().getName()));
        }
        if (this.serviceTicket != null) {
            context.put("contextServiceTicket", this.serviceTicket);
        }
    }

    private void requestorSideGSSTokenCreation(String realmName, String clientName, Credentials ccreds, String service) throws Exception {
        this.debug.out(7, "KerberosTokenGenerator: Creating an GSS Wrapped output token");
        this.debug.out(7, "KerberosTokenGenerator: The Realm name = " + realmName);
        this.debug.out(7, "KerberosTokenGenerator: The Client name = " + clientName);
        this.debug.out(7, "KerberosTokenGenerator: The Service name = " + service);
        try {
            APReq apReq = this.createAPReq(realmName, ccreds, service);
            this.gssWrappedToken = apReq != null ? this.gssWrapAPReqToken(apReq) : null;
            this.debug.out(7, "KerberosTokenGenerator: The GSS Wrapped Token DER Coded =\n" + new HexDumpEncoder().encodeBuffer(this.gssWrappedToken));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw exc;
        }
    }

    private byte[] gssWrapAPReqToken(APReq apReq) throws Exception {
        byte[] encodedKrbMsg = null;
        byte[] tokId = null;
        tokId = AP_REQ_TOK_ID;
        encodedKrbMsg = apReq.asn1Encode();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(tokId, 0, 2);
        os.write(encodedKrbMsg, 0, encodedKrbMsg.length);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] mechToken = os.toByteArray();
        Oid mech = new Oid("1.2.840.113554.1.2.2");
        TokenHeader header = new TokenHeader(mech, mechToken);
        header.asn1Encode((OutputStream)outStream);
        return outStream.toByteArray();
    }

    private void requestorSideAPReqCreation(String realmName, String client, Credentials ccreds, String service) throws Exception {
        this.debug.out(7, "KerberosTokenGenerator: Creating an AP_REQ output token");
        this.debug.out(7, "KerberosTokenGenerator: The Realm name = " + realmName);
        this.debug.out(7, "KerberosTokenGenerator: The Client name = " + client);
        this.debug.out(7, "KerberosTokenGenerator: The Service name = " + service);
        try {
            APReq apReq = this.createAPReq(realmName, ccreds, service);
            this.apReqToken = apReq != null ? apReq.asn1Encode() : null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw exc;
        }
    }

    private Credentials getClientCredentials(String client) throws Exception {
        KerberosTicket kerbTicket = null;
        Credentials ccreds = null;
        if (this.useSubjectCredsOnly()) {
            this.debug.out(5, "KerberosTokenGenerator: use creds from subject ");
            try {
                kerbTicket = (KerberosTicket)AccessController.doPrivileged(new SubjectCredFinder(client + "@" + this.clientRealmName, "krbtgt"));
            }
            catch (PrivilegedActionException exc) {
                throw (GSSException)exc.getException();
            }
        }
        try {
            if (client == null) {
                this.debug.out(5, "KerberosTokenGenerator: acquiring default creds");
                ccreds = Credentials.acquireDefaultCreds();
            } else {
                String nameStr = client + "@" + this.clientRealmName;
                this.debug.out(5, "KerberosTokenGenerator: acquiring creds for " + nameStr);
                ccreds = Credentials.acquireCreds((String)nameStr, null);
                if (ccreds != null && !ccreds.getClient().toString().equals(nameStr)) {
                    this.debug.out(5, "KerberosTokenGenerator: Cached creds belongs to " + ccreds.getClient().toString());
                    ccreds = null;
                }
            }
        }
        catch (Exception exc) {
            I18NException.throwGSSException((int)11, (int)0, (String)"NoKrbCred", (Object[])new String[]{exc.toString()});
        }
        if (kerbTicket != null && ccreds == null) {
            ccreds = new Credentials(kerbTicket.getEncoded(), kerbTicket.getClient().getName(), kerbTicket.getServer().getName(), kerbTicket.getSessionKey().getEncoded(), kerbTicket.getSessionKeyType(), kerbTicket.getFlags(), kerbTicket.getAuthTime(), kerbTicket.getStartTime(), kerbTicket.getEndTime(), kerbTicket.getRenewTill(), kerbTicket.getClientAddresses());
        }
        if (ccreds == null) {
            I18NException.throwGSSException((int)11, (int)0, (String)"NoKrbCred", (Object[])new String[]{"Failed to obtain credentials for " + client + "@" + this.clientRealmName});
        }
        return ccreds;
    }

    private APReq createAPReq(String serviceRealmName, Credentials ccreds, String service) throws Exception {
        Credentials serviceCreds = null;
        StringBuffer buf = new StringBuffer(service);
        buf.append("@");
        buf.append(serviceRealmName);
        String serviceFullname = buf.toString();
        try {
            serviceCreds = this.getServiceCredentialFromSubject();
            if (serviceCreds == null) {
                this.debug.out(5, "KerberosTokenGenerator:  found no service credential from subject, need to acquire it");
                ServiceName sname = new ServiceName(service);
                serviceCreds = ccreds.acquireSvcCreds((PrincipalName)sname, null, null);
            }
            ServiceName targetName = new ServiceName(serviceFullname);
            this.serviceTicket = new KerberosTicket(serviceCreds.getEncoded(), new KerberosPrincipal(serviceCreds.getClient().toString()), new KerberosPrincipal(serviceCreds.getServer().toString()), serviceCreds.getSessionKey().getBytes(), serviceCreds.getSessionKey().getEType(), serviceCreds.getFlags(), serviceCreds.getAuthTime(), serviceCreds.getStartTime(), serviceCreds.getEndTime(), serviceCreds.getRenewTill(), serviceCreds.getClientAddresses());
            this.sessionKey = serviceCreds.getSessionKey();
            APOptions apOpts = new APOptions();
            apOpts.set(2, false);
            apOpts.set(1, false);
            this.debug.out(4, "KerberosTokenGenerator: The APOptions DER Coded =\n" + new HexDumpEncoder().encodeBuffer(apOpts.asn1Encode()));
            LocalSeqNumber sendSeqNr = new LocalSeqNumber();
            int seed = sendSeqNr.current();
            if (seed == 0) {
                seed = (int)(Math.random() * 16384.0);
            }
            seed = Math.abs(seed);
            sendSeqNr.init(seed);
            if (this.localSubKey == null) {
                this.localSubKey = this.generateSubKey(this.sessionKey);
            }
            KerberosTime timeNow = new KerberosTime(true);
            byte[] cksum = this.encodeCksum((PrincipalName)targetName, ccreds, serviceCreds);
            Checksum checkSum = new Checksum(cksum, 32771);
            Authenticator authn = new Authenticator(serviceCreds.getClient().getRealm(), serviceCreds.getClient(), checkSum, timeNow.getMicroSeconds(), timeNow, this.localSubKey, new Integer(sendSeqNr.step()), null);
            EncryptedData encAuthn = null;
            encAuthn = new EncryptedData(this.sessionKey, authn.asn1Encode(), 11);
            APReq apreq = new APReq(apOpts, serviceCreds.getTicket(), encAuthn);
            this.debug.out(7, "KerberosTokenGenerator: The AP_REQ DER Coded =\n" + new HexDumpEncoder().encodeBuffer(apreq.asn1Encode()));
            this.debug.out(7, "KerberosTokenGenerator: The Authenicator =\n" + new HexDumpEncoder().encodeBuffer(authn.asn1Encode()));
            this.debug.out(7, "KerberosTokenGenerator: The encrypted Authenicator enc type=\n" + encAuthn.encTypeToString() + " " + encAuthn.getEType());
            return apreq;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private byte[] encodeCksum(PrincipalName targetName, Credentials ccreds, Credentials serviceCreds) throws GSSException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] bytes = null;
            bytes = KerberosTokenGenerator.intToBytes(16);
            os.write(bytes, 0, bytes.length);
            bytes = this.encodeNull();
            os.write(bytes, 0, bytes.length);
            int flags = 0;
            bytes = KerberosTokenGenerator.intToBytes(flags |= 1);
            os.write(bytes, 0, bytes.length);
            KRBCred delegCred = this.getDelgCreds(targetName, ccreds, serviceCreds);
            if (delegCred != null) {
                bytes = KerberosTokenGenerator.intToBytes(1, 2);
                os.write(bytes, 0, bytes.length);
                bytes = delegCred.asn1Encode();
                os.write(KerberosTokenGenerator.intToBytes(bytes.length, 2), 0, 2);
                os.write(bytes, 0, bytes.length);
            }
            return os.toByteArray();
        }
        catch (Exception exc) {
            I18NException.throwGSSException((int)11, (int)0, (String)"CksumEncodingError", (Object[])new String[]{exc.toString()});
            return null;
        }
    }

    static byte[] intToBytes(int nr, int size) {
        if (size > 4 || size < 0) {
            size = 4;
        }
        if (size == 0) {
            return null;
        }
        byte[] temp = new byte[size];
        int i = 0;
        while (i < size) {
            temp[i] = (byte)(nr & 0xFF);
            ++i;
            nr >>>= 8;
        }
        return temp;
    }

    static byte[] intToBytes(int nr) {
        return KerberosTokenGenerator.intToBytes(nr, 4);
    }

    private byte[] encodeNull() {
        byte[] bytes = new byte[16];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
        this.debug.out(4, "Encoded null channel binding");
        return bytes;
    }

    public void setUseSubjectCredsOnly(boolean setUseSubjectCreds) {
        this.useSubject = setUseSubjectCreds;
    }

    private boolean useSubjectCredsOnly() {
        return this.useSubject;
    }

    private EncryptionKey generateSubKey(EncryptionKey key) throws Exception {
        int enctype = key.getEType();
        String ktype = null;
        ktype = EncryptedData.isRc4HMacEncType((int)enctype) ? "RC4" : (enctype == 16 ? "Desede" : (enctype == 17 ? "AES" : (enctype == 18 ? "AES" : "DES")));
        KeyGenerator generator = KeyGenerator.getInstance(ktype);
        if (enctype == 17) {
            generator.init(128, new SecureRandom());
        } else if (enctype == 18) {
            generator.init(256, new SecureRandom());
        } else if (EncryptedData.isRc4HMacEncType((int)enctype)) {
            int len = key.getBytes().length;
            generator.init(len <<= 3, new SecureRandom());
        } else {
            generator.init(new SecureRandom());
        }
        SecretKey secretKey = generator.generateKey();
        EncryptionKey newKey = new EncryptionKey(secretKey.getEncoded(), enctype, key.getKeyVersionNumber());
        return newKey;
    }

    private boolean isWrapped() {
        return this.isWrapped;
    }

    private int getSessionKeyEncType() {
        if (this.sessionKey != null) {
            return this.sessionKey.getEType();
        }
        return 0;
    }

    private int getSubSessionKeyEncType() {
        if (this.localSubKey != null) {
            return this.localSubKey.getEType();
        }
        return 0;
    }

    private KRBCred getDelgCreds(PrincipalName server, Credentials ccred, Credentials serviceCreds) throws GSSException {
        KerberosTicket delegTicket = null;
        if (!ccred.isForwardable()) {
            this.debug.out(5, "The client credentials are not forwardable");
            return null;
        }
        this.debug.out(5, "The client credentials are forwardable");
        try {
            Config cfg = Config.getInstance();
            int cfgCheckDelegate = cfg.getDefaultIntValue("check_delegate", "libdefaults");
            this.debug.out(5, "check_delegate=" + cfgCheckDelegate);
            if (cfgCheckDelegate == 1) {
                boolean okAsDelegate = serviceCreds.checkDelegate();
                if (!okAsDelegate) {
                    this.debug.out(5, "Peer not trusted for delegation");
                    return null;
                }
                this.debug.out(5, "Peer  trusted for delegation");
            }
            this.debug.out(5, "Delegating creds");
            KDCOptions options = new KDCOptions();
            options.set(2, true);
            options.set(1, true);
            String tgsRealm = ccred.getClient().getRealmString();
            ServiceName svr = new ServiceName("krbtgt", tgsRealm, tgsRealm);
            HostAddresses peerAddresses = null;
            try {
                peerAddresses = new HostAddresses(server);
            }
            catch (Exception exc) {
                // empty catch block
            }
            Credentials scred = null;
            if (scred == null) {
                scred = ccred.acquireSvcCreds((PrincipalName)svr, options, peerAddresses);
            }
            if (this.useSubjectCredsOnly()) {
                final AccessControlContext context = AccessController.getContext();
                Subject subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Subject.getSubject(context);
                    }
                });
                if (subject != null && !subject.isReadOnly()) {
                    delegTicket = new KerberosTicket(scred.getEncoded(), new KerberosPrincipal(scred.getClient().toString()), new KerberosPrincipal(scred.getServer().toString()), this.sessionKey.getBytes(), this.sessionKey.getEType(), scred.getFlags(), scred.getAuthTime(), scred.getStartTime(), scred.getEndTime(), scred.getRenewTill(), scred.getClientAddresses());
                    EncryptionKey[] skeys = serviceCreds.getServiceKeys();
                    KerberosKey[] kkeys = null;
                    if (skeys != null) {
                        kkeys = new KerberosKey[skeys.length];
                        for (int i = 0; i < skeys.length; ++i) {
                            Integer kvno = skeys[i].getKeyVersionNumber();
                            kkeys[i] = new KerberosKey(new KerberosPrincipal(serviceCreds.getClient().toString()), skeys[i].getBytes(), skeys[i].getEType(), kvno != null ? kvno : 0);
                        }
                    }
                    final KerberosTicket kt = delegTicket;
                    final Subject subjectF = subject;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            subjectF.getPrivateCredentials().add(kt);
                            return null;
                        }
                    });
                    if (kkeys != null) {
                        if (this.debug.on(5)) {
                            this.debug.out(5, "Attempting to add " + kkeys.length + " Kerberos key(s) to Subject");
                        }
                        int added = 0;
                        Set<Object> credSet = subjectF.getPrivateCredentials();
                        for (int i = 0; i < kkeys.length; ++i) {
                            if (!credSet.add(kkeys[i])) {
                                if (!this.debug.on(5)) continue;
                                this.debug.out(5, "key of type " + EncryptedData.encTypeToString((int)kkeys[i].getKeyType()) + " already exists in Subject");
                                continue;
                            }
                            ++added;
                            if (!this.debug.on(5)) continue;
                            this.debug.out(5, "added key of type " + EncryptedData.encTypeToString((int)kkeys[i].getKeyType()));
                        }
                        if (this.debug.on(5)) {
                            this.debug.out(5, "Successfully added " + added + " keys to Subject.");
                        }
                    }
                    this.debug.out(5, "Kerberos Service ticket stored in subject");
                    this.debug.out(5, "Kerberos Delegate Service ticket stored in subject");
                } else {
                    this.debug.out(5, "Subject is readOnly;Kerberos Delegate Service ticket not stored");
                }
            }
            this.debug.out(5, "Packaging creds for delegation to server " + server);
            return this.createKRBCred(peerAddresses, scred);
        }
        catch (KrbException exc) {
            if (this.debug.on(5)) {
                exc.printStackTrace();
            }
            I18NException.throwGSSException((int)11, (int)exc.returnCode(), (String)"KrbErrorCredFormat", (Object[])new Integer[]{new Integer(exc.returnCode())});
        }
        catch (Exception exc) {
            if (this.debug.on(5)) {
                exc.printStackTrace();
            }
            I18NException.throwGSSException((int)11, (int)0, (String)"ErrorCredFormat", (Object[])new String[]{exc.toString()});
        }
        return null;
    }

    private KRBCred createKRBCred(HostAddresses peerAddresses, Credentials cred) throws KrbException, UnknownHostException, Exception {
        Date authTime = cred.getAuthTime();
        Date startTime = cred.getStartTime();
        Date endTime = cred.getEndTime();
        Date renewTill = cred.getRenewTill();
        KrbCredInfo credInfo = new KrbCredInfo(cred.getSessionKey(), cred.getClient().getRealm(), cred.getClient(), cred.getTicketFlags(), authTime != null ? new KerberosTime(authTime) : null, startTime != null ? new KerberosTime(startTime) : null, endTime != null ? new KerberosTime(endTime) : null, renewTill != null ? new KerberosTime(renewTill) : null, cred.getTicket().getRealm(), cred.getTicket().getServer(), new HostAddresses(cred.getClientAddresses()));
        KrbCredInfo[] credInfos = new KrbCredInfo[]{credInfo};
        Ticket[] tickets = new Ticket[]{cred.getTicket()};
        KerberosTime timeNow = new KerberosTime(true);
        EncKrbCredPart encPart = new EncKrbCredPart(credInfos, timeNow, new Integer(timeNow.getMicroSeconds()), new Integer((int)timeNow.getTime()), new HostAddress(), peerAddresses);
        EncryptionKey contextKey = this.getSessionKey();
        EncryptedData encData = null;
        encData = EncryptedData.isDesEncType((int)contextKey.getEType()) ? new EncryptedData(contextKey, encPart.asn1Encode(), 14) : new EncryptedData(contextKey, encPart.asn1Encode(), 14);
        return new KRBCred(tickets, encData);
    }

    private EncryptionKey getSessionKey() {
        return this.sessionKey;
    }

    private Credentials getServiceCredentialFromSubject() throws GSSException {
        Credentials serviceCred = null;
        KerberosTicket svcTicket = null;
        if (this.useSubjectCredsOnly()) {
            try {
                svcTicket = (KerberosTicket)AccessController.doPrivileged(new SubjectCredFinder(this.clientName + "@" + this.clientRealmName, this.serviceName));
            }
            catch (PrivilegedActionException exc) {
                throw (GSSException)exc.getException();
            }
            if (svcTicket != null) {
                try {
                    this.debug.out(4, "KerberosTokenGenerator: Found KerberosTicket from subject =\n" + svcTicket.toString());
                    serviceCred = new Credentials(svcTicket.getEncoded(), svcTicket.getClient().getName(), svcTicket.getServer().getName(), svcTicket.getSessionKey().getEncoded(), svcTicket.getSessionKeyType(), svcTicket.getFlags(), svcTicket.getAuthTime(), svcTicket.getStartTime(), svcTicket.getEndTime(), svcTicket.getRenewTill(), svcTicket.getClientAddresses());
                }
                catch (KrbException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return serviceCred;
    }

    class NullPrompter
    implements CallbackHandler {
        private String userName;
        private char[] authenticator;

        private NullPrompter() {
        }

        public NullPrompter(String userName, char[] authenticator) {
            this.userName = userName;
            this.authenticator = authenticator;
        }

        public void nukeEm() {
            this.userName = null;
            for (int i = 0; i < this.authenticator.length; ++i) {
                this.authenticator[i] = 32;
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextOutputCallback || callbacks[i] instanceof CcacheFileTextInputCallback || callbacks[i] instanceof DefaultCcacheTextInputCallback || callbacks[i] instanceof DefaultKeytabTextInputCallback || callbacks[i] instanceof KeytabFileTextInputCallback) continue;
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(this.userName);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(this.authenticator);
                    continue;
                }
                KerberosTokenGenerator.this.debug.out(5, "KerberosTokenGenerator: Unrecognized Callback :" + callbacks[i]);
            }
        }
    }

    private class SubjectCredFinder
    implements PrivilegedExceptionAction {
        private String clientPrinc;
        private String serviceStarts;

        public SubjectCredFinder(String principal, String serviceStarts) {
            this.clientPrinc = principal;
            this.serviceStarts = serviceStarts;
        }

        public Object run() throws GSSException {
            KerberosTicket kerbTicket;
            KerberosTicket entry;
            try {
                if (KerberosTokenGenerator.this.subject == null && KerberosTokenGenerator.this.useSubject) {
                    final AccessControlContext secContext = AccessController.getContext();
                    KerberosTokenGenerator.this.subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Subject.getSubject(secContext);
                        }
                    });
                }
            }
            catch (Exception exc) {
                KerberosTokenGenerator.this.subject = null;
            }
            if (KerberosTokenGenerator.this.subject == null) {
                I18NException.throwGSSException((int)13, (int)0, (String)"SKFNoSubject");
            }
            Iterator<KerberosTicket> itr = KerberosTokenGenerator.this.subject.getPrivateCredentials(KerberosTicket.class).iterator();
            while (itr.hasNext()) {
                kerbTicket = entry = itr.next();
                KerberosTokenGenerator.this.debug.out(5, "KerberosTokenGenerator: SubjectCredFinder: Found Cred from private set: " + kerbTicket.toString());
                if (this.clientPrinc == null || !kerbTicket.getClient().toString().equals(this.clientPrinc) || !kerbTicket.getServer().toString().startsWith(this.serviceStarts)) continue;
                return kerbTicket;
            }
            itr = KerberosTokenGenerator.this.subject.getPublicCredentials(KerberosTicket.class).iterator();
            while (itr.hasNext()) {
                kerbTicket = entry = itr.next();
                KerberosTokenGenerator.this.debug.out(5, "KerberosTokenGenerator: SubjectCredFinder: Found Cred from public set: " + kerbTicket.toString());
                if (this.clientPrinc == null || !kerbTicket.getClient().toString().equals(this.clientPrinc) || !kerbTicket.getServer().toString().startsWith(this.serviceStarts)) continue;
                return kerbTicket;
            }
            return null;
        }
    }
}

