/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASMessageCatalog;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class RASUtil {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public static final String RAS_MSG_CAT = "com.ibm.ras.RASMsgs";
    private static final String MISSING_MSG_CAT = "The RAS message file, com.ibm.ras.RASMsgs, was not found.  No RAS messages can be displayed.";
    public static RASMessageCatalog rasMsgs = null;
    private static Hashtable localeToCodePage;
    private static PrintWriter errWriter;

    public static Object[] checkNullObjects(Object[] inserts) {
        String nullMsg = null;
        if (inserts != null) {
            for (int j = 0; j < inserts.length; ++j) {
                if (inserts[j] != null) continue;
                if (nullMsg == null) {
                    nullMsg = rasMsgs.getMessage("NULL_OBJECT");
                }
                inserts[j] = nullMsg;
            }
        }
        return inserts;
    }

    public static Object createObject(String name) {
        Class<?> objClass = null;
        Object object = null;
        ClassLoader cl = RASUtil.class.getClassLoader();
        try {
            objClass = cl != null ? cl.loadClass(name) : Class.forName(name);
            object = objClass.newInstance();
        }
        catch (Exception e) {
            RASUtil.errorMsg(rasMsgs.getMessage("ERR_OBJ_CREATE", name));
            e.printStackTrace();
        }
        return object;
    }

    public static void errorMsg(String msg) {
        if (errWriter == null) {
            System.err.println(msg);
        } else {
            errWriter.println(msg);
        }
    }

    public static String getConsoleCodePage() {
        String codePage = null;
        try {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.startsWith("Windows")) {
                Locale loc = Locale.getDefault();
                String lang = loc.getLanguage();
                String country = loc.getCountry();
                codePage = (String)localeToCodePage.get(lang + "_" + country);
                if (codePage == null) {
                    codePage = (String)localeToCodePage.get(lang);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codePage;
    }

    public static String left(String input, int length, String pad) {
        String output = input;
        if (input.length() < length) {
            while (output.length() < length) {
                output = output + pad;
            }
        } else if (input.length() > length) {
            output = input.substring(0, length);
        }
        return output;
    }

    public static String left(String input, int length) {
        return RASUtil.left(input, length, " ");
    }

    public static boolean makePath(String fileName) throws SecurityException {
        File path;
        boolean result = true;
        File file = new File(fileName = fileName.replace('/', File.separatorChar));
        String pathName = file.getParent();
        if (pathName != null && !(path = new File(pathName)).exists()) {
            result = path.mkdirs();
        }
        return result;
    }

    public static Vector arrayToVector(Object[] array) {
        Vector<String> v = null;
        if (array != null) {
            v = new Vector<String>();
            for (int i = 0; i < array.length; ++i) {
                v.addElement(array[i].toString());
            }
        }
        return v;
    }

    public static Vector stringToVector(String source) {
        Vector<String> v = null;
        if (source != null) {
            v = new Vector<String>();
            StringTokenizer st = new StringTokenizer(source);
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken().trim());
            }
        }
        return v;
    }

    public static String vectorToString(Vector source) {
        String s = null;
        StringBuffer bfr = null;
        if (source != null) {
            Enumeration e = source.elements();
            bfr = new StringBuffer();
            while (e.hasMoreElements()) {
                bfr.append(e.nextElement());
                bfr.append(" ");
            }
            s = bfr.toString().trim();
        }
        return s;
    }

    static {
        try {
            rasMsgs = new RASMessageCatalog(RAS_MSG_CAT);
        }
        catch (MissingResourceException e) {
            RASUtil.errorMsg(MISSING_MSG_CAT);
            e.printStackTrace();
        }
        localeToCodePage = new Hashtable();
        errWriter = null;
        localeToCodePage.put("cs", "Cp852");
        localeToCodePage.put("da", "Cp850");
        localeToCodePage.put("en", "Cp850");
        localeToCodePage.put("de", "Cp850");
        localeToCodePage.put("es", "Cp850");
        localeToCodePage.put("fi", "Cp850");
        localeToCodePage.put("fr", "Cp850");
        localeToCodePage.put("hu", "Cp852");
        localeToCodePage.put("it", "Cp850");
        localeToCodePage.put("nl", "Cp949");
        localeToCodePage.put("no", "Cp850");
        localeToCodePage.put("pl", "Cp852");
        localeToCodePage.put("pt", "Cp850");
        localeToCodePage.put("ru", "Cp866");
        localeToCodePage.put("sl", "Cp852");
        localeToCodePage.put("sv", "Cp850");
        localeToCodePage.put("tr", "Cp857");
        try {
            String codePage = RASUtil.getConsoleCodePage();
            RASUtil util = new RASUtil();
            OutputStreamWriter osw = codePage != null && util.getClass().getClassLoader() == null ? new OutputStreamWriter((OutputStream)System.err, codePage) : new OutputStreamWriter(System.err);
            errWriter = new PrintWriter((Writer)osw, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

