/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASCircularQueue;
import com.ibm.ras.RASConstants;
import com.ibm.ras.RASEvent;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASIQueue;
import com.ibm.ras.RASMaskChangeGenerator;
import com.ibm.ras.RASMessageFormatter;
import com.ibm.ras.RASQueue;
import com.ibm.ras.RASQueueEmptyException;
import com.ibm.ras.RASQueueFullException;
import com.ibm.ras.RASTraceFormatter;
import com.ibm.ras.RASUtil;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class RASHandler
extends RASMaskChangeGenerator
implements RASConstants,
RASIHandler,
Runnable {
    private static final String S = "(C) Copyright IBM Corp. 1998. (C) Copyright Tivoli Systems 1999.";
    public static final int DEFAULT_QUEUE_SIZE = 10000;
    public static final int DEFAULT_RETRY_INTERVAL = 5000;
    public transient boolean deviceOpen = false;
    private transient boolean done = false;
    private transient boolean stopRequested = false;
    protected Hashtable formatters;
    protected transient int deviceFailures = 0;
    private transient int discardedEventCount = 0;
    protected int retryInterval;
    protected transient Object deviceLock = new Object();
    protected transient Object queueLock = new Object();
    protected transient Object queueEmptyLock = new Object();
    protected transient Object queueFullLock = new Object();
    protected transient PrintWriter pWriter = null;
    private transient RASIQueue inQueue;
    private transient RASIQueue outQueue;
    private String formatterNames;
    protected transient Thread myThread;

    public RASHandler() {
        this(null, null);
    }

    public RASHandler(String name) {
        this(name, null);
    }

    public RASHandler(String name, String desc) {
        super(name, desc);
        String threadName = this.getClass().getName() + ":" + this.getName();
        this.myThread = new Thread((Runnable)this, threadName);
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    protected void init() {
        super.init();
        this.formatterNames = "";
        this.outQueue = this.inQueue = new RASQueue(10000);
        this.setRetryInterval(5000);
        this.addMessageEventClass("com.ibm.ras.RASMessageEvent");
        this.addTraceEventClass("com.ibm.ras.RASTraceEvent");
        this.formatters = new Hashtable();
        RASMessageFormatter mf = new RASMessageFormatter();
        mf.setDefault(true);
        this.addFormatter(mf);
        RASTraceFormatter tf = new RASTraceFormatter();
        tf.setDefault(true);
        this.addFormatter(tf);
    }

    public Hashtable getConfig() {
        Hashtable ht = super.getConfig();
        ht.put("maxQueueSize", new Integer(this.getMaximumQueueSize()).toString());
        ht.put("isCircular", new Boolean(this.isCircular()).toString());
        ht.put("retryInterval", new Integer(this.getRetryInterval()).toString());
        ht.put("formatterNames", this.formatterNames);
        return ht;
    }

    public void setConfig(Hashtable ht) {
        super.setConfig(ht);
        if (ht.containsKey("maxQueueSize")) {
            this.setMaximumQueueSize(new Integer((String)ht.get("maxQueueSize")));
        }
        if (ht.containsKey("isCircular")) {
            this.setCircular(new Boolean((String)ht.get("isCircular")));
        }
        if (ht.containsKey("retryInterval")) {
            this.setRetryInterval(new Integer((String)ht.get("retryInterval")));
        }
        if (ht.containsKey("formatterNames")) {
            this.formatterNames = (String)ht.get("formatterNames");
        }
    }

    public int getMaximumQueueSize() {
        return this.inQueue.getMaximumQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumQueueSize(int size) throws IllegalStateException {
        if (size >= 0) {
            Object object = this.queueEmptyLock;
            synchronized (object) {
                Object object2 = this.queueFullLock;
                synchronized (object2) {
                    if (this.inQueue.getQueueSize() != 0 || this.outQueue.getQueueSize() != 0) {
                        throw new IllegalStateException(RASUtil.rasMsgs.getMessage("ERR_QUEUE_STATE"));
                    }
                    this.newQueue(size, this.inQueue.isCircular());
                }
            }
        }
    }

    public boolean isCircular() {
        return this.inQueue.isCircular();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCircular(boolean circular) throws IllegalStateException {
        Object object = this.queueEmptyLock;
        synchronized (object) {
            Object object2 = this.queueFullLock;
            synchronized (object2) {
                if (this.inQueue.isCircular() != circular) {
                    if (this.inQueue.getQueueSize() != 0 || this.outQueue.getQueueSize() != 0) {
                        throw new IllegalStateException(RASUtil.rasMsgs.getMessage("ERR_QUEUE_STATE"));
                    }
                    this.newQueue(this.getMaximumQueueSize(), circular);
                }
            }
        }
    }

    protected void newQueue(int size, boolean circular) {
        if (circular) {
            this.inQueue = new RASCircularQueue(size);
            this.outQueue = new RASQueue(0);
        } else {
            this.outQueue = this.inQueue = new RASQueue(size);
        }
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int interval) {
        if (interval >= 0) {
            this.retryInterval = interval;
        }
    }

    public int getQueueSize() {
        int size = this.isCircular() ? this.inQueue.getQueueSize() + this.outQueue.getQueueSize() : this.inQueue.getQueueSize();
        return size;
    }

    public void addFormatter(RASIFormatter formatter) {
        if (formatter != null) {
            Enumeration e = formatter.getEventClasses();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.formatters.put(name, formatter);
            }
        }
    }

    public void removeFormatter(RASIFormatter formatter) {
        if (formatter != null) {
            Enumeration e = formatter.getEventClasses();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.formatters.remove(name);
            }
        }
    }

    public Enumeration getFormatters() {
        return this.formatters.elements();
    }

    public abstract void openDevice();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.pWriter != null) {
                this.pWriter.close();
            }
            this.pWriter = null;
            this.deviceOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int retryCount = 0;
        while (!this.done) {
            RASEvent event;
            Object object = this.queueEmptyLock;
            synchronized (object) {
                try {
                    event = (RASEvent)this.outQueue.dequeue();
                }
                catch (RASQueueEmptyException e) {
                    event = null;
                    if (this.stopRequested) {
                        this.done = true;
                    }
                    try {
                        this.queueEmptyLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            if (event == null) continue;
            object = this.queueFullLock;
            synchronized (object) {
                this.queueFullLock.notifyAll();
            }
            this.writeEvent(event);
            if (this.deviceOpen) {
                retryCount = 0;
            } else if (!this.stopRequested) {
                if (retryCount++ < 5) {
                    this.outQueue.requeue(event);
                }
                try {
                    int interval = this.getRetryInterval();
                    if (interval != 0) {
                        Thread.sleep(interval);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.discardedEventCount == 0 || this.inQueue.isFull()) continue;
            if (this.discardedEventCount == 1) {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_QUEUE_OK_1", this.getName()));
            } else {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_QUEUE_OK_2", this.getName(), new Integer(this.discardedEventCount)));
            }
            this.discardedEventCount = 0;
        }
        Object object = this.queueEmptyLock;
        synchronized (object) {
            this.queueEmptyLock.notify();
        }
        this.closeDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.dumpQueue();
        Object object = this.queueEmptyLock;
        synchronized (object) {
            this.stopRequested = true;
            this.queueEmptyLock.notify();
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            while (!this.done) {
                try {
                    this.queueEmptyLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(RASIEvent event) {
        if (event != null && !this.stopRequested) {
            boolean done = false;
            while (!done) {
                try {
                    Object object = this.queueEmptyLock;
                    synchronized (object) {
                        this.inQueue.enqueue(event);
                        done = true;
                        if (!this.inQueue.isCircular()) {
                            this.queueEmptyLock.notify();
                        }
                    }
                }
                catch (RASQueueFullException e1) {
                    if (!Thread.currentThread().equals(this.myThread)) {
                        Object object = this.queueFullLock;
                        synchronized (object) {
                            this.myThread.interrupt();
                            try {
                                this.queueFullLock.wait();
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (this.discardedEventCount == 0) {
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_QUEUE_FULL", this.getName()));
                    }
                    ++this.discardedEventCount;
                    done = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEvent(RASIEvent event) {
        Object object = this.deviceLock;
        synchronized (object) {
            RASIFormatter formatter;
            if (!this.deviceOpen) {
                this.openDevice();
            }
            if (this.deviceOpen && (formatter = this.findFormatter(event)) != null) {
                String msg = formatter.format(event);
                this.pWriter.println(msg);
                if (this.pWriter.checkError()) {
                    this.closeDevice();
                    if (++this.deviceFailures <= 2) {
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_WRITE_MSG", this.getName()));
                    }
                } else if (this.deviceFailures != 0) {
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("RETRY_OK", this.getName()));
                    this.deviceFailures = 0;
                }
            }
        }
    }

    protected RASIFormatter findFormatter(RASIEvent event) {
        boolean found = false;
        Class<?> eventClass = event.getClass();
        RASIFormatter formatter = null;
        while (!found && eventClass != null) {
            String className = eventClass.getName();
            if (this.formatters.containsKey(className)) {
                found = true;
                formatter = (RASIFormatter)this.formatters.get(className);
                continue;
            }
            eventClass = eventClass.getSuperclass();
        }
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpQueue() {
        if (this.isCircular()) {
            boolean done = false;
            Object object = this.queueEmptyLock;
            synchronized (object) {
                Object object2 = this.queueFullLock;
                synchronized (object2) {
                    while (!done) {
                        try {
                            Object obj = this.inQueue.dequeue();
                            this.outQueue.enqueue(obj);
                        }
                        catch (RASQueueEmptyException e) {
                            done = true;
                        }
                        catch (RASQueueFullException e) {}
                    }
                    this.queueFullLock.notifyAll();
                }
                this.queueEmptyLock.notifyAll();
            }
        }
    }
}

