/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASHandler;
import com.ibm.ras.RASUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

public class RASFileHandler
extends RASHandler
implements RASConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -8525824951965645330L;
    private String encoding;
    protected String fileName;
    protected String orgFileName;

    public RASFileHandler() {
    }

    public RASFileHandler(String name) {
        super(name);
    }

    public RASFileHandler(String name, String desc) {
        super(name, desc);
    }

    public RASFileHandler(String name, String desc, String file) {
        super(name, desc);
        this.setFileName(file);
    }

    public RASFileHandler(String name, String desc, String file, String encoding) {
        this(name, desc, file);
        this.setEncoding(encoding);
    }

    protected void init() {
        super.init();
        this.fileName = null;
        this.orgFileName = null;
        this.setEncoding(null);
    }

    public Hashtable getConfig() {
        String encoding;
        Hashtable ht = super.getConfig();
        if (this.orgFileName != null) {
            ht.put("fileName", this.orgFileName);
        }
        if ((encoding = this.getEncoding()) != null) {
            ht.put("encoding", this.getEncoding());
        }
        return ht;
    }

    public void setConfig(Hashtable ht) {
        super.setConfig(ht);
        if (ht.containsKey("fileName")) {
            this.setFileName((String)ht.get("fileName"));
        }
        if (ht.containsKey("encoding")) {
            this.setEncoding((String)ht.get("encoding"));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        if (name != null) {
            this.orgFileName = name;
            this.fileName = name.replace('/', File.separatorChar);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() {
        this.closeDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            block5: {
                String fileName = this.getFileName();
                try {
                    RASUtil.makePath(fileName);
                    FileOutputStream fos = new FileOutputStream(fileName, true);
                    OutputStreamWriter osw = this.getEncoding() == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, this.encoding);
                    this.pWriter = new PrintWriter((Writer)new BufferedWriter(osw), true);
                    this.deviceOpen = true;
                }
                catch (Exception e) {
                    if (++this.deviceFailures > 2) break block5;
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_OPEN_FILE", fileName));
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() {
        Object object = this.deviceLock;
        synchronized (object) {
            File file;
            this.closeDevice();
            String fileName = this.getFileName();
            if (fileName != null && (file = new File(fileName)).exists() && !file.delete()) {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_DELETE_FILE", fileName));
            }
        }
    }
}

