/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.OlsonTimeZone;
import com.ibm.icu.impl.TimeZoneAdapter;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;

public class JDKTimeZone
extends TimeZone {
    private static final long serialVersionUID = -3724907649889455280L;
    protected transient OlsonTimeZone zone;

    public static TimeZone wrap(java.util.TimeZone tz) {
        if (tz instanceof TimeZoneAdapter) {
            return ((TimeZoneAdapter)tz).unwrap();
        }
        if (tz instanceof java.util.SimpleTimeZone) {
            return new SimpleTimeZone((java.util.SimpleTimeZone)tz, tz.getID());
        }
        return new JDKTimeZone(tz);
    }

    public JDKTimeZone(java.util.TimeZone tz) {
        String id = tz.getID();
        try {
            this.zone = new OlsonTimeZone(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setID(id);
    }

    protected JDKTimeZone(OlsonTimeZone tz) {
        this.zone = tz;
        super.setID(this.zone.getID());
    }

    protected JDKTimeZone() {
    }

    public void setID(String ID2) {
        super.setID(ID2);
        if (this.zone != null) {
            this.zone.setID(ID2);
        }
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        if (this.zone != null) {
            return this.zone.getOffset(era, year, month, day, dayOfWeek, milliseconds);
        }
        return 0;
    }

    public void getOffset(long date, boolean local, int[] offsets) {
        if (this.zone != null) {
            this.zone.getOffset(date, local, offsets);
        } else {
            super.getOffset(date, local, offsets);
        }
    }

    public void setRawOffset(int offsetMillis) {
        if (this.zone != null) {
            this.zone.setRawOffset(offsetMillis);
        }
    }

    public int getRawOffset() {
        if (this.zone != null) {
            return this.zone.getRawOffset();
        }
        return 0;
    }

    public boolean useDaylightTime() {
        if (this.zone != null) {
            return this.zone.useDaylightTime();
        }
        return false;
    }

    public boolean inDaylightTime(Date date) {
        if (this.zone != null) {
            return this.zone.inDaylightTime(date);
        }
        return false;
    }

    public boolean hasSameRules(TimeZone other) {
        if (other == null) {
            return false;
        }
        if (other instanceof JDKTimeZone && this.zone != null) {
            return this.zone.hasSameRules(((JDKTimeZone)other).zone);
        }
        return super.hasSameRules(other);
    }

    public Object clone() {
        JDKTimeZone clone = new JDKTimeZone();
        if (this.zone != null) {
            clone.zone = (OlsonTimeZone)this.zone.clone();
        }
        return clone;
    }

    public synchronized int hashCode() {
        if (this.zone != null) {
            return this.zone.hashCode();
        }
        return super.hashCode();
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            if (this.zone != null) {
                return this.zone.getDSTSavings();
            }
            return 3600000;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        try {
            if (obj != null) {
                OlsonTimeZone tz1 = this.zone;
                OlsonTimeZone tz2 = ((JDKTimeZone)obj).zone;
                boolean equal = true;
                if (tz1 != null && tz2 != null) {
                    equal = ((TimeZone)tz1).equals(tz2);
                }
                return equal;
            }
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return "JDKTimeZone: " + this.zone.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.zone != null) {
            out.writeObject(this.zone.getID());
        } else {
            out.writeObject(this.getID());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String id = (String)in.readObject();
        try {
            this.zone = new OlsonTimeZone(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setID(id);
    }
}

