/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.FfdcProviderDependent;
import com.ibm.ffdc.util.provider.Incident;
import com.ibm.ffdc.util.provider.IncidentEntry;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ffdc
extends FfdcProviderDependent<FfdcProvider>
implements com.ibm.ffdc.Ffdc {
    private static final String emptyString = "";
    private final WeakReference<Object> reporterRef;
    private final WeakReference<Throwable> thRef;
    private final IncidentEntry incident;

    public Ffdc(Throwable th, Object reporter, String sourceId, String probeId, FfdcProvider provider) {
        super(provider);
        this.thRef = new WeakReference<Throwable>(th);
        String exceptionname = th == null ? String.valueOf((Object)null) : th.getClass().getName();
        IncidentEntry.Key key = new IncidentEntry.Key(sourceId, probeId == null ? emptyString : probeId, exceptionname);
        this.incident = provider.getIncident(key, Ffdc.getClassLoader(reporter));
        this.reporterRef = new WeakReference<Object>(reporter);
    }

    private static ClassLoader getClassLoader(final Object o) {
        ClassLoader result = null;
        if (o != null) {
            result = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    if (o instanceof Class) {
                        return ((Class)o).getClassLoader();
                    }
                    return o.getClass().getClassLoader();
                }
            });
        }
        return result;
    }

    @Override
    public final void log(Object ... capturedDataElements) {
        this.incident.log(this.provider, this.reporterRef.get(), (Throwable)this.thRef.get(), capturedDataElements);
    }

    @Override
    public final boolean isLoggable() {
        return this.provider.isLoggable(this.incident);
    }

    @Override
    public Incident getIncident() {
        return this.incident;
    }

    public String toString() {
        String label = this.incident.getLabel();
        if (label == null) {
            label = emptyString;
        }
        return "Ffdc{" + this.incident.getExceptionName() + " count:" + this.incident.getCount() + " SourceID:" + this.incident.getSourceId() + " ProbeID:" + this.incident.getProbeId() + "} " + label;
    }
}

