/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.osgi;

import com.ibm.ffdc.config.DataCollector;
import com.ibm.ffdc.provider.FfdcProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class DataCollectorTracker
extends ServiceTracker {
    private final FfdcProvider ffdcProvider;
    private static final Logger tracer = Logger.getLogger(DataCollectorTracker.class.getName(), "com.ibm.ffdc.FFDCBundleMessages");
    private static final Level LOGLEVEL = Level.INFO;

    public DataCollectorTracker(BundleContext context, FfdcProvider ffdcProvider) {
        super(context, DataCollector.class.getName(), null);
        this.ffdcProvider = ffdcProvider;
    }

    public Object addingService(ServiceReference reference) {
        DataCollector dataCollector = (DataCollector)this.context.getService(reference);
        this.ffdcProvider.register(dataCollector);
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.log(LOGLEVEL, "DataCollector added:" + dataCollector);
        }
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.logp(LOGLEVEL, this.getClass().getName(), "addingService", "FFDCDataCollectorAdded", dataCollector);
        }
        return dataCollector;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.ffdcProvider.deregister((DataCollector)service);
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.logp(LOGLEVEL, this.getClass().getName(), "removedService", "FFDCDataCollectorRemoved", service);
        }
    }
}

