/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ffdc.Manager;
import java.util.concurrent.Executor;

class _Alarm
implements Alarm,
Comparable,
Runnable {
    private static final TraceComponent tc = Tr.register(_Alarm.class, null, null);
    long expirationTime;
    private static long localAlarmId = 1L;
    long alarmId;
    Object context;
    AlarmListener listener;
    boolean deferrable;
    boolean fired = false;
    Executor executor;

    _Alarm() {
        this.expirationTime = -1L;
        this.alarmId = _Alarm.getNextId();
        this.context = null;
        this.listener = null;
        this.deferrable = true;
    }

    _Alarm(long t, AlarmListener l, Object o, boolean d, Executor e) {
        this.expirationTime = t;
        this.alarmId = _Alarm.getNextId();
        this.listener = l;
        this.context = o;
        this.deferrable = d;
        this.executor = e;
    }

    void execute() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "firing alarm", this);
        }
        try {
            this.executor.execute(this);
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ejs.util.am._Alarm.execute", "103", this);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm fired");
        }
    }

    public void run() {
        try {
            this.listener.alarm(this.context);
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, this, "com.ibm.ejs.util.am._Alarm.run", "95", this);
            Tr.event(tc, "firing alarm failed", new Object[]{this, t});
        }
    }

    public void cancel() {
        AlarmManager.cancel(this);
    }

    private static final synchronized long getNextId() {
        return localAlarmId++;
    }

    public final int compareTo(Object c) {
        if (this == c) {
            return 0;
        }
        long otherExpirationTime = ((_Alarm)c).expirationTime;
        if (this.expirationTime < otherExpirationTime) {
            return -1;
        }
        if (this.expirationTime > otherExpirationTime) {
            return 1;
        }
        long otherAlarmId = ((_Alarm)c).alarmId;
        if (this.alarmId < otherAlarmId) {
            return -1;
        }
        if (this.alarmId > otherAlarmId) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "_Alarm(" + this.expirationTime + "," + Util.identity(this.listener) + "," + Util.identity(this.context) + ")";
    }
}

