/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class MathUtil {
    public static final int MAX_PRIME_INTEGER = 2147482661;

    private MathUtil() {
    }

    public static int findNextPrime(int number) {
        if (number <= 2) {
            return 2;
        }
        if (MathUtil.isEven(number)) {
            ++number;
        }
        if (number > 2147482661) {
            return number;
        }
        for (int next = number; next < number + 1000; next += 2) {
            if (!MathUtil.isPrime(next)) continue;
            return next;
        }
        return number;
    }

    public static boolean isPrime(int number) {
        if (number == 2 || number == 3 || number == 5 || number == 7 || number == 11 || number == 13 || number == 17 || number == 19) {
            return true;
        }
        if (number % 2 == 0 || number % 3 == 0 || number % 5 == 0 || number % 7 == 0 || number % 11 == 0 || number % 13 == 0 || number % 17 == 0 || number % 19 == 0) {
            return false;
        }
        long numberMinusOne = number - 1;
        long s = 0L;
        long d = numberMinusOne;
        while (MathUtil.isEven(d)) {
            d /= 2L;
            ++s;
        }
        long d1 = d;
        for (int a = 2; a <= 5; ++a) {
            if (a == 4) continue;
            long prod = 1L;
            long a2j = a;
            for (d = d1; d > 0L; d /= 2L) {
                if (MathUtil.isOdd(d)) {
                    prod = prod * a2j % (long)number;
                }
                a2j = a2j * a2j % (long)number;
            }
            if (prod == 1L || prod == numberMinusOne) continue;
            for (long i = 1L; i <= s && (prod = prod * prod % (long)number) != numberMinusOne; ++i) {
            }
            if (prod == numberMinusOne) continue;
            return false;
        }
        return number != 25326001 && number != 161304001 && number != 960946321 && number != 1157839381;
    }

    public static boolean isOdd(int number) {
        return MathUtil.isOdd((long)number);
    }

    public static boolean isOdd(long number) {
        return number % 2L != 0L;
    }

    public static boolean isEven(int number) {
        return MathUtil.isEven((long)number);
    }

    public static boolean isEven(long number) {
        return number % 2L == 0L;
    }

    public static void main(String[] args) {
        System.out.println("Testing out findNextPrime()....................");
        Date start = new Date();
        int prime = 0;
        int primesToFind = 100008;
        int columns = 9;
        int[] primes = new int[columns];
        int index = 0;
        for (int i = 0; i < primesToFind; ++i) {
            prime = MathUtil.findNextPrime(prime);
            index = i % columns;
            primes[index] = prime;
            if (index == columns - 1) {
                String output = "Primes[" + (i + 1) + "] : ";
                for (int j = 0; j < columns; ++j) {
                    output = output + primes[j];
                    if (j >= columns - 1) continue;
                    output = output + ", ";
                }
                System.out.println(output);
            }
            switch (i + 1) {
                case 100: {
                    if (prime == 541) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("100th prime is 541, but found " + prime);
                    System.exit(-1);
                    break;
                }
                case 1000: {
                    if (prime == 7919) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("1,000th prime is 7919, but found " + prime);
                    System.exit(-1);
                    break;
                }
                case 10000: {
                    if (prime == 104729) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("10,000th prime is 104729, but found " + prime);
                    System.exit(-1);
                    break;
                }
                case 100008: {
                    if (prime == 1299827) break;
                    System.out.println("ERROR - findNextPrime not working!!!!!!!!!!!!!");
                    System.out.println("100,008th prime is 1299827, but found " + prime);
                    System.exit(-1);
                }
            }
            ++prime;
        }
        Date end = new Date();
        long findTime = end.getTime() - start.getTime();
        Date find = new Date(findTime);
        SimpleDateFormat formatter = new SimpleDateFormat("mm:ss:SS");
        String findTimeStr = formatter.format(find);
        System.out.println("Time to find " + primesToFind + " primes : " + findTimeStr);
        System.exit(0);
    }
}

