/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.CastoutPolicy;
import com.ibm.ejs.util.LRUCacheElement;
import com.ibm.ejs.util.Queue;
import java.util.Enumeration;
import java.util.Hashtable;

public class LRUCache {
    protected Hashtable elements;
    protected Queue lruQ;
    protected int maxSize;
    protected CastoutPolicy castoutPolicy;

    public LRUCache(int maxSize, CastoutPolicy castoutPolicy) {
        this.maxSize = maxSize;
        this.castoutPolicy = castoutPolicy;
        this.elements = maxSize >= 10 ? new Hashtable(maxSize / 10) : new Hashtable(maxSize);
        this.lruQ = new Queue();
    }

    public Object get(Object key) {
        LRUCacheElement result = null;
        result = (LRUCacheElement)this.elements.get(key);
        if (result != null) {
            this.lruQ.remove(result);
            this.lruQ.addToTail(result);
        }
        return result;
    }

    public void put(Object key, LRUCacheElement ele) {
        LRUCacheElement old = (LRUCacheElement)this.elements.remove(key);
        if (old != null) {
            this.lruQ.remove(old);
            if (this.castoutPolicy != null) {
                this.castoutPolicy.castout(old);
            }
        } else {
            while (this.elements.size() >= this.maxSize) {
                LRUCacheElement removed = (LRUCacheElement)this.lruQ.removeHead();
                this.elements.remove(removed.key);
                if (this.castoutPolicy == null) continue;
                this.castoutPolicy.castout(removed);
            }
        }
        this.elements.put(key, ele);
        ele.key = key;
        this.lruQ.addToTail(ele);
    }

    public LRUCacheElement remove(Object key) {
        LRUCacheElement removed = (LRUCacheElement)this.elements.remove(key);
        if (removed != null) {
            this.lruQ.remove(removed);
        }
        return removed;
    }

    public int size() {
        return this.elements.size();
    }

    public void dump() {
    }

    public Enumeration elements() {
        return this.lruQ.elements();
    }
}

