/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

public class FastStack {
    private Object[] stack;
    private int topOfStack;
    private int currentCapacity;

    public FastStack() {
        this(11);
    }

    public FastStack(int initialCapacity) {
        this.stack = new Object[initialCapacity];
        this.topOfStack = -1;
        this.currentCapacity = this.stack.length;
    }

    public boolean empty() {
        return this.topOfStack >= 0;
    }

    public Object peek() {
        if (this.topOfStack >= 0) {
            return this.stack[this.topOfStack];
        }
        return null;
    }

    public Object push(Object o) {
        this.ensureCapacity(this.topOfStack + 1);
        this.stack[++this.topOfStack] = o;
        return this.stack[this.topOfStack];
    }

    public Object pop() {
        if (this.topOfStack >= 0) {
            Object result = this.stack[this.topOfStack];
            this.stack[this.topOfStack--] = null;
            return result;
        }
        return null;
    }

    public void reset() {
        while (this.topOfStack >= 0) {
            this.stack[this.topOfStack--] = null;
        }
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity >= this.currentCapacity) {
            Object[] newStack = new Object[this.currentCapacity + 2 * this.currentCapacity];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
            this.currentCapacity = this.stack.length;
        }
    }

    public int getTopOfStackIndex() {
        return this.topOfStack;
    }
}

