/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ffdc.Manager;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CBuff {
    protected int size = 1024;
    protected Object[] elements = new Object[this.size];
    protected int tail = -1;
    protected int count = 0;

    public CBuff(int n) {
        this.setSize(n);
    }

    public void put(Object o) {
        if (this.size != 0) {
            if (this.count < this.size) {
                ++this.count;
            }
            this.tail = (this.tail + 1) % this.size;
            this.elements[this.tail] = o;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int newSize) {
        if (newSize == this.size || newSize < 0) {
            return;
        }
        try {
            Object[] newElements = new Object[newSize];
            if (newSize >= this.count && (this.size != this.count || this.size == 0)) {
                System.arraycopy(this.elements, 0, newElements, 0, this.count);
            } else {
                int head = 0;
                int copyCount = 0;
                int copyBase = 0;
                if (this.size > newSize) {
                    copyBase = newSize;
                    head = (this.tail + this.size - newSize + 1) % this.size;
                } else {
                    copyBase = this.size;
                    head = (this.tail + 1) % this.size;
                }
                copyCount = copyBase < this.size - head ? copyBase : this.size - head;
                System.arraycopy(this.elements, head, newElements, 0, copyCount);
                if (copyCount < copyBase) {
                    System.arraycopy(this.elements, 0, newElements, copyCount, copyBase - copyCount);
                }
                this.count = copyBase;
                this.tail = copyBase - 1;
            }
            this.size = newSize;
            this.elements = newElements;
        }
        catch (OutOfMemoryError err) {
            Manager.Ffdc.log(err, this, "com.ibm.ejs.util.CBuff.setSize", "170", this);
        }
    }

    public Enumeration elements() {
        int head = -1;
        if (this.count == this.size) {
            head = this.tail;
        }
        return new CBuffEnum(this.elements, this.size, this.count, head, this.tail);
    }

    class CBuffEnum
    implements Enumeration {
        private int count;
        private int current;
        private int size;
        private int tail;
        private Object[] elements;

        public CBuffEnum(Object[] o, int s, int c, int h, int t) {
            this.elements = o;
            this.size = s;
            this.count = c;
            this.current = h;
            this.tail = t;
        }

        public boolean hasMoreElements() {
            return this.count != 0;
        }

        public Object nextElement() {
            if (this.count != 0) {
                this.current = (this.current + 1) % this.size;
                --this.count;
                return this.elements[this.current];
            }
            throw new NoSuchElementException("Enumeration exhausted");
        }
    }
}

