/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras.ffdc;

import com.ibm.ejs.ras.ffdc.FfdcProvider;
import com.ibm.ejs.ras.ffdc.IncidentStream;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.bulkdata.CapacityException;
import com.ibm.ffdc.util.bulkdata.FixedCapacityOutputStream;
import com.ibm.ffdc.util.formatting.IncidentReportHeader;
import com.ibm.ffdc.util.provider.Incident;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IncidentLogger<T extends FfdcProvider>
extends com.ibm.ffdc.util.provider.IncidentLogger<T> {
    private static final int MAXINCIDENTSIZE = 0x400000;

    protected IncidentLogger(T provider) {
        super(provider);
    }

    @Override
    protected final String log(final Incident incident, final Object reporter, final Throwable th, final Object[] capturedDataElements) {
        FixedCapacityOutputStream os = new FixedCapacityOutputStream(0x400000);
        IncidentStream.Writer<FixedCapacityOutputStream> isWriter = new IncidentStream.Writer<FixedCapacityOutputStream>(){

            @Override
            public void writeTo(FixedCapacityOutputStream os) {
                IncidentLogger.this.writeIncidentTo(os, incident, reporter, th, capturedDataElements);
            }
        };
        boolean capacityException = false;
        try {
            isWriter.writeTo(os);
        }
        catch (IOException ex) {
            this.ffdcerror(ex);
        }
        catch (CapacityException cex) {
            capacityException = true;
        }
        PrintStream ffdcFile = FfdcProvider.getFFDCFilePrintStream();
        if (ffdcFile != null) {
            try {
                os.writeTo(ffdcFile);
                if (capacityException) {
                    ffdcFile.println("* * * FFDC output truncated here * * * ");
                }
            }
            catch (IOException e) {
                this.ffdcerror(e);
            }
        }
        return null;
    }

    private void writeIncidentTo(FixedCapacityOutputStream os, Incident incident, Object reporter, Throwable th, Object ... capturedDataElements) {
        IncidentStream.Writer<OutputStream> incidentReportHeader = this.getReportHeader(incident, th, reporter);
        try {
            incidentReportHeader.writeTo(os);
        }
        catch (IOException e) {
            this.ffdcerror(e);
        }
        catch (CapacityException cex) {
            // empty catch block
        }
        if (capturedDataElements != null) {
            IncidentStream is = new IncidentStream((FfdcProvider)this.provider, os);
            for (int i = 0; i < capturedDataElements.length; ++i) {
                String label = "arg" + (capturedDataElements.length == 1 ? "" : Integer.valueOf(i));
                is.write(label, capturedDataElements[i]);
            }
        }
    }

    private IncidentStream.Writer<OutputStream> getReportHeader(Incident incident, Throwable th, Object reporter) {
        return new IncidentReportHeader(incident, th, reporter);
    }
}

