/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ws.ffdc.FFDCFilter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class TraceNLS {
    public static final String $sccsid = "@(#) 1.3 SERV1/ws/code/ras.lite/src/com/ibm/ejs/ras/TraceNLS.java, WAS.ras.lite, WAS70.SERV1, cf070937.21 07/07/31 10:19:12 [9/18/09 22:40:07]";
    private static final String nullKey = "null Key";
    private static final String svNullBundleName = "Resource Bundle name is null, key = {0}";
    private static final String svBundleNotLoaded = "Unable to load ResourceBundle {0}";
    private static final String svNullKeyMessage = "Null key passed while using ResourceBundle {0}";
    private static final String svMalformedMessage = "No message text associated with key {0} in bundle {1}";
    private String ivBundleName = null;

    public static TraceNLS getTraceNLS(String bundleName) {
        return new TraceNLS(bundleName);
    }

    private TraceNLS(String bundleName) {
        this.ivBundleName = bundleName;
    }

    public String getString(String key) {
        return TraceNLS.worker(null, this.ivBundleName, key, null, null, false, null, false);
    }

    public String getString(String key, String defaultString) {
        return TraceNLS.worker(null, this.ivBundleName, key, null, defaultString, false, null, false);
    }

    public String getFormattedMessage(String key, Object[] args, String defaultString) {
        return TraceNLS.worker(null, this.ivBundleName, key, args, defaultString, true, null, false);
    }

    public String getFormattedMessage(String key, Object[] args, String defaultString, boolean quiet) {
        return TraceNLS.worker(null, this.ivBundleName, key, args, defaultString, true, null, quiet);
    }

    public static String getStringFromBundle(String bundleName, String key) {
        return TraceNLS.worker(null, bundleName, key, null, null, false, null, false);
    }

    public static String getStringFromBundle(String bundleName, String key, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, null, defaultString, false, null, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Object[] args, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, null, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Object[] args, String defaultString, boolean quiet) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, null, quiet);
    }

    public static String getStringFromBundle(String bundleName, String key, Locale locale) {
        return TraceNLS.worker(null, bundleName, key, null, null, false, locale, false);
    }

    public static String getStringFromBundle(String bundleName, String key, Locale locale, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, null, defaultString, false, locale, false);
    }

    public static String getStringFromBundle(ResourceBundle bundle, String bundleName, String key, Locale locale) {
        return TraceNLS.worker(bundle, bundleName, key, null, null, false, locale, false);
    }

    public static String getStringFromBundle(ResourceBundle bundle, String bundleName, String key, Locale locale, String defaultString) {
        return TraceNLS.worker(bundle, bundleName, key, null, defaultString, false, locale, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Locale locale, Object[] args, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, locale, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Locale locale, Object[] args, String defaultString, boolean quiet) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, locale, quiet);
    }

    public static String getFormattedMessageFromLocalizedMessage(String localizedMessage, Object[] args, boolean quiet) {
        return TraceNLS.workerFormatLocalizedMessage(localizedMessage, args);
    }

    private static String worker(ResourceBundle bundle, String bundleName, String key, Object[] args, String defaultString, boolean format, Locale locale, boolean quiet) {
        String returnValue = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            if (bundle == null) {
                bundle = TraceNLS.getResourceBundle(bundleName, locale);
            }
            if ((returnValue = bundle.getString(key)).equals("")) {
                returnValue = defaultString == null ? key : defaultString;
            }
            if (!format) {
                return returnValue;
            }
            return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
        }
        catch (RuntimeException re) {
            if (bundleName == null) {
                if (key == null && defaultString == null) {
                    return MessageFormat.format(svNullBundleName, nullKey);
                }
                returnValue = defaultString == null ? key : defaultString;
                if (!format) {
                    return returnValue;
                }
                return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
            }
            if (bundle == null) {
                if (key == null && defaultString == null) {
                    return MessageFormat.format(svBundleNotLoaded, bundleName);
                }
                returnValue = defaultString == null ? key : defaultString;
                if (!format) {
                    return returnValue;
                }
                return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
            }
            if (key == null) {
                if (defaultString == null) {
                    return MessageFormat.format(svNullKeyMessage, bundleName);
                }
                returnValue = defaultString;
                if (!format) {
                    return returnValue;
                }
                return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
            }
            returnValue = defaultString == null ? key : defaultString;
            if (!format) {
                return returnValue;
            }
            return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
        }
    }

    private static String workerFormatLocalizedMessage(String message, Object[] args) {
        if (args == null) {
            return message;
        }
        String formattedMessage = null;
        try {
            formattedMessage = MessageFormat.format(message, args);
        }
        catch (IllegalArgumentException e) {
            return message;
        }
        return formattedMessage;
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        ResourceBundle bundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            bundle = ResourceBundle.getBundle(bundleName, locale);
        }
        catch (RuntimeException re) {
            ClassLoader classLoader = null;
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException(e, "com.ibm.ejs.ras.TraceNLS", "1");
                throw new RuntimeException(e);
            }
            bundle = ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        return bundle;
    }

    public static boolean isMessageIdConversionEnabled() {
        return false;
    }
}

