/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import com.ibm.ejs.ras.WsHandler;
import com.ibm.ejs.ras.ffdc.FfdcProvider;
import com.ibm.ffdc.impl.Ffdc;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.logging.WsLoggerFactoryImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tr {
    public static final String $sccsid = "@(#) 1.32 SERV1/ws/code/ras.lite/src/com/ibm/ejs/ras/Tr.java, WAS.ras.lite, WAS70.SERV1, cf070937.21 08/06/19 03:27:04 [9/18/09 22:40:07]";
    private static final String FFDC_IGNORE_PREFIX = "ffdc.ignore";
    private static final String TRACE_SETTINGS_FILE = "traceSettingsFile";
    private static final String TRACE_FILE_NAME = "traceFileName";
    private static final String TRACE_MAX_FILE_SIZE = "maxFileSize";
    private static final String TRACE_MAX_FILES = "maxFiles";
    private static final String TRACE_FORMAT = "traceFormat";
    private static final String ALT_TRACE_FILE_NAME = "com.ibm.ejs.ras.lite.traceFileName";
    private static final String ALT_TRACE_SPECIFICATION = "com.ibm.ejs.ras.lite.traceSpecification";
    private static final String ALT_TRACE_MAX_FILE_SIZE = "com.ibm.ejs.ras.lite.maxFileSize";
    private static final String ALT_TRACE_MAX_FILES = "com.ibm.ejs.ras.lite.maxFiles";
    private static final String ALT_TRACE_FORMAT = "com.ibm.ejs.ras.lite.traceFormat";
    private static final String CMVC_RELEASE = "CMVC_RELEASE";
    private static final String CMVC_LEVEL = "CMVC_LEVEL";
    private static final String className;
    private static final TraceNLS nls;
    private static ComponentManager cm;
    private static Set<TraceComponent> allTraceComponents;
    private static Properties traceProperties;
    private static PrintStream traceFile;
    private static FileOutputStream traceFileOutputStream;
    static Logger logger;
    private static final String BUILD_PROPERTIES = "com/ibm/ejs/ras/lite/build.properties";
    private static final String USER_PROPERTIES = "com/ibm/ejs/ras/lite/user.properties";
    private static final String USER2_PROPERTIES = "com/ibm/ejs/ras/lite/user2.properties";
    private static String traceFileName;
    private static String traceSpec;
    private static int maxFileSize;
    private static int maxFiles;
    private static String traceFormat;
    private static List<String> ffdcIgnore;
    static final String nl;
    private static int nnn;

    private static void handleUserProperties(Set<Properties> s) {
        for (Properties props : s) {
            Properties temp = new Properties();
            String cmvcRelease = props.getProperty(CMVC_RELEASE);
            String cmvcLevel = props.getProperty(CMVC_LEVEL);
            if (cmvcRelease != null) {
                temp.put(CMVC_RELEASE, cmvcRelease);
            }
            if (cmvcLevel != null) {
                temp.put(CMVC_LEVEL, cmvcLevel);
            }
            if (temp.size() != 0) {
                Tr.traceRecord("Using build " + temp);
            }
            Set<Map.Entry<Object, Object>> entries = props.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String key = (String)entry.getKey();
                if (!key.startsWith(FFDC_IGNORE_PREFIX)) continue;
                ffdcIgnore.add((String)entry.getValue());
            }
        }
    }

    private static String safelyGetSystemProperty(final String key) {
        String rc = null;
        try {
            rc = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return System.getProperty(key);
                }
            });
        }
        catch (Exception ex) {
            System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{ex, key}, ""));
        }
        return rc;
    }

    private static String[] safelyGetFiles(final String dir) {
        String[] rc = null;
        try {
            rc = AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                @Override
                public String[] run() throws Exception {
                    return new File(dir).list();
                }
            });
        }
        catch (Exception ex) {
            System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{ex, dir}, ""));
        }
        return rc;
    }

    private static Set<Properties> getUserProperties(final String fn) {
        HashSet<Properties> rc = new HashSet<Properties>();
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> e = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return cl.getResources(fn);
                }
            });
            while (e != null && e.hasMoreElements()) {
                final URL url = e.nextElement();
                InputStream is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return url.openStream();
                    }
                });
                Properties ps = new Properties();
                ps.load(is);
                rc.add(ps);
            }
        }
        catch (Exception e1) {
            System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{e1, fn}, ""));
        }
        return rc;
    }

    private Tr() {
    }

    public static void init() {
    }

    public static TraceComponent register(Class aClass) {
        return Tr.register(aClass.getName());
    }

    public static TraceComponent register(String name) {
        return Tr.register(name, null, null);
    }

    public static TraceComponent register(Class aClass, String group) {
        return Tr.register(aClass.getName(), group, null);
    }

    public static TraceComponent register(String name, String group) {
        return Tr.register(name, group, null);
    }

    public static TraceComponent register(Class aClass, String group, String bundle) {
        return Tr.register(aClass.getName(), group, bundle);
    }

    public static TraceComponent register(String name, String group, String bundle) {
        TraceComponent tc = new TraceComponent(name, group, bundle);
        if (logger != null) {
            tc.setLogger(Logger.getLogger(name));
        }
        tc.setTraceSpec(traceSpec);
        allTraceComponents.add(tc);
        return tc;
    }

    public static void registerDumpable(TraceComponent tc, Dumpable d) {
    }

    static ComponentManager getComponentManager() {
        return cm;
    }

    public static final void audit(TraceComponent tc, String msgKey) {
        Tr.audit(tc, msgKey, "");
    }

    public static final void audit(TraceComponent tc, String msgKey, Object objs) {
        if (tc.isAuditEnabled()) {
            Tr.trace(tc, Level.INFO, " ", "Audit: " + Tr.formatMsg(tc, msgKey, objs));
        }
    }

    public static final void debug(TraceComponent tc, String msg) {
        Tr.debug(tc, msg, "");
    }

    public static final void debug(TraceComponent tc, String msg, Object objs) {
        if (tc.isDumpEnabled()) {
            Tr.trace(tc, Level.FINEST, "3", msg + " " + Tr.formatObj(objs));
        }
    }

    public static final void dump(TraceComponent tc, String msg) {
        Tr.dump(tc, msg, "");
    }

    public static final void dump(TraceComponent tc, String msg, Object objs) {
        if (tc.isDumpEnabled()) {
            Tr.trace(tc, Level.FINEST, " ", "Dump: " + msg + " " + Tr.formatObj(objs));
        }
    }

    public static final void error(TraceComponent tc, String msgKey) {
        Tr.error(tc, msgKey, "");
    }

    public static final void error(TraceComponent tc, String msgKey, Object objs) {
        String msg = Tr.formatMsg(tc, msgKey, objs);
        if (tc.isErrorEnabled()) {
            Tr.trace(tc, Level.INFO, " ", "Error: " + msg);
        }
        System.err.println(msg);
    }

    public static final void event(TraceComponent tc, String msg) {
        Tr.event(tc, msg, "");
    }

    public static final void event(TraceComponent tc, String msg, Object objs) {
        if (tc.isEventEnabled()) {
            Tr.trace(tc, Level.INFO, " ", "Event: " + msg + " " + Tr.formatObj(objs));
        }
    }

    public static final void entry(TraceComponent tc, String methodName) {
        Tr.entry(tc, methodName, "");
    }

    public static final void entry(TraceComponent tc, String methodName, Object objs) {
        if (tc.isEntryEnabled()) {
            Tr.trace(tc, Level.FINER, ">", methodName, "Entry " + Tr.formatObj(objs));
        }
    }

    public static final void exit(TraceComponent tc, String methodName) {
        Tr.exit(tc, methodName, "");
    }

    public static final void exit(TraceComponent tc, String methodName, Object objs) {
        if (tc.isEntryEnabled()) {
            Tr.trace(tc, Level.FINER, "<", methodName, "Exit " + Tr.formatObj(objs));
        }
    }

    public static final void fatal(TraceComponent tc, String msgKey) {
        Tr.fatal(tc, msgKey, "");
    }

    public static final void fatal(TraceComponent tc, String msgKey, Object objs) {
        String msg = Tr.formatMsg(tc, msgKey, objs);
        if (tc.isFatalEnabled()) {
            Tr.trace(tc, Level.SEVERE, " ", "Fatal: " + msg);
        }
        System.err.println(msg);
    }

    public static final void info(TraceComponent tc, String msgKey) {
        Tr.info(tc, msgKey, "");
    }

    public static final void info(TraceComponent tc, String msgKey, Object objs) {
        if (tc.isInfoEnabled()) {
            Tr.trace(tc, Level.INFO, " ", "Info: " + Tr.formatMsg(tc, msgKey, objs));
        }
    }

    public static final void service(TraceComponent tc, String msgKey) {
        Tr.service(tc, msgKey, "");
    }

    public static final void service(TraceComponent tc, String msgKey, Object objs) {
        if (tc.isServiceEnabled()) {
            Tr.trace(tc, Level.INFO, " ", "Service: " + msgKey + " " + Tr.formatObj(objs));
        }
    }

    public static final void uncondEvent(TraceComponent tc, String msg) {
        Tr.uncondEvent(tc, msg, "");
    }

    public static final void uncondEvent(TraceComponent tc, String msg, Object objs) {
        Tr.trace(tc, Level.INFO, " ", "uncondEvent: " + msg + " " + Tr.formatObj(objs));
    }

    public static final void uncondFormattedEvent(TraceComponent tc, String msgKey) {
        Tr.uncondFormattedEvent(tc, msgKey, "");
    }

    public static final void uncondFormattedEvent(TraceComponent tc, String msgKey, Object objs) {
        Tr.trace(tc, Level.INFO, " ", "uncondFormattedEvent: " + Tr.formatMsg(tc, msgKey, objs));
    }

    public static final void warning(TraceComponent tc, String msgKey) {
        Tr.warning(tc, msgKey, "");
    }

    public static final void warning(TraceComponent tc, String msgKey, Object objs) {
        if (tc.isWarningEnabled()) {
            Tr.trace(tc, Level.WARNING, " ", "Warning: " + Tr.formatMsg(tc, msgKey, objs));
        }
    }

    public static void setTraceSpec(String ts) {
        traceSpec = ts;
        for (TraceComponent t : allTraceComponents) {
            t.setTraceSpec(traceSpec);
        }
    }

    public static List<String> getFfdcIgnoreList() {
        return ffdcIgnore;
    }

    private static void trace(TraceComponent tc, Level level, String sym, String txt) {
        Tr.trace(tc, level, sym, null, txt);
    }

    private static void trace(TraceComponent tc, Level level, String sym, String method, String txt) {
        String record = Tr.formatTraceRecord(tc.getName(), sym, method, txt);
        if (tc.getLogger() == null) {
            Tr.traceToFile(record);
        } else {
            tc.getLogger().log(level, record);
        }
    }

    static String formatTraceRecord(String name, String sym, String method, String txt) {
        String timestamp = new SimpleDateFormat("[dd/MM/yyyy HH:mm:ss:SSS z]").format(new Date());
        String threadid = RasHelper.getThreadId();
        String record = timestamp + " " + threadid + " " + sym + " ";
        record = traceFormat.equalsIgnoreCase("basic") ? record + Tr.format(name, 48) + " " + (method == null ? "" : method + " ") + txt : record + "UOW=" + " " + "source=" + name + " " + (method == null ? "" : "method=" + method + " ") + nl + "          " + txt;
        return record;
    }

    private static String format(String s, int l) {
        if (s.length() > l) {
            return s.substring(s.length() - l, s.length());
        }
        StringBuffer sb = new StringBuffer(256).append(s);
        for (int i = sb.length(); i < l; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String formatMsg(TraceComponent tc, String msgKey, Object objs) {
        String ans = "";
        Object[] args = new Object[]{};
        TraceNLS traceNLS = TraceNLS.getTraceNLS(tc.getResourceBundleName());
        if (objs != null) {
            args = objs.getClass().isArray() ? (Object[])objs : new Object[]{objs};
        }
        return traceNLS.getFormattedMessage(msgKey, args, "Message Key:" + msgKey + " not found in resource bundle:" + tc.getResourceBundleName());
    }

    static String formatObj(Object objs) {
        String ans = "";
        if (objs != null) {
            if (objs.getClass().isArray()) {
                StringBuffer sb = new StringBuffer();
                String pad = "                                                                                                ";
                int len = Array.getLength(objs);
                if (objs.getClass().getName().equals("[B")) {
                    sb.append(nl + "                                                                                                ");
                    sb.append("[");
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(Array.get(objs, i));
                        if (sb.length() <= 16384) continue;
                        sb.append("...Remaining entries suppressed");
                        break;
                    }
                    sb.append("]");
                } else {
                    for (int i = 0; i < len; ++i) {
                        sb.append(nl + "                                                                                                " + Tr.formatObj(Array.get(objs, i)));
                        if (sb.length() <= 16384) continue;
                        sb.append(nl + "                                                                                                " + "...Remaining entries suppressed");
                        break;
                    }
                }
                ans = sb.toString();
            } else if (objs instanceof Untraceable) {
                ans = objs.getClass().getName();
            } else if (objs instanceof Traceable) {
                try {
                    ans = ((Traceable)objs).toTraceString();
                }
                catch (Exception e) {
                    ans = "<Exception " + e + " caught while calling toTraceString() on object " + objs.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(objs)) + ">";
                }
            } else {
                try {
                    ans = objs.toString();
                }
                catch (Exception e) {
                    ans = "<Exception " + e + " caught while calling toString() on object " + objs.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(objs)) + ">";
                }
            }
        }
        return ans;
    }

    private static void traceRecord(String record) {
        if (traceSpec != null) {
            if (logger == null) {
                Tr.traceToFile(record);
            } else if (logger.isLoggable(Level.CONFIG)) {
                logger.config(record);
            }
        }
    }

    static void traceToFile(String record) {
        if (maxFileSize > 0) {
            long currentSize = 0L;
            long maxFileSizeBytes = (long)maxFileSize * 1024L * 1024L;
            do {
                try {
                    currentSize = traceFileOutputStream.getChannel().size();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (currentSize <= maxFileSizeBytes) continue;
                traceFile.close();
                Tr.openNewTraceFile();
            } while (currentSize > maxFileSizeBytes);
        }
        traceFile.println(record);
    }

    private static boolean openNewTraceFile() {
        String fileName;
        String dirName;
        String fn = traceFileName;
        final String fs = System.getProperty("file.separator");
        int lio = traceFileName.lastIndexOf(fs);
        if (lio > 0) {
            dirName = traceFileName.substring(0, lio + 1);
            fileName = traceFileName.substring(lio + 1);
        } else {
            dirName = ".";
            fileName = traceFileName;
        }
        if (maxFileSize > 0) {
            String[] files;
            if (nnn == 0 && (files = Tr.safelyGetFiles(dirName)) != null) {
                for (int i = 0; i < files.length; ++i) {
                    int lio2;
                    String number;
                    int numberInt;
                    if (!files[i].startsWith(fileName + ".") || (numberInt = new Integer(number = files[i].substring((lio2 = files[i].lastIndexOf(".")) + 1)).intValue()) <= nnn) continue;
                    nnn = numberInt;
                }
            }
            fn = fn + "." + Integer.toString(nnn++);
        }
        final String fnf = fn;
        final String dirNamef = dirName;
        final String fileNamef = fileName;
        Boolean traceFileExists = false;
        try {
            traceFileExists = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    String[] files;
                    boolean rc = new File(fnf).isFile();
                    traceFileOutputStream = new FileOutputStream(fnf, true);
                    traceFile = new PrintStream(traceFileOutputStream, true);
                    if (maxFiles > 0 && (files = Tr.safelyGetFiles(dirNamef)) != null) {
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].startsWith(fileNamef + ".")) continue;
                            boolean delete = true;
                            for (int j = 0; j < maxFiles && nnn - 1 - j >= 0 && delete; ++j) {
                                delete = !files[i].equals(fileNamef + "." + (nnn - 1 - j));
                            }
                            if (!delete) continue;
                            new File(dirNamef + fs + files[i]).delete();
                        }
                    }
                    return rc;
                }
            });
        }
        catch (Exception e) {
            System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{e, dirName + fs}, ""));
        }
        return traceFileExists;
    }

    static {
        boolean bl;
        String mf;
        String mfs;
        boolean foundMaxFiles;
        boolean foundMaxFileSize;
        className = Tr.class.getName();
        nls = TraceNLS.getTraceNLS("com.ibm.ejs.ras.Messages");
        cm = new ComponentManager();
        allTraceComponents = new HashSet<TraceComponent>();
        traceProperties = new Properties();
        traceFile = System.out;
        traceFileOutputStream = null;
        logger = null;
        maxFileSize = 0;
        maxFiles = 0;
        ffdcIgnore = new ArrayList<String>();
        LogManager o = LogManager.getLogManager();
        if (o.getClass().getName().equals("com.ibm.ws.bootstrap.WsLogManager")) {
            try {
                ((WsLogManager)o).initWsLoggerFactory(WsLoggerFactoryImpl.getInstance());
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Logger.getLogger("").addHandler(new WsHandler());
                        return null;
                    }
                });
            }
            catch (Exception e) {
                System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{e, "Initilizing WebSphere Log Manager"}, ""));
            }
        }
        traceFileName = Tr.safelyGetSystemProperty(ALT_TRACE_FILE_NAME);
        traceSpec = Tr.safelyGetSystemProperty(ALT_TRACE_SPECIFICATION);
        boolean bl2 = foundMaxFileSize = Tr.safelyGetSystemProperty(ALT_TRACE_MAX_FILE_SIZE) != null;
        if (foundMaxFileSize) {
            maxFileSize = new Integer(Tr.safelyGetSystemProperty(ALT_TRACE_MAX_FILE_SIZE));
        }
        boolean bl3 = foundMaxFiles = Tr.safelyGetSystemProperty(ALT_TRACE_MAX_FILES) != null;
        if (foundMaxFiles) {
            maxFiles = new Integer(Tr.safelyGetSystemProperty(ALT_TRACE_MAX_FILES));
        }
        traceFormat = Tr.safelyGetSystemProperty(ALT_TRACE_FORMAT);
        final String tracePropertiesFile = Tr.safelyGetSystemProperty(TRACE_SETTINGS_FILE);
        if (tracePropertiesFile != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                    @Override
                    public Properties run() throws Exception {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        URL url = cl.getResource(tracePropertiesFile);
                        if (url != null) {
                            traceProperties.load(url.openStream());
                        }
                        return traceProperties;
                    }
                });
            }
            catch (Exception e) {
                System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{e, tracePropertiesFile}, ""));
            }
        }
        if (traceFileName == null) {
            traceFileName = traceProperties.getProperty(TRACE_FILE_NAME);
        }
        if (traceSpec == null) {
            StringBuffer sb = new StringBuffer(256);
            Enumeration<?> e = traceProperties.propertyNames();
            while (e.hasMoreElements()) {
                String element = (String)e.nextElement();
                if (element.equals(TRACE_FILE_NAME) || element.equals(TRACE_MAX_FILE_SIZE) || element.equals(TRACE_MAX_FILES) || element.equals(TRACE_FORMAT)) continue;
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ':') {
                    sb.append(":");
                }
                sb.append(element + "=" + traceProperties.getProperty(element));
            }
            if (sb.toString().trim().length() > 0) {
                traceSpec = sb.toString();
            }
        }
        if (!foundMaxFileSize && (mfs = traceProperties.getProperty(TRACE_MAX_FILE_SIZE)) != null) {
            maxFileSize = new Integer(mfs);
        }
        if (!foundMaxFiles && (mf = traceProperties.getProperty(TRACE_MAX_FILES)) != null) {
            maxFiles = new Integer(mf);
        }
        if (traceFormat == null && (traceFormat = traceProperties.getProperty(TRACE_FORMAT)) == null) {
            traceFormat = "basic";
        }
        if (traceFileName == null) {
            traceFileName = "";
        }
        if (traceFileName.equals("") || traceFileName.equalsIgnoreCase("stdout")) {
            traceFile = System.out;
            maxFileSize = 0;
            maxFiles = 0;
        } else if (traceFileName.equalsIgnoreCase("stderr")) {
            traceFile = System.err;
            maxFileSize = 0;
            maxFiles = 0;
        } else if (traceFileName.equalsIgnoreCase("java.util.logging")) {
            logger = Logger.getLogger(className);
            maxFileSize = 0;
            maxFiles = 0;
        } else if (Tr.openNewTraceFile()) {
            Tr.traceRecord("--------------------------------------------------------------------------------------------------------------------------------------------");
        }
        Tr.traceRecord("************ Start Display Current Environment ************");
        try {
            Properties p = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws Exception {
                    return System.getProperties();
                }
            });
            TreeMap<Object, Object> tm = new TreeMap<Object, Object>(p);
            Set<Object> s = tm.keySet();
            for (String string : s) {
                if (string.toLowerCase().indexOf("password", 0) == -1) {
                    Tr.traceRecord(string + "=" + Tr.safelyGetSystemProperty(string));
                    continue;
                }
                Tr.traceRecord(string + "=" + "********");
            }
        }
        catch (Exception e) {
            Tr.traceRecord(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{e, "All System Properties"}, ""));
            Tr.traceRecord("com.ibm.ejs.ras.lite.traceFileName=" + Tr.safelyGetSystemProperty(ALT_TRACE_FILE_NAME));
            Tr.traceRecord("com.ibm.ejs.ras.lite.traceSpecification=" + Tr.safelyGetSystemProperty(ALT_TRACE_SPECIFICATION));
            Tr.traceRecord("com.ibm.ejs.ras.lite.maxFileSize=" + Tr.safelyGetSystemProperty(ALT_TRACE_MAX_FILE_SIZE));
            Tr.traceRecord("com.ibm.ejs.ras.lite.maxFiles=" + Tr.safelyGetSystemProperty(ALT_TRACE_MAX_FILES));
            Tr.traceRecord("com.ibm.ejs.ras.lite.traceFormat=" + Tr.safelyGetSystemProperty(ALT_TRACE_FORMAT));
            Tr.traceRecord("traceSettingsFile=" + Tr.safelyGetSystemProperty(TRACE_SETTINGS_FILE));
        }
        Tr.traceRecord(" ");
        Tr.traceRecord("Using trace specification \"" + traceSpec + "\"");
        Properties firstProperties = null;
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = null;
        try {
            e = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return cl.getResources(Tr.BUILD_PROPERTIES);
                }
            });
        }
        catch (Exception ex) {
            System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{ex, BUILD_PROPERTIES}, ""));
        }
        URL firstURL = null;
        boolean bl4 = true;
        try {
            while (e != null && e.hasMoreElements()) {
                final URL url = e.nextElement();
                InputStream is = null;
                try {
                    is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            return url.openStream();
                        }
                    });
                }
                catch (Exception ex) {
                    System.err.println(nls.getFormattedMessage("EXCP_CWSJE0003E", new Object[]{ex, url}, ""));
                }
                Properties ps = new Properties();
                ps.load(is);
                if (firstURL == null) {
                    firstURL = url;
                    firstProperties = ps;
                    continue;
                }
                if (ps.equals(firstProperties)) continue;
                String msg = nls.getFormattedMessage("BUILDLEVELS_NOT_SAME_CWSJE0001E", new Object[]{firstURL, firstProperties, url, ps}, "");
                System.err.println(msg);
                Tr.traceRecord(msg);
                bl = false;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!bl) {
            String msg = nls.getString("BUILDLEVELS_NOT_SAME_CWSJE0002E");
            Tr.traceRecord(msg);
            throw new RuntimeException(msg);
        }
        Tr.traceRecord("Using build " + firstProperties);
        Tr.handleUserProperties(Tr.getUserProperties(USER_PROPERTIES));
        Tr.handleUserProperties(Tr.getUserProperties(USER2_PROPERTIES));
        Tr.traceRecord("************* End Display Current Environment *************");
        ffdcIgnore = Collections.unmodifiableList(ffdcIgnore);
        Ffdc.set(new FfdcProvider());
        nl = System.getProperty("line.separator");
        nnn = 0;
    }
}

