/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.jca.ConfigProperty;
import org.eclipse.jst.j2ee.jca.RequiredConfigPropertyType;
import org.eclipse.jst.j2ee.jca.internal.util.JCADescriptionHelper;

public class J2CProps {
    private static final TraceComponent TC = Tr.register(J2CProps.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    public static final String nl = System.getProperty("line.separator");

    J2CProps() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "<init>");
        }
    }

    public static List mergeRAProperties(List tier0, List tier1, List tier3, int versionId) {
        if (TC.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer("mergeRAProperties");
            sb.append(nl);
            sb.append("  tier0     = <");
            sb.append(tier0 == null ? null : J2CProps.dumpList(tier0));
            sb.append("  >");
            sb.append(nl);
            sb.append("  tier1     = <");
            sb.append(tier1 == null ? null : J2CProps.dumpList(tier1));
            sb.append("  >");
            sb.append(nl);
            sb.append("  tier3     = <");
            sb.append(tier3 == null ? null : J2CProps.dumpList(tier3));
            sb.append("  >");
            sb.append(nl);
            sb.append("  versionId = <");
            sb.append(versionId);
            sb.append("  >");
            sb.append(nl);
            Tr.entry(TC, sb.toString());
        }
        List tier2 = null;
        if (tier0 != null) {
            List RAtier1 = J2CProps.convertCfgToJ2EE(tier1, versionId);
            tier2 = J2CProps.mergeProperty(tier0, RAtier1, tier3);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeRAProperties returning tier2 = <" + tier2 + ">");
        }
        return tier2;
    }

    public static List mergeCFProperties(List tier0, List tier1, List RAtier2, int versionId) {
        if (TC.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer("mergeCFProperties");
            sb.append(nl);
            sb.append("  tier0     = <");
            sb.append(tier0 == null ? null : J2CProps.dumpJ2EEResourcePropertyList(tier0));
            sb.append("  >");
            sb.append(nl);
            sb.append("  tier1     = <");
            sb.append(tier1 == null ? null : J2CProps.dumpList(tier1));
            sb.append("  >");
            sb.append(nl);
            sb.append("  RAtier2     = <");
            sb.append(RAtier2 == null ? null : J2CProps.dumpList(RAtier2));
            sb.append("  >");
            sb.append(nl);
            sb.append("  versionId = <");
            sb.append(versionId);
            sb.append("  >");
            sb.append(nl);
            Tr.entry(TC, sb.toString());
        }
        List tier2 = null;
        List RAtier1 = J2CProps.convertCfgToJ2EE(tier1, versionId);
        if (tier0 != null) {
            tier2 = J2CProps.mergeProperty(tier0, RAtier1, RAtier2);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeCFProperties returning tier2 = <" + J2CProps.dumpJ2EEResourcePropertyList(tier2) + ">");
        }
        return tier2;
    }

    public static List mergeACProperties(List tier0, List reqprops, List RAtier2) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "mergeACProperties");
            Tr.entry(TC, "   tier0    = <" + tier0 + ">");
            Tr.entry(TC, "   reqprops = <" + reqprops + ">");
            Tr.entry(TC, "   RAtier2  = <" + RAtier2 + ">");
        }
        List tier2 = null;
        if (tier0 != null) {
            tier2 = J2CProps.mergeProperty(tier0, RAtier2, null);
        }
        int rqSize = reqprops.size();
        for (int j = 0; j < rqSize; ++j) {
            RequiredConfigPropertyType reqprop = (RequiredConfigPropertyType)reqprops.get(j);
            String name = reqprop.getName();
            int t2Size = tier2.size();
            for (int k = 0; k < t2Size; ++k) {
                J2EEResourceProperty pp = (J2EEResourceProperty)tier2.get(k);
                if (!name.equalsIgnoreCase(pp.getName())) continue;
                pp.setRequired(true);
            }
            Tr.warning(TC, "REQUIRED_PROPERTY_MISSING_J2CA0282", name);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeACProperties returning tier2 = <" + tier2 + ">");
        }
        return tier2;
    }

    public static List mergeAOProperties(List tier0, List tier1cfg, int versionId) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "mergeAOProperties");
            Tr.entry(TC, "  tier0    = <" + tier0 + ">");
            Tr.entry(TC, "  tier1cfg = <" + tier1cfg + ">");
            Tr.entry(TC, "  versionId = <" + versionId + ">");
        }
        List tier2 = null;
        List tier1 = J2CProps.convertCfgToJ2EE(tier1cfg, versionId);
        if (tier0 != null) {
            tier2 = J2CProps.mergeProperty(tier0, tier1, null);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeAOProperties returning tier2 = <" + tier2 + ">");
        }
        return tier2;
    }

    private static List mergeProperty(List inTier0, List xmlTier1, List raTier2) {
        int t0Size;
        String pname;
        J2EEResourceProperty prop;
        int i;
        if (TC.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer("mergeProperty");
            sb.append(nl);
            sb.append("  inTier0     = <");
            sb.append(inTier0 == null ? null : J2CProps.dumpJ2EEResourcePropertyList(inTier0));
            sb.append("  >");
            sb.append(nl);
            sb.append("  xmlTier1     = <");
            sb.append(xmlTier1 == null ? null : J2CProps.dumpJ2EEResourcePropertyList(xmlTier1));
            sb.append("  >");
            sb.append(nl);
            sb.append("  raTier2     = <");
            sb.append(raTier2 == null ? null : J2CProps.dumpJ2EEResourcePropertyList(raTier2));
            sb.append("  >");
            sb.append(nl);
            Tr.entry(TC, sb.toString());
        }
        ArrayList<J2EEResourceProperty> outTier2 = new ArrayList<J2EEResourceProperty>(inTier0.size());
        outTier2.addAll(inTier0);
        if (xmlTier1 != null) {
            int t1Size = xmlTier1.size();
            for (i = 0; i < t1Size; ++i) {
                prop = (J2EEResourceProperty)xmlTier1.get(i);
                if (prop == null) continue;
                pname = prop.getName();
                t0Size = inTier0.size();
                boolean foundMatch = false;
                for (int j = 0; j < t0Size && !foundMatch; ++j) {
                    J2EEResourceProperty t0Prop = (J2EEResourceProperty)inTier0.get(j);
                    String name = t0Prop.getName();
                    if (!J2CProps.equalsIgnoreFirst(name, pname)) continue;
                    foundMatch = true;
                    String pvalue = prop.getValue();
                    if (pvalue != null && !pvalue.equals("")) {
                        String ptype = prop.getType();
                        String type = ((J2EEResourceProperty)inTier0.get(j)).getType();
                        if (type.equals(ptype)) {
                            prop.setName(pname);
                            outTier2.set(j, prop);
                            continue;
                        }
                        Object[] parms = new Object[]{name, ptype, type};
                        Tr.warning(TC, "PROPERTY_TYPE_MISMATCH_J2CA0280", parms);
                        outTier2.set(j, (J2EEResourceProperty)inTier0.get(j));
                        continue;
                    }
                    t0Prop.setName(pname);
                    String pdescr = prop.getDescription();
                    if (pdescr != null && !pdescr.equals("")) {
                        t0Prop.setDescription(pdescr);
                    }
                    outTier2.set(j, t0Prop);
                }
                if (foundMatch) continue;
                Tr.warning(TC, "PROPERTY_NOT_FOUND_J2CA0284", pname);
            }
        }
        if (raTier2 != null) {
            int t2Size = raTier2.size();
            for (i = 0; i < t2Size; ++i) {
                prop = (J2EEResourceProperty)raTier2.get(i);
                if (prop == null) continue;
                pname = prop.getName();
                t0Size = inTier0.size();
                for (int j = 0; j < t0Size; ++j) {
                    String pvalue;
                    String name = ((J2EEResourceProperty)outTier2.get(j)).getName();
                    if (!J2CProps.equalsIgnoreFirst(name, pname) || (pvalue = prop.getValue()) == null || pvalue.equals("")) continue;
                    String ptype = prop.getType();
                    String type = ((J2EEResourceProperty)inTier0.get(j)).getType();
                    if (type.equals(ptype)) {
                        outTier2.set(j, prop);
                        continue;
                    }
                    Object[] parms = new Object[]{name, ptype, type};
                    Tr.warning(TC, "PROPERTY_TYPE_MISMATCH_J2CA0281", parms);
                    outTier2.set(j, (J2EEResourceProperty)inTier0.get(j));
                }
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "mergeProperty() returned:" + outTier2);
        }
        return outTier2;
    }

    private static List convertCfgToJ2EE(List configs, int versionId) {
        ArrayList<J2EEResourceProperty> j2eeList = new ArrayList<J2EEResourceProperty>(configs.size());
        int cSize = configs.size();
        for (int i = 0; i < cSize; ++i) {
            ConfigProperty prop = (ConfigProperty)configs.get(i);
            String ttype = prop.getType();
            if (!ttype.startsWith("java.lang")) {
                Tr.warning(TC, "MSG001 %1 is ignored because type is not java.lang.*", prop.getName());
                continue;
            }
            ResourcesPackage respkg = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
            ResourcesFactory resFact = respkg.getResourcesFactory();
            J2EEResourceProperty property = resFact.createJ2EEResourceProperty();
            JCADescriptionHelper jdh = new JCADescriptionHelper();
            String desc = JCADescriptionHelper.getDescription((ConfigProperty)prop, (int)versionId);
            property.setDescription(desc);
            property.setName(prop.getName());
            property.setType(ttype);
            property.setValue(prop.getValue());
            j2eeList.add(property);
        }
        return j2eeList;
    }

    protected static boolean equalsIgnoreFirst(String s1, String s2) {
        int s1Len = s1.length();
        if (s1Len != s2.length()) {
            return false;
        }
        return s1.regionMatches(true, 0, s2, 0, 1) && s1.regionMatches(false, 1, s2, 1, s1Len - 1);
    }

    public static void main(String[] args) {
        ArrayList<J2EEResourceProperty> t0 = new ArrayList<J2EEResourceProperty>(52);
        ArrayList<J2EEResourceProperty> t1 = new ArrayList<J2EEResourceProperty>(52);
        ArrayList t2 = new ArrayList(52);
        List res = new ArrayList(52);
        J2CProps j2cp = new J2CProps();
        J2EEResourceProperty valProp1Bean = j2cp.newProp("valProp1", null, null);
        J2EEResourceProperty valProp1Ra = j2cp.newProp("valProp1", null, null);
        t0.add(valProp1Bean);
        t1.add(valProp1Ra);
        J2EEResourceProperty valProp2Bean = j2cp.newProp("valProp2", null, null);
        J2EEResourceProperty valProp2Ra = j2cp.newProp("valProp2", "b", null);
        t0.add(valProp2Bean);
        t1.add(valProp2Ra);
        J2EEResourceProperty valProp3Bean = j2cp.newProp("valProp3", null, null);
        J2EEResourceProperty valProp3Ra = j2cp.newProp("valProp3", null, "desc");
        t0.add(valProp3Bean);
        t1.add(valProp3Ra);
        J2EEResourceProperty valProp4Bean = j2cp.newProp("valProp4", null, null);
        J2EEResourceProperty valProp4Ra = j2cp.newProp("valProp4", "b", "desc");
        t0.add(valProp4Bean);
        t1.add(valProp4Ra);
        J2EEResourceProperty valProp5Bean = j2cp.newProp("valProp5", "b", null);
        J2EEResourceProperty valProp5Ra = j2cp.newProp("valProp5", null, null);
        t0.add(valProp5Bean);
        t1.add(valProp5Ra);
        J2EEResourceProperty valProp6Bean = j2cp.newProp("valProp6", "b", null);
        J2EEResourceProperty valProp6Ra = j2cp.newProp("valProp6", "b", null);
        t0.add(valProp6Bean);
        t1.add(valProp6Ra);
        J2EEResourceProperty valProp7Bean = j2cp.newProp("valProp7", "b", null);
        J2EEResourceProperty valProp7Ra = j2cp.newProp("valProp7", null, "desc");
        t0.add(valProp7Bean);
        t1.add(valProp7Ra);
        J2EEResourceProperty valProp8Bean = j2cp.newProp("valProp8", "b", null);
        J2EEResourceProperty valProp8Ra = j2cp.newProp("valProp8", "b", "desc");
        t0.add(valProp8Bean);
        t1.add(valProp8Ra);
        J2EEResourceProperty valProp9Bean = j2cp.newProp("valProp9", null, "desc");
        J2EEResourceProperty valProp9Ra = j2cp.newProp("valProp9", null, null);
        t0.add(valProp9Bean);
        t1.add(valProp9Ra);
        J2EEResourceProperty valProp10Bean = j2cp.newProp("valProp10", null, "desc");
        J2EEResourceProperty valProp10Ra = j2cp.newProp("valProp10", "b", null);
        t0.add(valProp10Bean);
        t1.add(valProp10Ra);
        J2EEResourceProperty valProp11Bean = j2cp.newProp("valProp11", null, "desc");
        J2EEResourceProperty valProp11Ra = j2cp.newProp("valProp11", null, "desc");
        t0.add(valProp11Bean);
        t1.add(valProp11Ra);
        J2EEResourceProperty valProp12Bean = j2cp.newProp("valProp12", null, "desc");
        J2EEResourceProperty valProp12Ra = j2cp.newProp("valProp12", "b", "desc");
        t0.add(valProp12Bean);
        t1.add(valProp12Ra);
        J2EEResourceProperty valProp13Bean = j2cp.newProp("valProp13", "b", "desc");
        J2EEResourceProperty valProp13Ra = j2cp.newProp("valProp13", null, null);
        t0.add(valProp13Bean);
        t1.add(valProp13Ra);
        J2EEResourceProperty valProp14Bean = j2cp.newProp("valProp14", "b", "desc");
        J2EEResourceProperty valProp14Ra = j2cp.newProp("valProp14", "b", null);
        t0.add(valProp14Bean);
        t1.add(valProp14Ra);
        J2EEResourceProperty valProp15Bean = j2cp.newProp("valProp15", "b", "desc");
        J2EEResourceProperty valProp15Ra = j2cp.newProp("valProp15", null, "desc");
        t0.add(valProp15Bean);
        t1.add(valProp15Ra);
        J2EEResourceProperty valProp16Bean = j2cp.newProp("valProp16", "b", "desc");
        J2EEResourceProperty valProp16Ra = j2cp.newProp("valProp16", "b", "desc");
        t0.add(valProp16Bean);
        t1.add(valProp16Ra);
        J2EEResourceProperty valProp1CBean = j2cp.newProp("valProp1C", "", "");
        J2EEResourceProperty valProp1CRa = j2cp.newProp("valProp1C", "", "");
        t0.add(valProp1CBean);
        t1.add(valProp1CRa);
        J2EEResourceProperty valProp2CBean = j2cp.newProp("valProp2C", "", "");
        J2EEResourceProperty valProp2CRa = j2cp.newProp("valProp2C", "b", "");
        t0.add(valProp2CBean);
        t1.add(valProp2CRa);
        J2EEResourceProperty valProp3CBean = j2cp.newProp("valProp3C", "", "");
        J2EEResourceProperty valProp3CRa = j2cp.newProp("valProp3C", "", "desc");
        t0.add(valProp3CBean);
        t1.add(valProp3CRa);
        J2EEResourceProperty valProp4CBean = j2cp.newProp("valProp4C", "", "");
        J2EEResourceProperty valProp4CRa = j2cp.newProp("valProp4C", "b", "desc");
        t0.add(valProp4CBean);
        t1.add(valProp4CRa);
        J2EEResourceProperty valProp5CBean = j2cp.newProp("valProp5C", "b", "");
        J2EEResourceProperty valProp5CRa = j2cp.newProp("valProp5C", "");
        t0.add(valProp5CBean);
        t1.add(valProp5CRa);
        J2EEResourceProperty valProp6CBean = j2cp.newProp("valProp6C", "b", "");
        J2EEResourceProperty valProp6CRa = j2cp.newProp("valProp6C", "b", "");
        t0.add(valProp6CBean);
        t1.add(valProp6CRa);
        J2EEResourceProperty valProp7CBean = j2cp.newProp("valProp7C", "b", "");
        J2EEResourceProperty valProp7CRa = j2cp.newProp("valProp7C", "", "desc");
        t0.add(valProp7CBean);
        t1.add(valProp7CRa);
        J2EEResourceProperty valProp8CBean = j2cp.newProp("valProp8C", "b", "");
        J2EEResourceProperty valProp8CRa = j2cp.newProp("valProp8C", "b", "desc");
        t0.add(valProp8CBean);
        t1.add(valProp8CRa);
        J2EEResourceProperty valProp9CBean = j2cp.newProp("valProp9C", "", "desc");
        J2EEResourceProperty valProp9CRa = j2cp.newProp("valProp9C", "", "");
        t0.add(valProp9CBean);
        t1.add(valProp9CRa);
        J2EEResourceProperty valProp10CBean = j2cp.newProp("valProp10C", "", "desc");
        J2EEResourceProperty valProp10CRa = j2cp.newProp("valProp10C", "b");
        t0.add(valProp10CBean);
        t1.add(valProp10CRa);
        J2EEResourceProperty valProp11CBean = j2cp.newProp("valProp11C", "", "desc");
        J2EEResourceProperty valProp11CRa = j2cp.newProp("valProp11C", "", "desc");
        t0.add(valProp11CBean);
        t1.add(valProp11CRa);
        J2EEResourceProperty valProp12CBean = j2cp.newProp("valProp12C", "", "desc");
        J2EEResourceProperty valProp12CRa = j2cp.newProp("valProp12C", "b", "desc");
        t0.add(valProp12CBean);
        t1.add(valProp12CRa);
        J2EEResourceProperty valProp13CBean = j2cp.newProp("valProp13C", "b", "desc");
        J2EEResourceProperty valProp13CRa = j2cp.newProp("valProp13C", "", "");
        t0.add(valProp13CBean);
        t1.add(valProp13CRa);
        J2EEResourceProperty valProp14CBean = j2cp.newProp("valProp14C", "b", "desc");
        J2EEResourceProperty valProp14CRa = j2cp.newProp("valProp14C", "b", "");
        t0.add(valProp14CBean);
        t1.add(valProp14CRa);
        J2EEResourceProperty valProp15CBean = j2cp.newProp("valProp15C", "b", "desc");
        J2EEResourceProperty valProp15CRa = j2cp.newProp("valProp15C", "", "desc");
        t0.add(valProp15CBean);
        t1.add(valProp15CRa);
        J2EEResourceProperty valProp16CBean = j2cp.newProp("valProp16C", "b", "desc");
        J2EEResourceProperty valProp16CRa = j2cp.newProp("valProp16C", "b", "desc");
        t0.add(valProp16CBean);
        t1.add(valProp16CRa);
        J2EEResourceProperty valProp1DBean = j2cp.newProp("valProp1D", null);
        J2EEResourceProperty valProp1DRa = j2cp.newProp("valProp1D", null);
        t0.add(valProp1DBean);
        t1.add(valProp1DRa);
        J2EEResourceProperty valProp2DBean = j2cp.newProp("valProp2D", null);
        J2EEResourceProperty valProp2DRa = j2cp.newProp("valProp2D", "b");
        t0.add(valProp2DBean);
        t1.add(valProp2DRa);
        J2EEResourceProperty valProp3DBean = j2cp.newProp("valProp3D", null);
        J2EEResourceProperty valProp3DRa = j2cp.newProp("valProp3D", null, "desc");
        t0.add(valProp3DBean);
        t1.add(valProp3DRa);
        J2EEResourceProperty valProp4DBean = j2cp.newProp("valProp4D", null);
        J2EEResourceProperty valProp4DRa = j2cp.newProp("valProp4D", "b", "desc");
        t0.add(valProp4DBean);
        t1.add(valProp4DRa);
        J2EEResourceProperty valProp5DBean = j2cp.newProp("valProp5D", "b");
        J2EEResourceProperty valProp5DRa = j2cp.newProp("valProp5D", null);
        t0.add(valProp5DBean);
        t1.add(valProp5DRa);
        J2EEResourceProperty valProp6DBean = j2cp.newProp("valProp6D", "b");
        J2EEResourceProperty valProp6DRa = j2cp.newProp("valProp6D", "b");
        t0.add(valProp6DBean);
        t1.add(valProp6DRa);
        J2EEResourceProperty valProp7DBean = j2cp.newProp("valProp7D", "b");
        J2EEResourceProperty valProp7DRa = j2cp.newProp("valProp7D", null, "desc");
        t0.add(valProp7DBean);
        t1.add(valProp7DRa);
        J2EEResourceProperty valProp8DBean = j2cp.newProp("valProp8D", "b");
        J2EEResourceProperty valProp8DRa = j2cp.newProp("valProp8D", "b", "desc");
        t0.add(valProp8DBean);
        t1.add(valProp8DRa);
        J2EEResourceProperty valProp9DBean = j2cp.newProp("valProp9D", null, "desc");
        J2EEResourceProperty valProp9DRa = j2cp.newProp("valProp9D", null);
        t0.add(valProp9DBean);
        t1.add(valProp9DRa);
        J2EEResourceProperty valProp10DBean = j2cp.newProp("valProp10D", null, "desc");
        J2EEResourceProperty valProp10DRa = j2cp.newProp("valProp10D", "b");
        t0.add(valProp10DBean);
        t1.add(valProp10DRa);
        J2EEResourceProperty valProp11DBean = j2cp.newProp("valProp11D", null, "desc");
        J2EEResourceProperty valProp11DRa = j2cp.newProp("valProp11D", null, "desc");
        t0.add(valProp11DBean);
        t1.add(valProp11DRa);
        J2EEResourceProperty valProp12DBean = j2cp.newProp("valProp12D", null, "desc");
        J2EEResourceProperty valProp12DRa = j2cp.newProp("valProp12D", "b", "desc");
        t0.add(valProp12DBean);
        t1.add(valProp12DRa);
        J2EEResourceProperty valProp13DBean = j2cp.newProp("valProp13D", "b", "desc");
        J2EEResourceProperty valProp13DRa = j2cp.newProp("valProp13D", null);
        t0.add(valProp13DBean);
        t1.add(valProp13DRa);
        J2EEResourceProperty valProp14DBean = j2cp.newProp("valProp14D", "b", "desc");
        J2EEResourceProperty valProp14DRa = j2cp.newProp("valProp14D", "b");
        t0.add(valProp14DBean);
        t1.add(valProp14DRa);
        J2EEResourceProperty valProp15DBean = j2cp.newProp("valProp15D", "b", "desc");
        J2EEResourceProperty valProp15DRa = j2cp.newProp("valProp15D", null, "desc");
        t0.add(valProp15DBean);
        t1.add(valProp15DRa);
        J2EEResourceProperty valProp16DBean = j2cp.newProp("valProp16D", "b", "desc");
        J2EEResourceProperty valProp16DRa = j2cp.newProp("valProp16D", "b", "desc");
        t0.add(valProp16DBean);
        t1.add(valProp16DRa);
        J2EEResourceProperty nullPropARa = j2cp.newProp("nullPropA", null);
        t1.add(nullPropARa);
        J2EEResourceProperty valPropBRa = j2cp.newProp("valPropB", "ra");
        t1.add(valPropBRa);
        J2EEResourceProperty nullPropCBean = j2cp.newProp("nullPropC", null);
        t0.add(nullPropCBean);
        J2EEResourceProperty valPropDBean = j2cp.newProp("valPropD", "b");
        t0.add(valPropDBean);
        res = J2CProps.mergeProperty(t0, t1, t2);
        System.out.println(res);
    }

    J2EEResourceProperty newProp(String name, String value) {
        J2EEResourcePropertyImpl retval = new J2EEResourcePropertyImpl();
        retval.setName(name);
        retval.setType("java.lang.String");
        retval.setValue(value);
        return retval;
    }

    J2EEResourceProperty newProp(String name, String value, String desc) {
        J2EEResourceProperty retval = this.newProp(name, value);
        retval.setDescription(desc);
        return retval;
    }

    private static String dumpList(List l) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append(nl);
            sb.append("               ");
        }
        return sb.toString();
    }

    private static String dumpJ2EEResourcePropertyList(List l) {
        StringBuffer sb = new StringBuffer();
        for (J2EEResourceProperty j2eeRP : l) {
            sb.append(j2eeRP);
            String rpName = j2eeRP.getName();
            String rpType = j2eeRP.getType();
            String rpValue = j2eeRP.getValue();
            sb.append("   - " + rpName + "  :  " + rpType + "  :  " + rpValue);
            sb.append(nl);
            sb.append("               ");
        }
        return sb.toString();
    }

    class J2EEResourcePropertyImpl
    implements J2EEResourceProperty {
        private String name;
        private String type;
        private String value;
        private String description;

        J2EEResourcePropertyImpl() {
        }

        public EClass eClass() {
            return null;
        }

        public Resource eResource() {
            return null;
        }

        public EReference eContainmentFeature() {
            return null;
        }

        public EList eContents() {
            return null;
        }

        public TreeIterator eAllContents() {
            return null;
        }

        public boolean eIsProxy() {
            return false;
        }

        public EList eCrossReferences() {
            return null;
        }

        public Object eGet(EStructuralFeature arg0) {
            return null;
        }

        public Object eGet(EStructuralFeature arg0, boolean arg1) {
            return null;
        }

        public void eSet(EStructuralFeature arg0, Object arg1) {
        }

        public boolean eIsSet(EStructuralFeature arg0) {
            return false;
        }

        public void eUnset(EStructuralFeature arg0) {
        }

        public EList eAdapters() {
            return null;
        }

        public boolean eDeliver() {
            return false;
        }

        public void eSetDeliver(boolean arg0) {
        }

        public void eNotify(Notification arg0) {
        }

        public String toString() {
            String nl = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            sb.append(nl + this.name + "=" + this.value + "," + this.description);
            return sb.toString();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isRequired() {
            return false;
        }

        public void setRequired(boolean arg0) {
        }

        public void unsetRequired() {
        }

        public boolean isSetRequired() {
            return false;
        }

        public EObject eContainer() {
            return null;
        }

        public EStructuralFeature eContainingFeature() {
            return null;
        }
    }
}

