/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.websphere.csi.J2EEName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;

public class J2EENameImpl
implements J2EEName {
    private static final long serialVersionUID = 7488184044073147667L;
    private static final String SEPARATOR = "#";
    private static HashMap activeJ2EEName = new HashMap();
    private transient String ivApplication;
    private transient String ivModule;
    private transient String ivComponent;
    private transient String ivJ2eeName;
    private transient int ivNameHashValue;
    private byte[] j2eeNameBytes;
    private int activeListIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J2EENameImpl(String application, String module, String component) {
        this.ivApplication = application;
        this.ivModule = module;
        this.ivComponent = component;
        if (application == null) {
            throw new IllegalArgumentException("Application name required.");
        }
        StringBuffer sb = new StringBuffer(application);
        if (module != null) {
            sb.append(SEPARATOR).append(module);
        }
        if (module != null && component != null) {
            sb.append(SEPARATOR).append(component);
        }
        if (module == null && component != null) {
            throw new IllegalArgumentException("Module name is null yet Component name is non-null, this is not acceptable");
        }
        this.ivJ2eeName = sb.toString();
        this.j2eeNameBytes = this.ivJ2eeName.getBytes();
        this.ivNameHashValue = this.ivJ2eeName.hashCode();
        HashMap hashMap = activeJ2EEName;
        synchronized (hashMap) {
            J2EENameImpl existing = (J2EENameImpl)activeJ2EEName.get(this.ivJ2eeName);
            if (existing == null) {
                this.activeListIndex = activeJ2EEName.size();
                activeJ2EEName.put(this.ivJ2eeName, this);
            } else {
                this.activeListIndex = existing.activeListIndex;
                this.ivJ2eeName = existing.ivJ2eeName;
            }
        }
    }

    public J2EENameImpl(byte[] j2eenameBytes) {
        this.activeListIndex = -1;
        this.resetFromByteArray(j2eenameBytes);
    }

    public String toString() {
        return this.ivJ2eeName;
    }

    public String getApplication() {
        return this.ivApplication;
    }

    public String getModule() {
        return this.ivModule;
    }

    public String getComponent() {
        return this.ivComponent;
    }

    public byte[] getBytes() {
        return this.j2eeNameBytes;
    }

    public int hashCode() {
        return this.ivNameHashValue;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof J2EENameImpl)) {
            return false;
        }
        return ((J2EENameImpl)o).activeListIndex == this.activeListIndex;
    }

    public boolean equals(J2EENameImpl j2eeName) {
        if (j2eeName == null) {
            return false;
        }
        return j2eeName.activeListIndex == this.activeListIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFromByteArray(byte[] j2eenameBytes) {
        this.ivApplication = null;
        this.ivModule = null;
        this.ivComponent = null;
        this.j2eeNameBytes = j2eenameBytes;
        this.ivJ2eeName = new String(j2eenameBytes);
        int index = this.ivJ2eeName.indexOf(SEPARATOR);
        if (index == -1) {
            this.ivApplication = this.ivJ2eeName;
        } else {
            this.ivApplication = new String(this.ivJ2eeName.substring(0, index));
            int nextIndex = this.ivJ2eeName.indexOf(SEPARATOR, index + 1);
            if (nextIndex == -1) {
                this.ivModule = new String(this.ivJ2eeName.substring(index + 1));
            } else {
                this.ivModule = new String(this.ivJ2eeName.substring(index + 1, nextIndex));
                this.ivComponent = new String(this.ivJ2eeName.substring(nextIndex + 1));
            }
        }
        this.ivNameHashValue = this.ivJ2eeName.hashCode();
        HashMap hashMap = activeJ2EEName;
        synchronized (hashMap) {
            J2EENameImpl existing = (J2EENameImpl)activeJ2EEName.get(this.ivJ2eeName);
            if (existing == null) {
                this.activeListIndex = activeJ2EEName.size();
                activeJ2EEName.put(this.ivJ2eeName, this);
            } else {
                this.activeListIndex = existing.activeListIndex;
                this.ivJ2eeName = existing.ivJ2eeName;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.activeListIndex = -1;
        this.resetFromByteArray(this.j2eeNameBytes);
    }
}

