/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.util.BuzzHash;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.StringTokenizer;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.Session;

public final class NameUtil {
    private static final TraceComponent tc = Tr.register(NameUtil.class, "EJBContainer", "com.ibm.ejs.container.container");
    public static final String homeRemotePrefix = "EJSRemote";
    public static final String homeBeanPrefix = "EJS";
    public static final String remotePrefix = "EJSRemote";
    public static final String concreteBeanPrefix = "Concrete";
    public static final String persisterPrefix = "EJSJDBCPersister";
    public static final String endpointPrefix = "WSEJBProxy";
    public static final String homeLocalPrefix = "EJSLocal";
    public static final String localPrefix = "EJSLocal";
    public static final int Max_Gen_File_Size = 100;
    public static final int Max_EjbName_Size = 32;
    public static final String UNKNOWN = "UNKNOWN";
    public static final String STATELESS = "SL";
    public static final String STATEFUL = "SF";
    public static final String BEAN_MANAGED = "BMP";
    public static final String CONTAINER_MANAGED = "CMP";
    public static final String MESSAGE_DRIVEN = "MDB";
    public static final int EJB_1X = 1;
    public static final int EJB_2X = 2;
    public static final int EJB_3X = 3;
    private String ivBeanName = null;
    private String ivFullBeanName = null;
    private String ivBeanType = null;
    private String ivHashSuffix = null;
    private int ivHashVersion = -1;
    private int ivVersion = -1;
    private final String ivRemoteHomeInterface;
    private final String ivRemoteInterface;
    private final String ivLocalHomeInterface;
    private final String ivLocalInterface;
    private final String[] ivBusinessRemote;
    private final String[] ivBusinessLocal;
    private final String ivBeanClass;
    private final String ivPrimaryKey;

    public static String getRemoteImplClassName(EnterpriseBean enterpriseBean, boolean isPost11DD) {
        String remoteInterfaceName = enterpriseBean.getRemoteInterfaceName();
        if (remoteInterfaceName == null) {
            return null;
        }
        String packageName = NameUtil.packageName(remoteInterfaceName);
        String remoteName = NameUtil.encodeBeanInterfacesName(enterpriseBean, isPost11DD, false, false, false);
        StringBuffer result = new StringBuffer();
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSRemote");
        result.append(NameUtil.getUniquePrefix(enterpriseBean));
        result.append(remoteName);
        return result.toString();
    }

    public static String getLocalImplClassName(EnterpriseBean enterpriseBean, boolean isPost11DD) {
        String localInterfaceName = enterpriseBean.getLocalInterfaceName();
        if (localInterfaceName == null) {
            return null;
        }
        String packageName = NameUtil.packageName(localInterfaceName);
        String localName = NameUtil.encodeBeanInterfacesName(enterpriseBean, isPost11DD, true, false, false);
        StringBuffer result = new StringBuffer();
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSLocal");
        result.append(NameUtil.getUniquePrefix(enterpriseBean));
        result.append(localName);
        return result.toString();
    }

    public static String getHomeRemoteImplClassName(EnterpriseBean enterpriseBean, boolean isPost11DD) {
        String homeInterfaceName = enterpriseBean.getHomeInterfaceName();
        if (homeInterfaceName == null) {
            return null;
        }
        String remoteInterfaceName = enterpriseBean.getRemoteInterfaceName();
        String packageName = NameUtil.packageName(remoteInterfaceName);
        String homeName = NameUtil.encodeBeanInterfacesName(enterpriseBean, isPost11DD, false, true, false);
        StringBuffer result = new StringBuffer();
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSRemote");
        result.append(NameUtil.getUniquePrefix(enterpriseBean));
        result.append(homeName);
        return result.toString();
    }

    public static String getHomeLocalImplClassName(EnterpriseBean enterpriseBean, boolean isPost11DD) {
        String homeLocalInterfaceName = enterpriseBean.getLocalHomeInterfaceName();
        if (homeLocalInterfaceName == null) {
            return null;
        }
        String localInterfaceName = enterpriseBean.getLocalInterfaceName();
        String packageName = NameUtil.packageName(localInterfaceName);
        String homeLocalName = NameUtil.encodeBeanInterfacesName(enterpriseBean, isPost11DD, true, true, false);
        StringBuffer result = new StringBuffer();
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSLocal");
        result.append(NameUtil.getUniquePrefix(enterpriseBean));
        result.append(homeLocalName);
        return result.toString();
    }

    public static String getHomeBeanClassName(EnterpriseBean enterpriseBean, boolean isPost11DD) {
        String packageName = null;
        String homeInterfaceName = enterpriseBean.getHomeInterfaceName();
        if (homeInterfaceName == null) {
            homeInterfaceName = enterpriseBean.getLocalHomeInterfaceName();
        }
        if (homeInterfaceName != null) {
            packageName = NameUtil.packageName(homeInterfaceName);
            StringBuffer result = new StringBuffer();
            if (packageName != null) {
                result.append(packageName);
                result.append('.');
            }
            result.append(homeBeanPrefix);
            result.append(NameUtil.getUniquePrefix(enterpriseBean));
            String homeName = NameUtil.encodeBeanInterfacesName(enterpriseBean, isPost11DD, false, true, true);
            result.append(homeName);
            return result.toString();
        }
        return null;
    }

    public static String getConcreteBeanClassName(EnterpriseBean enterpriseBean) {
        String beanClassName = enterpriseBean.getEjbClassName();
        String packageName = NameUtil.packageName(beanClassName);
        String beanName = NameUtil.encodeBeanInterfacesName(enterpriseBean, true, false, false, false);
        StringBuffer result = new StringBuffer();
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append(concreteBeanPrefix);
        result.append(beanName);
        return result.toString();
    }

    public static String getDeployedPersisterClassName(EnterpriseBean enterpriseBean) {
        String beanClassName = enterpriseBean.getEjbClassName();
        String packageName = NameUtil.packageName(beanClassName);
        String beanName = NameUtil.relativeName(beanClassName);
        StringBuffer result = new StringBuffer();
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append(persisterPrefix);
        result.append(NameUtil.getUniquePrefix(enterpriseBean));
        result.append(beanName);
        return result.toString();
    }

    public static String getDeployedPersisterClassName(Object enterpriseBean) {
        return NameUtil.getDeployedPersisterClassName((EnterpriseBean)enterpriseBean);
    }

    public static String relativeName(String className) {
        return NameUtil.relativeName(className, ".");
    }

    public static String relativeName(String className, String delim) {
        String tmp = null;
        StringTokenizer st = new StringTokenizer(className, delim, false);
        while (st.hasMoreElements()) {
            tmp = st.nextToken();
        }
        return tmp;
    }

    public static String packageName(String className) {
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(0, index);
        }
        return null;
    }

    public static String getUniquePrefix(EnterpriseBean enterpriseBean) {
        String prefix = "";
        if (enterpriseBean.isSession()) {
            prefix = ((Session)enterpriseBean).getSessionType().getName();
        } else if (enterpriseBean.isEntity()) {
            prefix = ((Entity)enterpriseBean).isContainerManagedEntity() ? CONTAINER_MANAGED : BEAN_MANAGED;
        } else if (enterpriseBean.isMessageDriven()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "EJB Internal Error - MessageDriven has no unique prefix");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Unknown bean type");
        }
        return prefix;
    }

    public static String getCreateTableStringsMethodNameBase() {
        return "getCreateTableSQLStrings_";
    }

    public static final String getHashStr(EnterpriseBean enterpriseBean) {
        String localBusinessInterfaceName;
        String localHomeInterfaceName;
        String remoteBusinessInterfaceName;
        StringBuffer hashStr = new StringBuffer(enterpriseBean.getName());
        String remoteHomeInterfaceName = enterpriseBean.getHomeInterfaceName();
        if (remoteHomeInterfaceName != null) {
            hashStr.append(remoteHomeInterfaceName);
        }
        if ((remoteBusinessInterfaceName = enterpriseBean.getRemoteInterfaceName()) != null) {
            hashStr.append(remoteBusinessInterfaceName);
        }
        if ((localHomeInterfaceName = enterpriseBean.getLocalHomeInterfaceName()) != null) {
            hashStr.append(localHomeInterfaceName);
        }
        if ((localBusinessInterfaceName = enterpriseBean.getLocalInterfaceName()) != null) {
            hashStr.append(localBusinessInterfaceName);
        }
        String beanClassName = enterpriseBean.getEjbClassName();
        hashStr.append(beanClassName);
        if (enterpriseBean.isEntity()) {
            hashStr.append(((Entity)enterpriseBean).getPrimaryKeyName());
        }
        return hashStr.toString();
    }

    public static final String getHashStr(Object enterpriseBean) {
        return NameUtil.getHashStr((EnterpriseBean)enterpriseBean);
    }

    private static final String encodeBeanInterfacesName(EnterpriseBean enterpriseBean, boolean isPost11DD, boolean isLocal, boolean isHome, boolean isBean) {
        String rtnStr = null;
        if (!isPost11DD) {
            if (isHome) {
                rtnStr = isLocal ? enterpriseBean.getLocalHomeInterfaceName() : enterpriseBean.getHomeInterfaceName();
                if (isBean) {
                    rtnStr = rtnStr + "Bean";
                }
            } else {
                rtnStr = isLocal ? enterpriseBean.getLocalInterfaceName() : enterpriseBean.getRemoteInterfaceName();
            }
            return NameUtil.relativeName(rtnStr);
        }
        String ejbName = enterpriseBean.getName();
        rtnStr = NameUtil.translateEjbName(ejbName);
        String hashStr = NameUtil.getHashStr(enterpriseBean);
        if (isHome) {
            rtnStr = rtnStr + "Home";
        }
        if (isBean) {
            rtnStr = rtnStr + "Bean";
        }
        return rtnStr + "_" + BuzzHash.computeHashStringMid32Bit(hashStr);
    }

    private static boolean allHexDigits(String str, int start, int end) {
        boolean rtn = true;
        for (int i = start; i < end; ++i) {
            if ("0123456789abcdefABCDEF".indexOf(str.charAt(i)) != -1) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static final String updateFilenameHashCode(EnterpriseBean enterpriseBean, String oldName) {
        int last_;
        String newName = null;
        int len = oldName.length();
        int n = last_ = len > 9 && oldName.charAt(len - 9) == '_' ? len - 9 : -1;
        if (last_ != -1 && NameUtil.allHexDigits(oldName, ++last_, len)) {
            String hashStr = NameUtil.getHashStr(enterpriseBean);
            newName = oldName.substring(0, last_) + BuzzHash.computeHashStringMid32Bit(hashStr, true);
        }
        return newName;
    }

    public static final String updateFilenameHashCode(Object enterpriseBean, String oldName) {
        return NameUtil.updateFilenameHashCode((EnterpriseBean)enterpriseBean, oldName);
    }

    private static String translateEjbName(String ejbName) {
        int len = (ejbName = ejbName.trim()).length();
        if (len > 32) {
            len = 32;
        }
        char[] translated = new char[len];
        for (int i = 0; i < len; ++i) {
            int curChar = ejbName.charAt(i);
            translated[i] = Character.isLetterOrDigit((char)curChar) ? curChar : 95;
        }
        return new String(translated);
    }

    public static void dumpClassNames(EnterpriseBean enterpriseBean, boolean isPost11DD) {
        System.out.println("<NameUtil><EjbName          > " + enterpriseBean.getName() + ":" + isPost11DD);
        System.out.println("<NameUtil><RemoteWrapper    > " + NameUtil.getRemoteImplClassName(enterpriseBean, isPost11DD));
        System.out.println("<NameUtil><RemoteHomeWrapper> " + NameUtil.getHomeRemoteImplClassName(enterpriseBean, isPost11DD));
        System.out.println("<NameUtil><LocalWrapper     > " + NameUtil.getLocalImplClassName(enterpriseBean, isPost11DD));
        System.out.println("<NameUtil><LocalHomeWrapper > " + NameUtil.getHomeLocalImplClassName(enterpriseBean, isPost11DD));
        System.out.println("<NameUtil><HomeBean         > " + NameUtil.getHomeBeanClassName(enterpriseBean, isPost11DD));
        System.out.println("<NameUtil><ConcreateBean    > " + NameUtil.getConcreteBeanClassName(enterpriseBean));
        System.out.println("<NameUtil><Persister        > " + NameUtil.getDeployedPersisterClassName(enterpriseBean));
    }

    public NameUtil(String beanName, String remoteHomeInterface, String remoteInterface, String localHomeInterface, String localInterface, String[] remoteBusinessInterfaces, String[] localBusinessInterfaces, String beanClass, String primaryKey, String beanType, int version) {
        if (beanName == null) {
            throw new IllegalArgumentException("Bean Name not specified.");
        }
        this.ivBeanName = NameUtil.translateEjbName(beanName);
        this.ivFullBeanName = beanName;
        if (version < 1 || version > 3) {
            throw new IllegalArgumentException("Unsupported module version : " + version);
        }
        this.ivVersion = version == 3 && beanType == CONTAINER_MANAGED ? 2 : version;
        if (beanType != STATELESS && beanType != STATEFUL && beanType != CONTAINER_MANAGED && beanType != BEAN_MANAGED && beanType != MESSAGE_DRIVEN) {
            throw new IllegalArgumentException("Unsupported bean type : " + beanType);
        }
        switch (this.ivVersion) {
            case 3: {
                this.ivBeanType = beanType;
                break;
            }
            case 1: 
            case 2: {
                this.ivBeanType = beanType == STATELESS ? "Stateless" : (beanType == STATEFUL ? "Stateful" : beanType);
            }
        }
        this.ivRemoteHomeInterface = remoteHomeInterface;
        this.ivRemoteInterface = remoteInterface;
        this.ivLocalHomeInterface = localHomeInterface;
        this.ivLocalInterface = localInterface;
        this.ivBusinessRemote = remoteBusinessInterfaces;
        this.ivBusinessLocal = localBusinessInterfaces;
        this.ivBeanClass = beanClass;
        this.ivPrimaryKey = primaryKey;
        this.ivHashSuffix = this.getHashSuffix(this.ivVersion >= 3);
    }

    public String getBusinessRemoteImplClassName(int index) {
        if (this.ivBusinessRemote == null || this.ivVersion < 3) {
            throw new IllegalStateException("Remote Business interfaces are not supported in EJB 1.x and 2.x modules");
        }
        String remoteInterface = this.ivBusinessRemote[index];
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(remoteInterface);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSRemote");
        result.append(index);
        result.append(this.ivBeanType);
        result.append(this.ivBeanName);
        result.append('_');
        result.append(this.ivHashSuffix);
        return result.toString();
    }

    public String getBusinessLocalImplClassName(int index) {
        if (this.ivBusinessLocal == null || this.ivVersion < 3) {
            throw new IllegalStateException("Local Business interfaces are not supported in EJB 1.x and 2.x modules");
        }
        String localInterface = this.ivBusinessLocal[index];
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(localInterface);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSLocal");
        result.append(index);
        result.append(this.ivBeanType);
        result.append(this.ivBeanName);
        result.append('_');
        result.append(this.ivHashSuffix);
        return result.toString();
    }

    public String getRemoteImplClassName() {
        if (this.ivRemoteInterface == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(this.ivRemoteInterface);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSRemote");
        if (this.ivVersion >= 3) {
            result.append("C");
        }
        result.append(this.ivBeanType);
        if (this.ivVersion >= 2) {
            result.append(this.ivBeanName);
            result.append('_');
            result.append(this.ivHashSuffix);
        } else {
            result.append(NameUtil.relativeName(this.ivRemoteInterface));
            if (this.ivHashVersion > 0) {
                result.append('_');
                result.append(this.ivHashSuffix);
            }
        }
        return result.toString();
    }

    public String getLocalImplClassName() {
        if (this.ivLocalInterface == null) {
            return null;
        }
        if (this.ivVersion == 1) {
            throw new IllegalStateException("Local interfaces are not supported in EJB 1.x modules");
        }
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(this.ivLocalInterface);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSLocal");
        if (this.ivVersion >= 3) {
            result.append("C");
        }
        result.append(this.ivBeanType);
        result.append(this.ivBeanName);
        result.append('_');
        result.append(this.ivHashSuffix);
        return result.toString();
    }

    public String getHomeRemoteImplClassName() {
        if (this.ivRemoteHomeInterface == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(this.ivRemoteInterface);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSRemote");
        if (this.ivVersion >= 3) {
            result.append("C");
        }
        result.append(this.ivBeanType);
        if (this.ivVersion >= 2) {
            result.append(this.ivBeanName);
            result.append("Home");
            result.append('_');
            result.append(this.ivHashSuffix);
        } else {
            result.append(NameUtil.relativeName(this.ivRemoteHomeInterface));
            if (this.ivHashVersion > 0) {
                result.append('_');
                result.append(this.ivHashSuffix);
            }
        }
        return result.toString();
    }

    public String getHomeLocalImplClassName() {
        if (this.ivLocalHomeInterface == null) {
            return null;
        }
        if (this.ivVersion == 1) {
            throw new IllegalStateException("Local interfaces are not supported in EJB 1.x modules");
        }
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(this.ivLocalInterface);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append("EJSLocal");
        if (this.ivVersion >= 3) {
            result.append("C");
        }
        result.append(this.ivBeanType);
        result.append(this.ivBeanName);
        result.append("Home");
        result.append('_');
        result.append(this.ivHashSuffix);
        return result.toString();
    }

    public String getHomeBeanClassName() {
        String homeInterface;
        String string = homeInterface = this.ivRemoteHomeInterface == null ? this.ivLocalHomeInterface : this.ivRemoteHomeInterface;
        if (homeInterface == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(homeInterface);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append(homeBeanPrefix);
        if (this.ivVersion >= 3) {
            result.append("C");
        }
        result.append(this.ivBeanType);
        if (this.ivVersion >= 2) {
            result.append(this.ivBeanName);
            result.append("HomeBean");
            result.append('_');
            result.append(this.ivHashSuffix);
        } else {
            result.append(NameUtil.relativeName(this.ivRemoteHomeInterface));
            result.append("Bean");
            if (this.ivHashVersion > 0) {
                result.append('_');
                result.append(this.ivHashSuffix);
            }
        }
        return result.toString();
    }

    public String getConcreteBeanClassName() {
        if (this.ivVersion != 2 && this.ivBeanType != CONTAINER_MANAGED) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(this.ivBeanClass);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append(concreteBeanPrefix);
        result.append(this.ivBeanName);
        result.append('_');
        result.append(this.ivHashSuffix);
        return result.toString();
    }

    public String getDeployedPersisterClassName() {
        StringBuffer result = new StringBuffer();
        String packageName = NameUtil.packageName(this.ivBeanClass);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append(persisterPrefix);
        result.append(this.ivBeanType);
        result.append(NameUtil.relativeName(this.ivBeanClass));
        return result.toString();
    }

    public String getWebServiceEndpointProxyClassName() {
        StringBuilder result = new StringBuilder();
        String packageName = NameUtil.packageName(this.ivBeanClass);
        if (packageName != null) {
            result.append(packageName);
            result.append('.');
        }
        result.append(endpointPrefix);
        result.append(this.ivBeanType);
        result.append(this.ivBeanName);
        result.append('_');
        result.append(this.ivHashSuffix);
        return result.toString();
    }

    private final String getHashSuffix(boolean modified) {
        int i;
        StringBuffer hashStr = new StringBuffer(this.ivFullBeanName);
        if (this.ivRemoteHomeInterface != null) {
            hashStr.append(this.ivRemoteHomeInterface);
        }
        if (this.ivRemoteInterface != null) {
            hashStr.append(this.ivRemoteInterface);
        }
        if (this.ivLocalHomeInterface != null) {
            hashStr.append(this.ivLocalHomeInterface);
        }
        if (this.ivLocalInterface != null) {
            hashStr.append(this.ivLocalInterface);
        }
        if (this.ivBusinessRemote != null) {
            for (i = 0; i < this.ivBusinessRemote.length; ++i) {
                hashStr.append(this.ivBusinessRemote[i]);
            }
        }
        if (this.ivBusinessLocal != null) {
            for (i = 0; i < this.ivBusinessLocal.length; ++i) {
                hashStr.append(this.ivBusinessLocal[i]);
            }
        }
        hashStr.append(this.ivBeanClass);
        if (this.ivPrimaryKey != null) {
            hashStr.append(this.ivPrimaryKey);
        }
        this.ivHashVersion = modified ? 2 : 1;
        return BuzzHash.computeHashStringMid32Bit(hashStr.toString(), modified);
    }

    public final String updateFilenameHashCode(String fileName) {
        int last_;
        String nextName = null;
        int len = fileName.length();
        int n = last_ = len > 9 && fileName.charAt(len - 9) == '_' ? len - 9 : -1;
        if (last_ != -1 && NameUtil.allHexDigits(fileName, ++last_, len)) {
            if (this.ivHashVersion == 1) {
                this.ivHashSuffix = this.getHashSuffix(true);
                nextName = fileName.substring(0, last_) + this.ivHashSuffix;
            } else if (this.ivHashVersion == 2 && this.ivVersion == 1) {
                this.ivHashVersion = 0;
                nextName = fileName.substring(0, last_ - 1);
            }
        }
        return nextName;
    }
}

