/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.logger;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayOutputStream;

public class TraceOutputStream
extends ByteArrayOutputStream {
    private final TraceComponent destination;
    private StringBuffer textBuf = new StringBuffer();
    private static final TraceComponent tc = Tr.register(TraceOutputStream.class);

    public TraceOutputStream(String componentName) {
        this.destination = Tr.register(componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        if (this.destination.isDebugEnabled()) {
            TraceOutputStream traceOutputStream = this;
            synchronized (traceOutputStream) {
                super.write(b);
                if (this.count > 32) {
                    this.formatTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) {
        if (this.destination.isDebugEnabled()) {
            TraceOutputStream traceOutputStream = this;
            synchronized (traceOutputStream) {
                super.write(b, off, len);
                this.formatTrace();
            }
        }
    }

    public boolean isTraceEnabled() {
        return this.destination.isDebugEnabled();
    }

    private synchronized void formatTrace() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatTrace");
        }
        this.textBuf.append(this.toString());
        this.reset();
        int start = 0;
        for (int end = 0; end < this.textBuf.length(); ++end) {
            if (this.textBuf.charAt(end) != '\n') continue;
            String msg = this.textBuf.substring(start, end);
            start = end + 1;
            if (!this.destination.isDebugEnabled()) continue;
            Tr.debug(this.destination, msg);
        }
        if (start > 0 && start < this.textBuf.length()) {
            this.textBuf = new StringBuffer(this.textBuf.substring(start));
        } else if (start >= this.textBuf.length()) {
            this.textBuf = new StringBuffer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatTrace");
        }
    }
}

