/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordCipherException;
import com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.wsspi.security.crypto.CustomPasswordEncryption;
import com.ibm.wsspi.security.crypto.EncryptedInfo;
import com.ibm.wsspi.security.crypto.PasswordDecryptException;
import com.ibm.wsspi.security.crypto.PasswordEncryptException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class PasswordCipherUtil {
    private static final byte XOR_MASK = 95;
    private static final TraceComponent tc = Tr.register(PasswordCipherUtil.class, "SASRas", "com.ibm.ejs.resources.security");
    private static String[] _supported_crypto_algorithms = null;
    private static final String DEFAULT_CRYPTO_ALGORITHM_PROPERTY = "os400.security.password.encoding.algorithm";
    private static final String VALIDATION_LIST_PROPERTY = "os400.security.password.validation.list.object";
    private static final String[] DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS = new String[]{"xor", "os400", "custom"};
    private static final String DEFAULT_CUSTOM_CRYPTO_CLASS = "com.ibm.wsspi.security.crypto.CustomPasswordEncryptionImpl";
    private static final String CUSTOM_CRYPTO_CLASS_PROPERTY = "com.ibm.wsspi.security.crypto.customPasswordEncryptionClass";
    private static final String CUSTOM_CRYPTO_ENABLE_PROPERTY = "com.ibm.wsspi.security.crypto.customPasswordEncryptionEnabled";
    private static final int XOR_INDEX = 0;
    private static final int OS400_INDEX = 1;
    private static final int CUSTOM_INDEX = 2;
    private static final int ADVANCED_EDITION = 0;
    private static final int ADVANCED_EDITION_SINGLE_SERVER = 1;
    private static String[] _validation_list_objects = null;
    private static CustomPasswordEncryption customPasswordEncryptionClass = null;
    private static boolean _standalone = false;
    private static int _edition = 0;
    private static boolean _debug = false;
    private static String custom_crypto_class = null;
    private static boolean custom_crypto_enabled = false;
    private static final Class thisClass = PasswordCipherUtil.class;
    static String osName;

    /*
     * Unable to fully structure code
     */
    public static byte[] decipher(byte[] encrypted_bytes, String crypto_algorithm) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        if (crypto_algorithm == null) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        decrypted_bytes = null;
        if (crypto_algorithm.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            decrypted_bytes = PasswordCipherUtil.xor(encrypted_bytes);
        } else if (crypto_algorithm.startsWith(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2])) {
            try {
                if (PasswordCipherUtil.customPasswordEncryptionClass == null) ** GOTO lbl37
                index = crypto_algorithm.indexOf(":");
                keyAlias = null;
                if (index != -1) {
                    keyAlias = crypto_algorithm.substring(index + 1);
                }
                decrypted_bytes = PasswordCipherUtil.customPasswordEncryptionClass.decrypt(new EncryptedInfo(encrypted_bytes, keyAlias));
                if (!PasswordCipherUtil.tc.isDebugEnabled()) ** GOTO lbl37
                Tr.debug(PasswordCipherUtil.tc, "Successfully decrypted password using custom encryption plug point.");
            }
            catch (PasswordDecryptException e) {
                Manager.Ffdc.log(e, PasswordCipherUtil.thisClass, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.decipher", "282");
                Tr.error(PasswordCipherUtil.tc, "PasswordDecryptException during custom decryption: " + e.getMessage());
                throw new InvalidPasswordCipherException();
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, PasswordCipherUtil.thisClass, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.decipher", "288");
                Tr.error(PasswordCipherUtil.tc, "Exception during custom decryption: " + e.getMessage());
                throw new InvalidPasswordCipherException();
            }
        } else if (PasswordCipherUtil.osName.compareTo("OS/400") == 0 && crypto_algorithm.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[1])) {
            try {
                s = new String(encrypted_bytes, "UTF8");
                result = PasswordCipherUtil.ntv_os400Decipher(s, PasswordCipherUtil._validation_list_objects, PasswordCipherUtil._edition, PasswordCipherUtil._standalone, PasswordCipherUtil._debug);
                if (result == null) {
                    throw new InvalidPasswordCipherException();
                }
                decrypted_bytes = result.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidPasswordCipherException();
            }
        } else {
            throw new UnsupportedCryptoAlgorithmException();
        }
lbl37:
        // 5 sources

        if (decrypted_bytes == null) {
            throw new InvalidPasswordCipherException();
        }
        return decrypted_bytes;
    }

    public static byte[] encipher(byte[] decrypted_bytes, String crypto_algorithm) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        try {
            EncryptedInfo info = PasswordCipherUtil.encipher_internal(decrypted_bytes, crypto_algorithm);
            return info.getEncryptedBytes();
        }
        catch (PasswordEncryptException e) {
            throw new InvalidPasswordCipherException();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static EncryptedInfo encipher_internal(byte[] decrypted_bytes, String crypto_algorithm) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException, PasswordEncryptException {
        if (crypto_algorithm == null) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        info = null;
        encrypted_bytes = null;
        if (crypto_algorithm.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            encrypted_bytes = PasswordCipherUtil.xor(decrypted_bytes);
            if (encrypted_bytes != null) {
                info = new EncryptedInfo(encrypted_bytes, "");
            }
        } else if (crypto_algorithm.startsWith(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2])) {
            try {
                if (PasswordCipherUtil.customPasswordEncryptionClass != null) {
                    info = PasswordCipherUtil.customPasswordEncryptionClass.encrypt(decrypted_bytes);
                    if (!PasswordCipherUtil.tc.isDebugEnabled()) ** GOTO lbl41
                    Tr.debug(PasswordCipherUtil.tc, "Successfully encrypted password using custom encryption plug point.");
                }
                encrypted_bytes = PasswordCipherUtil.xor(decrypted_bytes);
                if (encrypted_bytes == null) ** GOTO lbl41
                info = new EncryptedInfo(encrypted_bytes, "");
            }
            catch (PasswordEncryptException e) {
                Manager.Ffdc.log(e, PasswordCipherUtil.thisClass, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.encipher", "387");
                Tr.error(PasswordCipherUtil.tc, "PasswordEncryptException during custom encryption: " + e.getMessage());
                return new EncryptedInfo(PasswordCipherUtil.xor(decrypted_bytes), "");
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, PasswordCipherUtil.thisClass, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.encipher", "393");
                Tr.error(PasswordCipherUtil.tc, "Received a password encrypted with a custom algorithm that is not currently configured.");
                return new EncryptedInfo(PasswordCipherUtil.xor(decrypted_bytes), "");
            }
        } else if (PasswordCipherUtil.osName.compareTo("OS/400") == 0 && crypto_algorithm.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[1])) {
            try {
                result = PasswordCipherUtil.ntv_os400Encipher(new String(decrypted_bytes, "UTF8"), PasswordCipherUtil._validation_list_objects, PasswordCipherUtil._edition, PasswordCipherUtil._standalone, PasswordCipherUtil._debug);
                if (result == null) {
                    throw new InvalidPasswordCipherException();
                }
                encrypted_bytes = result.getBytes("UTF8");
                if (encrypted_bytes == null) ** GOTO lbl41
                info = new EncryptedInfo(encrypted_bytes, "");
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidPasswordCipherException();
            }
        } else {
            throw new UnsupportedCryptoAlgorithmException();
        }
lbl41:
        // 7 sources

        if (info == null) {
            throw new InvalidPasswordCipherException();
        }
        return info;
    }

    public static String[] getSupportedCryptoAlgorithms() {
        return _supported_crypto_algorithms;
    }

    public static String getFailSafeCryptoAlgorithm() {
        return DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
    }

    public static void updateValidationList() {
        Tr.entry(tc, "updateValidationList");
        if (osName.compareTo("OS/400") == 0) {
            String validation_list_names = System.getProperty(VALIDATION_LIST_PROPERTY, null);
            try {
                int n;
                int number_of_names = 0;
                if (validation_list_names != null && validation_list_names.length() != 0) {
                    if ((validation_list_names = validation_list_names.toUpperCase()).indexOf(58) == -1) {
                        ++number_of_names;
                    } else {
                        int m = 0;
                        while (m < validation_list_names.length() && (n = validation_list_names.indexOf(58, m)) > -1) {
                            ++number_of_names;
                            m = n + 1;
                        }
                        ++number_of_names;
                    }
                }
                _validation_list_objects = new String[number_of_names];
                StringTokenizer st = new StringTokenizer(validation_list_names, ":");
                n = 0;
                while (st.hasMoreTokens()) {
                    PasswordCipherUtil._validation_list_objects[n] = st.nextToken();
                    ++n;
                }
            }
            catch (Exception e) {
                _validation_list_objects = null;
            }
        }
        Tr.exit(tc, "updateValidationList");
    }

    private static byte[] xor(byte[] bytes) {
        byte[] xor_bytes = null;
        if (bytes != null) {
            xor_bytes = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                xor_bytes[i] = (byte)(0x5F ^ bytes[i]);
            }
        }
        return xor_bytes;
    }

    private static void initializeCustomPasswordEncryption() {
        block20: {
            if (customPasswordEncryptionClass == null) {
                try {
                    String custom_crypto_enabled_string = System.getProperty(CUSTOM_CRYPTO_ENABLE_PROPERTY);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.wsspi.security.crypto.customPasswordEncryptionEnabled = " + custom_crypto_enabled_string);
                    }
                    if (custom_crypto_enabled_string == null || custom_crypto_enabled_string != null && (custom_crypto_enabled_string.equalsIgnoreCase("no") || custom_crypto_enabled_string.equalsIgnoreCase("false"))) {
                        custom_crypto_enabled = false;
                    } else if (custom_crypto_enabled_string != null && (custom_crypto_enabled_string.equalsIgnoreCase("yes") || custom_crypto_enabled_string.equalsIgnoreCase("true"))) {
                        custom_crypto_enabled = true;
                    }
                    custom_crypto_class = System.getProperty(CUSTOM_CRYPTO_CLASS_PROPERTY);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.wsspi.security.crypto.customPasswordEncryptionClass = " + custom_crypto_class);
                    }
                    if (custom_crypto_class == null) {
                        custom_crypto_class = DEFAULT_CUSTOM_CRYPTO_CLASS;
                    }
                    if (custom_crypto_class == null) break block20;
                    try {
                        Class<?> c = null;
                        try {
                            ClassLoader ccl = ExtClassLoader.getInstance();
                            if (ccl == null) {
                                ccl = PasswordCipherUtil.class.getClassLoader();
                            }
                            c = Class.forName(custom_crypto_class, true, ccl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (c == null) {
                            c = Class.forName(custom_crypto_class);
                        }
                        if ((customPasswordEncryptionClass = (CustomPasswordEncryption)c.newInstance()) != null && custom_crypto_enabled_string == null && custom_crypto_class.equals(DEFAULT_CUSTOM_CRYPTO_CLASS)) {
                            custom_crypto_enabled = true;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully loaded the custom encryption class: " + custom_crypto_class);
                        }
                    }
                    catch (Exception e) {
                        if (!DEFAULT_CUSTOM_CRYPTO_CLASS.equals(custom_crypto_class)) {
                            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.initializeCustomPasswordEncryption", "611");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load the custom encryption class: " + custom_crypto_class);
                        }
                        custom_crypto_enabled = false;
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil", "620");
                    Tr.error(tc, "Could not load class: " + custom_crypto_class);
                    custom_crypto_enabled = false;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom encryption enabled = " + custom_crypto_enabled);
        }
    }

    private static native String ntv_os400Encipher(String var0, String[] var1, int var2, boolean var3, boolean var4);

    private static native String ntv_os400Decipher(String var0, String[] var1, int var2, boolean var3, boolean var4);

    private static native void ntv_os400ReportBadDefaultCryptoAlgorithm(int var0, boolean var1, boolean var2);

    static {
        PasswordCipherUtil.initializeCustomPasswordEncryption();
        osName = System.getProperty("os.name");
        if (osName.compareTo("OS/400") == 0) {
            String library = System.getProperty("was.install.library");
            try {
                String debugProperty;
                Tr.debug(tc, "Loading native library: /QSYS.LIB/" + library + ".LIB/QWASPMGT.SRVPGM");
                System.load("/QSYS.LIB/" + library + ".LIB/QWASPMGT.SRVPGM");
                String standaloneProperty = System.getProperty("was.standalone", "false");
                if (standaloneProperty.equalsIgnoreCase("true")) {
                    _standalone = true;
                }
                if ((debugProperty = System.getProperty("os400.security.password.debug", "false")).equalsIgnoreCase("true")) {
                    _debug = true;
                }
                String default_crypto_algorithm = System.getProperty(DEFAULT_CRYPTO_ALGORITHM_PROPERTY, DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0]);
                if (custom_crypto_enabled && customPasswordEncryptionClass != null) {
                    default_crypto_algorithm = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2];
                }
                int number_of_crypto_algorithms = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS.length;
                boolean matched = false;
                default_crypto_algorithm = default_crypto_algorithm.trim();
                for (int i = 0; i < number_of_crypto_algorithms; ++i) {
                    if (!default_crypto_algorithm.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[i])) continue;
                    matched = true;
                    _supported_crypto_algorithms = new String[number_of_crypto_algorithms];
                    PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[i];
                    int j = 1;
                    for (int k = 0; k < number_of_crypto_algorithms; ++k) {
                        if (k == i) continue;
                        PasswordCipherUtil._supported_crypto_algorithms[j++] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[k];
                    }
                    break;
                }
                if (!matched) {
                    PasswordCipherUtil.ntv_os400ReportBadDefaultCryptoAlgorithm(_edition, _standalone, _debug);
                }
            }
            catch (Throwable e) {
                _supported_crypto_algorithms = null;
            }
            if (_supported_crypto_algorithms == null) {
                _supported_crypto_algorithms = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS;
            }
        } else if (_supported_crypto_algorithms == null) {
            if (custom_crypto_enabled && customPasswordEncryptionClass != null) {
                _supported_crypto_algorithms = new String[2];
                PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2];
                PasswordCipherUtil._supported_crypto_algorithms[1] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
            } else if (customPasswordEncryptionClass != null) {
                _supported_crypto_algorithms = new String[2];
                PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
                PasswordCipherUtil._supported_crypto_algorithms[1] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2];
            } else {
                _supported_crypto_algorithms = new String[1];
                PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
            }
        }
        if (osName.compareTo("OS/400") == 0) {
            String validation_list_names = System.getProperty(VALIDATION_LIST_PROPERTY, null);
            try {
                int number_of_names = 0;
                if (validation_list_names != null && validation_list_names.length() != 0) {
                    if ((validation_list_names = validation_list_names.toUpperCase()).indexOf(58) == -1) {
                        ++number_of_names;
                    } else {
                        int n;
                        int m = 0;
                        while (m < validation_list_names.length() && (n = validation_list_names.indexOf(58, m)) > -1) {
                            ++number_of_names;
                            m = n + 1;
                        }
                        ++number_of_names;
                    }
                }
                _validation_list_objects = new String[number_of_names];
                StringTokenizer st = new StringTokenizer(validation_list_names, ":");
                int n = 0;
                while (st.hasMoreTokens()) {
                    PasswordCipherUtil._validation_list_objects[n] = st.nextToken();
                    ++n;
                }
            }
            catch (Exception e) {
                _validation_list_objects = null;
            }
        }
    }
}

