/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurityPriv.Current;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ServerConnectionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.Subject;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.SecurityLevel2.Credentials;

public class VaultImpl {
    private static Vector _vaultRegistry = new Vector();
    protected static int _authenticationTarget = 0;
    protected static String _authenticationTargetString = "unknown";
    private static final TraceComponent tc = Tr.register(VaultImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private Hashtable effectivePolicyTable = new Hashtable();
    private CurrentImpl _current = null;
    private MechanismFactory _mechanismFactory = null;
    private ORB _orb = null;
    protected static VaultImpl _vault = null;
    private SecurityConnectionInterceptor securityConnectionInterceptor = null;
    private SessionManager sessionManager = null;
    private Hashtable gssFactoryTable = new Hashtable();
    private static AuthenticationTarget authTarget = null;
    private Codec codec = null;
    private SecurityServer securityServer = null;
    private Subject _defaultSubject = null;
    private static int MAX_AUTH_REALM_CACHE_ENTRIES = 100;
    protected Hashtable basicAuthTable = new Hashtable();
    protected Hashtable basicAuthSubjectTable = new Hashtable();
    protected Hashtable basicAuthRealmHostSubjectTable = new Hashtable();
    protected Hashtable basicAuthRealmSubjectTable = new Hashtable();

    public static VaultImpl getInstance() {
        ORB orb;
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && _vault == null && (orb = GlobalORBFactory.globalORB()) != null) {
            _vault = new ZOSVaultImpl(orb);
        }
        if (_vault == null) {
            _vault = new VaultImpl();
        }
        return _vault;
    }

    protected VaultImpl(MechanismFactory in_MechanismFactory, ORB in_orb) {
        try {
            this._mechanismFactory = in_MechanismFactory;
            if (in_orb != null) {
                this._orb = in_orb;
            }
            _vaultRegistry.addElement(this);
            _vault = this;
            this.sessionManager = new SessionManager();
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            _authenticationTarget = csiv2.getInteger("com.ibm.CORBA.authenticationTarget");
            _authenticationTargetString = (String)AuthenticationTarget.strings.get(new Integer(_authenticationTarget));
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl.constructor", "353", this);
            Tr.error(tc, "security.JSAS0010E", new Object[]{e.getMessage()});
            throw new INITIALIZE();
        }
    }

    protected VaultImpl() {
    }

    public Credentials getBasicAuthCred(String securityName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get BasicAuth Cred from cache, security name is " + securityName);
        }
        return (Credentials)this.basicAuthTable.get(securityName);
    }

    public void addBasicAuthCred(String securityName, Credentials basicAuthCred) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cacheing BasicAuth Cred to the table, security name is " + securityName);
        }
        this.basicAuthTable.put(securityName, basicAuthCred);
    }

    public Subject getBasicAuthSubject(String securityName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get BasicAuth WSCredential from cache, security name is " + securityName);
        }
        return (Subject)this.basicAuthSubjectTable.get(securityName);
    }

    public void addBasicAuthSubject(String securityName, Subject basicAuthSubject) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "caching BasicAuth WSCredential to the table, security name is " + securityName);
        }
        this.basicAuthSubjectTable.put(securityName, basicAuthSubject);
    }

    public Subject getRealmHostSubject(String realmHostLookup) {
        Subject subject = (Subject)this.basicAuthRealmHostSubjectTable.get(realmHostLookup);
        if (SubjectHelper.subjectContainsCredential(subject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "get BasicAuth WSCredential from cache, realm/host lookup key is " + realmHostLookup);
            }
            return subject;
        }
        return null;
    }

    public void addRealmHostSubject(String realmHostLookup, Subject basicAuthSubject) {
        if (this.basicAuthRealmHostSubjectTable.get(realmHostLookup) != null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Caching BasicAuth WSCredential to the table, realm/host lookup is " + realmHostLookup);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Realm/host BasicAuth cache size: " + this.basicAuthRealmHostSubjectTable.size());
        }
        this.basicAuthRealmHostSubjectTable.put(realmHostLookup, basicAuthSubject);
    }

    public Subject getRealmSubject(String realm) {
        Subject subject = (Subject)this.basicAuthRealmSubjectTable.get(realm);
        if (SubjectHelper.subjectContainsCredential(subject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "get BasicAuth WSCredential from cache, realm lookup key is " + realm);
            }
            return subject;
        }
        return null;
    }

    public void addRealmSubject(String realm, Subject basicAuthSubject) {
        if (this.basicAuthRealmSubjectTable.get(realm) != null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Caching BasicAuth WSCredential to the table, realm lookup is " + realm + " cache size = " + this.basicAuthRealmSubjectTable.size());
        }
        if (this.basicAuthRealmSubjectTable.size() > MAX_AUTH_REALM_CACHE_ENTRIES) {
            this.basicAuthRealmSubjectTable.clear();
        }
        this.basicAuthRealmSubjectTable.put(realm, basicAuthSubject);
    }

    public Current current() {
        return (Current)((Object)this.getCurrent());
    }

    public synchronized void deleteSessionsForConnection(String connectionKey) {
        if (connectionKey == null) {
            return;
        }
        if (this.sessionManager == null) {
            this.sessionManager = new SessionManager();
        }
        this.sessionManager.csi_delete_client_connection(connectionKey);
    }

    public void deleteSessionsForConnection(ServerConnectionKey connectionKey) {
        if (connectionKey == null) {
            return;
        }
        if (this.sessionManager == null) {
            this.sessionManager = new SessionManager();
        }
        this.sessionManager.csi_delete_server_connection(connectionKey.get_server_connection_hash());
    }

    public void set_default_subject(Subject subject) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") || !csiv2.getBoolean("com.ibm.CORBA.useDefaultSubjectForThreads")) {
            return;
        }
        if (subject == null) {
            return;
        }
        if (this._defaultSubject == null) {
            this._defaultSubject = subject;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting the default subject: " + this._defaultSubject);
            }
        }
    }

    public Subject get_default_subject() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") || !csiv2.getBoolean("com.ibm.CORBA.useDefaultSubjectForThreads")) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting the default subject: " + this._defaultSubject);
        }
        return this._defaultSubject;
    }

    public MechanismFactory getMechanismFactory() {
        if (this._mechanismFactory == null) {
            this._mechanismFactory = new MechanismFactory();
        }
        return this._mechanismFactory;
    }

    public SessionManager getSessionManager() {
        if (this.sessionManager == null) {
            this.sessionManager = new SessionManager();
        }
        return this.sessionManager;
    }

    public void setMechanismFactory(MechanismFactory mechanismFactory) {
        if (mechanismFactory != null) {
            this._mechanismFactory = mechanismFactory;
        }
    }

    public ORB getORB() {
        return this._orb;
    }

    public void setORB(ORB orb) {
        if (orb != null) {
            this._orb = orb;
        }
    }

    public SecurityServer getSecurityServer() throws Exception {
        if (this.securityServer == null) {
            try {
                Class<?> wrapperclass = Class.forName("com.ibm.WebSphereSecurityImpl.SecurityServerImpl");
                Object wrapperObj = wrapperclass.newInstance();
                this.securityServer = (SecurityServer)wrapperObj;
                if (this.securityServer != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security Server is initialized.");
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl.getSecurityServer", "674", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security Server cannot be initialized.", new Object[]{e});
                }
                throw e;
            }
        }
        return this.securityServer;
    }

    public GSSFactory getGSSFactory(String OID2) {
        GSSFactory existingGSSFactory = null;
        existingGSSFactory = (GSSFactory)this.gssFactoryTable.get(OID2);
        if (existingGSSFactory == null) {
            existingGSSFactory = new GSSFactory(OID2);
            this.gssFactoryTable.put(OID2, existingGSSFactory);
        }
        return existingGSSFactory;
    }

    public Codec getCodec() {
        if (this.codec == null) {
            CodecFactory factory = null;
            try {
                factory = (CodecFactory)this._orb.resolve_initial_references("CodecFactory");
            }
            catch (InvalidName in) {
                Manager.Ffdc.log(in, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl.getCodec", "720", this);
                Tr.debug(tc, in.getMessage(), new Object[]{in});
            }
            Encoding enc = new Encoding(0, 1, 2);
            try {
                this.codec = factory.create_codec(enc);
            }
            catch (UnknownEncoding ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl.getCodec", "732", this);
                Tr.debug(tc, ex.getMessage(), new Object[]{ex});
            }
        }
        return this.codec;
    }

    public CurrentImpl getCurrent() {
        if (this._current == null) {
            this._current = new CurrentImpl();
        }
        return this._current;
    }

    public static synchronized AuthenticationTarget getAuthenticationTarget() {
        if (authTarget == null) {
            authTarget = new AuthenticationTarget();
        }
        return authTarget;
    }

    public SecurityConnectionInterceptor getSecurityConnectionInterceptor() {
        return this.securityConnectionInterceptor;
    }

    public void setSecurityConnectionInterceptor(SecurityConnectionInterceptor sci) {
        if (sci != null) {
            this.securityConnectionInterceptor = sci;
        }
    }

    protected boolean put_effective_policy(int request_id, CSIv2EffectivePerformPolicy csiv2EffectivePolicy) {
        if (csiv2EffectivePolicy == null) {
            return false;
        }
        this.effectivePolicyTable.put(Integer.toString(request_id), csiv2EffectivePolicy);
        return true;
    }

    public CSIv2EffectivePerformPolicy get_effective_policy(int request_id) {
        return (CSIv2EffectivePerformPolicy)this.effectivePolicyTable.get(Integer.toString(request_id));
    }

    protected boolean clear_effective_policy(int request_id) {
        this.effectivePolicyTable.remove(Integer.toString(request_id));
        return true;
    }

    protected static final class ZOSVaultImpl
    extends VaultImpl {
        private static final long serialVersionUID = -5857883218773800603L;

        protected ZOSVaultImpl(ORB orb) {
            this.setMechanismFactory(new MechanismFactory());
            this.setORB(orb);
            _vault = this;
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            _authenticationTarget = csiv2.getInteger("com.ibm.CORBA.authenticationTarget");
            _authenticationTargetString = (String)AuthenticationTarget.strings.get(new Integer(_authenticationTarget));
        }
    }
}

