/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ExtendedIORInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIORBInit;
import com.ibm.ISecurityLocalObjectBaseL13Impl.PrincipalAuthFailReason;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SecurityExecutionEnvironment;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ServerConnectionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager;
import com.ibm.ISecurityUtilityImpl.AuditData;
import com.ibm.ISecurityUtilityImpl.BasicAuthWithRealm;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.Translate;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.rmi.ServiceContext;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSSubjectWrapperImpl;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.AppContextManager;
import com.ibm.ws.security.core.AppContextManagerFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSKRBAuthnTokenFactoryFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.outofband.OutOfBandData;
import com.ibm.ws390.outofband.OutOfBandDataHolder;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.rmi.CORBA.Tie;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.x500.X500Principal;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.X501DistinguishedNameHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.RequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AssociationStatus;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.InvalidCredential;

public class CSIServerRIBase
extends CSIORBInit
implements ServerRequestInterceptor {
    private static final TraceComponent tc = Tr.register(CSIServerRIBase.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private String princ = null;
    public static ObjectName interceptorObjName = null;
    private static Class rmiConnectorClz = null;
    private static Method getAttributeMethod = null;
    private static Class adminContextClz = null;
    private static Method pushMethod = null;
    private static Method popMethod = null;
    private static final Class thisClass = CSIServerRIBase.class;
    protected static final String providerName = "WebSphere";
    protected static final String componentName = "WAS.security.sas";
    protected static AuditService auditService;
    protected Date startTime = null;
    protected Date endTime = null;
    protected static String className;
    protected String activeUserRegistry = null;
    protected ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    protected ORB orb = null;
    protected Codec codec = null;
    protected VaultImpl myVault = null;
    protected SecurityConnectionInterceptor _securityConnectionInterceptor = null;
    protected MechanismFactory _mechanismFactory = null;
    protected int csiClientCertPort = 0;
    protected IntHolder expiry_time_now = new IntHolder(0);
    public int slotid;
    protected CSIUtil csiUtil = new CSIUtil();
    protected SessionManager sessionMgr = null;
    protected CSICredentialsManager credsMgr = new CSICredentialsManager();
    protected AppContextManager appContextMgr = null;
    protected Hashtable sessionRequestTable = new Hashtable();
    protected static String cert_chain_private_token_name;
    protected static String attribute_layer_private_token_name;
    protected static String client_auth_layer_private_token_name;
    protected static String session_info_private_token_name;

    public void init(ORB orb) {
        CSIv2Config csiv2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{orb, this});
        }
        if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CORBA.securityEnabled")) {
            className = ((Object)((Object)this)).getClass().getName();
            this.appContextMgr = AppContextManagerFactory.getInstance();
            if (this.myVault == null) {
                this.myVault = VaultImpl.getInstance();
            }
            if (this.myVault != null) {
                this.orb = this.myVault.getORB();
                this.activeUserRegistry = csiv2.getString("com.ibm.CSI.activeUserRegistry");
                this._mechanismFactory = this.myVault.getMechanismFactory();
                this._securityConnectionInterceptor = this.myVault.getSecurityConnectionInterceptor();
                this.sessionMgr = this.myVault.getSessionManager();
            } else {
                Tr.error(tc, "security.JSAS0010E");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "myVault: " + this.myVault);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        CSIv2Config csiv2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "post_init", new Object[]{info, this});
        }
        if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CORBA.securityEnabled")) {
            this.appContextMgr = AppContextManagerFactory.getInstance();
            if (this.myVault == null) {
                this.myVault = VaultImpl.getInstance();
            }
            if (this.myVault != null) {
                this.orb = this.myVault.getORB();
                this._mechanismFactory = this.myVault.getMechanismFactory();
                this._securityConnectionInterceptor = this.myVault.getSecurityConnectionInterceptor();
                this.sessionMgr = this.myVault.getSessionManager();
            } else {
                Tr.error(tc, "security.JSAS0010E");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "post_init");
        }
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo info) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo info) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo info) {
    }

    public void send_exception(ServerRequestInfo info) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo info) throws ForwardRequest {
    }

    protected boolean qualifyServerRequest(ServerRequestInfo info) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "qualifyServerRequest", new Object[]{info, this});
        }
        String class_name = "<unknown>";
        if (((ExtendedServerRequestInfo)info).getTarget() != null) {
            class_name = ((ExtendedServerRequestInfo)info).getTarget().getClass().getName();
        }
        if (this.is_local_server_request(info)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local request, exempt from authentication.");
            }
            this.receive_request_local(info);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "qualifyServerRequest", Boolean.TRUE);
            }
            return true;
        }
        String method = info.operation();
        if (SecurityConnectionInterceptor.isUserRegistryMethodProtected(method, class_name)) {
            String msg = "UserRegistry method " + method + " is protected for all remote clients.  To unprotect this method, include its name in custom property com.ibm.ws.security.unprotectedUserRegistryMethods.";
            throw new NO_PERMISSION(msg, 1229066392, CompletionStatus.COMPLETED_NO);
        }
        if (SecurityConnectionInterceptor.isSpecialNamingMethod(method, class_name) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(method, class_name) || ORB.isSpecialMethod((String)method) && !this.csiUtil.isCORBAAuthRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Special request, exempt from authentication.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "qualifyServerRequest", Boolean.TRUE);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "qualifyServerRequest", Boolean.FALSE);
        }
        return false;
    }

    protected AuditData initializeAuditService(String operation, String remoteHost, int remotePort, String transportPrincipal) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeAuditService", new Object[]{operation, remoteHost, new Integer(remotePort), transportPrincipal, this});
            }
            if (auditService == null) {
                try {
                    auditService = ContextManagerFactory.getInstance().getAuditService();
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.initializeAuditService", "432", new Object[]{this});
                    Tr.error(tc, "security.JSAS1500E", new Object[]{e});
                    if (auditService == null) break block6;
                    auditService.processAuditFailure("security.audit.eventfactory.init.error", e);
                }
            }
        }
        AuditData ad = new AuditData();
        ad.setOperation(operation);
        if (remoteHost != null) {
            ad.setRemoteHost(remoteHost);
        }
        ad.setRemotePort(remotePort);
        if (transportPrincipal != null) {
            ad.setTransportPrincipal(transportPrincipal);
        }
        return ad;
    }

    protected AuditData initializeAuditService(String operation) {
        return this.initializeAuditService(operation, null, 0, null);
    }

    protected SASContextBody getCSIv2MessageFromServiceContext(ServerRequestInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIv2MessageFromServiceContext", new Object[]{info, this});
        }
        SASContextBody msg = null;
        org.omg.IOP.ServiceContext sc = this.csiUtil.get_sc_from_request((RequestInfo)info);
        if (sc != null) {
            msg = this.csiUtil.get_message_from_sc(sc);
        }
        if (msg != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "CSIv2 message has been found in service context.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIv2MessageFromServiceContext", msg);
        }
        return msg;
    }

    protected SASContextBody getCSIv2MessageFromServiceContext(com.ibm.CORBA.iiop.ServiceContext sc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIv2MessageFromServiceContext", new Object[]{sc, this});
        }
        SASContextBody msg = null;
        if (sc != null) {
            org.omg.IOP.ServiceContext sc_iop = new org.omg.IOP.ServiceContext(sc.getId(), sc.getContextData());
            msg = this.csiUtil.get_message_from_sc(sc_iop);
        }
        if (msg != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "CSIv2 message has been found in service context.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIv2MessageFromServiceContext", msg);
        }
        return msg;
    }

    protected boolean verifySecurityInfoIsSufficientToContinue(X509Certificate[] cert_chain, SASContextBody msg, byte[] tldType, String remoteHost, int remotePort, String objectClass, String operation, AuditData auditData) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        ContextHandler contextHandler = null;
        if (tc.isDebugEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "verifySecurityInfoIsSufficientToContinue", new Object[]{cert_chain, msg, tldType, remoteHost, new Integer(remotePort), objectClass, operation, auditData, this});
            }
            if (tldType == null) {
                Tr.debug(tc, "transport layer data is null");
            } else {
                Tr.debug(tc, "transport layer data: ", new Object[]{tldType});
            }
        }
        if (msg == null && csiv2.getBoolean("com.ibm.CSI.claimClientAuthenticationRequired")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client authentication required at the server but no principal information is present in the " + objectClass + "." + operation + " method request from client " + remoteHost + ":" + remotePort + ".");
            }
            Tr.warning(tc, "security.JSAS0638E", new Object[]{"verifySecurityInfoIsSufficientToContinue", objectClass + "." + operation, remoteHost + ":" + remotePort});
            throw new NO_PERMISSION("security.JSAS0638E", 1229066390, CompletionStatus.COMPLETED_NO);
        }
        if (cert_chain == null && tldType == null && csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Transport layer client authentication required at the server but no principal information is present in the " + objectClass + "." + operation + " method request from client " + remoteHost + ":" + remotePort + ".");
            }
            Tr.warning(tc, "security.JSAS0638E", new Object[]{objectClass + "." + operation, remoteHost + ":" + remotePort});
            throw new NO_PERMISSION("Transport layer client authentication required at the server but no principal information is present in the " + objectClass + "." + operation + " method request from client " + remoteHost + ":" + remotePort + ".", 1229066390, CompletionStatus.COMPLETED_NO);
        }
        if (msg == null && cert_chain == null && tldType == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service context and certificates do not exist: returing from receive_request ");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifySecurityInfoIsSufficientToContinue", Boolean.FALSE);
            }
            if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msga = "security.audit.service.context.error";
                auditService.processAuditFailure(msga, null);
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData((String)auditService.getLastTrailId(), (String[])auditService.getEventTrailIds(), (Date)new Date(), (long)new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData((String)"challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)1L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                    String failmsg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(failmsg, pfe);
                }
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifySecurityInfoIsSufficientToContinue", Boolean.TRUE);
        }
        return true;
    }

    protected List handlePropagationToken(EstablishContext ec, SessionEntry sessionEntry, AuditData auditData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handlePropagationToken", new Object[]{ec, sessionEntry, auditData, this});
        }
        ArrayList tokenList = null;
        ContextHandler contextHandler = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled")) {
            AuthorizationElement[] authorization_token = null;
            byte[] opaque_token = null;
            if (sessionEntry != null) {
                opaque_token = sessionEntry.get_opaque_authz_token();
            }
            authorization_token = ec.authorization_token;
            if (opaque_token == null) {
                if (authorization_token != null && authorization_token.length > 0 && authorization_token[0].the_type == 1229066447) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization token present in EstablishContext message.");
                    }
                    opaque_token = authorization_token[0].the_element;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No authorization token in the EstablishContext message.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization token found in SessionEntry.");
            }
            String lastTrailId = null;
            String[] eventTrailIds = null;
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            if (opaque_token != null) {
                try {
                    tokenList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(opaque_token);
                }
                catch (WSSecurityException e) {
                    Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.handlePropagationToken", "738", new Object[]{this});
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                    if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msg = "security.audit.service.context.error";
                        auditService.processAuditFailure(msg, null);
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)10L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                            String failmsg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION(e.getMessage(), 1229066390, CompletionStatus.COMPLETED_NO);
                }
                if (tokenList != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Saving TokenHolder list in thread local.");
                    }
                    ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), tokenList);
                } else {
                    Tr.debug(tc, "Null TokenHolder list returned from authorization token.");
                    if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msg = "security.audit.service.context.error";
                        auditService.processAuditFailure(msg, null);
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)10L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                            String failmsg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION("Null TokenHolder list returned from authorization token.", 1229066390, CompletionStatus.COMPLETED_NO);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handlePropagationToken");
        }
        return tokenList;
    }

    /*
     * Unable to fully structure code
     */
    protected SecurityContextImpl getSecurityContext(EstablishContext ec, AuditData auditData, ConnectionData connData, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey) {
        if (CSIServerRIBase.tc.isEntryEnabled()) {
            Tr.entry(CSIServerRIBase.tc, "getSecurityContext", new Object[]{ec, auditData, connData, sessionEntry, new Long(stateful_context_id), connKey, this});
        }
        logMsg = "";
        csiv2 = SecurityObjectLocator.getCSIv2Config();
        contextHandler = null;
        lastTrailId = null;
        eventTrailIds = null;
        if (CSIServerRIBase.auditService != null) {
            lastTrailId = CSIServerRIBase.auditService.getLastTrailId();
            eventTrailIds = CSIServerRIBase.auditService.getEventTrailIds();
        }
        if (ec.client_authentication_token != null && ec.client_authentication_token.length > 0) {
            try {
                clientAuthOID = GSSFactory.getMechOIDFromGSSToken((byte[])ec.client_authentication_token);
                auditData.setMechType(GSSFactory.mapOidToMechType((String)clientAuthOID));
                if (auditData.getMechType() == null) {
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        logMsg = "Failed to map for mechanism type from receiving GSS token in receive_request.";
                        Tr.debug(CSIServerRIBase.tc, logMsg);
                    }
                    throw new NO_PERMISSION(logMsg, 1229066437, CompletionStatus.COMPLETED_NO);
                }
                auditData.setClientAuthOID(clientAuthOID);
                if (auditData.getMechType() != null && auditData.getMechType().equals(VaultConstants.GSSUP_MECH_TYPE) && sessionEntry != null && stateful_context_id != 0L) {
                    sessionEntry.set_basic_auth_type();
                }
                if (!CSIServerRIBase.tc.isDebugEnabled()) ** GOTO lbl65
                logMsg = "Mapped mechanism from receiving GSS token in receive_request: " + auditData.getMechType();
                Tr.debug(CSIServerRIBase.tc, logMsg);
            }
            catch (GSSEncodeDecodeException gEx) {
                Manager.Ffdc.log(gEx, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.getSecurityContext", "987", new Object[]{this});
                if (CSIServerRIBase.tc.isDebugEnabled()) {
                    logMsg = "Failed to get OID from receiving GSS token in receive_request.";
                    Tr.debug(CSIServerRIBase.tc, logMsg);
                }
                if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                    Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                    msg = "security.audit.service.context.error";
                    CSIServerRIBase.auditService.processAuditFailure(msg, null);
                }
                if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                    this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                    data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData((String)"challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)11L);
                    try {
                        CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException pfe) {
                        Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                        failmsg = "security.audit.service.sendevent.error";
                        CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                    }
                }
                throw new NO_PERMISSION(logMsg, 1229066437, CompletionStatus.COMPLETED_NO);
            }
        } else {
            auditData.setMechType(VaultConstants.GSSUP_MECH_TYPE);
        }
lbl65:
        // 3 sources

        connectionKey = null;
        if (connData != null) {
            connectionKey = connData.getConnectionKey();
        } else if (connKey != null) {
            connectionKey = connKey.get_server_connection_hash();
        }
        secCtx = this.csiUtil.get_security_context_impl(auditData.getMechType(), connectionKey);
        if (secCtx == null) {
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                sessionEntry.set_session_state(7);
            }
            if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                msg = "security.audit.service.context.error";
                CSIServerRIBase.auditService.processAuditFailure(msg, null);
            }
            if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData((String)"challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                try {
                    CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                    failmsg = "security.audit.service.sendevent.error";
                    CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                }
            }
            throw new INTERNAL("Security context holder is null in receive_request", 1229066420, CompletionStatus.COMPLETED_NO);
        }
        if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L && secCtx != null) {
            secCtx.set_stateful_context_id(stateful_context_id);
        }
        if (CSIServerRIBase.tc.isEntryEnabled()) {
            Tr.exit(CSIServerRIBase.tc, "getSecurityContext", secCtx);
        }
        return secCtx;
    }

    /*
     * Unable to fully structure code
     */
    protected byte[] processIdentityToken(EstablishContext ec, IdentityToken ittToken, AuditData auditData, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey, SecurityContextImpl secCtx, X509Certificate[] cert_chain, String transportPrincipal) {
        if (CSIServerRIBase.tc.isEntryEnabled()) {
            Tr.entry(CSIServerRIBase.tc, "processIdentityToken", new Object[]{ec, ittToken, auditData, sessionEntry, new Long(stateful_context_id), connKey, secCtx, cert_chain, transportPrincipal, this});
        }
        in_token = null;
        trustEvaluated = false;
        serverIDFromToken = false;
        contextHandler = null;
        csiv2 = SecurityObjectLocator.getCSIv2Config();
        ctxMgr = ContextManagerFactory.getInstance();
        transport_layer_data = sessionEntry.get_transport_layer_data();
        if (this.csiUtil.isTrusted("*")) {
            trustEvaluated = true;
            if (CSIServerRIBase.tc.isDebugEnabled()) {
                Tr.debug(CSIServerRIBase.tc, "The trust established is \"Presumed Trust\"");
            }
        } else {
            if (ec.client_authentication_token != null && ec.client_authentication_token.length > 0) {
                if (CSIServerRIBase.tc.isDebugEnabled()) {
                    Tr.debug(CSIServerRIBase.tc, "Validating the Client Authentication Token during Identity Assertion Processing");
                }
                try {
                    ba = new BasicAuthWithRealm();
                    receivedToken = new OpaqueHolder();
                    baUserid = null;
                    baPassword = null;
                    if (OID.compareOIDs((String)auditData.getClientAuthOID(), (String)"oid:2.23.130.1.1.1")) {
                        try {
                            this.csiUtil.parse_gssup_initial_context_token(ec.client_authentication_token, ba);
                            baUserid = ba.getUserid();
                            baPassword = ba.getPassword();
                        }
                        catch (WSSecurityContextException ex) {
                            Manager.Ffdc.log(ex, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1247", new Object[]{this});
                            Tr.debug(CSIServerRIBase.tc, "Error in GSSUP parse_gssup_initial_context_token, message: " + ex.toString());
                            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                                sessionEntry.set_session_state(7);
                            }
                            throw new BAD_PARAM("Error in GSSUP parse_gssup_initial_context_token, message: " + ex.toString(), 1229066437, CompletionStatus.COMPLETED_NO);
                        }
                    }
                    if (OID.compareOIDs((String)auditData.getClientAuthOID(), (String)"oid:1.3.18.0.2.30.2")) {
                        try {
                            _gFactory = new GSSFactory(GSSFactory.getMechOIDFromGSSToken((byte[])ec.client_authentication_token));
                            gssInitToken = _gFactory.decodeGSSToken(ec.client_authentication_token);
                            this.csiUtil.parse_gss_initial_context_token(gssInitToken, receivedToken);
                            server_ltpa_token = ctxMgr.getWSCredTokenMapper().validateLTPAToken(receivedToken.value);
                            auditData.setMechType(VaultConstants.LTPA_MECH_TYPE);
                            if (server_ltpa_token != null && (accessIDArray = server_ltpa_token.getAttributes("u")) != null && accessIDArray.length > 0) {
                                baUserid = RealmSecurityName.getSecurityName(accessIDArray[0]);
                                if (CSIServerRIBase.tc.isDebugEnabled()) {
                                    Tr.debug(CSIServerRIBase.tc, "serverIDFromToken is true");
                                }
                                serverIDFromToken = true;
                            }
                        }
                        catch (WSSecurityContextException ex) {
                            Manager.Ffdc.log(ex, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1293", new Object[]{this});
                            Tr.debug(CSIServerRIBase.tc, "Error in Token parse_gssup_initial_context_token, message: " + ex.toString());
                            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                                sessionEntry.set_session_state(7);
                            }
                            throw new BAD_PARAM("Error in Token parse_gssup_initial_context_token, message: " + ex.toString(), 1229066437, CompletionStatus.COMPLETED_NO);
                        }
                        catch (WSLoginFailedException ex) {
                            Manager.Ffdc.log(ex, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1309", new Object[]{this});
                            Tr.debug(CSIServerRIBase.tc, "Error in LTPA token login, message: " + ex.toString());
                            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                                sessionEntry.set_session_state(7);
                            }
                            throw new NO_PERMISSION("Error in LTPA token login, message: " + ex.toString(), 1229079301, CompletionStatus.COMPLETED_NO);
                        }
                    }
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "Verifying if server ID " + baUserid + " is trusted");
                    }
                    if (serverIDFromToken && !csiv2.getBoolean("com.ibm.ws.security.isUseRegistryServerId")) {
                        if (CSIServerRIBase.tc.isDebugEnabled()) {
                            Tr.debug(CSIServerRIBase.tc, "Check if " + baUserid + " is the internalServerId");
                        }
                        trustEvaluated = ContextManagerFactory.getInstance().isInternalServerId(baUserid);
                    } else {
                        trustEvaluated = this.csiUtil.isTrusted(baUserid, baPassword);
                    }
                    if (trustEvaluated) {
                        if (CSIServerRIBase.tc.isDebugEnabled()) {
                            Tr.debug(CSIServerRIBase.tc, "User " + baUserid + " is trusted");
                        }
                        if (receivedToken.value == null) {
                            ctxMgr.login(ctxMgr.getDefaultRealm(), baUserid, baPassword);
                            if (trustEvaluated && CSIServerRIBase.tc.isDebugEnabled()) {
                                Tr.debug(CSIServerRIBase.tc, "Validated the Client Authentication Token during Identity Assertion Processing: " + baUserid);
                            }
                        }
                    } else {
                        aur = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
                        if (PlatformHelperFactory.getPlatformHelper().isZOS() && aur.getType().equals("LOCALOS")) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS0639E", new Object[]{baUserid});
                        } else {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS0499E", new Object[]{baUserid, csiv2.getString("com.ibm.CSI.trustedPrincipalList")});
                        }
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1364", new Object[]{this});
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "Cannot validate the Client Authentication Token during Identity Assertion processing: ");
                    }
                    trustEvaluated = false;
                }
            }
            if (!trustEvaluated && cert_chain != null) {
                if (CSIServerRIBase.tc.isDebugEnabled()) {
                    Tr.debug(CSIServerRIBase.tc, "Validating the Client Certificates during Identity Assertion Processing");
                }
                if (trustEvaluated = this.csiUtil.isTrusted(cert_chain)) {
                    auditData.setMechType(VaultConstants.CLIENT_CERT_MECH_TYPE);
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "Validated the Client Certificates during Identity Assertion Processing: " + transportPrincipal);
                    }
                } else if (CSIServerRIBase.tc.isDebugEnabled()) {
                    Tr.debug(CSIServerRIBase.tc, "Cannot Trust the client certificate id: " + transportPrincipal + " . Make sure that " + transportPrincipal + "  is in the com.ibm.CSI.trustedPrincipalList. Alternatively, if the platform is z/OS and the active user registry is localOS, make sure that the id has CONTROL access to the CBIND profile in RACF.");
                }
            }
            if (!trustEvaluated && transport_layer_data != null) {
                if (CSIServerRIBase.tc.isDebugEnabled()) {
                    Tr.debug(CSIServerRIBase.tc, "Validating the transport layer data during Identity Assertion Processing");
                }
                if (trustEvaluated = this.csiUtil.isTrusted(new String(transport_layer_data))) {
                    auditData.setMechType(VaultConstants.LOCAL_OS_MECH_TYPE);
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "Validated the transport layer data during Identity Assertion Processing: " + transportPrincipal);
                    }
                } else if (CSIServerRIBase.tc.isDebugEnabled()) {
                    Tr.debug(CSIServerRIBase.tc, "Cannot Trust the transport layer id: " + transportPrincipal + " . Make sure that " + transportPrincipal + "  is in the com.ibm.CSI.trustedPrincipalList. Alternatively, if the platform is z/OS and the active user registry is localOS, make sure that the id has CONTROL access to the CBIND profile in RACF.");
                }
            }
        }
        lastTrailId = null;
        eventTrailIds = null;
        if (CSIServerRIBase.auditService != null) {
            lastTrailId = CSIServerRIBase.auditService.getLastTrailId();
            eventTrailIds = CSIServerRIBase.auditService.getEventTrailIds();
        }
        if (trustEvaluated) {
            if (CSIServerRIBase.tc.isDebugEnabled()) {
                Tr.debug(CSIServerRIBase.tc, "Trusted and Validated the server. Begin Identity token processing");
            }
            if ((ittToken = ec.identity_token).discriminator() == 2) {
                if (CSIServerRIBase.tc.isDebugEnabled()) {
                    Tr.debug(CSIServerRIBase.tc, "Identity Token is ITTPrincipal");
                }
                try {
                    gssFactory = new GSSFactory("oid:2.23.130.1.1.1");
                    read_Any = null;
                    try {
                        read_Any = this.csiUtil.getCodec().decode_value(ittToken.principal_name(), GSS_NT_ExportedNameHelper.type());
                    }
                    catch (MARSHAL e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1449", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, e.getMessage(), new Object[]{e});
                    }
                    catch (BAD_OPERATION ex) {
                        Manager.Ffdc.log(ex, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1454", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, ex.getMessage(), new Object[]{ex});
                    }
                    catch (FormatMismatch fm) {
                        Manager.Ffdc.log(fm, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1459", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, fm.getMessage(), new Object[]{fm});
                    }
                    catch (TypeMismatch tm) {
                        Manager.Ffdc.log(tm, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1464", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, tm.getMessage(), new Object[]{tm});
                    }
                    expTargetName = GSS_NT_ExportedNameHelper.extract((Any)read_Any);
                    principalName1 = gssFactory.decodeExportedTargetName(expTargetName);
                    principalName = this.csiUtil.parsePrincipal(principalName1);
                    securityName = "";
                    realm = "";
                    try {
                        idx = principalName.lastIndexOf("@");
                        esc = 32;
                        if (idx < 0) {
                            securityName = principalName;
                        } else if (idx == 0) {
                            realm = principalName.substring(1);
                        } else {
                            esc = principalName.charAt(idx - 1);
                            if (esc == 92) {
                                securityName = principalName;
                            } else {
                                securityName = principalName.substring(0, idx);
                                realm = principalName.substring(idx + 1, principalName.length());
                            }
                            idx = securityName.indexOf("\\@");
                            if (idx > -1) {
                                sb = new StringBuffer(securityName.length());
                                b = 32;
                                for (i = 0; i < securityName.length(); ++i) {
                                    a = securityName.charAt(i);
                                    if (i < securityName.length() - 1) {
                                        b = securityName.charAt(i + 1);
                                    }
                                    if (a == '\\' && b == 64) continue;
                                    sb.append(a);
                                }
                                securityName = sb.toString();
                            }
                        }
                    }
                    catch (Exception ie) {
                        // empty catch block
                    }
                    if (securityName.equals("")) {
                        securityName = principalName;
                    }
                    if (realm.equals("")) {
                        realm = RealmSecurityName.getRealm(csiv2.getString("com.ibm.CORBA.principalName"));
                    }
                    in_token = StringBytesConversion.getConvertedBytes((String)securityName);
                    secCtx.setIdentityName("ITTPrincipalName");
                    secCtx.setIdentityValue(ittToken.principal_name());
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "ITTPrincipal in the Identity Token is: " + principalName);
                    }
                    if (!CSIServerRIBase.tc.isDebugEnabled()) ** GOTO lbl411
                    Tr.debug(CSIServerRIBase.tc, "Using ITTPrincipalName for Authentication");
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1546", new Object[]{this});
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079296);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                        this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                        sessionEntry.set_session_state(7);
                    }
                    if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                        Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                        msg = "security.audit.service.context.error";
                        CSIServerRIBase.auditService.processAuditFailure(msg, null);
                    }
                    if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                        try {
                            CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                            failmsg = "security.audit.service.sendevent.error";
                            CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION("Cannot obtain the identity of the ITTPrincipalName: " + e, 1229079308, CompletionStatus.COMPLETED_NO);
                }
            } else if (ittToken.discriminator() == 8) {
                try {
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "Identity Token is ITTDistinguishedName");
                    }
                    read_Any = null;
                    try {
                        read_Any = this.csiUtil.getCodec().decode_value(ittToken.dn(), X501DistinguishedNameHelper.type());
                    }
                    catch (MARSHAL e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1652", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, e.getMessage(), new Object[]{e});
                    }
                    catch (BAD_OPERATION ex) {
                        Manager.Ffdc.log(ex, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1657", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, ex.getMessage(), new Object[]{ex});
                    }
                    catch (FormatMismatch fm) {
                        Manager.Ffdc.log(fm, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1662", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, fm.getMessage(), new Object[]{fm});
                    }
                    catch (TypeMismatch tm) {
                        Manager.Ffdc.log(tm, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1667", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, tm.getMessage(), new Object[]{tm});
                    }
                    decodedDN = X501DistinguishedNameHelper.extract((Any)read_Any);
                    tempX500 = new X500Principal(decodedDN);
                    DNString = tempX500.toString();
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "Received DN Name: " + DNString);
                    }
                    try {
                        DNString = this.csiUtil.parseDN(DNString);
                    }
                    catch (AuthenticationFailedException ex) {
                        Manager.Ffdc.log(ex, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1688", new Object[]{this});
                        Tr.debug(CSIServerRIBase.tc, "Error when parsing DN from the identity token, message: " + ex.toString());
                        throw new INTERNAL("Error when parsing DN from the identity token, message: " + ex.toString(), 1229079296, CompletionStatus.COMPLETED_NO);
                    }
                    in_token = StringBytesConversion.getConvertedBytes((String)DNString);
                    secCtx.setIdentityName("ITTDistinguishedName");
                    secCtx.setIdentityValue(ittToken.dn());
                    if (!CSIServerRIBase.tc.isDebugEnabled()) ** GOTO lbl411
                    Tr.debug(CSIServerRIBase.tc, "Using ITTDistinguishedName for Authentication: " + DNString);
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1712", new Object[]{this});
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079296);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                        this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                        sessionEntry.set_session_state(7);
                    }
                    Tr.debug(CSIServerRIBase.tc, e.getMessage(), new Object[]{e});
                    if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                        Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                        msg = "security.audit.service.context.error";
                        CSIServerRIBase.auditService.processAuditFailure(msg, null);
                    }
                    if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)11L);
                        try {
                            CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                            failmsg = "security.audit.service.sendevent.error";
                            CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION("Cannot obtain the identity of the ITTDistinguishedName: " + e, 1229079308, CompletionStatus.COMPLETED_NO);
                }
            } else if (ittToken.discriminator() == 4) {
                try {
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        Tr.debug(CSIServerRIBase.tc, "Identity Token is ITTX509CertChain");
                    }
                    cert_chain_bytes = ittToken.certificate_chain();
                    itt_cert_chain = SessionEntry.convertBytesToCertChain((byte[])cert_chain_bytes);
                    transportPrincipal = itt_cert_chain[0].getSubjectDN().getName();
                    in_token = StringBytesConversion.getConvertedBytes((String)transportPrincipal);
                    if (CSIServerRIBase.tc.isDebugEnabled() && itt_cert_chain != null) {
                        for (j = 0; j < itt_cert_chain.length; ++j) {
                            Tr.debug(CSIServerRIBase.tc, "Cert chain[" + j + "]: " + itt_cert_chain[j].toString());
                        }
                    }
                    secCtx.setIdentityName("ITTX509CertChain");
                    secCtx.setIdentityValue(ittToken.certificate_chain());
                    if (!CSIServerRIBase.tc.isDebugEnabled()) ** GOTO lbl411
                    Tr.debug(CSIServerRIBase.tc, "Using ITTX509CertChain for Authentication: Security Name in the certificate is: " + transportPrincipal);
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processIdentityToken", "1833", new Object[]{this});
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079296);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                        this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                        sessionEntry.set_session_state(7);
                    }
                    if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                        Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                        msg = "security.audit.service.context.error";
                        CSIServerRIBase.auditService.processAuditFailure(msg, null);
                    }
                    if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                        try {
                            CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                            failmsg = "security.audit.service.sendevent.error";
                            CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION("Cannot obtain the identity of the ITTX509CertChain: " + e, 1229079308, CompletionStatus.COMPLETED_NO);
                }
            }
        } else {
            if (CSIServerRIBase.tc.isDebugEnabled()) {
                Tr.debug(CSIServerRIBase.tc, "Authentication failed. Could not validate Client Authentication Token and/or Client Certificates during Identity Assertion");
            }
            if (secCtx != null) {
                secCtx.update_context_fail_reason(1229079296);
                this.csiUtil.getCurrent().setSecurityContext(secCtx);
            }
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                sessionEntry.set_session_state(7);
            }
            if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                msg = "security.audit.service.context.error";
                CSIServerRIBase.auditService.processAuditFailure(msg, null);
            }
            if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData((String)"challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                try {
                    CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                    failmsg = "security.audit.service.sendevent.error";
                    CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                }
            }
            throw new NO_PERMISSION("Authentication failed. Could not validate Client Authentication Token and/or Client Certificates during Identity Assertion", 1229079309, CompletionStatus.COMPLETED_NO);
        }
lbl411:
        // 7 sources

        if (CSIServerRIBase.tc.isEntryEnabled()) {
            Tr.exit(CSIServerRIBase.tc, "processIdentityToken", in_token);
        }
        return in_token;
    }

    /*
     * Unable to fully structure code
     */
    protected SessionEntry handleStatefulContext(SASContextBody msg, X509Certificate[] cert_chain, AuditData auditData, String remoteHost, int remotePort, ServerConnectionKey connKey, SecurityContextImpl secCtx, Map j2eeName) {
        block96: {
            if (CSIServerRIBase.tc.isEntryEnabled()) {
                Tr.entry(CSIServerRIBase.tc, "handleStatefulContext", new Object[]{msg, cert_chain, auditData, remoteHost, new Integer(remotePort), connKey, secCtx, this});
            }
            logMsg = "";
            csiv2 = SecurityObjectLocator.getCSIv2Config();
            received_subject = null;
            stateful_context_id = 0L;
            sessionEntry = new SessionEntry(0L);
            discard_context = false;
            contextHandler = null;
            lastTrailId = null;
            eventTrailIds = null;
            if (CSIServerRIBase.auditService != null) {
                lastTrailId = CSIServerRIBase.auditService.getLastTrailId();
                eventTrailIds = CSIServerRIBase.auditService.getEventTrailIds();
            }
            if (msg != null && msg.discriminator() == 0) {
                message = msg.establish_msg();
                stateful_context_id = message.client_context_id;
                auditData.setStatefulContextId(stateful_context_id);
            } else if (msg != null && msg.discriminator() == 5) {
                if (CSIServerRIBase.tc.isDebugEnabled()) {
                    Tr.debug(CSIServerRIBase.tc, "handleStatefulContexti > MessageInContext");
                }
                message = msg.in_context_msg();
                stateful_context_id = message.client_context_id;
                auditData.setStatefulContextId(stateful_context_id);
                if (stateful_context_id == 0L) {
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079296);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                        Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                        msga = "security.audit.service.context.error";
                        CSIServerRIBase.auditService.processAuditFailure(msga, null);
                    }
                    if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        data = DataHelper.buildSessionData(null, null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)1L);
                        try {
                            CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                            failmsg = "security.audit.service.sendevent.error";
                            CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION("SessionDoesNotExist on the server.", 1229079304, CompletionStatus.COMPLETED_NO);
                }
            } else if (cert_chain != null) {
                received_subject = this.sessionMgr.csi_lookup_connection_cred(connKey);
                if (received_subject != null) {
                    try {
                        block95: {
                            if (!SubjectHelper.isWSCredentialValid(received_subject, true)) {
                                throw new InvalidCredential();
                            }
                            this.csiUtil.getCurrent().initialize_requestor_context(received_subject);
                            auditData.setReceivedSubject(received_subject);
                            if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") && (tokenMap = this.sessionMgr.csi_lookup_connection_propagation_token_map(connKey)) != null) {
                                try {
                                    for (String key : tokenMap.keySet()) {
                                        propToken = (PropagationToken)tokenMap.get(key);
                                        if (propToken == null) continue;
                                        tokenPriv = (PropagationToken)propToken.clone();
                                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                            public Object run() throws WSSecurityException {
                                                if (tc.isDebugEnabled()) {
                                                    String logMsg = "Setting propagation token from connection: " + tokenPriv.getName() + ":" + tokenPriv.getVersion();
                                                    Tr.debug(tc, logMsg);
                                                }
                                                ContextManagerFactory.getInstance().setPropagationToken(tokenPriv.getName() + ":" + tokenPriv.getVersion(), tokenPriv);
                                                return null;
                                            }
                                        });
                                    }
                                }
                                catch (PrivilegedActionException e) {
                                    Manager.Ffdc.log(e.getException(), (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.handleStatefulContext", "2225", new Object[]{this});
                                    if (!CSIServerRIBase.tc.isDebugEnabled()) break block95;
                                    logMsg = "Error setting propagation token.";
                                    Tr.debug(CSIServerRIBase.tc, logMsg, new Object[]{e.getException()});
                                }
                            }
                        }
                        if (CSIServerRIBase.tc.isDebugEnabled()) {
                            logMsg = "*** BEGIN PREINVOKE ***";
                            Tr.debug(CSIServerRIBase.tc, logMsg);
                        }
                        if (CSIServerRIBase.tc.isEntryEnabled()) {
                            Tr.exit(CSIServerRIBase.tc, "handleStatefulContext", null);
                        }
                        return null;
                    }
                    catch (InvalidCredential e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.handleStatefulContext", "2249", new Object[]{this});
                        if (!CSIServerRIBase.tc.isDebugEnabled()) ** GOTO lbl101
                        logMsg = "Credential is expired, reauthenticating with certificate principal instead of using cached Subject.";
                        Tr.debug(CSIServerRIBase.tc, logMsg, new Object[]{e});
                    }
                } else if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") && (tokenMap = this.sessionMgr.csi_lookup_connection_propagation_token_map(connKey)) != null) {
                    sessionEntry.set_propagation_token_map(tokenMap);
                }
lbl101:
                // 5 sources

                stateful_context_id = 0L;
                auditData.setStatefulContextId(stateful_context_id);
            } else {
                stateful_context_id = 0L;
                auditData.setStatefulContextId(stateful_context_id);
            }
            if (stateful_context_id == 0L) break block96;
            session_state = 5;
            sessionEntry = this.sessionMgr.csi_server_session_lookup(stateful_context_id, connKey, msg, false);
            if (sessionEntry == null) {
                if (CSIServerRIBase.tc.isDebugEnabled()) {
                    logMsg = "Session state:  SESSION_DOES_NOT_EXIST.  Throwing NO_PERMISSION exception.";
                    Tr.debug(CSIServerRIBase.tc, logMsg);
                }
                if (secCtx != null) {
                    secCtx.update_context_fail_reason(1229079304);
                    secCtx.set_stateful_context_id(stateful_context_id);
                    this.csiUtil.getCurrent().setSecurityContext(secCtx);
                }
                if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                    Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                    msga = "security.audit.service.context.error";
                    CSIServerRIBase.auditService.processAuditFailure(msga, null);
                }
                if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                    this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                    data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData((String)"challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)1L);
                    try {
                        CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException pfe) {
                        Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                        failmsg = "security.audit.service.sendevent.error";
                        CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                    }
                }
                throw new NO_PERMISSION(logMsg, 1229079304, CompletionStatus.COMPLETED_NO);
            }
            session_state = sessionEntry.get_session_state();
            switch (session_state) {
                case 4: {
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        logMsg = "Session state:  SESSION_DOES_NOT_EXIST.  Throwing NO_PERMISSION exception.";
                        Tr.debug(CSIServerRIBase.tc, logMsg);
                    }
                    sessionEntry.set_session_state(2);
                    sessionEntry.set_remote_host(connKey.get_remote_host());
                    sessionEntry.set_remote_port(connKey.get_remote_port());
                    sessionEntry.set_remote_connection_unique_id(connKey.get_connection_creation_time());
                    break;
                }
                case 2: {
                    stateful_context_id = 0L;
                    auditData.setStatefulContextId(stateful_context_id);
                    sessionEntry.set_renegotiate_to_stateless();
                    if (!CSIServerRIBase.tc.isDebugEnabled()) break;
                    logMsg = "Session state:  SESSION_IN_INCOMPLETE_STATE.  Renegotiating to stateless.";
                    Tr.debug(CSIServerRIBase.tc, logMsg);
                    break;
                }
                case 3: {
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        logMsg = "Session state:  SESSION_CONFLICTING_EVIDENCE.  Throwing NO_PERMISSION exception.";
                        Tr.debug(CSIServerRIBase.tc, logMsg);
                    }
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079296);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                        Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                        msga = "security.audit.service.context.error";
                        CSIServerRIBase.auditService.processAuditFailure(msga, null);
                    }
                    if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)2L);
                        try {
                            CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                            failmsg = "security.audit.service.sendevent.error";
                            CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION(logMsg, 1229079305, CompletionStatus.COMPLETED_NO);
                }
                case 7: {
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        logMsg = "Session state:  SESSION_REJECTED.  Throwing NO_PERMISSION exception.";
                        Tr.debug(CSIServerRIBase.tc, logMsg);
                    }
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079296);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                        Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                        msga = "security.audit.service.context.error";
                        CSIServerRIBase.auditService.processAuditFailure(msga, null);
                    }
                    if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                        try {
                            CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                            failmsg = "security.audit.service.sendevent.error";
                            CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION(logMsg, 1229079306, CompletionStatus.COMPLETED_NO);
                }
                case 1: {
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        logMsg = "Session state:  SESSION_IN_COMPLETE_STATE.  Proceeding to use session credentials to validate.";
                        Tr.debug(CSIServerRIBase.tc, logMsg);
                    }
                    if (sessionEntry == null || stateful_context_id == 0L) break;
                    if (msg != null && msg.discriminator() == 5) {
                        mic = msg.in_context_msg();
                        this.csiUtil.print_mic_message(mic, "handleStatefulContext");
                        discard_context = mic.discard_context;
                    }
                    if ((secCtx = sessionEntry.get_security_context_holder()) == null) {
                        if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                            Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                            msga = "security.audit.service.context.error";
                            CSIServerRIBase.auditService.processAuditFailure(msga, null);
                        }
                        if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                            this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                            data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData((String)"challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)2L);
                            try {
                                CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException pfe) {
                                Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                                failmsg = "security.audit.service.sendevent.error";
                                CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                            }
                        }
                        throw new INTERNAL("Security context holder is null in receive_request", 1229066420, CompletionStatus.COMPLETED_NO);
                    }
                    received_subject = secCtx.getClientSubject();
                    auditData.setReceivedSubject(received_subject);
                    secCtx.set_discard_context(discard_context);
                    try {
                        if (received_subject != null) {
                            if (sessionEntry.get_basic_auth_type() != false ? SubjectHelper.isWSCredentialValid(received_subject, true) == false : SubjectHelper.isWSCredentialValid(received_subject) == false) {
                                throw new InvalidCredential();
                            }
                            trace_username = null;
                            if (CSIServerRIBase.tc.isDebugEnabled() && (cred = SubjectHelper.getWSCredentialFromSubject(received_subject)) != null) {
                                trace_username = cred.getSecurityName();
                                logMsg = "Request from remote user: " + trace_username + ", remote host/port: " + remoteHost + ":" + remotePort;
                                Tr.debug(CSIServerRIBase.tc, logMsg);
                            }
                            if (j2eeName != null && csiv2.getBoolean("com.ibm.CSI.rmiInboundMappingEnabled")) {
                                received_subject = this.mapAuthenticatedSubject(received_subject, j2eeName);
                                if (CSIServerRIBase.tc.isDebugEnabled()) {
                                    try {
                                        wsCred = SubjectHelper.getWSCredentialFromSubject(received_subject);
                                        username = wsCred.getSecurityName();
                                        logMsg = "Mapped authenticated remote user: " + trace_username + " to: " + username;
                                        Tr.debug(CSIServerRIBase.tc, logMsg);
                                    }
                                    catch (Exception e) {}
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.handleStatefulContext", "2793", new Object[]{this});
                        if (CSIServerRIBase.tc.isDebugEnabled()) {
                            logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0202E", "JSAS0202E: Credential token expired.");
                            Tr.debug(CSIServerRIBase.tc, logMsg);
                        }
                        if (secCtx != null) {
                            secCtx.update_context_fail_reason(1229079296);
                            this.csiUtil.getCurrent().setSecurityContext(secCtx);
                        }
                        if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                            this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                            sessionEntry.set_session_state(7);
                        }
                        if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                            Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                            msga = "security.audit.service.context.error";
                            CSIServerRIBase.auditService.processAuditFailure(msga, null);
                        }
                        if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                            this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                            data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData((String)"challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)4L);
                            try {
                                CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException pfe) {
                                Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                                failmsg = "security.audit.service.sendevent.error";
                                CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                            }
                        }
                        throw new NO_PERMISSION(logMsg, 1229079302, CompletionStatus.COMPLETED_NO);
                    }
                    if (received_subject == null) {
                        if (secCtx != null) {
                            secCtx.update_context_fail_reason(1229079296);
                            this.csiUtil.getCurrent().setSecurityContext(secCtx);
                        }
                        if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                            this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                            sessionEntry.set_session_state(7);
                        }
                        logMsg = "security.JSAS0439E";
                        Tr.error(CSIServerRIBase.tc, logMsg);
                        if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                            Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                            msga = "security.audit.service.context.error";
                            CSIServerRIBase.auditService.processAuditFailure(msga, null);
                        }
                        if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                            this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                            data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData((String)"challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                            try {
                                CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException pfe) {
                                Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                                failmsg = "security.audit.service.sendevent.error";
                                CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                            }
                        }
                        throw new INTERNAL(logMsg, 1229066420, CompletionStatus.COMPLETED_NO);
                    }
                    if (!csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") || (tokenMap = sessionEntry.get_propagation_token_map()) == null) ** GOTO lbl410
                    try {
                        for (String key : tokenMap.keySet()) {
                            propToken = (PropagationToken)tokenMap.get(key);
                            if (propToken == null) continue;
                            tokenPriv = (PropagationToken)propToken.clone();
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws WSSecurityException {
                                    if (tc.isDebugEnabled()) {
                                        String logMsg = "Setting propagation token from session: " + tokenPriv.getName() + ":" + tokenPriv.getVersion();
                                        Tr.debug(tc, logMsg);
                                    }
                                    ContextManagerFactory.getInstance().setPropagationToken(tokenPriv.getName() + ":" + tokenPriv.getVersion(), tokenPriv);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (PrivilegedActionException e) {
                        Manager.Ffdc.log(e.getException(), (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.handleStatefulContext", "3033", new Object[]{this});
                        if (!CSIServerRIBase.tc.isDebugEnabled()) ** GOTO lbl410
                        logMsg = "Error setting propagation token.";
                        Tr.debug(CSIServerRIBase.tc, logMsg, new Object[]{e.getException()});
                    }
lbl410:
                    // 4 sources

                    this.csiUtil.getCurrent().initialize_requestor_context(received_subject);
                    if (secCtx != null) {
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (CSIServerRIBase.tc.isDebugEnabled()) {
                        logMsg = "*** BEGIN PREINVOKE ***";
                        Tr.debug(CSIServerRIBase.tc, logMsg);
                    }
                    if (CSIServerRIBase.tc.isEntryEnabled()) {
                        Tr.exit(CSIServerRIBase.tc, "handleStatefulContext", null);
                    }
                    if (CSIServerRIBase.auditService != null && (contextHandler = CSIServerRIBase.auditService.getContextHandler()) == null) {
                        Tr.error(CSIServerRIBase.tc, "security.audit.service.context.error");
                        msga = "security.audit.service.context.error";
                        CSIServerRIBase.auditService.processAuditFailure(msga, null);
                    }
                    if (CSIServerRIBase.auditService != null && CSIServerRIBase.auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)"WebSphere", (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"authnSuccess", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)CSIServerRIBase.auditService.getFirstCaller(), (String[])CSIServerRIBase.auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)CSIServerRIBase.auditService.getDomain(), (String)CSIServerRIBase.auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"SUCCESSFUL", (Integer)new Integer(0), (Integer)new Integer(0), (String)"SUCCESS", (long)5L);
                        try {
                            CSIServerRIBase.auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(CSIServerRIBase.tc, "security.JSAS1503E", new Object[]{pfe});
                            failmsg = "security.audit.service.sendevent.error";
                            CSIServerRIBase.auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    return null;
                }
            }
        }
        if (CSIServerRIBase.tc.isEntryEnabled()) {
            Tr.exit(CSIServerRIBase.tc, "handleStatefulContext", sessionEntry);
        }
        return sessionEntry;
    }

    protected SessionEntry handleStatefulContextFromFilter(SASContextBody msg, X509Certificate[] cert_chain, AuditData auditData, String remoteHost, int remotePort, String remoteConnectionId, SecurityContextImpl secCtx, GIOPMessageContext gmc) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleStatefulContextFromFilter", new Object[]{msg, cert_chain, auditData, remoteHost, new Integer(remotePort), remoteConnectionId, secCtx, gmc, this});
        }
        String logMsg = "";
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        long stateful_context_id = 0L;
        SessionEntry sessionEntryFromLookup = null;
        SessionEntry sessionEntry = new SessionEntry(0L);
        sessionEntry.set_remote_host(remoteHost);
        sessionEntry.set_remote_port(remotePort);
        sessionEntry.set_remote_connection_unique_id(remoteConnectionId);
        sessionEntry.set_cert_chain(cert_chain);
        ContextHandler contextHandler = null;
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        if (msg != null) {
            EstablishContext message;
            if (msg.discriminator() == 0) {
                if (tc.isDebugEnabled()) {
                    logMsg = "Message is MTEstablishContext, session will be created if non-zero context id.";
                    Tr.debug(tc, logMsg);
                }
                message = msg.establish_msg();
                stateful_context_id = message.client_context_id;
                auditData.setStatefulContextId(stateful_context_id);
                sessionEntry.set_ec_message(message);
            } else if (msg.discriminator() == 5) {
                if (tc.isDebugEnabled()) {
                    logMsg = "Message is MTMessageInContext, session should exist.";
                    Tr.debug(tc, logMsg);
                }
                message = msg.in_context_msg();
                stateful_context_id = message.client_context_id;
                auditData.setStatefulContextId(stateful_context_id);
                if (stateful_context_id == 0L || !csiv2.getBoolean("com.ibm.CSI.claimStateful")) {
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079304);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msga = "security.audit.service.context.error";
                        auditService.processAuditFailure(msga, null);
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        HashMap data = DataHelper.buildSessionData(null, null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)1L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                            String failmsg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION("SessionDoesNotExist on the server.", 1229079304, CompletionStatus.COMPLETED_NO);
                }
            }
            if (stateful_context_id != 0L) {
                int session_state = 5;
                ServerConnectionKey connKey = new ServerConnectionKey(remoteConnectionId, remoteHost, remotePort);
                sessionEntryFromLookup = this.sessionMgr.csi_server_session_lookup(stateful_context_id, connKey, msg, false);
                if (sessionEntryFromLookup == null) {
                    if (tc.isDebugEnabled()) {
                        logMsg = "Session state:  SESSION_DOES_NOT_EXIST.  Throwing NO_PERMISSION exception.";
                        Tr.debug(tc, logMsg);
                    }
                    if (secCtx != null) {
                        secCtx.update_context_fail_reason(1229079304);
                        secCtx.set_stateful_context_id(stateful_context_id);
                        this.csiUtil.getCurrent().setSecurityContext(secCtx);
                    }
                    if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msga = "security.audit.service.context.error";
                        auditService.processAuditFailure(msga, null);
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                        this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                        HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData((String)"challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)1L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                            String failmsg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(failmsg, pfe);
                        }
                    }
                    throw new NO_PERMISSION(logMsg, 1229079304, CompletionStatus.COMPLETED_NO);
                }
                session_state = sessionEntryFromLookup.get_session_state();
                switch (session_state) {
                    case 4: {
                        if (msg.discriminator() == 5) {
                            if (tc.isDebugEnabled()) {
                                logMsg = "Session state:  SESSION_NEW for MTMessageInContext message.  Throwing NO_PERMISSION exception.";
                                Tr.debug(tc, logMsg);
                            }
                            if (secCtx != null) {
                                secCtx.update_context_fail_reason(1229079304);
                                secCtx.set_stateful_context_id(stateful_context_id);
                                this.csiUtil.getCurrent().setSecurityContext(secCtx);
                                sessionEntryFromLookup.set_security_context_holder(secCtx);
                            }
                            if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                                Tr.error(tc, "security.audit.service.context.error");
                                String msga = "security.audit.service.context.error";
                                auditService.processAuditFailure(msga, null);
                            }
                            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                                HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                                data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                                data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                                data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                                data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                                data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                                data = DataHelper.buildAuthnData((String)"challengeResponse");
                                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                                data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)1L);
                                try {
                                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                                }
                                catch (ProviderFailureException pfe) {
                                    Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                                    String failmsg = "security.audit.service.sendevent.error";
                                    auditService.processAuditFailure(failmsg, pfe);
                                }
                            }
                            throw new NO_PERMISSION(logMsg, 1229079304, CompletionStatus.COMPLETED_NO);
                        }
                        if (msg.discriminator() != 0) break;
                        if (tc.isDebugEnabled()) {
                            logMsg = "Session state:  SESSION_NEW for MTEstablishContext message.  Proceeding to authenticate.";
                            Tr.debug(tc, logMsg);
                        }
                        sessionEntryFromLookup.set_session_state(2);
                        sessionEntryFromLookup.set_remote_host(remoteHost);
                        sessionEntryFromLookup.set_remote_port(remotePort);
                        sessionEntryFromLookup.set_remote_connection_unique_id(remoteConnectionId);
                        sessionEntryFromLookup.set_ec_message(msg.establish_msg());
                        sessionEntryFromLookup.set_cert_chain(cert_chain);
                        this.getTransportLayerData(sessionEntryFromLookup, gmc);
                        break;
                    }
                    case 2: {
                        if (msg.discriminator() == 0) {
                            sessionEntryFromLookup = null;
                            if (tc.isDebugEnabled()) {
                                logMsg = "Session state:  SESSION_IN_INCOMPLETE_STATE for MTEstablishContext message.  Renegotiating to stateless.";
                                Tr.debug(tc, logMsg);
                            }
                        } else if (msg.discriminator() == 5) {
                            if (tc.isDebugEnabled()) {
                                logMsg = "Session state:  SESSION_IN_INCOMPLETE_STATE for MTMessageInContext message.  Renegotiating to stateless.";
                                Tr.debug(tc, logMsg);
                            }
                            sessionEntry.set_session_state(sessionEntryFromLookup.get_session_state());
                            sessionEntry.set_cert_chain(sessionEntryFromLookup.get_cert_chain());
                            sessionEntry.set_ec_message(sessionEntryFromLookup.get_ec_message());
                            sessionEntryFromLookup = null;
                        }
                        this.getTransportLayerData(sessionEntry, gmc);
                        break;
                    }
                    case 3: {
                        if (msg.discriminator() == 0) {
                            sessionEntryFromLookup = null;
                            if (tc.isDebugEnabled()) {
                                logMsg = "Session state:  SESSION_CONFLICTING_EVIDENCE for MTEstablishContext message.  Renegotiating to stateless.";
                                Tr.debug(tc, logMsg);
                            }
                            this.getTransportLayerData(sessionEntry, gmc);
                            break;
                        }
                        if (msg.discriminator() != 5) break;
                        if (tc.isDebugEnabled()) {
                            logMsg = "Session state:  SESSION_CONFLICTING_EVIDENCE for MTMessageInContext message.  Throwing NO_PERMISSION exception.";
                            Tr.debug(tc, logMsg);
                        }
                        if (secCtx != null) {
                            secCtx.update_context_fail_reason(1229079305);
                            this.csiUtil.getCurrent().setSecurityContext(secCtx);
                        }
                        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                            Tr.error(tc, "security.audit.service.context.error");
                            String msga = "security.audit.service.context.error";
                            auditService.processAuditFailure(msga, null);
                        }
                        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                            this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                            HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData((String)"challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)2L);
                            try {
                                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException pfe) {
                                Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                                String failmsg = "security.audit.service.sendevent.error";
                                auditService.processAuditFailure(failmsg, pfe);
                            }
                        }
                        throw new NO_PERMISSION(logMsg, 1229079305, CompletionStatus.COMPLETED_NO);
                    }
                    case 7: {
                        if (msg.discriminator() == 0) {
                            sessionEntryFromLookup = null;
                            if (tc.isDebugEnabled()) {
                                logMsg = "Session state: SESSION_REJECTED for MTEstablishContext message.  Renegotiating to stateless.";
                                Tr.debug(tc, logMsg);
                            }
                            this.getTransportLayerData(sessionEntry, gmc);
                            break;
                        }
                        if (msg.discriminator() != 5) break;
                        if (tc.isDebugEnabled()) {
                            logMsg = "Session state:  SESSION_REJECTED.  Throwing NO_PERMISSION exception.";
                            Tr.debug(tc, logMsg);
                        }
                        if (secCtx != null) {
                            secCtx.update_context_fail_reason(1229079306);
                            this.csiUtil.getCurrent().setSecurityContext(secCtx);
                        }
                        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                            Tr.error(tc, "security.audit.service.context.error");
                            String msga = "security.audit.service.context.error";
                            auditService.processAuditFailure(msga, null);
                        }
                        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                            this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                            HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                            contextHandler.buildContextObject("SESSION_CONTEXT", data);
                            data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                            data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                            contextHandler.buildContextObject("EVENT_CONTEXT", data);
                            data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                            data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                            data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                            data = DataHelper.buildAuthnData((String)"challengeResponse");
                            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                            data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                            this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                            try {
                                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                            }
                            catch (ProviderFailureException pfe) {
                                Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                                String failmsg = "security.audit.service.sendevent.error";
                                auditService.processAuditFailure(failmsg, pfe);
                            }
                        }
                        throw new NO_PERMISSION(logMsg, 1229079306, CompletionStatus.COMPLETED_NO);
                    }
                    case 1: {
                        if (!tc.isDebugEnabled()) break;
                        logMsg = "Session state:  SESSION_IN_COMPLETE_STATE.  Proceeding to use session credentials to validate.";
                        Tr.debug(tc, logMsg);
                    }
                }
            } else {
                this.getTransportLayerData(sessionEntry, gmc);
            }
        } else if (cert_chain != null) {
            ServerConnectionKey connKey;
            Map tokenMap;
            auditData.setStatefulContextId(0L);
            sessionEntry.set_cert_chain(cert_chain);
            if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") && (tokenMap = this.sessionMgr.csi_lookup_connection_propagation_token_map(connKey = new ServerConnectionKey(remoteConnectionId, remoteHost, remotePort))) != null) {
                sessionEntry.set_propagation_token_map(tokenMap);
            }
        } else {
            auditData.setStatefulContextId(0L);
            this.getTransportLayerData(sessionEntry, gmc);
        }
        if (sessionEntryFromLookup != null) {
            if (tc.isDebugEnabled()) {
                logMsg = "Returning session from session table.";
                Tr.debug(tc, logMsg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleStatefulContextFromFilter", sessionEntryFromLookup);
            }
            return sessionEntryFromLookup;
        }
        if (tc.isDebugEnabled()) {
            logMsg = "Returning stateless session.";
            Tr.debug(tc, logMsg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleStatefulContextFromFilter", sessionEntry);
        }
        return sessionEntry;
    }

    protected byte[] processClientAuthToken(EstablishContext ec, AuditData auditData, SecurityContextImpl secCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processClientAuthToken", new Object[]{ec, auditData, secCtx, this});
        }
        String logMsg = "";
        byte[] in_token = ec.client_authentication_token;
        ContextHandler contextHandler = null;
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        try {
            String theOID = GSSFactory.getMechOIDFromGSSToken((byte[])in_token);
            auditData.setMechType(GSSFactory.mapOidToMechType((String)theOID));
            if (tc.isDebugEnabled()) {
                logMsg = "Extracted OID and mechtype from receiving client GSS token in receive_request." + theOID + " / " + auditData.getMechType();
                Tr.debug(tc, logMsg);
            }
        }
        catch (GSSEncodeDecodeException gEx) {
            Manager.Ffdc.log(gEx, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processClientAuthToken", "3930", new Object[]{this});
            if (tc.isDebugEnabled()) {
                logMsg = "Failed to get OID from receiving client GSS token in receive_request.";
                Tr.debug(tc, logMsg);
            }
            if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msga = "security.audit.service.context.error";
                auditService.processAuditFailure(msga, null);
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData((String)"challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)11L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                    String failmsg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(failmsg, pfe);
                }
            }
            throw new NO_PERMISSION(logMsg, 1229066437, CompletionStatus.COMPLETED_NO);
        }
        secCtx.setIdentityName("ClientAuthenticationToken");
        secCtx.setIdentityValue(in_token);
        if (tc.isDebugEnabled()) {
            logMsg = "Using Client Authentication Token for Authentication";
            Tr.debug(tc, logMsg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processClientAuthToken", in_token);
        }
        return in_token;
    }

    protected void processCertificateChain(X509Certificate[] cert_chain, String transportPrincipal, AuditData auditData, SecurityContextImpl secCtx, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCertificateChain", new Object[]{cert_chain, transportPrincipal, auditData, secCtx, sessionEntry, new Long(stateful_context_id), connKey, this});
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        ContextHandler contextHandler = null;
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing client certificate chain.");
            }
            auditData.setMechType(VaultConstants.CLIENT_CERT_MECH_TYPE);
            byte[] cert_chain_bytes = SessionEntry.convertCertChainToBytes((X509Certificate[])cert_chain);
            secCtx.setIdentityName("ClientCertificate");
            secCtx.setIdentityValue(cert_chain_bytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using Client Certificates for Authentication: Security Name in the certificate is: " + transportPrincipal);
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.processCertificateChain", "4072", new Object[]{this});
            if (secCtx != null) {
                secCtx.update_context_fail_reason(1229079296);
                this.csiUtil.getCurrent().setSecurityContext(secCtx);
            }
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                sessionEntry.set_session_state(7);
            }
            if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msga = "security.audit.service.context.error";
                auditService.processAuditFailure(msga, null);
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData((String)"challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(-1), (Integer)new Integer(-1), (String)"DENIED", (long)3L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                    String failmsg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(failmsg, pfe);
                }
            }
            throw new INTERNAL("Problem Converting client certificate chain to ByteArray: " + e, 1229066416, CompletionStatus.COMPLETED_NO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCertificateChain");
        }
    }

    protected void processUnauthenticated(AuditData auditData, SecurityContextImpl secCtx, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processUnauthenticated", new Object[]{auditData, secCtx, sessionEntry, new Long(stateful_context_id), connKey, this});
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        ContextHandler contextHandler = null;
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        Subject unauthSubject = SubjectHelper.createUnauthenticatedSubject();
        if (this.csiUtil.getCurrent() != null) {
            this.csiUtil.getCurrent().initialize_requestor_context(unauthSubject);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No valid Identity tokens. Setting the credential to Unauthenticated");
        }
        if (secCtx != null) {
            if (unauthSubject != null) {
                secCtx.setClientSubject(unauthSubject);
            }
            secCtx.update_context_fail_reason(1229079296);
            this.csiUtil.getCurrent().setSecurityContext(secCtx);
        }
        if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L && secCtx != null) {
            secCtx.set_server_conn_key(connKey);
            sessionEntry.set_security_context_holder(secCtx);
            this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 1);
        }
        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
            this.princ = unauthSubject != null && unauthSubject.getPrincipals() != null ? ((Principal)unauthSubject.getPrincipals().toArray()[0]).getName() : null;
            HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
            data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
            data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
            contextHandler.buildContextObject("EVENT_CONTEXT", data);
            data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
            data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
            data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
            data = DataHelper.buildAuthnData((String)"challengeResponse");
            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
            data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
            this.auditOutcome = DataHelper.buildOutcomeData((String)"SUCCESSFUL", (Integer)new Integer(0), (Integer)new Integer(0), (String)"DENIED", (long)12L);
            try {
                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
            }
            catch (ProviderFailureException pfe) {
                Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                String failmsg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(failmsg, pfe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processUnauthenticated");
        }
    }

    protected void processInvalidMessage(AuditData auditData, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey) {
        CSIv2Config csiv2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processInvalidMessage", new Object[]{auditData, sessionEntry, new Long(stateful_context_id), connKey, this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Either message type is not EstablishContext or message and cert_chain are both no longer present.");
        }
        if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
            this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
            sessionEntry.set_session_state(7);
        }
        ContextHandler contextHandler = null;
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
            this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
            HashMap data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
            data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
            data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
            contextHandler.buildContextObject("EVENT_CONTEXT", data);
            data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
            data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
            data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
            data = DataHelper.buildAuthnData((String)"challengeResponse");
            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
            data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
            this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(0), (Integer)new Integer(0), (String)"DENIED", (long)3L);
            try {
                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
            }
            catch (ProviderFailureException pfe) {
                Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                String failmsg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(failmsg, pfe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processInvalidMessage", "NO_PERMISSION");
        }
        throw new NO_PERMISSION("Message type invalid.", 1229079310, CompletionStatus.COMPLETED_NO);
    }

    protected Subject authenticateSecurityTokens(byte[] in_token, X509Certificate[] cert_chain, AuditData auditData, SecurityContextImpl secCtx, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey, String remoteHost, int remotePort, Map j2eeName) {
        HashMap data;
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticateSecurityTokens", new Object[]{in_token, cert_chain, auditData, secCtx, sessionEntry, new Long(stateful_context_id), connKey, remoteHost, new Integer(remotePort), this});
        }
        Subject received_subject = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing security information.");
        }
        ContextHandler contextHandler = null;
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        AssociationStatus associationStatus = null;
        try {
            OpaqueHolder out_token = new OpaqueHolder();
            secCtx.csi_initialize(null, in_token, cert_chain, out_token, j2eeName);
            associationStatus = AssociationStatus.SecAssocSuccess;
        }
        catch (Exception e) {
            if (!SecurityMessages.suppressFFDCforKrbSkewError(e)) {
                Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.authenticateSecurityTokens", "4456", new Object[]{this});
            }
            Tr.debug(tc, "Exception in csi_accept_security_context.", new Object[]{e});
            this.csiUtil.getCurrent().setRootException(e);
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                sessionEntry.set_session_state(7);
            }
            if (secCtx != null) {
                secCtx.update_context_fail_reason(1229079296);
                this.csiUtil.getCurrent().setSecurityContext(secCtx);
                byte[] fail_reason = null;
                fail_reason = e.getMessage() != null && e.getMessage().length() != 0 ? e.getMessage().getBytes() : secCtx._principalAuthFailDetail;
                PrincipalAuthFailReason.map_auth_fail_to_minor_code(secCtx._principalAuthFailReason, fail_reason);
            }
            if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msg2 = "security.audit.service.context.error";
                auditService.processAuditFailure(msg2, null);
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                HashMap data2 = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data2);
                data2 = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data2);
                data2 = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data2);
                data2 = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data2);
                data2 = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data2);
                data2 = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data2);
                data2 = DataHelper.buildAuthnData((String)"challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data2);
                data2 = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data2);
                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(0), (Integer)new Integer(0), (String)"DENIED", (long)13L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                    String failmsg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(failmsg, pfe);
                }
            }
            throw new NO_PERMISSION(e.getMessage(), 1229079296, CompletionStatus.COMPLETED_NO);
        }
        if (associationStatus.value() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication Failed.");
            }
            if (secCtx != null) {
                secCtx.update_context_fail_reason(1229079296);
                this.csiUtil.getCurrent().setSecurityContext(secCtx);
            }
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                sessionEntry.set_session_state(7);
            }
            PrincipalAuthFailReason.map_auth_fail_to_minor_code(secCtx._principalAuthFailReason, secCtx._principalAuthFailDetail);
        } else if (secCtx != null) {
            secCtx.setContextState(3);
            received_subject = secCtx.getClientSubject();
            if (tc.isDebugEnabled()) {
                try {
                    WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(received_subject);
                    String username = wsCred.getSecurityName();
                    Tr.debug(tc, "Request authenticated for remote user: " + username + ", remote host/port: " + remoteHost + ":" + remotePort);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (received_subject == null) {
                if (secCtx != null) {
                    secCtx.update_context_fail_reason(1229079296);
                    this.csiUtil.getCurrent().setSecurityContext(secCtx);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                    this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                    sessionEntry.set_session_state(7);
                }
                Tr.error(tc, "security.JSAS0439E");
                if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                    Tr.error(tc, "security.audit.service.context.error");
                    msg = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg, null);
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                    this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                    data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData((String)"challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(0), (Integer)new Integer(0), (String)"DENIED", (long)3L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException pfe) {
                        Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                        String failmsg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(failmsg, pfe);
                    }
                }
                throw new NO_PERMISSION("The Subject returned from authentication is null.", 1229079296, CompletionStatus.COMPLETED_NO);
            }
            this.csiUtil.getCurrent().initialize_requestor_context(received_subject);
            if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") && sessionEntry != null) {
                try {
                    Map tokenMap = ContextManagerFactory.getInstance().getPropagationTokens();
                    if (tokenMap != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting propagation token(s) into session.");
                        }
                        sessionEntry.set_propagation_token_map(tokenMap);
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.authenticateSecurityTokens", "4722", new Object[]{this});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error setting propagation token into session.", new Object[]{e});
                    }
                }
            }
        } else {
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 7);
                sessionEntry.set_session_state(7);
            }
            if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                msg = "security.audit.service.context.error";
                auditService.processAuditFailure(msg, null);
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "DENIED")) {
                this.princ = auditData != null && auditData.getReceivedSubject() != null ? ((Principal)auditData.getReceivedSubject().getPrincipals().toArray()[0]).getName() : null;
                data = DataHelper.buildSessionData((String)new Long(auditData.getStatefulContextId()).toString(), null, (String)auditData.getRemoteHost(), (String)new Integer(auditData.getRemotePort()).toString());
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData((String)providerName, (String)auditData.getOperation(), (String)this.princ, (String)auditData.getTransportPrincipal(), (String)"denied", (String)auditData.getOperation(), (String)"ORB", (Long)new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData((String)lastTrailId, (String[])eventTrailIds, (Date)new Date(), (long)new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData((String)auditService.getFirstCaller(), (String[])auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData((String)auditService.getDomain(), (String)auditService.getRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData((String)DataHelper.convertRegistryInfoType((String)this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnData((String)"challengeResponse");
                contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                data = DataHelper.buildProviderData((String)auditData.getProviderName(), (String)new Boolean(auditData.getProviderSuccessful()).toString());
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData((String)"UNSUCCESSFUL", (Integer)new Integer(0), (Integer)new Integer(0), (String)"DENIED", (long)3L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.JSAS1503E", new Object[]{pfe});
                    String failmsg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(failmsg, pfe);
                }
            }
            throw new NO_PERMISSION("The security context is null after authentication.", 1229079296, CompletionStatus.COMPLETED_NO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticateSecurityTokens", received_subject);
        }
        return received_subject;
    }

    protected void finishSessionProcessing(SecurityContextImpl secCtx, Subject received_subject, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey, boolean secTransportOnly, Map j2eeName) {
        CSIv2Config csiv2;
        String logMsg;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "finishSessionProcessing", new Object[]{secCtx, received_subject, sessionEntry, new Long(stateful_context_id), connKey, new Boolean(secTransportOnly), this});
            }
            logMsg = null;
            csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && sessionEntry != null && stateful_context_id != 0L) {
                if (secCtx != null) {
                    secCtx.set_server_conn_key(connKey);
                    sessionEntry.set_security_context_holder(secCtx);
                    this.sessionMgr.csi_server_session_status_update(stateful_context_id, connKey, 1);
                }
            } else if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && secTransportOnly && received_subject != null) {
                this.sessionMgr.csi_set_connection_cred(connKey, received_subject);
                if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled")) {
                    try {
                        Map tokenMap = ContextManagerFactory.getInstance().getPropagationTokens();
                        if (tokenMap != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting propagation token(s) for connection.");
                            }
                            this.sessionMgr.csi_set_connection_propagation_token_map(connKey, tokenMap);
                        }
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.finishSessionProcessing", "4872", new Object[]{this});
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug(tc, "Error setting propagation token for connection.", new Object[]{e});
                    }
                }
            }
        }
        if (!secTransportOnly) {
            if (secCtx != null) {
                this.csiUtil.getCurrent().setSecurityContext(secCtx);
            }
        } else {
            Tr.debug(tc, "Security transport only request. No security context set for reply.");
        }
        String trace_username = null;
        if (j2eeName != null && csiv2.getBoolean("com.ibm.CSI.rmiInboundMappingEnabled")) {
            WSCredential wsCred;
            logMsg = "*** Credential Mapping ***";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, logMsg);
            }
            if (tc.isDebugEnabled()) {
                try {
                    wsCred = SubjectHelper.getWSCredentialFromSubject(received_subject);
                    trace_username = wsCred.getSecurityName();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            received_subject = this.mapAuthenticatedSubject(received_subject, j2eeName);
            if (tc.isDebugEnabled()) {
                try {
                    wsCred = SubjectHelper.getWSCredentialFromSubject(received_subject);
                    String username = wsCred.getSecurityName();
                    logMsg = "Mapped authenticated remote user: " + trace_username + " to: " + username;
                    Tr.debug(tc, logMsg);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.csiUtil.getCurrent().initialize_requestor_context(received_subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finishSessionProcessing");
        }
    }

    public boolean is_local_server_request(ServerRequestInfo info) {
        if (((ExtendedServerRequestInfo)info).isLocal()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local ORB request.");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Remote ORB request.");
        }
        return false;
    }

    public void receive_request_local(ServerRequestInfo info) throws ForwardRequest {
    }

    org.omg.IOP.ServiceContext getPrivateReceiveRequestServiceContextFromFilter(ServerRequestInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateServiceContextFromFilter", new Object[]{info, this});
        }
        org.omg.IOP.ServiceContext sc = null;
        try {
            sc = info.get_request_service_context(1229081892);
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        if (tc.isDebugEnabled() && sc == null) {
            Tr.debug(tc, "Private service context not found.");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found private service context.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateReceiveRequestServiceContextFromFilter", sc);
        }
        return sc;
    }

    public void removePrivateContext(GIOPMessageContext gmc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePrivateContext", new Object[]{gmc, this});
        }
        try {
            boolean removed;
            ServiceContextList scl = gmc.getServiceContexts();
            if (scl != null && (removed = scl.remove(1229081892)) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed private service context from message context.");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePrivateContext");
        }
    }

    public void removeSeedContext(GIOPMessageContext gmc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSeedContext", new Object[]{gmc, this});
        }
        try {
            boolean removed;
            ServiceContextList scl = gmc.getServiceContexts();
            if (scl != null && (removed = scl.remove(1229081891)) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed seed service context from message context.");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSeedContext");
        }
    }

    org.omg.IOP.ServiceContext getSeedServiceContext(ServerRequestInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSeedServiceContext", new Object[]{info, this});
        }
        org.omg.IOP.ServiceContext sc = null;
        try {
            sc = info.get_request_service_context(1229081891);
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        if (tc.isDebugEnabled() && sc == null) {
            Tr.debug(tc, "Seed service context not found.");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found seed service context.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSeedServiceContext", sc);
        }
        return sc;
    }

    protected void finishSessionProcessingForFilter(ServerRequestInfo info, SecurityContextImpl secCtx, Subject received_subject, SessionEntry sessionEntry, long stateful_context_id, ServerConnectionKey connKey, boolean secTransportOnly, List tokenHolderList) throws Exception {
        byte[] session_bytes;
        block27: {
            Map tokenMap;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "finishSessionProcessingForFilter", new Object[]{info, secCtx, received_subject, sessionEntry, new Long(stateful_context_id), connKey, new Boolean(secTransportOnly), this});
            }
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && secCtx != null && sessionEntry != null && stateful_context_id != 0L) {
                byte[] opaque_token;
                if (received_subject != null && csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") && (opaque_token = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(received_subject)) != null) {
                    WSCredential wsCred;
                    sessionEntry.set_opaque_authz_token(opaque_token);
                    EstablishContext ec = sessionEntry.get_ec_message();
                    boolean identity_assertion_enabled = false;
                    if (ec != null) {
                        IdentityToken ittToken = ec.identity_token;
                        boolean bl = identity_assertion_enabled = ittToken.discriminator() != 0;
                    }
                    if (!identity_assertion_enabled && (wsCred = SubjectHelper.getWSCredentialFromSubject(received_subject)) != null) {
                        WSSecurityContextFactory wsFactory = WSSecurityContextFactory.getInstance();
                        WSSecurityContext wsSecContext = null;
                        wsSecContext = wsCred.isBasicAuth() ? wsFactory.createContext("oid:2.23.130.1.1.1") : wsFactory.createContext(wsCred.getOID());
                        String realm = null;
                        realm = OID.compareOIDs((String)wsCred.getOID(), (String)"oid:1.2.840.113554.1.2.2") ? SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getString("krb5Realm") : ctxMgr.getDefaultRealm();
                        byte[] gssInitToken = wsSecContext.initSecContext(received_subject, wsCred.getHostName(), realm);
                        if (gssInitToken != null) {
                            GSSFactory _gFactory = null;
                            _gFactory = wsCred.isBasicAuth() ? new GSSFactory("oid:2.23.130.1.1.1") : new GSSFactory(wsCred.getOID());
                            byte[] client_auth_token = _gFactory.encodeGSSToken(gssInitToken);
                            if (client_auth_token != null && ec != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting encoded bytes for in_token.");
                                }
                                sessionEntry.set_in_token(client_auth_token);
                                ec.client_authentication_token = client_auth_token;
                                sessionEntry.set_ec_message(ec);
                            }
                        }
                    }
                }
                secCtx.set_server_conn_key(connKey);
                sessionEntry.set_security_context_holder(secCtx);
                sessionEntry.set_session_state(1);
                if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled")) {
                    try {
                        tokenMap = ctxMgr.getPropagationTokens();
                        if (tokenMap != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting propagation token(s) for connection.");
                            }
                            sessionEntry.set_propagation_token_map(tokenMap);
                            String cacheKey = this.getTokenHolderCacheKey(tokenHolderList);
                            if (cacheKey != null) {
                                ctxMgr.addPropagationTokensToCacheObject(cacheKey, tokenMap);
                            }
                        }
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.finishSessionProcessingForFilter", "5233", new Object[]{this});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error setting propagation token for connection.", new Object[]{e});
                        }
                    }
                }
            } else if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && secTransportOnly && received_subject != null) {
                this.sessionMgr.csi_set_connection_cred(connKey, received_subject);
                if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled")) {
                    try {
                        tokenMap = ctxMgr.getPropagationTokens();
                        if (tokenMap != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting propagation token(s) for connection.");
                            }
                            sessionEntry.set_propagation_token_map(tokenMap);
                        }
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.finishSessionProcessingForFilter", "5259", new Object[]{this});
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "Error setting propagation token for connection.", new Object[]{e});
                    }
                }
            }
        }
        if (!secTransportOnly) {
            if (secCtx != null) {
                this.csiUtil.getCurrent().setSecurityContext(secCtx);
            }
        } else {
            Tr.debug(tc, "Security transport only request. No security context set for reply.");
        }
        if ((session_bytes = sessionEntry.getBytes()) != null) {
            org.omg.IOP.ServiceContext sc = new org.omg.IOP.ServiceContext(1229081892, session_bytes);
            info.add_reply_service_context(sc, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finishSessionProcessingForFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterReceiveRequest(GIOPConnectionContext gcc, GIOPMessageContext gmc, ConnectionStateElement cse) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doFilterReceiveRequest", new Object[]{gcc, gmc, cse, this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Request ID: " + Integer.toString(gmc.getRequestId()));
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        AuditData auditData = this.initializeAuditService("<unknown operation>");
        ConnectionInformationImpl connectionInfo = (ConnectionInformationImpl)this.myVault.getSecurityConnectionInterceptor().getServerConnectionData(gcc);
        if (connectionInfo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectionInfo object is null from the ORB.");
            }
            throw new INTERNAL("ConnectionInfo object is null from the ORB.", 1229066420, CompletionStatus.COMPLETED_NO);
        }
        String remoteHost = connectionInfo.getRemoteHost();
        int remotePort = connectionInfo.getRemotePort();
        String remoteConnectionId = Long.toString(connectionInfo.getConnectionCreationTime());
        SSLSession session = null;
        SSLConnectionContext sslConnContext = gcc.getSSLContext();
        if (sslConnContext != null) {
            session = sslConnContext.getSession();
        }
        X509Certificate[] cert_chain = null;
        if (session != null) {
            try {
                cert_chain = (X509Certificate[])session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        com.ibm.CORBA.iiop.ServiceContext csiv2_sc = null;
        try {
            csiv2_sc = gmc.getServiceContexts().get(15);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        SASContextBody msg = this.getCSIv2MessageFromServiceContext(csiv2_sc);
        if (remoteHost != null) {
            auditData.setRemoteHost(remoteHost);
        }
        auditData.setRemotePort(remotePort);
        if (cert_chain != null && cert_chain.length > 0) {
            auditData.setTransportPrincipal(cert_chain[0].getSubjectDN().getName());
        }
        SessionEntry sessionEntry = null;
        byte[] contextBytes = null;
        SecurityContextImpl secCtx = this.csiUtil.get_security_context_impl("", "");
        sessionEntry = this.handleStatefulContextFromFilter(msg, cert_chain, auditData, remoteHost, remotePort, remoteConnectionId, secCtx, gmc);
        if (sessionEntry != null) {
            String authenticateInCRandSR = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.krb.authenticateInCRandSR");
            if (authenticateInCRandSR != null && authenticateInCRandSR.equalsIgnoreCase("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The authenticateInCRandSR property is set to true. Will proceed to authenticate with the ticket.");
                }
                EstablishContext ec = sessionEntry.get_ec_message();
                String clientAuthOID = null;
                if (ec != null) {
                    this.csiUtil.print_ec_message(ec, "doFilterReceiveRequest");
                    clientAuthOID = GSSFactory.getMechOIDFromGSSToken((byte[])ec.client_authentication_token);
                }
                if (OID.compareOIDs(clientAuthOID, (String)"oid:1.2.840.113554.1.2.2")) {
                    WSSecurityContext ctx = WSSecurityContextFactory.getInstance().createContext(clientAuthOID);
                    sessionEntry.set_security_context_holder(secCtx);
                    Subject receivedSubject = secCtx.getClientSubject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "receivedSubject: " + receivedSubject);
                    }
                    if (receivedSubject == null) {
                        GSSFactory _gFactory = new GSSFactory(clientAuthOID);
                        byte[] token = _gFactory.decodeGSSToken(ec.client_authentication_token);
                        boolean pushed = false;
                        WSSecurityContextResult wsresult = null;
                        try {
                            String uuid;
                            if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent() && (uuid = sessionEntry.get_managed_node_uuid()) != null && uuid.length() > 0) {
                                pushed = CSIServerRIBase.pushAdminContext(uuid);
                            }
                            wsresult = ctx.acceptSecContext(token, null, clientAuthOID);
                        }
                        catch (Exception ex) {
                        }
                        finally {
                            if (pushed) {
                                CSIServerRIBase.popAdminContext();
                            }
                        }
                        if (wsresult != null && wsresult.getSubject() != null) {
                            receivedSubject = wsresult.getSubject();
                        }
                    }
                    secCtx.setClientSubject(receivedSubject);
                    WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(receivedSubject);
                    if (OID.compareOIDs((String)wsCred.getOID(), (String)"oid:1.2.840.113554.1.2.2")) {
                        if (!SubjectHelper.isWSCredentialValid(receivedSubject, true)) {
                            throw new NO_PERMISSION("The credential for the subject " + receivedSubject + " is no longer valid. The request will be retried.", 1229079302, CompletionStatus.COMPLETED_NO);
                        }
                        if (wsCred != null && msg.discriminator() == 5) {
                            WSSecurityContextFactory wsFactory = WSSecurityContextFactory.getInstance();
                            WSSecurityContext wsSecContext = null;
                            wsSecContext = wsCred.isBasicAuth() ? wsFactory.createContext("oid:2.23.130.1.1.1") : wsFactory.createContext(wsCred.getOID());
                            byte[] gssInitToken = wsSecContext.initSecContext(receivedSubject, wsCred.getHostName(), SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getString("krb5Realm"));
                            if (gssInitToken != null) {
                                GSSFactory _gFactory = null;
                                _gFactory = wsCred.isBasicAuth() ? new GSSFactory("oid:2.23.130.1.1.1") : new GSSFactory(wsCred.getOID());
                                byte[] client_auth_token = _gFactory.encodeGSSToken(gssInitToken);
                                if (client_auth_token != null && ec != null) {
                                    sessionEntry.set_in_token(client_auth_token);
                                    ec.client_authentication_token = client_auth_token;
                                    sessionEntry.set_ec_message(ec);
                                }
                            }
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The authenticateInCRandSR property is set to false. The ticket was not authenticated in the control region.");
            }
            contextBytes = sessionEntry.getBytes();
        }
        if (contextBytes != null) {
            ServiceContext sc = new ServiceContext(1229081892, contextBytes);
            try {
                ServiceContextList scl = gmc.getServiceContexts();
                if (scl != null) {
                    scl.add((com.ibm.CORBA.iiop.ServiceContext)sc, true);
                    gmc.setServiceContexts(scl);
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doFilterReceiveRequest");
        }
    }

    public Subject loginWithSeed(SecurityExecutionEnvironment seed, Map appContext) throws WSLoginFailedException, WSSecurityException {
        Subject seedSubject;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loginWithSeed", new Object[]{seed});
            }
            seedSubject = null;
            ContextManager contextMgr = ContextManagerFactory.getInstance();
            if (seed.isUnauthenticatedCredential()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting unauthenticated Subject from seed.");
                }
                seedSubject = contextMgr.createUnauthenticatedSubject();
            } else if (seed.isServerCredential()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting server Subject from seed.");
                }
                seedSubject = contextMgr.getServerSubject();
            } else {
                byte[] krbTokenBytes;
                String authMech;
                Hashtable loginHash = seed.getLoginHashtable();
                seedSubject = new Subject();
                seedSubject.getPublicCredentials().add(loginHash);
                String securityName = seed.getSecurityName();
                String realmName = seed.getRealm();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Building subject from seed hashtable login.");
                }
                seedSubject = contextMgr.login(realmName, securityName, null, null, null, appContext, seedSubject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loginWithSeed authenticated " + securityName);
                }
                if ("KRB5".equals(authMech = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getType()) && (krbTokenBytes = seed.getKrbAuthnToken()) != null) {
                    KRBAuthnToken krbToken = WSKRBAuthnTokenFactoryFactory.getFactory().createToken(krbTokenBytes);
                    seedSubject.getPrivateCredentials().add(krbToken);
                    try {
                        KerberosPrincipal krbPrinc = new KerberosPrincipal(krbToken.getTokenPrincipal());
                        seedSubject.getPrincipals().add(krbPrinc);
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.loginWithSeed", "5588");
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Exception adding Kerberos principal to Subject.", new Object[]{e});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loginWithSeed", seedSubject);
        }
        return seedSubject;
    }

    public void doFilterSendReply(GIOPConnectionContext gcc, GIOPMessageContext gmc, ConnectionStateElement cse) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doFilterSendReply", new Object[]{gcc, gmc, cse, this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Request ID: " + Integer.toString(gmc.getRequestId()));
        }
        try {
            com.ibm.CORBA.iiop.ServiceContext sc = null;
            try {
                sc = gmc.getServiceContexts().get(1229081892);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            if (sc != null) {
                SessionEntry sessionEntryFromSR;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found private reply service context in filter.  Updating session entry.");
                }
                if ((sessionEntryFromSR = new SessionEntry(sc.getContextData())) != null) {
                    long stateful_context_id = sessionEntryFromSR.get_client_context_id();
                    boolean renegotiate_to_stateless = sessionEntryFromSR.get_renegotiate_to_stateless();
                    if (renegotiate_to_stateless || stateful_context_id == 0L) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Returning without session update, session is stateless.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "doFilterSendReply");
                        }
                        return;
                    }
                    ConnectionInformationImpl connectionInfo = (ConnectionInformationImpl)this.myVault.getSecurityConnectionInterceptor().getServerConnectionData(gcc);
                    String remoteHost = connectionInfo.getRemoteHost();
                    int remotePort = connectionInfo.getRemotePort();
                    String remoteConnectionId = Long.toString(connectionInfo.getConnectionCreationTime());
                    ServerConnectionKey connKey = new ServerConnectionKey(remoteConnectionId, remoteHost, remotePort);
                    EstablishContext ec = sessionEntryFromSR.get_ec_message();
                    String clientAuthOID = GSSFactory.getMechOIDFromGSSToken((byte[])ec.client_authentication_token);
                    String authenticateInCRandSR = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.krb.authenticateInCRandSR");
                    if (authenticateInCRandSR != null && authenticateInCRandSR.equalsIgnoreCase("true")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The authenticateInCRandSR property is set to true. Will proceed to authenticate with the ticket.");
                        }
                        if (OID.compareOIDs((String)clientAuthOID, (String)"oid:1.2.840.113554.1.2.2")) {
                            SASContextBody msg = new SASContextBody();
                            msg.establish_msg(ec);
                            boolean internalLookup = true;
                            SessionEntry sessionEntryFromCR = this.sessionMgr.csi_server_session_lookup(ec.client_context_id, connKey, msg, internalLookup);
                            if (sessionEntryFromCR != null) {
                                SecurityContextImpl secCtx_sr;
                                SecurityContextImpl secCtx_cr = sessionEntryFromCR.get_security_context_holder();
                                Subject crSubject = null;
                                if (secCtx_cr != null) {
                                    crSubject = secCtx_cr.getClientSubject();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Subject from cr: " + crSubject);
                                    }
                                }
                                if ((secCtx_sr = sessionEntryFromSR.get_security_context_holder()) == null) {
                                    secCtx_sr = this.csiUtil.get_security_context_impl("", "");
                                    sessionEntryFromSR.set_security_context_holder(secCtx_sr);
                                    secCtx_sr.setClientSubject(crSubject);
                                }
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The authenticateInCRandSR property is set to false. The ticket was not authenticated in the control region.");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating session from SR with: " + sessionEntryFromSR);
                    }
                    this.sessionMgr.csi_server_session_update(stateful_context_id, connKey, sessionEntryFromSR);
                }
            }
        }
        catch (BAD_PARAM e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doFilterSendReply");
        }
    }

    void getTransportLayerData(SessionEntry sessionEntry, GIOPMessageContext gmc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransportLayerData", new Object[]{sessionEntry, gmc, this});
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        OutOfBandDataHolder zmc = (OutOfBandDataHolder)gmc;
        byte[] transportLayerData = null;
        byte[] transportLayerDataType = null;
        if (gmc != null && zmc != null) {
            OutOfBandData oobData = zmc.getOutOfBandData();
            if (oobData != null && (transportLayerDataType = oobData.getChunk(3)) != null && transportLayerDataType.length > 0) {
                if (transportLayerDataType[0] == 1) {
                    String activeRegistry = csiv2.getString("com.ibm.CSI.activeUserRegistry");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Active user registry: " + activeRegistry);
                    }
                    if (activeRegistry != null && activeRegistry.equals("LOCALOS")) {
                        sessionEntry.set_transport_layer_data_type(transportLayerDataType[0]);
                        transportLayerData = oobData.getChunk(2);
                        if (transportLayerData != null && transportLayerData.length > 0) {
                            for (int i = 0; i < transportLayerData.length; ++i) {
                                transportLayerData[i] = Translate.toAscii((byte)transportLayerData[i]);
                            }
                            sessionEntry.set_transport_layer_data(new String(transportLayerData).trim().getBytes());
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unknown transport layer data type");
                }
            }
            if (tc.isDebugEnabled()) {
                if (transportLayerDataType != null && transportLayerDataType.length > 0) {
                    Tr.debug(tc, "type: " + transportLayerDataType + "\ndata: " + (transportLayerData == null ? "null" : new String(transportLayerData)));
                } else {
                    Tr.debug(tc, "No transport layer data");
                }
                Tr.exit(tc, "getTransportLayerData");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No transport layer data (zmc or gmc is null).");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTransportLayerData");
            }
        }
    }

    public byte[] getTransportLayerDataType(GIOPMessageContext gmc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransportLayerDataType", new Object[]{gmc, this});
        }
        byte[] transportLayerDataType = null;
        OutOfBandDataHolder zmc = (OutOfBandDataHolder)gmc;
        if (gmc != null && zmc != null) {
            OutOfBandData oobData = zmc.getOutOfBandData();
            if (oobData != null) {
                transportLayerDataType = oobData.getChunk(3);
                if (transportLayerDataType != null && transportLayerDataType.length == 0) {
                    transportLayerDataType = null;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OutOfBandData is null");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "GIOPMessageContext is null");
        }
        if (tc.isDebugEnabled()) {
            if (transportLayerDataType == null) {
                Tr.debug(tc, "transport layer data type is null");
            } else {
                Tr.debug(tc, "transport layer data type non-null", new Object[]{transportLayerDataType});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransportLayerDataType", transportLayerDataType);
        }
        return transportLayerDataType;
    }

    private String getTokenHolderCacheKey(List tokenHolderList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenHolderCacheKey", new Object[]{tokenHolderList});
        }
        String cacheKeyString = null;
        if (tokenHolderList != null) {
            for (int i = 0; i < tokenHolderList.size(); ++i) {
                byte[] cacheKeyBytes;
                TokenHolder th = (TokenHolder)tokenHolderList.get(i);
                if (!th.getName().equals("com.ibm.wsspi.security.cred.cacheKey") || (cacheKeyBytes = th.getBytes()) == null) continue;
                cacheKeyString = StringBytesConversion.getConvertedString((byte[])cacheKeyBytes);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found cache key from token holder list: " + cacheKeyString);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenHolderCacheKey", cacheKeyString);
        }
        return cacheKeyString;
    }

    protected Map getJ2EEName(byte[] userKeyBytes) {
        Map map = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEName", userKeyBytes);
        }
        if (this.appContextMgr != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "to get J2EE Name");
            }
            try {
                map = this.appContextMgr.getJ2EEName(userKeyBytes);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getJ2EEName caught exception =  " + e.getMessage());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appContextManager is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEName");
        }
        return map;
    }

    protected Subject mapAuthenticatedSubject(Subject received_subject, Map j2eeName) throws NO_PERMISSION {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        String logMsg = "";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapAuthenticatedSubject", j2eeName);
        }
        if (csiv2.getString("com.ibm.CSI.rmiInboundMappingConfig") == null || csiv2.getString("com.ibm.CSI.rmiInboundMappingConfig").length() == 0) {
            if (tc.isDebugEnabled()) {
                logMsg = "rmiInboundMappingConfig is not defined: do nothing";
                Tr.debug(tc, logMsg);
            }
            return received_subject;
        }
        if (csiv2.getBoolean("com.ibm.CSI.rmiInboundMappingEnabled")) {
            try {
                Subject mapped_subject = new Subject();
                WSSubjectWrapperImpl subjectWrapper = new WSSubjectWrapperImpl(received_subject);
                mapped_subject.getPrivateCredentials().add(subjectWrapper);
                ContextManager ctxMgr = ContextManagerFactory.getInstance();
                mapped_subject = ctxMgr.login(ctxMgr.getDefaultRealm(), null, null, csiv2.getString("com.ibm.CSI.rmiInboundMappingConfig"), null, null, j2eeName, mapped_subject);
                return mapped_subject;
            }
            catch (WSLoginFailedException le) {
                if (tc.isDebugEnabled()) {
                    logMsg = "WSLoginFailedException occurred in authenticateSecurityTokens> mappping: " + le.getMessage();
                    Tr.debug(tc, logMsg);
                    Tr.debug(tc, "Exception caught: " + le.getMessage());
                }
                Manager.Ffdc.log(le, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.receive_request", "5981", new Object[]{this});
                throw new NO_PERMISSION(le.getMessage(), 1229079311, CompletionStatus.COMPLETED_NO);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    logMsg = "Exception occurred in authenticateSecurityTokens> mappping: " + e.getMessage();
                    Tr.debug(tc, logMsg);
                    Tr.debug(tc, "Exception caught: " + e.getMessage());
                }
                Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase.receive_request", "5995", new Object[]{this});
                throw new NO_PERMISSION(e.getMessage(), 1229079311, CompletionStatus.COMPLETED_NO);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapAuthenticatedSubject");
        }
        return null;
    }

    static String getManagedNodeUUID(ServerRequestInfo reqInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagedNodeUUID ServerRequestInfo");
        }
        ExtendedServerRequestInfo info = (ExtendedServerRequestInfo)reqInfo;
        String uuid = CSIServerRIBase.getManagedNodeUUID(info.getTarget());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeUUID ServerRequestInfo: " + uuid);
        }
        return uuid;
    }

    static String getManagedNodeUUID(IORInfo iorInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagedNodeUUID IORInfo");
        }
        String uuid = CSIServerRIBase.getManagedNodeUUID(((ExtendedIORInfo)iorInfo).getTarget());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeUUID IORInfo: " + uuid);
        }
        return uuid;
    }

    public static String getManagedNodeUUID(Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagedNodeUUID Object");
        }
        String uuid = null;
        if (obj == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target is null");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target is " + obj.getClass().getName());
            }
            if (obj instanceof Tie) {
                Tie tie = (Tie)obj;
                Remote tieTarget = tie.getTarget();
                if (tieTarget == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tie's target is null");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tie's target is " + tieTarget.getClass().getName());
                    }
                    if (tieTarget instanceof RMIServerImpl) {
                        RMIServerImpl impl = (RMIServerImpl)tieTarget;
                        MBeanServer mbeanServer = impl.getMBeanServer();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "MBean server is: " + mbeanServer);
                        }
                        if (mbeanServer != null) {
                            try {
                                uuid = (String)mbeanServer.getAttribute(interceptorObjName, "uuid");
                            }
                            catch (Throwable ex) {
                                Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRI.getManagedNodeUUID", "%C");
                            }
                        }
                    } else if (tieTarget instanceof RMIConnectionImpl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "invoking getAttribute on javax.management.remote.rmi.RMIConnectionImpl");
                        }
                        RMIConnectionImpl impl = (RMIConnectionImpl)tieTarget;
                        try {
                            uuid = (String)impl.getAttribute(interceptorObjName, "uuid", null);
                        }
                        catch (Throwable ex) {
                            Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRI.getManagedNodeUUID", "%C");
                        }
                    } else {
                        Class<?> tieTargetClz = tieTarget.getClass();
                        if (rmiConnectorClz.isAssignableFrom(tieTargetClz)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "invoking getAttribute on com.ibm.ws.management.connector.rmi.RMIConnector");
                            }
                            try {
                                Object[] args = new Object[]{interceptorObjName, "uuid"};
                                uuid = (String)getAttributeMethod.invoke((Object)tieTarget, args);
                            }
                            catch (Throwable ex) {
                                Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRI.getManagedNodeUUID", "%C");
                            }
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeUUID Object", uuid);
        }
        return uuid;
    }

    static boolean pushAdminContext(String uuid) {
        try {
            Boolean ret = (Boolean)pushMethod.invoke(null, uuid);
            return ret;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRI.pushAdminContext", "%C");
            return false;
        }
    }

    static void popAdminContext() {
        try {
            popMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRI.popAdminContext", "%C");
        }
    }

    static {
        try {
            interceptorObjName = new ObjectName("WebSphere:type=AdminAgentInterceptor");
            rmiConnectorClz = Class.forName("com.ibm.ws.management.connector.rmi.RMIConnector");
            getAttributeMethod = rmiConnectorClz.getMethod("getAttribute", ObjectName.class, String.class);
            adminContextClz = Class.forName("com.ibm.websphere.management.AdminContext");
            pushMethod = adminContextClz.getMethod("push", String.class);
            popMethod = adminContextClz.getMethod("pop", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        auditService = null;
        cert_chain_private_token_name = "CERT_CHAIN_PRIVATE_TOKEN";
        attribute_layer_private_token_name = "ATTRIBUTE_LAYER_PRIVATE_TOKEN";
        client_auth_layer_private_token_name = "CLIENT_AUTH_LAYER_PRIVATE_TOKEN";
        session_info_private_token_name = "SESSION_INFO_PRIVATE_TOKEN";
    }
}

