/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRI;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SecurityExecutionEnvironment;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CSI.ContextError;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.RequestInfo;

public class CSIClientRIForCFW
extends CSIClientRIBase {
    private static final TraceComponent tc = Tr.register(CSIClientRIForCFW.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private CSIClientRI clientRI = null;
    private CSICredentialsManager credsMgr = new CSICredentialsManager();

    public void pre_init(ORBInitInfo info) {
        CSIv2Config csiv2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pre_init", info);
        }
        if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CORBA.securityEnabled")) {
            try {
                if (PlatformHelperFactory.getPlatformHelper().isClientJvm()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering simple client request interceptor");
                    }
                    this.clientRI = new CSIClientRI();
                    this.clientRI.pre_init(info);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering client request interceptor for CFW");
                    }
                    super.pre_init(info);
                    ((ExtendedORBInitInfo)info).add_client_request_interceptor((ClientRequestInterceptor)this, false);
                }
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, (java.lang.Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIForCFW.pre_init", "108", new java.lang.Object[]{this});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An exception has been thrown registering the interceptor.", new java.lang.Object[]{ex});
                }
                throw (INTERNAL)new INTERNAL().initCause((Throwable)ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void post_init(ORBInitInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "post_init", info);
        }
        if (this.clientRI != null) {
            this.clientRI.post_init(info);
        } else {
            super.post_init(info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "post_init");
        }
    }

    public void send_request(ClientRequestInfo info) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_request", info);
        }
        if (tc.isDebugEnabled()) {
            this.entry(info);
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        SecurityExecutionEnvironment seed = null;
        Subject invocation_subject = null;
        SessionEntry sessionEntry = null;
        ClientSessionKey clientSessionKey = null;
        String connectionKey = null;
        long stateful_context_id = 0L;
        ContextManager contextMgr = ContextManagerFactory.getInstance();
        sessionEntry = (SessionEntry)contextMgr.get(Integer.toString(1229081892));
        contextMgr.put(Integer.toString(1229081892), null);
        if (sessionEntry == null) {
            try {
                ServiceContext sc;
                CSIv2EffectivePerformPolicy csiv2EffectivePolicy;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Session entry not found from filter, generating SEED (first pass).");
                }
                if ((csiv2EffectivePolicy = this.getEffectivePolicyFromClientRequestInfo(info)) != null) {
                    boolean isUnprotectedNamingMethod = false;
                    if (csiv2EffectivePolicy.isNamingReadUnprotected()) {
                        isUnprotectedNamingMethod = this.namingReadUnprotected(info, csiv2EffectivePolicy);
                    }
                    if (isUnprotectedNamingMethod) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "Naming Read is unprotected and this is a naming method, so returning without creating SEED.");
                        }
                        return;
                    }
                }
                invocation_subject = CSICredentialsManager.getInstance().getInvocationSubject();
                if (csiv2.getBoolean("com.ibm.CSI.rmiOutboundMappingEnabled")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*** To unwrap innocation subject ***");
                    }
                    invocation_subject = this.unwrapSubject(invocation_subject);
                }
                seed = new SecurityExecutionEnvironment(invocation_subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Seed created, adding as private service context to flow to filter.");
                }
                if ((sc = new ServiceContext(1229081891, seed.getBytes())) != null) {
                    info.add_request_service_context(sc, true);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "send_request(seed)");
                }
                return;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception trying to create private service context.", new java.lang.Object[]{e});
                }
                if (e instanceof NO_PERMISSION) {
                    throw (NO_PERMISSION)e;
                }
                throw new NO_PERMISSION("Cannot create seed service context due to exception: \n" + e.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session entry found from filter (second pass).");
        }
        try {
            final CSIv2EffectivePerformPolicy csiv2EffectivePolicy = sessionEntry.get_effective_policy();
            if (csiv2EffectivePolicy != null) {
                boolean isUnprotectedNamingMethod = false;
                if (csiv2EffectivePolicy.isNamingReadUnprotected()) {
                    isUnprotectedNamingMethod = this.namingReadUnprotected(info, csiv2EffectivePolicy);
                }
                if (isUnprotectedNamingMethod) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Naming read is unprotected and this is a naming method, so returning without authenticating.");
                    }
                    return;
                }
                if (csiv2EffectivePolicy.performClientAuthentication() || csiv2EffectivePolicy.performIdentityAssertion()) {
                    ServiceContext sc;
                    stateful_context_id = sessionEntry.get_client_context_id();
                    clientSessionKey = sessionEntry.get_client_session_key();
                    this.sessionMgr.update_client_session(clientSessionKey, sessionEntry);
                    connectionKey = clientSessionKey.get_connection_key();
                    final String targetRealmName = RealmSecurityName.getRealmOrReturnSecurityName(csiv2EffectivePolicy.getTargetSecurityName(), csiv2EffectivePolicy.getPerformClientAuthMechOID(), csiv2EffectivePolicy.getTargetAuthMechOID());
                    this.myVault.put_effective_policy(info.request_id(), csiv2EffectivePolicy);
                    invocation_subject = csiv2EffectivePolicy.performIdentityAssertion() ? CSICredentialsManager.getInstance().getInvocationSubject() : (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        CSICredentialsManager credsMgr = CSICredentialsManager.getInstance();

                        public java.lang.Object run() throws Exception {
                            return this.credsMgr.getClientSubject(targetRealmName, csiv2EffectivePolicy);
                        }
                    });
                    if (invocation_subject == null) {
                        invocation_subject = contextMgr.createUnauthenticatedSubject();
                    } else if (csiv2.getBoolean("com.ibm.CSI.rmiOutboundMappingEnabled")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "*** To unwrap innocation subject ***");
                        }
                        invocation_subject = this.unwrapSubject(invocation_subject);
                    }
                    if (sessionEntry.get_renegotiate_to_stateless()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Request is renegotiated to stateless, session returned from filter.");
                        }
                        stateful_context_id = 0L;
                    }
                    csiv2EffectivePolicy.setStatefulContextID(stateful_context_id);
                    csiv2EffectivePolicy.setClientSessionKey(clientSessionKey);
                    if (csiv2EffectivePolicy.performAuthorizationToken() || csiv2.getBoolean("com.ibm.CSI.rmiOutboundLoginEnabled")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling JAAS login to map or create opaque authorization token.");
                        }
                        invocation_subject = this.mapOutboundOrCreateOAT(invocation_subject, csiv2EffectivePolicy);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Determining which SecurityContext to use (GSSUP or LTPA).");
                    }
                    SecurityContextImpl secCtx = this.determineSecurityContextType(invocation_subject, csiv2EffectivePolicy, connectionKey, this.sessionMgr, sessionEntry);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting the contents of the identity token.");
                    }
                    IdentityToken it = new IdentityToken();
                    this.setIdentityToken(it, invocation_subject, csiv2EffectivePolicy, this.sessionMgr, sessionEntry);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting the contents of the client authentication token and EstablishContext message.");
                    }
                    this.setSecurityContext(info, secCtx, it, invocation_subject, csiv2EffectivePolicy, this.sessionMgr, sessionEntry, targetRealmName);
                    this.csiUtil.setUnauthenticatedToNullIfNeeded();
                    if (csiv2EffectivePolicy.isStateful() && sessionEntry != null && stateful_context_id != 0L) {
                        sessionEntry.set_session_state(6);
                    }
                    if (sessionEntry != null && (sc = new ServiceContext(1229081892, sessionEntry.getBytes())) != null) {
                        info.add_request_service_context(sc, true);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Neither client auth or identity assertion is being performed.  Returning without sending EstablishContext.");
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, (java.lang.Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIForCFW.send_request", "310", new java.lang.Object[]{this});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception trying to create service context.", new java.lang.Object[]{e});
            }
            throw new NO_PERMISSION("Cannot create service context.  Message: " + e.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** SENDING REQUEST ***");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request(establish_context)");
        }
    }

    public void receive_reply(ClientRequestInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_reply");
        }
        if (tc.isDebugEnabled()) {
            this.entry(info);
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.is_local_client_request(info)) {
            this.receive_reply_local(info);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_reply");
            }
            return;
        }
        CSIv2EffectivePerformPolicy csiv2EffectivePolicy = this.myVault.get_effective_policy(info.request_id());
        this.myVault.clear_effective_policy(info.request_id());
        if (csiv2EffectivePolicy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Effective policy is null? " + (csiv2EffectivePolicy == null));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_reply");
            }
            return;
        }
        String class_name = "<unknown>";
        if (info.effective_target() != null) {
            class_name = info.effective_target().getClass().getName();
        }
        if (SecurityConnectionInterceptor.isSpecialNamingMethod(info.operation(), class_name) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(info.operation(), class_name) || ORB.isSpecialMethod((String)info.operation()) && !this.csiUtil.isCORBAAuthRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Special naming method or other corba special method. Return from interceptor.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_reply");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** RECEIVING REPLY ***");
        }
        ServiceContext sc = null;
        SASContextBody msg = null;
        sc = this.csiUtil.get_sc_from_reply((RequestInfo)info);
        if (sc != null) {
            msg = this.csiUtil.get_message_from_sc(sc);
        }
        if (msg != null && msg.discriminator() == 1 && csiv2.getBoolean("com.ibm.CORBA.authenticationRetryEnabled")) {
            this.csiUtil.getCurrent().clear_retry_count();
        }
        if (sc != null && csiv2EffectivePolicy != null && csiv2EffectivePolicy.performClientAuthentication() || csiv2EffectivePolicy.performIdentityAssertion()) {
            com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl secCtx = null;
            secCtx = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.myVault, "");
            secCtx.csi_continue_security_context(info, (SecurityContextImpl)secCtx);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** MESSAGE COMPLETED ***");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    public void receive_reply_local(ClientRequestInfo info) {
    }

    public void receive_exception(ClientRequestInfo info) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_exception");
        }
        if (tc.isDebugEnabled()) {
            this.entry(info);
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.is_local_client_request(info)) {
            this.receive_exception_local(info);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive_exception");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            String detailed_message;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "*** RECEIVING EXCEPTION ***");
            }
            if ((detailed_message = this.csiUtil.read_detailed_message((RequestInfo)info)) != null && !detailed_message.equals("") && tc.isDebugEnabled()) {
                Tr.debug(tc, "The following exception was received from the server: " + detailed_message);
            }
        }
        CSIv2EffectivePerformPolicy csiv2EffectivePolicy = this.myVault.get_effective_policy(info.request_id());
        this.myVault.clear_effective_policy(info.request_id());
        ServiceContext sc = null;
        SASContextBody msg = null;
        ContextError ce = null;
        sc = this.csiUtil.get_sc_from_reply((RequestInfo)info);
        if (sc != null) {
            msg = this.csiUtil.get_message_from_sc(sc);
        }
        if (msg != null && msg.discriminator() == 1) {
            if (csiv2.getBoolean("com.ibm.CORBA.authenticationRetryEnabled")) {
                this.csiUtil.getCurrent().clear_retry_count();
            }
        } else if (msg != null && msg.discriminator() == 4) {
            ce = msg.error_msg();
            if (ce != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client context ID: " + ce.client_context_id);
                }
                this.csiUtil.deserializeRootException(ce.error_token);
            }
            if (info.reply_status() == 1) {
                this.sessionMgr.retry(info);
            }
        }
        if (sc != null && csiv2EffectivePolicy != null && (csiv2EffectivePolicy.performClientAuthentication() || csiv2EffectivePolicy.performIdentityAssertion())) {
            com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl secCtx = null;
            secCtx = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.myVault, "");
            secCtx.csi_continue_security_context(info, (SecurityContextImpl)secCtx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "*** MESSAGE COMPLETED ***");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_exception");
        }
    }

    public void receive_exception_local(ClientRequestInfo info) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo info) throws ForwardRequest {
        ServiceContext private_context;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "receive_other");
            }
            if (tc.isDebugEnabled()) {
                this.entry(info);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "*** RECEIVE OTHER ***");
            }
            CSIv2EffectivePerformPolicy csiv2EffectivePolicy = this.myVault.get_effective_policy(info.request_id());
            this.myVault.clear_effective_policy(info.request_id());
            if (this.is_local_client_request(info)) {
                this.receive_other_local(info);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "receive_other");
                }
                return;
            }
            String class_name = "<unknown>";
            if (info.effective_target() != null) {
                class_name = info.effective_target().getClass().getName();
            }
            private_context = null;
            try {
                private_context = info.get_reply_service_context(1229081892);
            }
            catch (BAD_PARAM e) {
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Did not find SessionEntry service context", (java.lang.Object)e);
            }
        }
        if (private_context != null) {
            SessionEntry sessionEntry = null;
            try {
                sessionEntry = new SessionEntry(private_context.context_data);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found private context, but could not create session entry.", new java.lang.Object[]{e});
                }
                throw new INTERNAL("Error creating SessionEntry from bytes.  Message: " + e.getMessage());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SessionEntry from private service context", sessionEntry);
            }
            if (sessionEntry != null) {
                ContextManager contextMgr = ContextManagerFactory.getInstance();
                contextMgr.put(Integer.toString(1229081892), sessionEntry);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_other");
        }
    }

    public void receive_other_local(ClientRequestInfo info) throws ForwardRequest {
    }

    public void entry(ClientRequestInfo info) {
        if (tc.isDebugEnabled()) {
            StringBuffer logMsg = new StringBuffer(100);
            logMsg.append("Request_id: ").append(info.request_id()).append(", ");
            Object effectiveTarget = info.effective_target();
            if (effectiveTarget != null) {
                logMsg.append("class: ").append(effectiveTarget.getClass().getName()).append(", ");
            }
            logMsg.append("operation: ").append(info.operation());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, logMsg.toString());
            }
        }
    }
}

