/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityL13SupportImpl;

import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SecurityMessages {
    private static final String SEC_MSG_PREFIX = "security.";
    private static ResourceBundle bundle = null;

    public static String getMsg(String key) {
        String st = null;
        try {
            st = bundle.getString(SEC_MSG_PREFIX + key);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, SecurityMessages.class, "com.ibm.ISecurityL13SupportImpl.SecurityMessages.getMsg", "78");
            return null;
        }
        return st;
    }

    public static String getMsg(String key, String fill) {
        Object[] args = new Object[]{fill};
        String st = null;
        try {
            st = MessageFormat.format(bundle.getString(SEC_MSG_PREFIX + key), args);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, SecurityMessages.class, "com.ibm.ISecurityL13SupportImpl.SecurityMessages.getMsg", "97");
            return null;
        }
        return st;
    }

    public static String getMsgOrUseDefault(String id, String defaultMsg) {
        String msg = SecurityMessages.getMsg(id);
        if (msg != null) {
            return msg;
        }
        return defaultMsg;
    }

    public static String getMsgOrUseDefault(String id, String arg1, String defaultMsg) {
        String msg = SecurityMessages.getMsg(id, arg1);
        if (msg != null) {
            return msg;
        }
        return defaultMsg + arg1;
    }

    public static void setLocaleSpecificResourceBundle(Locale locale) {
        if (locale != null) {
            try {
                bundle = ResourceBundle.getBundle("com.ibm.ISecurityL13SupportImpl.sec.properties", locale);
            }
            catch (MissingResourceException e) {
                Manager.Ffdc.log(e, SecurityMessages.class, "com.ibm.ISecurityL13SupportImpl.SecurityMessages.setLocaleSpecificResourceBundle", "149");
                System.out.println("Could not find resource bundle.");
                e.printStackTrace();
            }
        }
    }

    public static String getMsg(String key, Object[] objs) {
        String msg = SecurityMessages.getMsg(key);
        if (msg == null) {
            return null;
        }
        String result = MessageFormat.format(msg, objs);
        return result;
    }

    public static boolean suppressFFDCforKrbSkewError(Throwable t) {
        SecurityConfig secConfig = SecurityObjectLocator.getSecurityConfig();
        return t.getMessage() != null && t.getMessage().contains("major code: 10, minor code: 37") && secConfig != null && !secConfig.getPropertyBool("com.ibm.websphere.security.krb.printFFDC.forSkewError");
    }

    static {
        try {
            bundle = ResourceBundle.getBundle("com.ibm.ISecurityL13SupportImpl.sec");
        }
        catch (MissingResourceException e) {
            Manager.Ffdc.log(e, SecurityMessages.class, "com.ibm.ISecurityL13SupportImpl.SecurityMessages", "61");
            System.out.println("Could not find resource bundle.");
            e.printStackTrace();
        }
    }
}

