/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services.redirector;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.services.redirector.RedirectorController;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orbimpl.MessageUtility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class Redirector {
    private static final String thisClassName = Redirector.class.getName();
    protected InputStream inFromServer;
    protected OutputStream outToServer;
    protected InputStream inFromClient;
    protected OutputStream outToClient;
    protected Socket outputSocket;
    public String my_id;
    public boolean busy = false;
    protected String outServerName;
    protected int outPort;
    protected ServletRequest request;
    protected ServletResponse response;
    protected RedirectorController controller;
    public static final int GIOPBigEndian = 0;
    public static final int GIOPLittleEndian = 1;
    private long _timeStamp = 0L;
    private long timeLastUsed = 0L;
    private long staleSocketThreshold = 0L;
    private long staleSocketThresholdMillis = 0L;
    private boolean connectionTerminated = false;

    public Redirector(String host, int port, long time, RedirectorController inController) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "Redirector(" + host + "," + port + "," + time + ")");
        }
        this._timeStamp = time;
        this.outServerName = host;
        this.outPort = port;
        this.controller = inController;
        this.my_id = Redirector.buildID(host, port, time);
        this.setupServerConnection();
        this.busy = false;
        this.staleSocketThreshold = this.controller.getStaleSocketThreshold();
        this.staleSocketThresholdMillis = this.staleSocketThreshold * 1000L;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "Redirector()");
        }
    }

    public void setupServerConnection() throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "setupServerConnection(" + this.my_id + ")");
        }
        try {
            this.outputSocket = new Socket(this.outServerName, this.outPort);
            this.outputSocket.setSoTimeout(this.controller.getRequestTimeout());
            this.outToServer = this.outputSocket.getOutputStream();
            this.inFromServer = this.outputSocket.getInputStream();
        }
        catch (IOException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.CORBA.services.redirector.Redirector.setupServerConnection", "129", this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setupServerConnection", "Error creating socket " + this.my_id + ": " + ex);
            }
            throw ex;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "setupServerConnection()");
        }
    }

    public void reconnect() throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "reconnect()");
        }
        this.outputSocket.close();
        try {
            this.setupServerConnection();
        }
        catch (IOException ex) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "reconnect", "Error reconnecting to server " + this.my_id);
            }
            throw ex;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "reconnect()");
        }
    }

    public synchronized void handle(ServletRequest request, ServletResponse response) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "handle(" + this.my_id + ")");
        }
        this.busy = true;
        this.request = request;
        this.response = response;
        this.inFromClient = request.getInputStream();
        this.outToClient = response.getOutputStream();
        this.timeLastUsed = System.currentTimeMillis();
        BufferedInputStream inFromClientBuf = new BufferedInputStream(this.inFromClient);
        if (this.inFromServer.available() != 0) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handle", "Stale data exists on inbound stream from the server.  Attempting to reconnect.");
            }
            this.reconnect();
        }
        int bufferSize = 2048;
        inFromClientBuf.mark(2048);
        this.handleRequest(inFromClientBuf, this.outToServer);
        if (!this.handleReply(this.inFromServer, this.outToClient, response, true)) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handle", "Socket exception received when reading reply from server.  Attempting to reconnect and resend request to the server.");
            }
            this.reconnect();
            try {
                inFromClientBuf.reset();
            }
            catch (IOException ex) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handle", "Unable to reset the input buffer from the client back to the beginning because the message is larger than the buffer.  The buffer size is 2048 bytes.  The message cannot be resent to the server.");
                }
                this.busy = false;
                throw ex;
            }
            this.handleRequest(inFromClientBuf, this.outToServer);
            this.handleReply(this.inFromServer, this.outToClient, response, false);
        }
        this.busy = false;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "handle()");
        }
    }

    protected void handleRequest(BufferedInputStream input, OutputStream output) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "handleRequest(" + this.my_id + ")");
        }
        try {
            int n = 0;
            byte[] buf = new byte[2048];
            while ((n = input.read(buf, 0, buf.length)) != -1) {
                int count = n <= 0 ? 0 : n;
                try {
                    output.write(buf, 0, count);
                }
                catch (SocketException se) {
                    Manager.Ffdc.log(se, this, "com.ibm.CORBA.services.redirector.Redirector.handleRequest", "276", this);
                    this.reconnect();
                    output = this.outToServer;
                    output.write(buf, 0, count);
                }
            }
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.CORBA.services.redirector.Redirector.handleRequest", "284", this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleRequest", MessageUtility.getMessage("Redirector.RequestIOException", e.toString()), (String)null, (Object)e);
            }
            throw e;
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, this, "com.ibm.CORBA.services.redirector.Redirector.handleRequest", "299", this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleRequest", MessageUtility.getMessage("Redirector.Throwable", t.toString()), (String)null, (Object)t);
            }
            throw new IOException("Throwable exception caught t=" + t.toString());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "handleRequest()");
        }
    }

    protected boolean handleReply(InputStream input, OutputStream output, ServletResponse response, boolean firstCall) throws IOException {
        block21: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(2064L, thisClassName, "handleReply(" + this.my_id + ")");
            }
            try {
                int b4;
                int b3;
                int b2;
                int b1;
                byte[] bufhdr = new byte[12];
                try {
                    Redirector.readFully(input, bufhdr, 0, 12);
                }
                catch (SocketException se) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handleReply", "Error calling readFully: " + se);
                    }
                    if (firstCall) {
                        return false;
                    }
                    throw se;
                }
                byte byteOrder = (byte)(bufhdr[6] & 1);
                if (byteOrder == 0) {
                    b1 = bufhdr[8] << 24 & 0xFF000000;
                    b2 = bufhdr[9] << 16 & 0xFF0000;
                    b3 = bufhdr[10] << 8 & 0xFF00;
                    b4 = bufhdr[11] << 0 & 0xFF;
                } else {
                    b1 = bufhdr[11] << 24 & 0xFF000000;
                    b2 = bufhdr[10] << 16 & 0xFF0000;
                    b3 = bufhdr[9] << 8 & 0xFF00;
                    b4 = bufhdr[8] << 0 & 0xFF;
                }
                int size = (b1 | b2 | b3 | b4) + 12;
                byte[] buf = new byte[size];
                System.arraycopy(bufhdr, 0, buf, 0, 12);
                Redirector.readFully(input, buf, 12, size - 12);
                if (response != null) {
                    response.setContentLength(size);
                }
                output.write(buf, 0, size);
                if (this._timeStamp <= (long)this.controller.maxOpenSockets()) break block21;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handleReply", "Closing temporary socket: " + this.my_id);
                }
                try {
                    if (this.inFromClient != null) {
                        this.inFromClient.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.inFromClient = null;
                try {
                    if (this.outToClient != null) {
                        this.outToClient.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.outToClient = null;
                this.request = null;
                this.response = null;
                this.controller.removeRedirector(this.getID());
                this.controller = null;
            }
            catch (IOException e) {
                Manager.Ffdc.log(e, this, "com.ibm.CORBA.services.redirector.Redirector.handleReply", "434", this);
                if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleReply", MessageUtility.getMessage("Redirector.ReplyIOException", e.toString()), (String)null, (Object)e);
                }
                throw e;
            }
            catch (Throwable t) {
                Manager.Ffdc.log(t, this, "com.ibm.CORBA.services.redirector.Redirector.handleReply", "448", this);
                if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleReply", MessageUtility.getMessage("Redirector.Throwable", t.toString()), (String)null, (Object)t);
                }
                throw new IOException("Throwable exception caught t=" + t.toString());
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "handleReply()");
        }
        return true;
    }

    public static void readFully(InputStream is, byte[] buf, int offset, int size) throws IOException {
        int bytecount;
        for (int n = 0; n < size; n += bytecount) {
            bytecount = 0;
            int itns = 0;
            while (true) {
                try {
                    bytecount = is.read(buf, offset + n, size - n);
                }
                catch (SocketTimeoutException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    if (itns++ < 5) continue;
                    throw ex;
                }
                break;
            }
            if (bytecount >= 0) continue;
            throw new IOException();
        }
    }

    public String getID() {
        return this.my_id;
    }

    public static String buildID(String host, int port, long timeStamp) {
        return host + ":" + port + ":" + timeStamp;
    }

    public void finalize() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "finalize(" + this.my_id + ")");
        }
        if (!this.connectionTerminated) {
            this.terminateServerConnection();
        }
        this.busy = false;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "finalize()");
        }
    }

    public synchronized void terminateServerConnection() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "terminateServerConnection(" + this.my_id + ")");
        }
        this.connectionTerminated = true;
        if (this.outToServer != null) {
            try {
                this.outToServer.close();
                this.outToServer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.inFromServer != null) {
            try {
                this.inFromServer.close();
                this.inFromServer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.outputSocket != null) {
            try {
                this.outputSocket.close();
                this.outputSocket = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "terminateServerConnection()");
        }
    }

    public boolean cleanupStaleConnection() {
        if (this.busy) {
            return false;
        }
        this.busy = true;
        boolean connectionRemoved = false;
        boolean removeConnection = false;
        if (this.controller.checkDeltaTime(this.timeLastUsed, this.staleSocketThresholdMillis) > 0L) {
            removeConnection = true;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "cleanupStaleConnection", this.my_id, (Object)("Connection was last used over " + this.staleSocketThreshold + " seconds ago.  Removing connection."));
            }
        } else {
            try {
                if (this.inFromServer.available() != 0) {
                    removeConnection = true;
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "cleanupStaleConnection", this.my_id, (Object)"Stale data exists on inbound stream from the server.  Removing connection.");
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (removeConnection) {
            try {
                this.terminateServerConnection();
                connectionRemoved = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!connectionRemoved) {
            this.busy = false;
        }
        return connectionRemoved;
    }
}

