/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.services.redirector.Redirector;
import com.ibm.CORBA.services.redirector.RedirectorController;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.orbimpl.MessageUtility;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IIOPTunnelServlet
extends HttpServlet {
    private static final long serialVersionUID = 750467456658215023L;
    protected boolean debug = false;
    protected RedirectorController controller;
    private static final int DEFAULT_MAX_OPEN_SOCKETS = 3;
    private static final String MAX_OPEN_SOCKETS_PROPERTY = "com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint";
    private static final String TIMEOUT_PROPERTY = "com.ibm.ws.orb.services.redirector.RequestTimeout";
    private static final String thisClassName = IIOPTunnelServlet.class.getName();

    public void init(ServletConfig config2) throws ServletException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "init()");
        }
        super.init(config2);
        this.controller = new RedirectorController();
        ORB orb = IIOPTunnelServlet.getOrb();
        this.getTunnelProperties(orb);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "init()");
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Redirector redirector;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "service() queryString=" + req.getQueryString());
        }
        String host = "";
        int port = 0;
        int begin_idx = 0;
        int end_idx = 0;
        res.setContentType("ijavaorb/iiop");
        try {
            String query = req.getQueryString();
            begin_idx = query.indexOf("debug=true");
            if (begin_idx != -1 || this.debug) {
                this.debug = true;
                this.log("service(): entered...");
            }
            if ((begin_idx = query.indexOf("debug=false")) != -1) {
                this.debug = false;
            }
            if ((begin_idx = query.indexOf("host=")) == -1) {
                this.log(MessageUtility.getMessage("IIOPTunnelServlet.parsingHost", query));
                return;
            }
            end_idx = query.indexOf(38, begin_idx += 5);
            if (end_idx == -1) {
                end_idx = query.length();
            }
            host = query.substring(begin_idx, end_idx);
            begin_idx = query.indexOf("port=");
            if (begin_idx == -1) {
                this.log(MessageUtility.getMessage("IIOPTunnelServlet.parsingPort", query));
                return;
            }
            end_idx = query.indexOf(38, begin_idx += 5);
            if (end_idx == -1) {
                end_idx = query.length();
            }
            port = Integer.parseInt(query.substring(begin_idx, end_idx));
            if (this.debug) {
                this.log("service(): target host = " + host + " target port = " + port);
            }
            redirector = this.controller.getRedirector(host, port);
        }
        catch (IOException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.CORBA.services.IIOPTunnelServlet.service", "188", this);
            this.log(MessageUtility.getMessage("IIOPTunnelServlet.IOException", ex.toString()));
            return;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.CORBA.services.IIOPTunnelServlet.service", "194", this);
            String[] args = new String[]{"service()", ex.toString()};
            this.log(MessageUtility.getMessage("IIOPTunnelServlet.Exception", args));
            return;
        }
        if (req.getMethod().equals("POST")) {
            if (this.debug) {
                this.log("service(): About to call redirector.handle() method");
            }
            try {
                redirector.handle(req, res);
            }
            catch (IOException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.CORBA.services.IIOPTunnelServlet.service", "217", this);
                this.controller.removeRedirector(redirector.getID());
                redirector = null;
                this.log(MessageUtility.getMessage("IIOPTunnelServlet.IOException", ex.toString()));
                return;
            }
        } else {
            this.log(MessageUtility.getMessage("IIOPTunnelServlet.unsupported", req.getMethod()));
            return;
        }
        this.controller.checkConnectionTable();
        if (this.debug) {
            this.log("end of service method");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "service()");
        }
    }

    public String getServletInfo() {
        return MessageUtility.getMessage("IIOPTunnelServlet.servletInfo");
    }

    public static ORB getOrb() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "getOrb()");
        }
        Object emptyStrArr = null;
        Object emptyProps = null;
        ORB orb = null;
        orb = GlobalORBFactory.globalORB();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "getOrb()");
        }
        return orb;
    }

    private void getTunnelProperties(ORB orb) {
        int requestTimeout;
        block15: {
            String thisMethodName = "getTunnelProperties()";
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(2064L, thisClassName, "getTunnelProperties()");
            }
            int maxOpenSockets = 0;
            requestTimeout = 0;
            String maxOpenSocketsString = orb.getProperty(MAX_OPEN_SOCKETS_PROPERTY);
            if (maxOpenSocketsString == null || maxOpenSocketsString.length() == 0) {
                maxOpenSockets = 3;
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint is defaulting to 3");
            } else {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint = " + maxOpenSocketsString);
                }
                try {
                    maxOpenSockets = Integer.parseInt(maxOpenSocketsString);
                    if (maxOpenSockets < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "The property com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint has a value of " + maxOpenSocketsString + ".  This is not a valid value.  " + MAX_OPEN_SOCKETS_PROPERTY + " has been reset to the default value of " + 3);
                    }
                    maxOpenSockets = 3;
                }
            }
            this.controller.setMaxOpenSockets(maxOpenSockets);
            String timeoutString = orb.getProperty(TIMEOUT_PROPERTY);
            if (timeoutString == null || timeoutString.length() == 0) {
                requestTimeout = orb.getRequestTimeout();
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.RequestTimeout is defaulting to the value for com.ibm.CORBA.RequestTimeout: " + requestTimeout / 1000 + " seconds.");
            } else {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.RequestTimeout = " + timeoutString + " seconds.");
                }
                try {
                    requestTimeout = Integer.parseInt(timeoutString);
                    if (requestTimeout < 0) {
                        throw new Exception();
                    }
                    requestTimeout *= 1000;
                }
                catch (Exception ex) {
                    requestTimeout = orb.getRequestTimeout();
                    if (!ORBRas.isTrcLogging) break block15;
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "The property com.ibm.ws.orb.services.redirector.RequestTimeout has a value of " + timeoutString + ".  This is not a valid value.  " + TIMEOUT_PROPERTY + " has been reset to be the same as the value for com.ibm.CORBA.RequestTimeout: " + requestTimeout / 1000 + " seconds.");
                }
            }
        }
        this.controller.setRequestTimeout(requestTimeout);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "getTunnelProperties()");
        }
    }
}

