/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.DatabaseHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderHashGeneratorFactory;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.QueryableKeyDatabase;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordDataHashGeneratorFactory;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.SequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;

final class QueryableKeyDatabaseFactory {
    private QueryableKeyDatabaseFactory() {
        throw new UnsupportedOperationException();
    }

    public static QueryableKeyDatabase newQueryableKeyDatabase(KeyDatabase database) {
        return new QueryableKeyDatabaseImpl(database);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueryableKeyDatabaseImpl
    implements QueryableKeyDatabase {
        private KeyDatabase keydatabase;
        private int nextRecordID;

        private static ByteSequence char2UTF8ByteSequence(char[] value) {
            CharBuffer buffer = CharBuffer.wrap(value);
            Charset charset = Charset.forName("UTF-8");
            ByteBuffer bbuffer = charset.encode(buffer);
            byte[] bytes = new byte[bbuffer.limit()];
            System.arraycopy(bbuffer.array(), 0, bytes, 0, bbuffer.limit());
            return ByteSequenceFactory.newByteSequence(bytes);
        }

        QueryableKeyDatabaseImpl(KeyDatabase database) {
            if (database == null) {
                throw new NullPointerException();
            }
            this.keydatabase = database;
            int numberOfRecords = this.keydatabase.getRecords().length();
            if (numberOfRecords > 0) {
                ArrayList<Integer> recordIDs = new ArrayList<Integer>(numberOfRecords);
                for (Record record : this.keydatabase.getRecords()) {
                    recordIDs.add(record.getRecordId().toInt());
                }
                this.nextRecordID = (Integer)Collections.max(recordIDs) + 1;
            } else {
                this.nextRecordID = 1;
            }
        }

        @Override
        public Record getRecordByLabel(String label) {
            ByteSequence labelSequence;
            try {
                labelSequence = ByteSequenceFactory.newByteSequence(label.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (Record record : this.keydatabase.getRecords()) {
                if (!((Object)record.getLabel().getContent()).equals(labelSequence)) continue;
                return record;
            }
            return null;
        }

        @Override
        public Record getRecordByPublicKeyInfo(Certificate certificate) {
            Buffer SPInfoHash;
            try {
                SPInfoHash = RecordDataHashGeneratorFactory.newRecordDataHashGenerator().generateSubjectPublicKeyInfoHash((X509Certificate)certificate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (Record record : this.keydatabase.getRecords()) {
                if (!record.getSubjectPublicKeyInfoHash().equals(SPInfoHash)) continue;
                return record;
            }
            return null;
        }

        @Override
        public Record getIssuerRecord(Record subject) {
            Buffer IssuerNameHash;
            try {
                X509Certificate certificate = (X509Certificate)subject.getEncoding().getCertificate();
                X500Name name = new X500Name(certificate.getIssuerDN().getName());
                IssuerNameHash = RecordDataHashGeneratorFactory.newRecordDataHashGenerator().generateHash(ByteSequenceFactory.newByteSequence(name.getEncoded()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (Record record : this.keydatabase.getRecords()) {
                if (!record.getSubjectNameHash().equals(IssuerNameHash)) continue;
                return record;
            }
            return null;
        }

        @Override
        public boolean checkKeyStoreIntegrity(char[] password) {
            ByteSequence calculatedHash;
            if (password == null) {
                throw new NullPointerException();
            }
            try {
                calculatedHash = DatabaseHashGeneratorFactory.newDatabaseHashGenerator(this.keydatabase.getHeader()).generateHash(this.keydatabase, new String(password));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteSequence existingHash = this.keydatabase.getHeader().getPasswordDatabaseHash();
            return ((Object)existingHash).equals(calculatedHash);
        }

        @Override
        public FileHeader getHeader() {
            return this.keydatabase.getHeader();
        }

        @Override
        public Sequence<Record> getRecords() {
            return this.keydatabase.getRecords();
        }

        @Override
        public byte get(int index) throws IndexOutOfBoundsException {
            return this.keydatabase.get(index);
        }

        @Override
        public int length() {
            return this.keydatabase.length();
        }

        @Override
        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            return this.keydatabase.append(sequence);
        }

        @Override
        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            return this.keydatabase.getSubSequence(fromPosition, toPosition);
        }

        @Override
        public int indexOf(byte b) {
            return this.keydatabase.indexOf(b);
        }

        @Override
        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.keydatabase.indexOf(position, b);
        }

        @Override
        public int lastIndexOf(byte b) {
            return this.keydatabase.lastIndexOf(b);
        }

        @Override
        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.keydatabase.lastIndexOf(position, b);
        }

        @Override
        public boolean isEmpty() {
            return this.keydatabase.isEmpty();
        }

        @Override
        public InputStream getInputStream() {
            return this.keydatabase.getInputStream();
        }

        @Override
        public ByteSequenceIterator getIterator() {
            return this.keydatabase.getIterator();
        }

        @Override
        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            return this.keydatabase.getIterator(position);
        }

        @Override
        public String toBinaryString() {
            return this.keydatabase.toBinaryString();
        }

        @Override
        public String toOctalString() {
            return this.keydatabase.toOctalString();
        }

        @Override
        public String toHexString() {
            return this.keydatabase.toHexString();
        }

        @Override
        public int getNextRecordID() {
            return this.nextRecordID++;
        }

        @Override
        public boolean checkPassword(char[] password) throws NullPointerException, NoSuchAlgorithmException, UnsupportedEncodingException {
            if (password == null) {
                throw new NullPointerException();
            }
            ByteSequence genHash = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(this.keydatabase.getHeader()).generateHash(this.keydatabase.getHeader(), new String(password));
            ByteSequence actualHash = this.keydatabase.getHeader().getPasswordHeaderHash();
            return ((Object)genHash).equals(actualHash);
        }

        @Override
        public Sequence<Record> getKeyRecords() {
            ArrayList<Record> keys = new ArrayList<Record>();
            for (Record record : this.keydatabase.getRecords()) {
                if (!record.getEncoding().isPrivateKeyPresent()) continue;
                keys.add(record);
            }
            return SequenceFactory.newSequence(keys);
        }

        @Override
        public boolean equals(Object o) {
            return this.keydatabase.equals(o);
        }

        @Override
        public int hashCode() {
            return this.keydatabase.hashCode();
        }

        @Override
        public String toString() {
            return this.keydatabase.toString();
        }
    }
}

