/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.rmi.registry;

import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.harmony.jndi.provider.rmi.registry.RegistryContext;

class BindingEnumeration
implements NamingEnumeration<Binding> {
    protected final String[] names;
    protected int index = 0;
    protected RegistryContext context;

    public BindingEnumeration(String[] stringArray, RegistryContext registryContext) {
        this.names = stringArray;
        this.context = registryContext.cloneContext();
    }

    @Override
    public boolean hasMore() {
        if (this.index < this.names.length) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public Binding next() throws NoSuchElementException, NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String string = this.names[this.index++];
        Binding binding = new Binding(string, this.context.lookup(string));
        binding.setNameInNamespace(string);
        return binding;
    }

    @Override
    public Binding nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw (NoSuchElementException)new NoSuchElementException().initCause(namingException);
        }
    }

    @Override
    public void close() {
        this.index = this.names.length;
        this.context.close();
    }
}

