/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.QuestionRecord;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;

public class Message {
    private int id = 0;
    private boolean qr = false;
    private int opCode = 0;
    private boolean aa = false;
    private boolean tc = false;
    private boolean rd = false;
    private boolean ra = false;
    private int rCode = 0;
    private int qdCount = 0;
    private int anCount = 0;
    private int nsCount = 0;
    private int arCount = 0;
    private Vector<QuestionRecord> questionRecords = null;
    private Vector<ResourceRecord> answerRRs = null;
    private Vector<ResourceRecord> authorityRRs = null;
    private Vector<ResourceRecord> additionalRRs = null;

    public Message() {
        this.questionRecords = new Vector();
        this.answerRRs = new Vector();
        this.authorityRRs = new Vector();
        this.additionalRRs = new Vector();
    }

    public Message(int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n3, int n4, int n5, int n6, int n7) {
        this.id = n;
        this.qr = bl;
        this.opCode = n2;
        this.aa = bl2;
        this.tc = bl3;
        this.rd = bl4;
        this.ra = bl5;
        this.rCode = n3;
        this.qdCount = n4;
        this.anCount = n5;
        this.nsCount = n6;
        this.arCount = n7;
        this.questionRecords = new Vector();
        this.answerRRs = new Vector();
        this.authorityRRs = new Vector();
        this.additionalRRs = new Vector();
    }

    public int writeBytes(byte[] byArray, int n) throws DomainProtocolException {
        Object object;
        int n2;
        int n3 = n;
        int n4 = 0;
        if (byArray == null) {
            throw new DomainProtocolException(Messages.getString("jndi.32"));
        }
        n3 = ProviderMgr.write16Int(this.id, byArray, n3);
        n4 = ProviderMgr.setBit(n4, 32768, this.qr);
        n4 &= 0xFFFF87FF;
        n4 |= (this.opCode & 0xF) << 11;
        n4 = ProviderMgr.setBit(n4, 1024, this.aa);
        n4 = ProviderMgr.setBit(n4, 512, this.tc);
        n4 = ProviderMgr.setBit(n4, 256, this.rd);
        n4 = ProviderMgr.setBit(n4, 128, this.ra);
        n4 &= 0xFFFFFF8F;
        n4 &= 0xFFFFFFF0;
        n3 = ProviderMgr.write16Int(n4 |= (this.rCode & 0xF) << 0, byArray, n3);
        n3 = ProviderMgr.write16Int(this.qdCount, byArray, n3);
        n3 = ProviderMgr.write16Int(this.anCount, byArray, n3);
        n3 = ProviderMgr.write16Int(this.nsCount, byArray, n3);
        n3 = ProviderMgr.write16Int(this.arCount, byArray, n3);
        for (n2 = 0; n2 < this.questionRecords.size(); ++n2) {
            object = this.questionRecords.elementAt(n2);
            n3 = ((QuestionRecord)object).writeBytes(byArray, n3);
        }
        for (n2 = 0; n2 < this.answerRRs.size(); ++n2) {
            object = this.answerRRs.elementAt(n2);
            n3 = ((ResourceRecord)object).writeBytes(byArray, n3);
        }
        for (n2 = 0; n2 < this.authorityRRs.size(); ++n2) {
            object = this.answerRRs.elementAt(n2);
            n3 = ((ResourceRecord)object).writeBytes(byArray, n3);
        }
        for (n2 = 0; n2 < this.additionalRRs.size(); ++n2) {
            object = this.answerRRs.elementAt(n2);
            n3 = ((ResourceRecord)object).writeBytes(byArray, n3);
        }
        return n3;
    }

    public static int parseMessage(byte[] byArray, int n, Message message) throws DomainProtocolException {
        Object object;
        int n2;
        int n3 = n;
        if (message == null) {
            throw new DomainProtocolException(Messages.getString("jndi.58"));
        }
        message.setId(ProviderMgr.parse16Int(byArray, n3));
        int n4 = ProviderMgr.parse16Int(byArray, n3 += 2);
        n3 += 2;
        message.setQR(ProviderMgr.checkBit(n4, 32768));
        int n5 = (n4 & 0x7800) >> 11;
        message.setOpCode(n5);
        message.setAA(ProviderMgr.checkBit(n4, 1024));
        message.setTc(ProviderMgr.checkBit(n4, 512));
        message.setRD(ProviderMgr.checkBit(n4, 256));
        message.setRA(ProviderMgr.checkBit(n4, 128));
        n5 = (n4 & 0xF) >> 0;
        message.setRCode(n5);
        int n6 = ProviderMgr.parse16Int(byArray, n3);
        message.setQDCount(n6);
        int n7 = ProviderMgr.parse16Int(byArray, n3 += 2);
        message.setANCount(n7);
        int n8 = ProviderMgr.parse16Int(byArray, n3 += 2);
        message.setNSCount(n8);
        int n9 = ProviderMgr.parse16Int(byArray, n3 += 2);
        message.setARCount(n9);
        n3 += 2;
        for (n2 = 0; n2 < n6; ++n2) {
            object = new QuestionRecord();
            n3 = QuestionRecord.parseRecord(byArray, n3, (QuestionRecord)object);
            message.addQuestionRecord((QuestionRecord)object);
        }
        for (n2 = 0; n2 < n7; ++n2) {
            object = new ResourceRecord();
            n3 = ResourceRecord.parseRecord(byArray, n3, (ResourceRecord)object);
            message.addAnswerRR((ResourceRecord)object);
        }
        for (n2 = 0; n2 < n8; ++n2) {
            object = new ResourceRecord();
            n3 = ResourceRecord.parseRecord(byArray, n3, (ResourceRecord)object);
            message.addAuthorityRR((ResourceRecord)object);
        }
        for (n2 = 0; n2 < n9; ++n2) {
            object = new ResourceRecord();
            n3 = ResourceRecord.parseRecord(byArray, n3, (ResourceRecord)object);
            message.addAdditionalRR((ResourceRecord)object);
        }
        return n3;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID=" + this.id + "\n");
        if (this.qr) {
            stringBuffer.append(" QR");
        }
        stringBuffer.append(" OPCODE=" + this.opCode);
        if (this.aa) {
            stringBuffer.append(" AA");
        }
        if (this.tc) {
            stringBuffer.append(" TC");
        }
        if (this.rd) {
            stringBuffer.append(" RD");
        }
        if (this.ra) {
            stringBuffer.append(" RA");
        }
        stringBuffer.append(" RCODE=" + this.rCode);
        stringBuffer.append("\n");
        stringBuffer.append("QDCOUNT=" + this.qdCount);
        for (n = 0; n < this.questionRecords.size(); ++n) {
            stringBuffer.append("\n");
            stringBuffer.append(this.questionRecords.elementAt(n).toString());
        }
        stringBuffer.append("\n");
        stringBuffer.append(" ANCOUNT=" + this.anCount);
        for (n = 0; n < this.answerRRs.size(); ++n) {
            stringBuffer.append("\n");
            stringBuffer.append(this.answerRRs.elementAt(n).toString());
        }
        stringBuffer.append("\n");
        stringBuffer.append(" NSCOUNT=" + this.nsCount);
        for (n = 0; n < this.authorityRRs.size(); ++n) {
            stringBuffer.append("\n");
            stringBuffer.append(this.authorityRRs.elementAt(n).toString());
        }
        stringBuffer.append("\n");
        stringBuffer.append(" ARCOUNT=" + this.arCount);
        for (n = 0; n < this.additionalRRs.size(); ++n) {
            stringBuffer.append("\n");
            stringBuffer.append(this.additionalRRs.elementAt(n).toString());
        }
        return stringBuffer.toString();
    }

    public boolean isAA() {
        return this.aa;
    }

    public void setAA(boolean bl) {
        this.aa = bl;
    }

    public int getANCount() {
        return this.anCount;
    }

    public void setANCount(int n) {
        this.anCount = n;
    }

    public int getARCount() {
        return this.arCount;
    }

    public void setARCount(int n) {
        this.arCount = n;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getNSCount() {
        return this.nsCount;
    }

    public void setNSCount(int n) {
        this.nsCount = n;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public void setOpCode(int n) {
        this.opCode = n;
    }

    public int getQDCount() {
        return this.qdCount;
    }

    public void setQDCount(int n) {
        this.qdCount = n;
    }

    public boolean getQR() {
        return this.qr;
    }

    public void setQR(boolean bl) {
        this.qr = bl;
    }

    public boolean isRA() {
        return this.ra;
    }

    public void setRA(boolean bl) {
        this.ra = bl;
    }

    public int getRCode() {
        return this.rCode;
    }

    public void setRCode(int n) {
        this.rCode = n;
    }

    public boolean isRD() {
        return this.rd;
    }

    public void setRD(boolean bl) {
        this.rd = bl;
    }

    public boolean isTc() {
        return this.tc;
    }

    public void setTc(boolean bl) {
        this.tc = bl;
    }

    public Enumeration<QuestionRecord> getQuestionRecords() {
        return this.questionRecords.elements();
    }

    public void addQuestionRecord(QuestionRecord questionRecord) {
        this.questionRecords.addElement(questionRecord);
    }

    public Enumeration<ResourceRecord> getAnswerRRs() {
        return this.answerRRs.elements();
    }

    public void addAnswerRR(ResourceRecord resourceRecord) {
        this.answerRRs.addElement(resourceRecord);
    }

    public Enumeration<ResourceRecord> getAuthorityRRs() {
        return this.authorityRRs.elements();
    }

    public void addAuthorityRR(ResourceRecord resourceRecord) {
        this.authorityRRs.addElement(resourceRecord);
    }

    public Enumeration<ResourceRecord> getAdditionalRRs() {
        return this.additionalRRs.elements();
    }

    public void addAdditionalRR(ResourceRecord resourceRecord) {
        this.additionalRRs.addElement(resourceRecord);
    }
}

