/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.harmony.jndi.internal.nls.Messages;

public abstract class GenericURLContextFactory
implements ObjectFactory {
    protected GenericURLContextFactory() {
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        Context context2 = this.createURLContext(hashtable);
        if (object == null) {
            return context2;
        }
        try {
            if (object instanceof String) {
                Object object2 = context2.lookup((String)object);
                return object2;
            }
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                if (stringArray.length < 1) {
                    throw new ConfigurationException(Messages.getString("jndi.2C"));
                }
                NamingException namingException = null;
                for (String string : stringArray) {
                    try {
                        Object object3 = context2.lookup(string);
                        return object3;
                    }
                    catch (NamingException namingException2) {
                        namingException = namingException2;
                    }
                }
                throw namingException;
            }
            throw new IllegalArgumentException(Messages.getString("jndi.2D", object));
        }
        finally {
            context2.close();
        }
    }

    protected abstract Context createURLContext(Hashtable<?, ?> var1);
}

