/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;
import org.apache.harmony.jndi.internal.EnvironmentReader;
import org.apache.harmony.jndi.internal.UrlParser;
import org.apache.harmony.jndi.internal.nls.Messages;

public class DirectoryManager
extends NamingManager {
    private DirectoryManager() {
    }

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws Exception {
        Object object2;
        if (null != ofb) {
            ObjectFactory objectFactory = ofb.createObjectFactory(object, hashtable);
            return DirectoryManager.getObjectInstanceFromGivenFactory(objectFactory, object, name, context, hashtable, attributes);
        }
        Reference reference = null;
        if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (object instanceof Reference) {
            reference = (Reference)object;
        }
        if (null != reference) {
            if (null != reference.getFactoryClassName()) {
                return DirectoryManager.getObjectInstanceByFactoryInReference(reference, object, name, context, hashtable, attributes);
            }
            object2 = DirectoryManager.getObjectInstanceByUrlRefAddr(name, context, hashtable, reference);
            if (null != object2) {
                return object2;
            }
        }
        if (null != (object2 = DirectoryManager.getObjectInstanceByObjectFactory(object, name, context, hashtable, attributes))) {
            return object2;
        }
        return object;
    }

    private static Object getObjectInstanceFromGivenFactory(ObjectFactory objectFactory, Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws Exception {
        if (objectFactory instanceof DirObjectFactory) {
            return ((DirObjectFactory)objectFactory).getObjectInstance(object, name, context, hashtable, attributes);
        }
        return objectFactory.getObjectInstance(object, name, context, hashtable);
    }

    private static Object getObjectInstanceByObjectFactory(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws NamingException, Exception {
        String[] stringArray;
        for (String string : stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, context, "java.naming.factory.object")) {
            ObjectFactory objectFactory = null;
            try {
                objectFactory = (ObjectFactory)DirectoryManager.classForName(string).newInstance();
            }
            catch (Exception exception) {
                continue;
            }
            Object object2 = DirectoryManager.getObjectInstanceFromGivenFactory(objectFactory, object, name, context, hashtable, attributes);
            if (null == object2) continue;
            return object2;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlRefAddr(Name name, Context context, Hashtable<?, ?> hashtable, Reference reference) throws NamingException {
        String[] stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, context, "java.naming.factory.url.pkgs");
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            String string;
            Object object;
            RefAddr refAddr = enumeration.nextElement();
            if (!(refAddr instanceof StringRefAddr) || !refAddr.getType().equalsIgnoreCase("URL") || null == (object = DirectoryManager.getObjectInstanceByUrlContextFactory(string = (String)((StringRefAddr)refAddr).getContent(), name, context, hashtable, stringArray, UrlParser.getScheme(string)))) continue;
            return object;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlContextFactory(String string, Name name, Context context, Hashtable<?, ?> hashtable, String[] stringArray, String string2) throws NamingException {
        if (null == string2 || 0 == string2.length()) {
            return null;
        }
        for (String string3 : stringArray) {
            Object object;
            ObjectFactory objectFactory = null;
            try {
                object = string3 + "." + string2 + "." + string2 + "URLContextFactory";
                objectFactory = (ObjectFactory)DirectoryManager.classForName((String)object).newInstance();
            }
            catch (Exception exception) {
                continue;
            }
            try {
                object = objectFactory.getObjectInstance(string, name, context, hashtable);
                if (null == object) continue;
                return object;
            }
            catch (Exception exception) {
                if (exception instanceof NamingException) {
                    throw (NamingException)exception;
                }
                NamingException namingException = new NamingException(Messages.getString("jndi.21"));
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return null;
    }

    private static Object getObjectInstanceByFactoryInReference(Reference reference, Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws Exception {
        ObjectFactory objectFactory = null;
        try {
            objectFactory = (ObjectFactory)DirectoryManager.classForName(reference.getFactoryClassName()).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (null == objectFactory && null != reference.getFactoryClassLocation()) {
            objectFactory = (ObjectFactory)DirectoryManager.loadFactoryFromLocation(reference.getFactoryClassName(), reference.getFactoryClassLocation());
        }
        if (null == objectFactory) {
            return object;
        }
        return DirectoryManager.getObjectInstanceFromGivenFactory(objectFactory, reference, name, context, hashtable, attributes);
    }

    private static Object loadFactoryFromLocation(String string, String string2) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = new URL(stringTokenizer.nextToken());
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        try {
            return uRLClassLoader.loadClass(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static DirStateFactory.Result getStateToBind(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws NamingException {
        String[] stringArray;
        for (String string : stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, context, "java.naming.factory.state")) {
            Object object2;
            StateFactory stateFactory = null;
            try {
                stateFactory = (StateFactory)DirectoryManager.classForName(string).newInstance();
            }
            catch (Exception exception) {
                continue;
            }
            if (stateFactory instanceof DirStateFactory) {
                object2 = ((DirStateFactory)stateFactory).getStateToBind(object, name, context, hashtable, attributes);
                if (null == object2) continue;
                return object2;
            }
            object2 = stateFactory.getStateToBind(object, name, context, hashtable);
            if (null == object2) continue;
            return new DirStateFactory.Result(object2, attributes);
        }
        return new DirStateFactory.Result(object, attributes);
    }

    public static DirContext getContinuationDirContext(CannotProceedException cannotProceedException) throws NamingException {
        Context context = null;
        try {
            context = NamingManager.getContinuationContext(cannotProceedException);
        }
        catch (CannotProceedException cannotProceedException2) {
            // empty catch block
        }
        if (context instanceof DirContext) {
            return (DirContext)context;
        }
        return new Context2DirContextWrapper(context, cannotProceedException);
    }

    private static Class<?> classForName(final String string) throws ClassNotFoundException {
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return Class.forName(string, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        return null;
                    }
                }
            }
        });
        if (clazz == null) {
            throw new ClassNotFoundException(Messages.getString("jndi.1C", string));
        }
        return clazz;
    }

    private static class Context2DirContextWrapper
    implements DirContext {
        private Context ctx;
        private CannotProceedException cpe;

        public Context2DirContextWrapper(Context context, CannotProceedException cannotProceedException) {
            this.ctx = context;
            this.cpe = cannotProceedException;
        }

        private Context getContext() throws CannotProceedException {
            if (this.ctx != null) {
                return this.ctx;
            }
            this.cpe.fillInStackTrace();
            throw this.cpe;
        }

        private DirContext getDirContext() throws CannotProceedException {
            if (this.ctx instanceof DirContext) {
                return (DirContext)this.ctx;
            }
            this.cpe.fillInStackTrace();
            throw this.cpe;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
            return this.getContext().listBindings(string);
        }

        @Override
        public Object removeFromEnvironment(String string) throws NamingException {
            return this.getContext().removeFromEnvironment(string);
        }

        @Override
        public Object lookupLink(String string) throws NamingException {
            return this.getContext().lookupLink(string);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return this.getContext().list(name);
        }

        @Override
        public Object lookup(String string) throws NamingException {
            return this.getContext().lookup(string);
        }

        @Override
        public Object addToEnvironment(String string, Object object) throws NamingException {
            return this.getContext().addToEnvironment(string, object);
        }

        public String toString() {
            try {
                return this.getContext().toString();
            }
            catch (CannotProceedException cannotProceedException) {
                return super.toString();
            }
        }

        @Override
        public Context createSubcontext(String string) throws NamingException {
            return this.getContext().createSubcontext(string);
        }

        @Override
        public void rename(Name name, Name name2) throws NamingException {
            this.getContext().rename(name, name2);
        }

        public int hashCode() {
            try {
                return this.getContext().hashCode();
            }
            catch (CannotProceedException cannotProceedException) {
                return super.hashCode();
            }
        }

        @Override
        public void rebind(Name name, Object object) throws NamingException {
            this.getContext().rebind(name, object);
        }

        @Override
        public void rename(String string, String string2) throws NamingException {
            this.getContext().rename(string, string2);
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return this.getContext().createSubcontext(name);
        }

        @Override
        public NameParser getNameParser(String string) throws NamingException {
            return this.getContext().getNameParser(string);
        }

        @Override
        public void rebind(String string, Object object) throws NamingException {
            this.getContext().rebind(string, object);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return this.getContext().listBindings(name);
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return this.getContext().getNameParser(name);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
            return this.getContext().list(string);
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return this.getContext().getNameInNamespace();
        }

        @Override
        public void unbind(Name name) throws NamingException {
            this.getContext().unbind(name);
        }

        @Override
        public Name composeName(Name name, Name name2) throws NamingException {
            return this.getContext().composeName(name, name2);
        }

        @Override
        public void bind(Name name, Object object) throws NamingException {
            this.getContext().bind(name, object);
        }

        @Override
        public void unbind(String string) throws NamingException {
            this.getContext().unbind(string);
        }

        @Override
        public void close() throws NamingException {
            this.getContext().close();
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return this.getContext().lookupLink(name);
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            this.getContext().destroySubcontext(name);
        }

        @Override
        public String composeName(String string, String string2) throws NamingException {
            return this.getContext().composeName(string, string2);
        }

        @Override
        public void bind(String string, Object object) throws NamingException {
            this.getContext().bind(string, object);
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.getContext().lookup(name);
        }

        public boolean equals(Object object) {
            try {
                return this.getContext().equals(object);
            }
            catch (CannotProceedException cannotProceedException) {
                return super.equals(object);
            }
        }

        @Override
        public void destroySubcontext(String string) throws NamingException {
            this.getContext().destroySubcontext(string);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return this.getContext().getEnvironment();
        }

        @Override
        public void bind(Name name, Object object, Attributes attributes) throws NamingException {
            this.getDirContext().bind(name, object, attributes);
        }

        @Override
        public void bind(String string, Object object, Attributes attributes) throws NamingException {
            this.getDirContext().bind(string, object, attributes);
        }

        @Override
        public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
            return this.getDirContext().createSubcontext(name, attributes);
        }

        @Override
        public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
            return this.getDirContext().createSubcontext(string, attributes);
        }

        @Override
        public Attributes getAttributes(Name name) throws NamingException {
            return this.getDirContext().getAttributes(name);
        }

        @Override
        public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
            return this.getDirContext().getAttributes(name, stringArray);
        }

        @Override
        public Attributes getAttributes(String string) throws NamingException {
            return this.getDirContext().getAttributes(string);
        }

        @Override
        public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
            return this.getDirContext().getAttributes(string, stringArray);
        }

        @Override
        public DirContext getSchema(Name name) throws NamingException {
            return this.getDirContext().getSchema(name);
        }

        @Override
        public DirContext getSchema(String string) throws NamingException {
            return this.getDirContext().getSchema(string);
        }

        @Override
        public DirContext getSchemaClassDefinition(Name name) throws NamingException {
            return this.getDirContext().getSchemaClassDefinition(name);
        }

        @Override
        public DirContext getSchemaClassDefinition(String string) throws NamingException {
            return this.getDirContext().getSchemaClassDefinition(string);
        }

        @Override
        public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
            this.getDirContext().modifyAttributes(name, n, attributes);
        }

        @Override
        public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
            this.getDirContext().modifyAttributes(name, modificationItemArray);
        }

        @Override
        public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
            this.getDirContext().modifyAttributes(string, n, attributes);
        }

        @Override
        public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
            this.getDirContext().modifyAttributes(string, modificationItemArray);
        }

        @Override
        public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
            this.getDirContext().rebind(name, object, attributes);
        }

        @Override
        public void rebind(String string, Object object, Attributes attributes) throws NamingException {
            this.getDirContext().rebind(string, object, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
            return this.getDirContext().search(name, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
            return this.getDirContext().search(name, attributes, stringArray);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(name, string, objectArray, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String string, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(name, string, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String string, Attributes attributes) throws NamingException {
            return this.getDirContext().search(string, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String string, Attributes attributes, String[] stringArray) throws NamingException {
            return this.getDirContext().search(string, attributes, stringArray);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(string, string2, objectArray, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String string, String string2, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(string, string2, searchControls);
        }
    }
}

