/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.RefAddr;
import org.apache.harmony.jndi.internal.nls.Messages;

public class Reference
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1673475790065791735L;
    protected String className;
    protected Vector<RefAddr> addrs;
    protected String classFactory;
    protected String classFactoryLocation;

    public Reference(String string) {
        this(string, null, null);
    }

    public Reference(String string, RefAddr refAddr) {
        this(string, refAddr, null, null);
    }

    public Reference(String string, String string2, String string3) {
        this.className = string;
        this.classFactory = string2;
        this.classFactoryLocation = string3;
        this.addrs = new Vector();
    }

    public Reference(String string, RefAddr refAddr, String string2, String string3) {
        this(string, string2, string3);
        this.addrs.add(refAddr);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassName() {
        return this.classFactory;
    }

    public String getFactoryClassLocation() {
        return this.classFactoryLocation;
    }

    public Enumeration<RefAddr> getAll() {
        return this.addrs.elements();
    }

    public RefAddr get(String string) {
        Enumeration<RefAddr> enumeration = this.addrs.elements();
        RefAddr refAddr = null;
        while (enumeration.hasMoreElements()) {
            refAddr = enumeration.nextElement();
            if (!string.equals(refAddr.getType())) continue;
            return refAddr;
        }
        return null;
    }

    public RefAddr get(int n) {
        return this.addrs.get(n);
    }

    public void add(RefAddr refAddr) {
        this.addrs.add(refAddr);
    }

    public void add(int n, RefAddr refAddr) {
        this.addrs.add(n, refAddr);
    }

    public Object remove(int n) {
        return this.addrs.remove(n);
    }

    public int size() {
        return this.addrs.size();
    }

    public void clear() {
        this.addrs.clear();
    }

    public Object clone() {
        try {
            Reference reference = (Reference)super.clone();
            reference.addrs = (Vector)this.addrs.clone();
            return reference;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)Messages.getString("jndi.03"));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            return reference.className.equals(this.className) && reference.addrs.equals(this.addrs);
        }
        return false;
    }

    public int hashCode() {
        int n = this.className.hashCode();
        Enumeration<RefAddr> enumeration = this.addrs.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().hashCode();
        }
        return n;
    }

    public String toString() {
        String string = "Reference Class Name: " + this.className + "\n";
        if (this.addrs.size() > 0) {
            Enumeration<RefAddr> enumeration = this.addrs.elements();
            while (enumeration.hasMoreElements()) {
                string = string + enumeration.nextElement();
            }
        }
        return string;
    }
}

