/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameImpl;
import org.apache.harmony.jndi.internal.nls.Messages;

public class CompoundName
implements Name {
    private static final long serialVersionUID = 3513100557083972036L;
    private static final String SEPARATOR = "jndi.syntax.separator";
    private static final String SEPARATOR_AVA = "jndi.syntax.separator.ava";
    private static final String SEPARATOR_TYPEVAL = "jndi.syntax.separator.typeval";
    private static final String ESCAPE = "jndi.syntax.escape";
    private static final String BEGIN_QUOTE = "jndi.syntax.beginquote";
    private static final String END_QUOTE = "jndi.syntax.endquote";
    private static final String BEGIN_QUOTE2 = "jndi.syntax.beginquote2";
    private static final String END_QUOTE2 = "jndi.syntax.endquote2";
    private static final String IGNORE_CASE = "jndi.syntax.ignorecase";
    private static final String TRIM_BLANKS = "jndi.syntax.trimblanks";
    private static final String DIRECTION = "jndi.syntax.direction";
    private static final String SEPARATOR2 = "jndi.syntax.separator2";
    private static final String LEFT_TO_RIGHT = "left_to_right";
    private static final String RIGHT_TO_LEFT = "right_to_left";
    private static final String FLAT = "flat";
    private static final String NULL_STRING = "";
    private static final int NORMAL_STATUS = 0;
    private static final int QUOTE1_STATUS = 1;
    private static final int QUOTE2_STATUS = 2;
    private static final int INIT_STATUS = 3;
    private static final int QUOTEEND_STATUS = 4;
    private transient String separatorString;
    private transient String separatorString2;
    private transient String escapeString;
    private transient String endQuoteString;
    private transient String endQuoteString2;
    private transient String beginQuoteString;
    private transient String beginQuoteString2;
    private transient String sepAvaString;
    private transient String sepTypeValString;
    private transient String direction;
    private transient boolean trimBlanks;
    private transient boolean ignoreCase;
    private transient boolean flat;
    private transient Vector<String> elem;
    protected transient Properties mySyntax;
    protected transient NameImpl impl = new NameImpl();

    protected CompoundName(Enumeration<String> enumeration, Properties properties) {
        if (null == properties || null == enumeration) {
            throw new NullPointerException();
        }
        this.init(properties);
        this.elem = new Vector();
        while (enumeration.hasMoreElements()) {
            this.elem.add(enumeration.nextElement());
        }
    }

    public CompoundName(String string, Properties properties) throws InvalidNameException {
        if (null == string || null == properties) {
            throw new NullPointerException();
        }
        this.init(properties);
        this.parseName(string);
    }

    private void init(Properties properties) {
        this.trimBlanks = false;
        this.ignoreCase = false;
        this.mySyntax = properties;
        String string = properties.getProperty(DIRECTION);
        String string2 = this.direction = null == string ? FLAT : string;
        if (!(LEFT_TO_RIGHT.equals(this.direction) || RIGHT_TO_LEFT.equals(this.direction) || FLAT.equals(this.direction))) {
            throw new IllegalArgumentException(Messages.getString("jndi.04"));
        }
        this.flat = FLAT.equals(this.direction);
        String string3 = this.separatorString = this.flat ? NULL_STRING : properties.getProperty(SEPARATOR);
        if (null == this.separatorString && !this.flat) {
            throw new IllegalArgumentException(Messages.getString("jndi.05"));
        }
        this.separatorString2 = this.flat || null == (string = properties.getProperty(SEPARATOR2)) ? NULL_STRING : string;
        string = properties.getProperty(IGNORE_CASE);
        this.ignoreCase = null == string ? false : Boolean.valueOf(string);
        string = properties.getProperty(TRIM_BLANKS);
        this.trimBlanks = null == string ? false : Boolean.valueOf(string);
        string = properties.getProperty(ESCAPE);
        this.escapeString = null == string ? NULL_STRING : string;
        string = properties.getProperty(BEGIN_QUOTE);
        this.beginQuoteString = null == string ? NULL_STRING : string;
        string = properties.getProperty(BEGIN_QUOTE2);
        this.beginQuoteString2 = null == string ? NULL_STRING : string;
        string = properties.getProperty(END_QUOTE);
        String string4 = this.endQuoteString = null == string ? this.beginQuoteString : string;
        if (NULL_STRING.equals(this.beginQuoteString)) {
            this.beginQuoteString = this.endQuoteString;
        }
        String string5 = this.endQuoteString2 = null == (string = properties.getProperty(END_QUOTE2)) ? this.beginQuoteString2 : string;
        if (NULL_STRING.equals(this.beginQuoteString2)) {
            this.beginQuoteString2 = this.endQuoteString2;
        }
        this.sepTypeValString = null == (string = properties.getProperty(SEPARATOR_TYPEVAL)) ? NULL_STRING : string;
        string = properties.getProperty(SEPARATOR_AVA);
        this.sepAvaString = null == string ? NULL_STRING : string;
    }

    private void parseName(String string) throws InvalidNameException {
        this.elem = new Vector();
        if (NULL_STRING.equals(string)) {
            return;
        }
        int n = 3;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        while (n2 < n3) {
            if (this.startsWithFromPos(string, n2, this.endQuoteString) && n == 1) {
                n = 4;
                n2 += this.addBuffer(stringBuilder, this.endQuoteString, bl2);
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.endQuoteString2) && n == 2) {
                n = 4;
                n2 += this.addBuffer(stringBuilder, this.endQuoteString2, bl2);
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.beginQuoteString) && n == 3) {
                bl = true;
                n = 1;
                n2 += this.addBuffer(stringBuilder, this.beginQuoteString, bl2);
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.beginQuoteString2) && n == 3) {
                bl = true;
                n = 2;
                n2 += this.addBuffer(stringBuilder, this.beginQuoteString2, bl2);
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.separatorString) && !this.flat && (n == 3 || n == 4 || n == 0)) {
                bl = bl || stringBuilder.length() > 0;
                this.addElement(stringBuilder);
                n = 3;
                n2 += this.separatorString.length();
                bl2 = false;
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.separatorString2) && !this.flat && (n == 3 || n == 4 || n == 0)) {
                bl = bl || stringBuilder.length() > 0;
                this.addElement(stringBuilder);
                n = 3;
                n2 += this.separatorString2.length();
                bl2 = false;
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.escapeString)) {
                if ((n2 += this.escapeString.length()) == string.length()) {
                    throw new InvalidNameException(Messages.getString("jndi.06", this.escapeString));
                }
                String string2 = this.extractEscapedString(string, n2, n);
                if (null == string2) {
                    n2 -= this.escapeString.length();
                    stringBuilder.append(string.charAt(n2++));
                    continue;
                }
                n2 += string2.length();
                stringBuilder.append(string2);
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.sepTypeValString) && (n == 3 || n == 0)) {
                bl2 = true;
                n2 += this.addBuffer(stringBuilder, this.sepTypeValString, true);
                n = 3;
                continue;
            }
            if (this.startsWithFromPos(string, n2, this.sepAvaString) && (n == 3 || n == 0)) {
                bl2 = true;
                n2 += this.addBuffer(stringBuilder, this.sepAvaString, true);
                n = 3;
                continue;
            }
            if (n == 4) {
                throw new InvalidNameException(Messages.getString("jndi.07", string));
            }
            n = n == 3 ? 0 : n;
            stringBuilder.append(string.charAt(n2++));
        }
        if (1 == n || 2 == n) {
            throw new InvalidNameException(Messages.getString("jndi.08", string));
        }
        bl = bl || stringBuilder.length() > 0;
        this.addElement(stringBuilder);
        if (!bl) {
            this.elem.remove(this.elem.size() - 1);
        }
    }

    private int addBuffer(StringBuilder stringBuilder, String string, boolean bl) {
        if (bl) {
            stringBuilder.append(string);
        }
        return string.length();
    }

    private void addElement(StringBuilder stringBuilder) {
        if (LEFT_TO_RIGHT == this.direction) {
            this.elem.add(stringBuilder.toString());
        } else {
            this.elem.add(0, stringBuilder.toString());
        }
        stringBuilder.setLength(0);
    }

    private String extractEscapedString(String string, int n, int n2) {
        String string2 = null;
        if (n2 == 1 && this.startsWithFromPos(string, n, this.endQuoteString)) {
            string2 = this.endQuoteString;
        } else if (n2 == 2 && this.startsWithFromPos(string, n, this.endQuoteString2)) {
            string2 = this.endQuoteString2;
        } else if (n2 != 1 && n2 != 2) {
            if (this.startsWithFromPos(string, n, this.beginQuoteString)) {
                string2 = this.beginQuoteString;
            } else if (this.startsWithFromPos(string, n, this.beginQuoteString2)) {
                string2 = this.beginQuoteString2;
            } else if (this.startsWithFromPos(string, n, this.endQuoteString)) {
                string2 = this.endQuoteString;
            } else if (this.startsWithFromPos(string, n, this.endQuoteString2)) {
                string2 = this.endQuoteString2;
            } else if (this.startsWithFromPos(string, n, this.separatorString)) {
                string2 = this.separatorString;
            } else if (this.startsWithFromPos(string, n, this.separatorString2)) {
                string2 = this.separatorString2;
            } else if (this.startsWithFromPos(string, n, this.escapeString)) {
                string2 = this.escapeString;
            }
        }
        return string2;
    }

    private boolean startsWithFromPos(String string, int n, String string2) {
        if (null == string || null == string2 || NULL_STRING.equals(string2) || string.length() - n < string2.length()) {
            return false;
        }
        int n2 = string2.length();
        int n3 = -1;
        while (++n3 < n2 && string.charAt(n + n3) == string2.charAt(n3)) {
        }
        return n3 == n2;
    }

    @Override
    public Enumeration<String> getAll() {
        return this.elem.elements();
    }

    @Override
    public String get(int n) {
        this.validateIndex(n, false);
        return this.elem.elementAt(n);
    }

    private void validateIndex(int n, boolean bl) {
        if (0 > n || n > this.elem.size() || !bl && n == this.elem.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public Name getPrefix(int n) {
        this.validateIndex(n, true);
        return new CompoundName(new Vector<String>(this.elem.subList(0, n)).elements(), this.mySyntax);
    }

    @Override
    public Name getSuffix(int n) {
        if (n == this.elem.size()) {
            return new CompoundName(new Vector().elements(), this.mySyntax);
        }
        this.validateIndex(n, false);
        return new CompoundName(new Vector<String>(this.elem.subList(n, this.elem.size())).elements(), this.mySyntax);
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.elem.size(), name);
    }

    @Override
    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.00"));
        }
        if (!(name instanceof CompoundName)) {
            throw new InvalidNameException(Messages.getString("jndi.09", name.toString()));
        }
        if (FLAT.equals(this.direction) && this.size() + name.size() > 1) {
            throw new InvalidNameException(Messages.getString("jndi.0A"));
        }
        this.validateIndex(n, true);
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            this.elem.add(n++, enumeration.nextElement());
        }
        return this;
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("jndi.8C"));
        }
        if (FLAT.equals(this.direction) && this.size() > 0) {
            throw new InvalidNameException(Messages.getString("jndi.0A"));
        }
        this.elem.add(string);
        return this;
    }

    @Override
    public Name add(int n, String string) throws InvalidNameException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("jndi.8C"));
        }
        if (FLAT.equals(this.direction) && this.size() > 0) {
            throw new InvalidNameException(Messages.getString("jndi.0A"));
        }
        this.validateIndex(n, true);
        this.elem.add(n, string);
        return this;
    }

    @Override
    public Object remove(int n) throws InvalidNameException {
        this.validateIndex(n, false);
        return this.elem.remove(n);
    }

    @Override
    public Object clone() {
        return new CompoundName(this.getAll(), this.mySyntax);
    }

    @Override
    public int size() {
        return this.elem.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elem.isEmpty();
    }

    @Override
    public boolean startsWith(Name name) {
        if (!(name instanceof CompoundName)) {
            return false;
        }
        return this.equals(name, 0, name.size());
    }

    @Override
    public boolean endsWith(Name name) {
        if (!(name instanceof CompoundName)) {
            return false;
        }
        return this.equals(name, this.size() - name.size(), name.size());
    }

    private String preProcess(String string, boolean bl, boolean bl2) {
        String string2 = string;
        if (null != string && !NULL_STRING.equals(string)) {
            string2 = bl ? string2.toLowerCase() : string2;
            string2 = bl2 ? string2.trim() : string2;
        }
        return string2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.mySyntax);
        objectOutputStream.writeInt(this.elem.size());
        for (int i = 0; i < this.elem.size(); ++i) {
            String string = this.elem.elementAt(i);
            objectOutputStream.writeObject(string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init((Properties)objectInputStream.readObject());
        int n = objectInputStream.readInt();
        this.elem = new Vector();
        for (int i = 0; i < n; ++i) {
            this.elem.add((String)objectInputStream.readObject());
        }
    }

    @Override
    public int compareTo(Object object) {
        int n;
        if (!(object instanceof CompoundName)) {
            throw new ClassCastException();
        }
        int n2 = -1;
        CompoundName compoundName = (CompoundName)object;
        Enumeration<String> enumeration = compoundName.getAll();
        for (n = 0; n < this.size() && enumeration.hasMoreElements(); ++n) {
            String string = this.preProcess(this.elem.get(n), this.ignoreCase, this.trimBlanks);
            String string2 = this.preProcess(enumeration.nextElement(), this.ignoreCase, this.trimBlanks);
            int n3 = null == string ? (null == string2 ? 0 : -1) : (n2 = string.compareTo(string2));
            if (0 == n2) continue;
            return n2;
        }
        if (n < this.size()) {
            n2 = 1;
        } else if (enumeration.hasMoreElements()) {
            n2 = -1;
        }
        return n2;
    }

    public int hashCode() {
        int n = 0;
        Enumeration<String> enumeration = this.elem.elements();
        while (enumeration.hasMoreElements()) {
            n += this.preProcess(enumeration.nextElement(), this.ignoreCase, this.trimBlanks).hashCode();
        }
        return n;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = NULL_STRING.equals(this.beginQuoteString) ? this.beginQuoteString2 : this.beginQuoteString;
        String string3 = NULL_STRING.equals(this.endQuoteString) ? this.endQuoteString2 : this.endQuoteString;
        String string4 = string = NULL_STRING.equals(this.separatorString) ? this.separatorString2 : this.separatorString;
        if (RIGHT_TO_LEFT.equals(this.direction)) {
            for (int i = this.elem.size() - 1; i >= 0; --i) {
                this.addElement(stringBuilder, i, string, string2, string3);
            }
        } else {
            for (int i = 0; i < this.elem.size(); ++i) {
                this.addElement(stringBuilder, i, string, string2, string3);
            }
        }
        if (this.size() * string.length() < stringBuilder.length()) {
            stringBuilder.setLength(stringBuilder.length() - string.length());
        }
        return stringBuilder.toString();
    }

    private void addElement(StringBuilder stringBuilder, int n, String string, String string2, String string3) {
        String string4 = this.elem.get(n);
        if (0 == string4.length()) {
            stringBuilder.append(string);
            return;
        }
        int n2 = stringBuilder.length();
        stringBuilder.append(string4);
        if (!(NULL_STRING.equals(string2) || NULL_STRING.equals(string3) || NULL_STRING.equals(string) || 0 > string4.indexOf(string))) {
            stringBuilder.insert(n2, string2);
            n2 += string2.length();
            int n3 = 0;
            int n4 = 0;
            while (0 <= (n4 = string4.indexOf(string3, n3))) {
                stringBuilder.insert(n2 + n4, this.escapeString);
                n2 += this.escapeString.length();
                n3 = n4 + string3.length();
            }
            stringBuilder.append(string3);
        } else {
            if (this.startsWithFromPos(string4, 0, this.beginQuoteString) || this.startsWithFromPos(string4, 0, this.beginQuoteString2)) {
                stringBuilder.insert(n2, this.escapeString);
                n2 += this.escapeString.length();
            }
            int n5 = 0;
            while (n5 < string4.length()) {
                if (this.startsWithFromPos(string4, n5, this.separatorString)) {
                    stringBuilder.insert(n2 + n5, this.escapeString);
                    n2 += this.escapeString.length();
                    n5 += this.separatorString.length();
                    continue;
                }
                if (this.startsWithFromPos(string4, n5, this.separatorString2)) {
                    stringBuilder.insert(n2 + n5, this.escapeString);
                    n2 += this.escapeString.length();
                    n5 += this.separatorString2.length();
                    continue;
                }
                if (this.startsWithFromPos(string4, n5, this.escapeString)) {
                    stringBuilder.insert(n2 + n5, this.escapeString);
                    n2 += this.escapeString.length();
                    n5 += this.escapeString.length();
                    continue;
                }
                ++n5;
            }
        }
        stringBuilder.append(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompoundName)) {
            return false;
        }
        CompoundName compoundName = (CompoundName)object;
        int n = compoundName.size();
        if (n != this.size()) {
            return false;
        }
        return this.equals(compoundName, 0, n);
    }

    private boolean equals(Name name, int n, int n2) {
        if (n2 > this.size()) {
            return false;
        }
        CompoundName compoundName = (CompoundName)name;
        Enumeration<String> enumeration = compoundName.getAll();
        for (int i = 0; i < n2; ++i) {
            String string = this.preProcess(this.elem.get(i + n), this.ignoreCase, this.trimBlanks);
            String string2 = this.preProcess(enumeration.nextElement(), this.ignoreCase, this.trimBlanks);
            if (null != string ? string.equals(string2) : null == string2) continue;
            return false;
        }
        return true;
    }
}

