/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.SunVolatileImage;
import sun.awt.windows.WComponentPeer;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.opengl.WGLSurfaceData;

public class WGLGraphicsConfig
extends Win32GraphicsConfig
implements OGLGraphicsConfig {
    protected static boolean wglAvailable;
    private static ImageCapabilities imageCaps;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private int oglCaps;
    private OGLContext context;
    private Object disposerReferent = new Object();

    public static native int getDefaultPixFmt(int var0);

    private static native boolean initWGL();

    private static native long getWGLConfigInfo(int var0, int var1);

    private static native int getOGLCapabilities(long var0);

    protected WGLGraphicsConfig(Win32GraphicsDevice win32GraphicsDevice, int n, long l, int n2) {
        super(win32GraphicsDevice, n);
        this.pConfigInfo = l;
        this.oglCaps = n2;
        this.context = new OGLContext(OGLRenderQueue.getInstance());
        Disposer.addRecord(this.disposerReferent, new WGLGCDisposerRecord(this.pConfigInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WGLGraphicsConfig getConfig(Win32GraphicsDevice win32GraphicsDevice, int n) {
        if (!wglAvailable) {
            return null;
        }
        long l = 0L;
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
            WGLGetConfigInfo wGLGetConfigInfo = new WGLGetConfigInfo(win32GraphicsDevice.getScreen(), n);
            oGLRenderQueue.flushAndInvokeNow(wGLGetConfigInfo);
            l = wGLGetConfigInfo.getConfigInfo();
        }
        finally {
            oGLRenderQueue.unlock();
        }
        if (l == 0L) {
            return null;
        }
        int n2 = WGLGraphicsConfig.getOGLCapabilities(l);
        return new WGLGraphicsConfig(win32GraphicsDevice, n, l, n2);
    }

    public static boolean isWGLAvailable() {
        return wglAvailable;
    }

    public final boolean isCapPresent(int n) {
        return (this.oglCaps & n) != 0;
    }

    public final long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    public final OGLContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayChanged() {
        super.displayChanged();
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public String toString() {
        return "WGLGraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    public SurfaceData createSurfaceData(WComponentPeer wComponentPeer, int n) {
        return WGLSurfaceData.createData(wComponentPeer);
    }

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
    }

    public VolatileImage createBackBuffer(WComponentPeer wComponentPeer) {
        Component component = (Component)wComponentPeer.getTarget();
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(WComponentPeer wComponentPeer, Component component, VolatileImage volatileImage, BufferCapabilities.FlipContents flipContents) {
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            Graphics graphics = wComponentPeer.getGraphics();
            try {
                graphics.drawImage(volatileImage, 0, 0, null);
            }
            finally {
                graphics.dispose();
            }
            return;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        OGLSurfaceData.swapBuffers(wComponentPeer.getData());
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics graphics = volatileImage.getGraphics();
            try {
                graphics.setColor(component.getBackground());
                graphics.fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                graphics.dispose();
            }
        }
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            boolean bl = this.isCapPresent(1);
            this.bufferCaps = new WGLBufferCaps(bl);
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    static {
        imageCaps = new WGLImageCaps();
        wglAvailable = WGLGraphicsConfig.initWGL();
    }

    private static class WGLImageCaps
    extends ImageCapabilities {
        private WGLImageCaps() {
            super(true);
        }

        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class WGLBufferCaps
    extends BufferCapabilities {
        public WGLBufferCaps(boolean bl) {
            super(imageCaps, imageCaps, bl ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class WGLGCDisposerRecord
    implements DisposerRecord {
        private long pCfgInfo;

        public WGLGCDisposerRecord(long l) {
            this.pCfgInfo = l;
        }

        public void dispose() {
            if (this.pCfgInfo != 0L) {
                OGLRenderQueue.disposeGraphicsConfig(this.pCfgInfo);
                this.pCfgInfo = 0L;
            }
        }
    }

    private static class WGLGetConfigInfo
    implements Runnable {
        private int screen;
        private int pixfmt;
        private long cfginfo;

        private WGLGetConfigInfo(int n, int n2) {
            this.screen = n;
            this.pixfmt = n2;
        }

        public void run() {
            this.cfginfo = WGLGraphicsConfig.getWGLConfigInfo(this.screen, this.pixfmt);
        }

        public long getConfigInfo() {
            return this.cfginfo;
        }
    }
}

