/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import sun.awt.Win32GraphicsDevice;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.pipe.Region;
import sun.java2d.windows.WindowsFlags;

public class D3DContext {
    public static final int NO_CONTEXT_FLAGS = 0;
    public static final int SRC_IS_OPAQUE = 1;
    public static final int J2D_D3D_FAILURE = 0;
    public static final int J2D_D3D_DEPTH_SURFACE_OK = 1;
    public static final int J2D_D3D_PLAIN_SURFACE_OK = 2;
    public static final int J2D_D3D_OP_TEXTURE_SURFACE_OK = 4;
    public static final int J2D_D3D_BM_TEXTURE_SURFACE_OK = 8;
    public static final int J2D_D3D_TR_TEXTURE_SURFACE_OK = 16;
    public static final int J2D_D3D_OP_RTT_SURFACE_OK = 32;
    public static final int J2D_D3D_LINES_OK = 64;
    public static final int J2D_D3D_TEXTURE_BLIT_OK = 128;
    public static final int J2D_D3D_TEXTURE_TRANSFORM_OK = 256;
    public static final int J2D_D3D_LINE_CLIPPING_OK = 512;
    public static final int J2D_D3D_DEVICE_OK = 1024;
    public static final int J2D_D3D_PIXEL_FORMATS_OK = 2048;
    public static final int J2D_D3D_SET_TRANSFORM_OK = 4096;
    public static final int J2D_D3D_HW_OK = 8192;
    public static final int J2D_D3D_ENABLED_OK = 16384;
    static Object LOCK;
    private Win32GraphicsDevice gd;
    private boolean valid;
    protected long nativeContext;
    private SurfaceData validatedDstData;
    private Region validatedClip;
    private Composite validatedComp;
    private int validatedPixel;
    private int validatedFlags;
    private boolean xformInUse;
    private double vScaleX;
    private double vScaleY;
    private double vShearX;
    private double vShearY;
    private double vTransX;
    private double vTransY;
    private int deviceCaps;

    private native void setRenderTarget(long var1, long var3);

    private native void setClip(long var1, long var3, Region var5, boolean var6, int var7, int var8, int var9, int var10);

    private native void resetClip(long var1, long var3);

    private native void resetComposite(long var1);

    private native void setAlphaComposite(long var1, int var3, float var4, int var5);

    private native void setTransform(long var1, long var3, AffineTransform var5, double var6, double var8, double var10, double var12, double var14, double var16);

    private native void resetTransform(long var1, long var3);

    private native void setColor(long var1, int var3, int var4);

    private native long initNativeContext(int var1);

    private native int getNativeDeviceCaps(long var1);

    public D3DContext(Win32GraphicsDevice win32GraphicsDevice) {
        this.gd = win32GraphicsDevice;
        this.reinitNativeContext();
    }

    void reinitNativeContext() {
        this.nativeContext = this.initNativeContext(this.gd.getScreen());
        this.deviceCaps = this.nativeContext != 0L ? this.getNativeDeviceCaps(this.nativeContext) : 0;
        boolean bl = this.valid = (this.deviceCaps & 0x4000) != 0;
        if (WindowsFlags.isD3DVerbose()) {
            if (this.valid) {
                System.out.println("Direct3D pipeline enabled on screen " + this.gd.getScreen());
            } else {
                System.out.println("Could not enable Direct3D pipeline on screen " + this.gd.getScreen() + ". Device Caps: " + Integer.toHexString(this.deviceCaps));
            }
        }
    }

    private void invalidateContext() {
        this.valid = false;
        this.nativeContext = 0L;
        this.validatedDstData = null;
    }

    static long getContext(SurfaceData surfaceData, SurfaceData surfaceData2, Region region, Composite composite, AffineTransform affineTransform, int n, int n2) {
        if (!(surfaceData2 instanceof D3DSurfaceData)) {
            throw new InvalidPipeException("Incorrect destination surface");
        }
        D3DContext d3DContext = ((D3DSurfaceData)surfaceData2).getContext();
        try {
            d3DContext.validate(surfaceData, surfaceData2, region, composite, affineTransform, n, n2);
        }
        catch (InvalidPipeException invalidPipeException) {
            d3DContext.invalidateContext();
        }
        return d3DContext.getNativeContext();
    }

    public int getDeviceCaps() {
        return this.deviceCaps;
    }

    boolean isRTTSupported() {
        return (this.deviceCaps & 0x20) != 0;
    }

    long getNativeContext() {
        return this.nativeContext;
    }

    private void validate(SurfaceData surfaceData, SurfaceData surfaceData2, Region region, Composite composite, AffineTransform affineTransform, int n, int n2) {
        Object object;
        long l;
        boolean bl = false;
        if (surfaceData != null && !surfaceData.isValid() || !surfaceData2.isValid() || surfaceData2.getNativeOps() == 0L || surfaceData2.isSurfaceLost()) {
            throw new InvalidPipeException("Invalid surface");
        }
        if (!this.valid) {
            this.reinitNativeContext();
        }
        if (surfaceData2 != this.validatedDstData) {
            this.validatedPixel = ~n;
            bl = true;
            l = surfaceData2.getNativeOps();
            this.setRenderTarget(this.nativeContext, l);
            object = surfaceData2;
            this.validatedDstData = surfaceData2;
            object = null;
        }
        l = surfaceData2.getNativeOps();
        if (region != this.validatedClip || bl) {
            if (region != null) {
                if (bl || this.validatedClip == null || !this.validatedClip.isRectangular() || !region.isRectangular() || region.getLoX() != this.validatedClip.getLoX() || region.getLoY() != this.validatedClip.getLoY() || region.getHiX() != this.validatedClip.getHiX() || region.getHiY() != this.validatedClip.getHiY()) {
                    this.setClip(this.nativeContext, l, region, region.isRectangular(), region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY());
                }
            } else {
                this.resetClip(this.nativeContext, l);
            }
            this.validatedClip = region;
        }
        if (composite != this.validatedComp || n2 != this.validatedFlags) {
            this.validatedPixel = ~n;
            this.validatedComp = composite;
            if (composite != null) {
                object = (AlphaComposite)composite;
                this.setAlphaComposite(this.nativeContext, ((AlphaComposite)object).getRule(), ((AlphaComposite)object).getAlpha(), n2);
            } else {
                this.resetComposite(this.nativeContext);
            }
        }
        if (affineTransform == null) {
            if (this.xformInUse) {
                this.resetTransform(this.nativeContext, l);
                this.xformInUse = false;
                this.vScaleY = 1.0;
                this.vScaleX = 1.0;
                this.vTransY = 0.0;
                this.vTransX = 0.0;
                this.vShearY = 0.0;
                this.vShearX = 0.0;
            }
        } else {
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getScaleY();
            double d3 = affineTransform.getShearX();
            double d4 = affineTransform.getShearY();
            double d5 = affineTransform.getTranslateX();
            double d6 = affineTransform.getTranslateY();
            if (d5 != this.vTransX || d6 != this.vTransY || d != this.vScaleX || d2 != this.vScaleY || d3 != this.vShearX || d4 != this.vShearY) {
                this.setTransform(this.nativeContext, l, affineTransform, d, d4, d3, d2, d5, d6);
                this.vScaleX = d;
                this.vScaleY = d2;
                this.vShearX = d3;
                this.vShearY = d4;
                this.vTransX = d6;
                this.vTransY = d6;
                this.xformInUse = true;
            }
        }
        if (n != this.validatedPixel) {
            this.validatedPixel = n;
            this.setColor(this.nativeContext, n, n2);
        }
        this.validatedFlags = n2;
        surfaceData2.markDirty();
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            LOCK = D3DContext.class;
        }
    }
}

