/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> clazz, Class<W> clazz2, String string) {
        return new AtomicReferenceFieldUpdaterImpl<U, W>(clazz, clazz2, string);
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T t, V v) {
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), v)) {
        }
        return v2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<V> vclass;
        private final Class cclass;

        AtomicReferenceFieldUpdaterImpl(Class<T> clazz, Class<V> clazz2, String string) {
            Field field = null;
            Class<?> clazz3 = null;
            Class clazz4 = null;
            int n = 0;
            try {
                field = clazz.getDeclaredField(string);
                clazz4 = Reflection.getCallerClass(3);
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz4, clazz, null, n);
                ReflectUtil.checkPackageAccess(clazz);
                clazz3 = field.getType();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (clazz2 != clazz3) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz4 != clazz ? clazz4 : null;
            this.tclass = clazz;
            this.vclass = clazz2 == Object.class ? null : clazz2;
            this.offset = unsafe.objectFieldOffset(field);
        }

        void targetCheck(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
        }

        void updateCheck(T t, V v) {
            if (!this.tclass.isInstance(t) || v != null && this.vclass != null && !this.vclass.isInstance(v)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
        }

        @Override
        public boolean compareAndSet(T t, V v, V v2) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v2 != null && this.vclass != null && this.vclass != v2.getClass()) {
                this.updateCheck(t, v2);
            }
            return unsafe.compareAndSwapObject(t, this.offset, v, v2);
        }

        @Override
        public boolean weakCompareAndSet(T t, V v, V v2) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v2 != null && this.vclass != null && this.vclass != v2.getClass()) {
                this.updateCheck(t, v2);
            }
            return unsafe.compareAndSwapObject(t, this.offset, v, v2);
        }

        @Override
        public void set(T t, V v) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v != null && this.vclass != null && this.vclass != v.getClass()) {
                this.updateCheck(t, v);
            }
            unsafe.putObjectVolatile(t, this.offset, v);
        }

        @Override
        public void lazySet(T t, V v) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v != null && this.vclass != null && this.vclass != v.getClass()) {
                this.updateCheck(t, v);
            }
            unsafe.putObjectVolatile(t, this.offset, v);
        }

        @Override
        public V get(T t) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null) {
                this.targetCheck(t);
            }
            return (V)unsafe.getObjectVolatile(t, this.offset);
        }

        private void ensureProtectedAccess(T t) {
            if (this.cclass.isInstance(t)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }
    }
}

