/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    private volatile int value;

    public AtomicInteger(int n) {
        this.value = n;
    }

    public AtomicInteger() {
    }

    public final int get() {
        return this.value;
    }

    public final void set(int n) {
        this.value = n;
    }

    public final void lazySet(int n) {
        unsafe.putIntVolatile(this, valueOffset, n);
    }

    public final int getAndSet(int n) {
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n)) {
        }
        return n2;
    }

    public final boolean compareAndSet(int n, int n2) {
        return unsafe.compareAndSwapInt(this, valueOffset, n, n2);
    }

    public final boolean weakCompareAndSet(int n, int n2) {
        return unsafe.compareAndSwapInt(this, valueOffset, n, n2);
    }

    public final int getAndIncrement() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 + 1)) {
        }
        return n2;
    }

    public final int getAndDecrement() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 - 1)) {
        }
        return n2;
    }

    public final int getAndAdd(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 + n)) {
        }
        return n3;
    }

    public final int incrementAndGet() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 + 1)) {
        }
        return n;
    }

    public final int decrementAndGet() {
        int n;
        int n2;
        while (!this.compareAndSet(n2 = this.get(), n = n2 - 1)) {
        }
        return n;
    }

    public final int addAndGet(int n) {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 + n)) {
        }
        return n2;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicInteger.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

