/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.SyncFailedException;

public final class FileDescriptor {
    private int fd;
    private int fd2;
    private int boundfd;
    private int fdinuse;
    private int refCount = 0;
    private long handle;
    public static final FileDescriptor in;
    public static final FileDescriptor out;
    public static final FileDescriptor err;

    public FileDescriptor() {
        this.fd = -1;
        this.handle = -1L;
        this.fd2 = -1;
        this.boundfd = -1;
        this.fdinuse = -1;
    }

    private FileDescriptor(int n) {
        this.fd = n;
        this.handle = -1L;
        this.fd2 = -1;
        this.boundfd = -1;
        this.fdinuse = -1;
    }

    int read() throws IOException {
        return this.read(this.handle);
    }

    private native int read(long var1) throws IOException;

    public boolean valid() {
        return this.handle != -1L || this.fd != -1 || this.fd2 != -1;
    }

    public native void sync() throws SyncFailedException;

    synchronized void incRefCount() {
        ++this.refCount;
    }

    synchronized int decRefCount() {
        --this.refCount;
        return this.refCount;
    }

    private static native void initIDs();

    private static native long set(int var0);

    private static FileDescriptor standardStream(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.handle = FileDescriptor.set(n);
        return fileDescriptor;
    }

    static {
        FileDescriptor.initIDs();
        in = FileDescriptor.standardStream(0);
        out = FileDescriptor.standardStream(1);
        err = FileDescriptor.standardStream(2);
    }
}

