/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.oa.poa;

import com.sun.corba.se.impl.oa.poa.DelegateImpl;
import com.sun.corba.se.impl.oa.poa.POAFactory;
import com.sun.corba.se.impl.oa.poa.POAImpl;
import com.sun.corba.se.impl.oa.poa.POAManagerImpl;
import com.sun.corba.se.impl.oa.poa.POAPolicyMediator;
import com.sun.corba.se.impl.oa.poa.Policies;
import com.sun.corba.se.impl.orbutil.ORBConstants;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.orb.ORB;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;

public abstract class POAPolicyMediatorBase
implements POAPolicyMediator {
    protected POAImpl poa;
    protected ORB orb;
    private int sysIdCounter;
    private Policies policies;
    private DelegateImpl delegateImpl;
    private int serverid;
    private int scid;
    protected boolean isImplicit;
    protected boolean isUnique;
    protected boolean isSystemId;

    public final Policies getPolicies() {
        return this.policies;
    }

    public final int getScid() {
        return this.scid;
    }

    public final int getServerId() {
        return this.serverid;
    }

    POAPolicyMediatorBase(Policies policies, POAImpl pOAImpl) {
        if (policies.isSingleThreaded()) {
            throw pOAImpl.invocationWrapper().singleThreadNotSupported();
        }
        POAManagerImpl pOAManagerImpl = (POAManagerImpl)pOAImpl.the_POAManager();
        POAFactory pOAFactory = pOAManagerImpl.getFactory();
        this.delegateImpl = (DelegateImpl)pOAFactory.getDelegateImpl();
        this.policies = policies;
        this.poa = pOAImpl;
        this.orb = pOAImpl.getORB();
        switch (policies.servantCachingLevel()) {
            case 0: {
                this.scid = 32;
                break;
            }
            case 1: {
                this.scid = 36;
                break;
            }
            case 2: {
                this.scid = 40;
                break;
            }
            case 3: {
                this.scid = 44;
            }
        }
        if (policies.isTransient()) {
            this.serverid = this.orb.getTransientServerId();
        } else {
            this.serverid = this.orb.getORBData().getPersistentServerId();
            this.scid = ORBConstants.makePersistent(this.scid);
        }
        this.isImplicit = policies.isImplicitlyActivated();
        this.isUnique = policies.isUniqueIds();
        this.isSystemId = policies.isSystemAssignedIds();
        this.sysIdCounter = 0;
    }

    public final Object getInvocationServant(byte[] byArray, String string) throws ForwardRequest {
        Object object = this.internalGetServant(byArray, string);
        return object;
    }

    protected final void setDelegate(Servant servant, byte[] byArray) {
        servant._set_delegate((Delegate)this.delegateImpl);
    }

    public synchronized byte[] newSystemId() throws WrongPolicy {
        if (!this.isSystemId) {
            throw new WrongPolicy();
        }
        byte[] byArray = new byte[8];
        ORBUtility.intToBytes(++this.sysIdCounter, byArray, 0);
        ORBUtility.intToBytes(this.poa.getPOAId(), byArray, 4);
        return byArray;
    }

    protected abstract Object internalGetServant(byte[] var1, String var2) throws ForwardRequest;
}

