/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.interceptors;

import com.sun.corba.se.impl.logging.InterceptorsSystemException;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.ior.TaggedComponent;
import com.sun.corba.se.spi.ior.TaggedComponentFactoryFinder;
import com.sun.corba.se.spi.ior.TaggedProfileTemplate;
import com.sun.corba.se.spi.legacy.interceptor.IORInfoExt;
import com.sun.corba.se.spi.legacy.interceptor.UnknownType;
import com.sun.corba.se.spi.oa.ObjectAdapter;
import com.sun.corba.se.spi.orb.ORB;
import java.util.Iterator;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.ObjectReferenceFactory;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;

public final class IORInfoImpl
extends LocalObject
implements IORInfo,
IORInfoExt {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_ESTABLISHED = 1;
    private static final int STATE_DONE = 2;
    private int state = 0;
    private ObjectAdapter adapter;
    private ORB orb;
    private ORBUtilSystemException orbutilWrapper;
    private InterceptorsSystemException wrapper;
    private OMGSystemException omgWrapper;

    IORInfoImpl(ObjectAdapter objectAdapter) {
        this.orb = objectAdapter.getORB();
        this.orbutilWrapper = ORBUtilSystemException.get(this.orb, "rpc.protocol");
        this.wrapper = InterceptorsSystemException.get(this.orb, "rpc.protocol");
        this.omgWrapper = OMGSystemException.get(this.orb, "rpc.protocol");
        this.adapter = objectAdapter;
    }

    public Policy get_effective_policy(int n) {
        this.checkState(0, 1);
        return this.adapter.getEffectivePolicy(n);
    }

    public void add_ior_component(org.omg.IOP.TaggedComponent taggedComponent) {
        this.checkState(0);
        if (taggedComponent == null) {
            this.nullParam();
        }
        this.addIORComponentToProfileInternal(taggedComponent, this.adapter.getIORTemplate().iterator());
    }

    public void add_ior_component_to_profile(org.omg.IOP.TaggedComponent taggedComponent, int n) {
        this.checkState(0);
        if (taggedComponent == null) {
            this.nullParam();
        }
        this.addIORComponentToProfileInternal(taggedComponent, this.adapter.getIORTemplate().iteratorById(n));
    }

    public int getServerPort(String string) throws UnknownType {
        this.checkState(0, 1);
        int n = this.orb.getLegacyServerSocketManager().legacyGetTransientOrPersistentServerPort(string);
        if (n == -1) {
            throw new UnknownType();
        }
        return n;
    }

    public ObjectAdapter getObjectAdapter() {
        return this.adapter;
    }

    public int manager_id() {
        this.checkState(0, 1);
        return this.adapter.getManagerId();
    }

    public short state() {
        this.checkState(0, 1);
        return this.adapter.getState();
    }

    public ObjectReferenceTemplate adapter_template() {
        this.checkState(1);
        return this.adapter.getAdapterTemplate();
    }

    public ObjectReferenceFactory current_factory() {
        this.checkState(1);
        return this.adapter.getCurrentFactory();
    }

    public void current_factory(ObjectReferenceFactory objectReferenceFactory) {
        this.checkState(1);
        this.adapter.setCurrentFactory(objectReferenceFactory);
    }

    private void addIORComponentToProfileInternal(org.omg.IOP.TaggedComponent taggedComponent, Iterator iterator) {
        TaggedComponentFactoryFinder taggedComponentFactoryFinder = this.orb.getTaggedComponentFactoryFinder();
        TaggedComponent taggedComponent2 = taggedComponentFactoryFinder.create((org.omg.CORBA.ORB)this.orb, taggedComponent);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl = true;
            TaggedProfileTemplate taggedProfileTemplate = (TaggedProfileTemplate)iterator.next();
            taggedProfileTemplate.add(taggedComponent2);
        }
        if (!bl) {
            throw this.omgWrapper.invalidProfileId();
        }
    }

    private void nullParam() {
        throw this.orbutilWrapper.nullParam();
    }

    private void checkState(int n) {
        if (n != this.state) {
            throw this.wrapper.badState1(new Integer(n), new Integer(this.state));
        }
    }

    private void checkState(int n, int n2) {
        if (n != this.state && n2 != this.state) {
            throw this.wrapper.badState2(new Integer(n), new Integer(n2), new Integer(this.state));
        }
    }

    void makeStateEstablished() {
        this.checkState(0);
        this.state = 1;
    }

    void makeStateDone() {
        this.checkState(1);
        this.state = 2;
    }
}

