/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import com.ibm.security.bootstrap.AlgorithmId;
import com.ibm.security.bootstrap.RSAKeyFactory;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPublicKey;
import sun.security.x509.X509Key;

public final class RSAPublicKeyImpl
extends X509Key
implements RSAPublicKey {
    private static final long serialVersionUID = 2644735423591199609L;
    private BigInteger n;
    private BigInteger e;
    protected AlgorithmId algid;
    static final AlgorithmId rsaId = new AlgorithmId(AlgorithmId.RSAEncryption_oid);

    public RSAPublicKeyImpl(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.n = bigInteger;
        this.e = bigInteger2;
        RSAKeyFactory.checkKeyLength(bigInteger);
        this.algid = rsaId;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public RSAPublicKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.checkKeyLength(this.n);
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream derInputStream2 = derValue.getData();
            this.n = RSAPublicKeyImpl.getBigInteger(derInputStream2);
            this.e = RSAPublicKeyImpl.getBigInteger(derInputStream2);
            if (derValue.getData().available() != 0) {
                throw new IOException("Extra data available");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid RSA public key", iOException);
        }
    }

    public String toString() {
        return "Sun RSA public key, " + this.n.bitLength() + " bits\n  modulus: " + this.n + "\n  public exponent: " + this.e;
    }

    static BigInteger getBigInteger(DerInputStream derInputStream) throws IOException {
        BigInteger bigInteger = derInputStream.getBigInteger();
        if (bigInteger.signum() < 0) {
            throw new IOException("Negative value");
        }
        return bigInteger;
    }
}

