/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.io;

import com.ibm.jvm.io.ConsoleInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.zip.ZipInputStream;
import sun.io.ByteToCharConverter;

public final class LocalizedInputStream
extends FilterInputStream {
    private ByteToCharConverter btc;
    public static boolean nonASCIIPlatform;
    private static final Class ZipFileInputStreamClass;
    private boolean allowUnwrapping = true;
    private byte[] peekBuffer = new byte[1000];
    private int peekLength;
    private int peekOffset;

    private LocalizedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private void btcInit() {
        boolean bl = false;
        this.peekLength = 0;
        while (this.peekLength < this.peekBuffer.length) {
            int n;
            try {
                if (this.in.available() == 0) break;
                n = this.in.read();
            }
            catch (IOException iOException) {
                break;
            }
            if (n == -1) break;
            this.peekBuffer[this.peekLength++] = (byte)n;
            if (n == 35 || n == 61 || n == 10) {
                bl = true;
                break;
            }
            if (n != 21) continue;
            break;
        }
        try {
            this.btc = bl ? ByteToCharConverter.getConverter("8859_1") : ByteToCharConverter.getConverter("Cp1047");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int available() throws IOException {
        return this.peekLength - this.peekOffset + this.in.available();
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray) != -1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        char[] cArray = new char[n2];
        if (this.btc == null) {
            this.btcInit();
        }
        if ((n3 = this.peekLength - this.peekOffset) > 0) {
            int n4;
            if (n3 > n2) {
                n3 = n2;
            }
            System.arraycopy(this.peekBuffer, this.peekOffset, byArray, n, n3);
            this.peekOffset += n3;
            if (this.peekOffset == this.peekLength) {
                this.peekBuffer = null;
            }
            if (n3 < n2 && (n4 = this.in.read(byArray, n + n3, n2 - n3)) > 0) {
                n3 += n4;
            }
        } else {
            n3 = this.in.read(byArray, n, n2);
        }
        if (n3 > 0) {
            this.btc.convert(byArray, n, n + n2, cArray, 0, n + n2);
            for (int i = 0; i < n2; ++i) {
                byArray[i + n] = (byte)cArray[i];
            }
        }
        return n3;
    }

    public static InputStream localize(InputStream inputStream) {
        if (nonASCIIPlatform) {
            InputStream inputStream2 = inputStream;
            while (inputStream2 != null && !(inputStream2 instanceof LocalizedInputStream)) {
                Class<?> clazz;
                for (clazz = inputStream2.getClass(); clazz != null && clazz != FileInputStream.class && clazz != ZipInputStream.class && clazz != ZipFileInputStreamClass && clazz != FilterInputStream.class; clazz = clazz.getSuperclass()) {
                }
                if (clazz == FilterInputStream.class) {
                    inputStream2 = LocalizedInputStream.unwrap((FilterInputStream)inputStream2);
                    continue;
                }
                if (clazz == FileInputStream.class) {
                    return new LocalizedInputStream(inputStream);
                }
                if (clazz != ZipFileInputStreamClass) break;
                return new LocalizedInputStream(inputStream);
            }
        }
        return inputStream;
    }

    public static InputStream getInputStream(InputStream inputStream) {
        if (nonASCIIPlatform && inputStream instanceof LocalizedInputStream && ((LocalizedInputStream)inputStream).allowUnwrapping) {
            return ((LocalizedInputStream)inputStream).in;
        }
        return ConsoleInputStream.getInputStream(inputStream);
    }

    public static void dontUnwrap(InputStream inputStream) {
        if (nonASCIIPlatform && inputStream instanceof LocalizedInputStream) {
            ((LocalizedInputStream)inputStream).allowUnwrapping = false;
        }
    }

    public static native InputStream unwrap(FilterInputStream var0);

    static {
        Class<?> clazz;
        nonASCIIPlatform = false;
        try {
            clazz = Class.forName("java.util.zip.ZipFile$ZipFileInputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        ZipFileInputStreamClass = clazz;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                nonASCIIPlatform = !System.getProperty("platform.notASCII", "false").equalsIgnoreCase("false");
                return null;
            }
        });
    }
}

