/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.Keywords;
import org.apache.xpath.compiler.OpMapVector;
import org.apache.xpath.compiler.XPathParser;

class Lexer {
    private Compiler m_compiler;
    PrefixResolver m_namespaceContext;
    XPathParser m_processor;
    static final int TARGETEXTRA = 10000;
    private int[] m_patternMap = new int[100];
    private int m_patternMapSize;

    Lexer(Compiler compiler, PrefixResolver prefixResolver, XPathParser xPathParser) {
        this.m_compiler = compiler;
        this.m_namespaceContext = prefixResolver;
        this.m_processor = xPathParser;
    }

    void tokenize(String string) throws TransformerException {
        this.tokenize(string, null);
    }

    void tokenize(String string, Vector vector) throws TransformerException {
        this.m_compiler.m_currentPattern = string;
        this.m_patternMapSize = 0;
        int n = (string.length() < 500 ? string.length() : 500) * 5;
        this.m_compiler.m_opMap = new OpMapVector(n, 2500, 1);
        int n2 = string.length();
        int n3 = -1;
        int n4 = -1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = 0;
        block9: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    if (n3 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n5, bl, bl2);
                        bl2 = false;
                        if (-1 != n4) {
                            n4 = this.mapNSTokens(string, n3, n4, i);
                        } else {
                            this.addToTokenQueue(string.substring(n3, i));
                        }
                    }
                    n3 = i++;
                    while (i < n2 && (c = string.charAt(i)) != '\"') {
                        ++i;
                    }
                    if (c == '\"' && i < n2) {
                        this.addToTokenQueue(string.substring(n3, i + 1));
                        n3 = -1;
                        continue block9;
                    }
                    this.m_processor.error("ER_EXPECTED_DOUBLE_QUOTE", null);
                    continue block9;
                }
                case '\'': {
                    if (n3 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n5, bl, bl2);
                        bl2 = false;
                        if (-1 != n4) {
                            n4 = this.mapNSTokens(string, n3, n4, i);
                        } else {
                            this.addToTokenQueue(string.substring(n3, i));
                        }
                    }
                    n3 = i++;
                    while (i < n2 && (c = string.charAt(i)) != '\'') {
                        ++i;
                    }
                    if (c == '\'' && i < n2) {
                        this.addToTokenQueue(string.substring(n3, i + 1));
                        n3 = -1;
                        continue block9;
                    }
                    this.m_processor.error("ER_EXPECTED_SINGLE_QUOTE", null);
                    continue block9;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n3 == -1) continue block9;
                    bl3 = false;
                    bl = this.mapPatternElemPos(n5, bl, bl2);
                    bl2 = false;
                    if (-1 != n4) {
                        n4 = this.mapNSTokens(string, n3, n4, i);
                    } else {
                        this.addToTokenQueue(string.substring(n3, i));
                    }
                    n3 = -1;
                    continue block9;
                }
                case '@': {
                    bl2 = true;
                }
                case '-': {
                    if ('-' == c) {
                        if (!bl3 && n3 != -1) continue block9;
                        bl3 = false;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    if (n3 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n5, bl, bl2);
                        bl2 = false;
                        if (-1 != n4) {
                            n4 = this.mapNSTokens(string, n3, n4, i);
                        } else {
                            this.addToTokenQueue(string.substring(n3, i));
                        }
                        n3 = -1;
                    } else if ('/' == c && bl) {
                        bl = this.mapPatternElemPos(n5, bl, bl2);
                    } else if ('*' == c) {
                        bl = this.mapPatternElemPos(n5, bl, bl2);
                        bl2 = false;
                    }
                    if (0 == n5 && '|' == c) {
                        if (null != vector) {
                            this.recordTokenString(vector);
                        }
                        bl = true;
                    }
                    if (')' == c || ']' == c) {
                        --n5;
                    } else if ('(' == c || '[' == c) {
                        ++n5;
                    }
                    this.addToTokenQueue(string.substring(i, i + 1));
                    continue block9;
                }
                case ':': {
                    if (i > 0) {
                        if (n4 == i - 1) {
                            if (n3 != -1 && n3 < i - 1) {
                                this.addToTokenQueue(string.substring(n3, i - 1));
                            }
                            bl3 = false;
                            bl2 = false;
                            n3 = -1;
                            n4 = -1;
                            this.addToTokenQueue(string.substring(i - 1, i + 1));
                            continue block9;
                        }
                        n4 = i;
                    }
                }
                default: {
                    if (-1 == n3) {
                        n3 = i;
                        bl3 = Character.isDigit(c) || c == '.';
                        continue block9;
                    }
                    if (!bl3) continue block9;
                    boolean bl4 = bl3 = Character.isDigit(c) || c == '.';
                    if (bl3) continue block9;
                    bl = this.mapPatternElemPos(n5, bl, bl2);
                    bl2 = false;
                    if (-1 != n4) {
                        n4 = this.mapNSTokens(string, n3, n4, i);
                    } else {
                        this.addToTokenQueue(string.substring(n3, i));
                    }
                    n3 = i;
                }
            }
        }
        if (n3 != -1) {
            bl3 = false;
            bl = this.mapPatternElemPos(n5, bl, bl2);
            if (-1 != n4 || this.m_namespaceContext != null && this.m_namespaceContext.handlesNullPrefixes()) {
                n4 = this.mapNSTokens(string, n3, n4, n2);
            } else {
                this.addToTokenQueue(string.substring(n3, n2));
            }
        }
        if (0 == this.m_compiler.getTokenQueueSize()) {
            this.m_processor.error("ER_EMPTY_EXPRESSION", null);
        } else if (null != vector) {
            this.recordTokenString(vector);
        }
        this.m_processor.m_queueMark = 0;
    }

    private boolean mapPatternElemPos(int n, boolean bl, boolean bl2) {
        if (0 == n) {
            if (this.m_patternMapSize >= this.m_patternMap.length) {
                int[] nArray = this.m_patternMap;
                int n2 = this.m_patternMap.length;
                this.m_patternMap = new int[this.m_patternMapSize + 100];
                System.arraycopy(nArray, 0, this.m_patternMap, 0, n2);
            }
            if (!bl) {
                int n3 = this.m_patternMapSize - 1;
                this.m_patternMap[n3] = this.m_patternMap[n3] - 10000;
            }
            this.m_patternMap[this.m_patternMapSize] = this.m_compiler.getTokenQueueSize() - (bl2 ? 1 : 0) + 10000;
            ++this.m_patternMapSize;
            bl = false;
        }
        return bl;
    }

    private int getTokenQueuePosFromMap(int n) {
        int n2 = this.m_patternMap[n];
        return n2 >= 10000 ? n2 - 10000 : n2;
    }

    private final void resetTokenMark(int n) {
        int n2 = this.m_compiler.getTokenQueueSize();
        int n3 = n > 0 ? (n <= n2 ? n - 1 : n) : (this.m_processor.m_queueMark = 0);
        if (this.m_processor.m_queueMark < n2) {
            this.m_processor.m_token = (String)this.m_compiler.getTokenQueue().elementAt(this.m_processor.m_queueMark++);
            this.m_processor.m_tokenChar = XPathParser.firstChar(this.m_processor.m_token);
        } else {
            this.m_processor.m_token = null;
            this.m_processor.m_tokenChar = 0;
        }
    }

    final int getKeywordToken(String string) {
        int n;
        try {
            Integer n2 = (Integer)Keywords.getKeyWord(string);
            n = null != n2 ? n2 : 0;
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        catch (ClassCastException classCastException) {
            n = 0;
        }
        return n;
    }

    private void recordTokenString(Vector vector) {
        int n = this.getTokenQueuePosFromMap(this.m_patternMapSize - 1);
        this.resetTokenMark(n + 1);
        if (this.m_processor.lookahead('(', 1)) {
            int n2 = this.getKeywordToken(this.m_processor.m_token);
            switch (n2) {
                case 1030: {
                    vector.addElement("#comment");
                    break;
                }
                case 1031: {
                    vector.addElement("#text");
                    break;
                }
                case 1033: {
                    vector.addElement("*");
                    break;
                }
                case 35: {
                    vector.addElement("/");
                    break;
                }
                case 36: {
                    vector.addElement("*");
                    break;
                }
                case 1032: {
                    vector.addElement("*");
                    break;
                }
                default: {
                    vector.addElement("*");
                    break;
                }
            }
        } else {
            if (this.m_processor.tokenIs('@')) {
                this.resetTokenMark(++n + 1);
            }
            if (this.m_processor.lookahead(':', 1)) {
                n += 2;
            }
            vector.addElement(this.m_compiler.getTokenQueue().elementAt(n));
        }
    }

    private final void addToTokenQueue(String string) {
        this.m_compiler.getTokenQueue().addElement(string);
    }

    private int mapNSTokens(String string, int n, int n2, int n3) throws TransformerException {
        String string2;
        String string3;
        block9: {
            string3 = "";
            if (n >= 0 && n2 >= 0) {
                string3 = string.substring(n, n2);
            }
            if (null != this.m_namespaceContext && !string3.equals("*") && !string3.equals("xmlns")) {
                try {
                    if (string3.length() > 0) {
                        string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                        break block9;
                    }
                    string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                }
                catch (ClassCastException classCastException) {
                    string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                }
            } else {
                string2 = string3;
            }
        }
        if (null != string2 && string2.length() > 0) {
            this.addToTokenQueue(string2);
            this.addToTokenQueue(":");
            String string4 = string.substring(n2 + 1, n3);
            if (string4.length() > 0) {
                this.addToTokenQueue(string4);
            }
        } else {
            this.m_processor.errorForDOM3("ER_PREFIX_MUST_RESOLVE", new String[]{string3});
        }
        return -1;
    }
}

