/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XPath
implements Serializable,
ExpressionOwner {
    static final long serialVersionUID = 3976493477939110553L;
    private Expression m_mainExp;
    private transient FunctionTable m_funcTable = null;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    private void initFunctionTable() {
        this.m_funcTable = new FunctionTable();
    }

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public void fixupVariables(Vector vector, int n) {
        this.m_mainExp.fixupVariables(vector, n);
    }

    public void setExpression(Expression expression) {
        if (null != this.m_mainExp) {
            expression.exprSetParent(this.m_mainExp.exprGetParent());
        }
        this.m_mainExp = expression;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp;
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n, ErrorListener errorListener, Vector vector) throws TransformerException {
        this.initFunctionTable();
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser(errorListener, sourceLocator);
        Compiler compiler = new Compiler(errorListener, sourceLocator, this.m_funcTable);
        compiler.setDefaultNamespaceContext(prefixResolver);
        if (vector != null) {
            compiler.setSaveDTMIterators(vector);
        }
        if (0 == n) {
            xPathParser.initXPath(compiler, string, prefixResolver);
        } else if (1 == n) {
            xPathParser.initMatchPattern(compiler, string, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(n)}));
        }
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
        if (null != sourceLocator && sourceLocator instanceof ExpressionNode) {
            expression.exprSetParent((ExpressionNode)sourceLocator);
        }
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n, ErrorListener errorListener) throws TransformerException {
        this.initFunctionTable();
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser(errorListener, sourceLocator);
        Compiler compiler = new Compiler(errorListener, sourceLocator, this.m_funcTable);
        if (0 == n) {
            xPathParser.initXPath(compiler, string, prefixResolver);
        } else if (1 == n) {
            xPathParser.initMatchPattern(compiler, string, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(n)}));
        }
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
        if (null != sourceLocator && sourceLocator instanceof ExpressionNode) {
            expression.exprSetParent((ExpressionNode)sourceLocator);
        }
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n, ErrorListener errorListener, FunctionTable functionTable) throws TransformerException {
        this.m_funcTable = functionTable;
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser(errorListener, sourceLocator);
        Compiler compiler = new Compiler(errorListener, sourceLocator, this.m_funcTable);
        if (0 == n) {
            xPathParser.initXPath(compiler, string, prefixResolver);
        } else if (1 == n) {
            xPathParser.initMatchPattern(compiler, string, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(n)}));
        }
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
        if (null != sourceLocator && sourceLocator instanceof ExpressionNode) {
            expression.exprSetParent((ExpressionNode)sourceLocator);
        }
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n) throws TransformerException {
        this(string, sourceLocator, prefixResolver, n, null);
    }

    public XPath(Expression expression) {
        this.setExpression(expression);
        this.initFunctionTable();
    }

    public XPath(String string, PrefixResolver prefixResolver, XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver, boolean bl) throws TransformerException {
        this(string, prefixResolver, xPathFunctionResolver, xPathVariableResolver, bl, false);
    }

    public XPath(String string, PrefixResolver prefixResolver, XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver, boolean bl, boolean bl2) throws TransformerException {
        this.initFunctionTable();
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser(defaultErrorHandler, null);
        Compiler compiler = new Compiler(defaultErrorHandler, null, this.m_funcTable, true, bl2);
        compiler.setFunctionResolver(xPathFunctionResolver);
        compiler.setVariableResolver(xPathVariableResolver);
        compiler.setSecureProcessing(bl);
        xPathParser.initXPath(compiler, string, prefixResolver);
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
    }

    public XObject execute(XPathContext xPathContext, Node node, PrefixResolver prefixResolver) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getDTMHandleFromNode(node), prefixResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject execute(XPathContext xPathContext, int n, PrefixResolver prefixResolver) throws TransformerException {
        XObject xObject;
        block11: {
            xPathContext.pushNamespaceContext(prefixResolver);
            xPathContext.pushCurrentNodeAndExpression(n, n);
            xObject = null;
            try {
                xObject = this.m_mainExp.execute(xPathContext);
            }
            catch (TransformerException transformerException) {
                transformerException.setLocator(this.getLocator());
                ErrorListener errorListener = xPathContext.getErrorListener();
                if (null != errorListener) {
                    errorListener.error(transformerException);
                    break block11;
                }
                throw transformerException;
            }
            catch (Exception exception) {
                Exception exception2;
                while (exception2 instanceof WrappedRuntimeException) {
                    exception2 = ((WrappedRuntimeException)exception2).getException();
                }
                String string = exception2.getMessage();
                if (string == null || string.length() == 0) {
                    string = XSLMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                }
                TransformerException transformerException = new TransformerException(string, this.getLocator(), exception2);
                ErrorListener errorListener = xPathContext.getErrorListener();
                if (null != errorListener) {
                    errorListener.fatalError(transformerException);
                    break block11;
                }
                throw transformerException;
            }
            finally {
                xPathContext.popNamespaceContext();
                xPathContext.popCurrentNodeAndExpression();
            }
        }
        return xObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bool(XPathContext xPathContext, int n, PrefixResolver prefixResolver) throws TransformerException {
        block11: {
            xPathContext.pushNamespaceContext(prefixResolver);
            xPathContext.pushCurrentNodeAndExpression(n, n);
            try {
                boolean bl = this.m_mainExp.bool(xPathContext);
                return bl;
            }
            catch (TransformerException transformerException) {
                transformerException.setLocator(this.getLocator());
                ErrorListener errorListener = xPathContext.getErrorListener();
                if (null != errorListener) {
                    errorListener.error(transformerException);
                    break block11;
                }
                throw transformerException;
            }
            catch (Exception exception) {
                Exception exception2;
                while (exception2 instanceof WrappedRuntimeException) {
                    exception2 = ((WrappedRuntimeException)exception2).getException();
                }
                String string = exception2.getMessage();
                if (string == null || string.length() == 0) {
                    string = XSLMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                }
                TransformerException transformerException = new TransformerException(string, this.getLocator(), exception2);
                ErrorListener errorListener = xPathContext.getErrorListener();
                if (null != errorListener) {
                    errorListener.fatalError(transformerException);
                    break block11;
                }
                throw transformerException;
            }
            finally {
                xPathContext.popNamespaceContext();
                xPathContext.popCurrentNodeAndExpression();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchScore(XPathContext xPathContext, int n) throws TransformerException {
        xPathContext.pushCurrentNode(n);
        xPathContext.pushCurrentExpressionNode(n);
        try {
            XObject xObject = this.m_mainExp.execute(xPathContext);
            double d = xObject.num();
            return d;
        }
        finally {
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
        }
    }

    public void warn(XPathContext xPathContext, int n, String string, Object[] objectArray) throws TransformerException {
        String string2 = XSLMessages.createXPATHWarning(string, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (null != errorListener) {
            errorListener.warning(new TransformerException(string2, (SAXSourceLocator)xPathContext.getSAXLocator()));
        }
    }

    public void assertion(boolean bl, String string) {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void error(XPathContext xPathContext, int n, String string, Object[] objectArray) throws TransformerException {
        String string2 = XSLMessages.createXPATHMessage(string, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (null != errorListener) {
            errorListener.fatalError(new TransformerException(string2, (SAXSourceLocator)xPathContext.getSAXLocator()));
        } else {
            SourceLocator sourceLocator = xPathContext.getSAXLocator();
            System.out.println(string2 + "; file " + sourceLocator.getSystemId() + "; line " + sourceLocator.getLineNumber() + "; column " + sourceLocator.getColumnNumber());
        }
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        this.m_mainExp.callVisitors(this, xPathVisitor);
    }
}

